/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.stores;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.stores.ResourceStoreException;
import org.globus.gsi.stores.SecurityObjectWrapper;
import org.globus.gsi.stores.Storable;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceSecurityWrapper<T>
implements SecurityObjectWrapper<T>,
Storable {
    protected PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    protected Resource resource;
    private Log logger = LogFactory.getLog(this.getClass().getCanonicalName());
    private boolean changed;
    private T securityObject;
    private long lastModified = -1L;
    private String alias;

    protected void init(String locationPattern) throws ResourceStoreException {
        this.init(this.resolver.getResource(locationPattern));
    }

    protected void init(Resource initialResource) throws ResourceStoreException {
        this.resource = initialResource;
        this.securityObject = this.create(this.resource);
        this.logger.debug(String.format("Loading initialResource: %s", this.resource.toString()));
        try {
            this.alias = this.resource.getURL().toExternalForm();
            this.lastModified = this.resource.lastModified();
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    protected void init(String locationPattern, T initialSecurityObject) throws ResourceStoreException {
        this.init(this.resolver.getResource(locationPattern), initialSecurityObject);
    }

    protected void init(Resource initialResource, T initialSecurityObject) throws ResourceStoreException {
        if (initialSecurityObject == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        this.securityObject = initialSecurityObject;
        this.resource = initialResource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public URL getResourceURL() {
        try {
            return this.resource.getURL();
        }
        catch (IOException e) {
            this.logger.warn("Unable to extract url", e);
            return null;
        }
    }

    public File getFile() {
        try {
            return this.resource.getFile();
        }
        catch (IOException e) {
            this.logger.debug("Resource is not a file", e);
            return null;
        }
    }

    @Override
    public void refresh() throws ResourceStoreException {
        long latestLastModified;
        this.changed = false;
        try {
            latestLastModified = this.resource.lastModified();
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
        if (this.lastModified < latestLastModified) {
            this.securityObject = this.create(this.resource);
            this.lastModified = latestLastModified;
            this.changed = true;
        }
    }

    protected abstract T create(Resource var1) throws ResourceStoreException;

    @Override
    public T getSecurityObject() throws ResourceStoreException {
        this.refresh();
        return this.securityObject;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

