/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.discovery.internal;

import de.rcenvironment.core.configuration.discovery.client.DiscoveryClientService;
import de.rcenvironment.core.configuration.discovery.internal.RemoteDiscoveryService;
import de.rcenvironment.core.jetty.JettyService;
import de.rcenvironment.core.utils.common.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiscoveryClientServiceImpl
implements DiscoveryClientService {
    private JettyService jettyService;
    private final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public String getReflectedIpFromDiscoveryServer(String address, int port) {
        String serviceURL = StringUtils.format((String)"http://%s:%d/Discovery", (Object[])new Object[]{address, port});
        this.logger.info((Object)("Querying discovery service at " + serviceURL + " for the reflected local IP address"));
        RemoteDiscoveryService client = (RemoteDiscoveryService)this.jettyService.createWebServiceClient(RemoteDiscoveryService.class, serviceURL);
        try {
            String callerAddress = client.getReflectedCallerAddress();
            return callerAddress;
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("Error querying discovery service at " + serviceURL + " for the reflected local IP address"), (Throwable)e);
            return null;
        }
    }

    protected void bindJettyService(JettyService newService) {
        this.jettyService = newService;
    }
}

