/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.gui.internal;

import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.gui.utils.incubator.ContextMenuItemRemover;
import de.rcenvironment.core.start.gui.internal.ApplicationWorkbenchWindowAdvisor;
import de.rcenvironment.core.start.gui.internal.EclipsePreferencesUIOrganizer;
import de.rcenvironment.core.start.gui.internal.UnwantedUIRemover;
import de.rcenvironment.core.start.gui.internal.WorkbenchAdvisorDelegate;
import de.rcenvironment.core.utils.common.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.resources.ProjectExplorer;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static final String READ_ONLY_WF_EDITOR_ID = "de.rcenvironment.core.gui.workflow.editor.WorkflowRunEditor";
    private static final int MINIMUM_HEIGHT = 250;
    private static final int MINIMUM_WIDTH = 500;
    private static final Log LOGGER = LogFactory.getLog(ApplicationWorkbenchAdvisor.class);
    private static ConfigurationService configService;
    private static String windowTitle;

    static {
        windowTitle = "%s (%s)";
    }

    protected void bindConfigurationService(ConfigurationService configServiceIn) {
        configService = configServiceIn;
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        IWorkbenchWindowConfigurer windowConfigurer = configurer;
        String platformName = configService.getInstanceName();
        String appName = Platform.getProduct().getName();
        if (platformName != null && appName != null) {
            windowConfigurer.setTitle(StringUtils.format((String)windowTitle, (Object[])new Object[]{appName, platformName}));
        }
        return new ApplicationWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return "de.rcenvironment.rce";
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        configurer.setSaveAndRestore(true);
        WorkbenchAdvisorDelegate.declareWorkbenchImages(this.getWorkbenchConfigurer());
    }

    public void preStartup() {
        super.preStartup();
        IDE.registerAdapters();
    }

    public void postStartup() {
        super.postStartup();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow[] workbenchs = PlatformUI.getWorkbench().getWorkbenchWindows();
                ProjectExplorer view = null;
                IWorkbenchWindow[] iWorkbenchWindowArray = workbenchs;
                int n = workbenchs.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow workbench = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = workbench.getPages();
                    if (iWorkbenchPageArray.length != 0) {
                        IWorkbenchPage page = iWorkbenchPageArray[0];
                        view = (ProjectExplorer)page.findView("org.eclipse.ui.navigator.ProjectExplorer");
                    }
                    ++n2;
                }
                if (view == null) {
                    LOGGER.debug((Object)"Project Explorer could not be found at startup so its resources could not be refreshed automatically.");
                    return;
                }
                view.getCommonViewer().setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                ContextMenuItemRemover.removeUnwantedMenuEntries((Control)view.getCommonViewer().getControl());
                UnwantedUIRemover.removeUnwantedNewWizards();
                UnwantedUIRemover.removeUnwantedExportWizards();
                UnwantedUIRemover.removeUnwantedImportWizards();
                UnwantedUIRemover.removeUnWantedPerspectives();
                UnwantedUIRemover.removeUnWantedViews();
                EclipsePreferencesUIOrganizer.removeUnwantetPreferencePages();
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setMinimumSize(500, 250);
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener((IPartListener)new WorkbenchWindowPartListener());
            }
        });
    }

    public boolean preShutdown() {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.save(true, null);
        }
        catch (CoreException coreException) {
        }
        catch (RuntimeException runtimeException) {}
        return super.preShutdown();
    }

    private final class WorkbenchWindowPartListener
    implements IPartListener {
        private WorkbenchWindowPartListener() {
        }

        public void partOpened(IWorkbenchPart workbenchPart) {
            if (workbenchPart instanceof ProjectExplorer) {
                ((ProjectExplorer)workbenchPart).getCommonViewer().setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            }
        }

        public void partDeactivated(IWorkbenchPart workbenchPart) {
        }

        public void partClosed(IWorkbenchPart workbenchPart) {
        }

        public void partBroughtToTop(IWorkbenchPart workbenchPart) {
        }

        public void partActivated(IWorkbenchPart workbenchPart) {
        }
    }
}

