/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common.security;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public abstract class AbstractDeserializationClasspathCheck {
    private static final String[] KNOWN_COMMONS_COLLECTIONS_ROOT_NAMESPACES = new String[]{"org.apache.commons.collections.", "org.apache.commons.collections4.", "org.apache.commons.collections15."};
    private static final String[] KNOWN_UNSAFE_OR_SUSPICIOUS_COMMONS_COLLECTIONS_CLASSES = new String[]{"Transformer", "Factory", "functors.ConstantTransformer", "functors.ConstantTransformer", "functors.ClosureTransformer", "functors.InvokerTransformer", "functors.InstantiateFactory", "functors.InstantiateTransformer", "functors.PrototypeFactory"};
    private static final String[] OTHER_UNSAFE_OR_SUSPICIOUS_CLASSES = new String[]{"org.codehaus.groovy.runtime.ConvertedClosure"};
    private final Log log = LogFactory.getLog(this.getClass());

    public boolean checkForKnownUnsafeClassesInClasspath() {
        Pattern typoGuard = Pattern.compile("^[a-zA-Z][a-zA-Z0-9\\.]+[a-zA-Z]$");
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        this.log.debug((Object)("Running in context of bundle " + bundle + " (may be 'null' when not running in an OSGi context)"));
        boolean unsafeClassFound = false;
        for (String className : this.assembleListOfSuspiciousOrKnownUnsafeClassesForDeserialization()) {
            if (!typoGuard.matcher(className).matches()) {
                throw new IllegalArgumentException("The class name seems to be malformed: " + className);
            }
            try {
                Class.forName(className);
                this.log.error((Object)("Known unsafe class found in classpath: " + className));
                unsafeClassFound = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    Thread.currentThread().getContextClassLoader().loadClass(className);
                    this.log.error((Object)("Known unsafe class found via context classloader: " + className));
                    unsafeClassFound = true;
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    try {
                        if (bundle == null) continue;
                        bundle.loadClass(className);
                        this.log.error((Object)("Known unsafe class found via bundle classloader: " + className));
                        unsafeClassFound = true;
                    }
                    catch (ClassNotFoundException classNotFoundException3) {
                        this.log.debug((Object)("Not found in classpath (good): " + className));
                    }
                }
            }
        }
        return unsafeClassFound;
    }

    private List<String> assembleListOfSuspiciousOrKnownUnsafeClassesForDeserialization() {
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = KNOWN_COMMONS_COLLECTIONS_ROOT_NAMESPACES;
        int n = KNOWN_COMMONS_COLLECTIONS_ROOT_NAMESPACES.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            String[] stringArray2 = KNOWN_UNSAFE_OR_SUSPICIOUS_COMMONS_COLLECTIONS_CLASSES;
            int n3 = KNOWN_UNSAFE_OR_SUSPICIOUS_COMMONS_COLLECTIONS_CLASSES.length;
            int n4 = 0;
            while (n4 < n3) {
                String suffix = stringArray2[n4];
                list.add(String.valueOf(prefix) + suffix);
                ++n4;
            }
            ++n2;
        }
        stringArray = OTHER_UNSAFE_OR_SUSPICIOUS_CLASSES;
        n = OTHER_UNSAFE_OR_SUSPICIOUS_CLASSES.length;
        n2 = 0;
        while (n2 < n) {
            String classname = stringArray[n2];
            list.add(classname);
            ++n2;
        }
        return list;
    }
}

