/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.xpathchooser.model;

import de.rcenvironment.core.gui.xpathchooser.model.AbstractXSDValueHolder;
import de.rcenvironment.core.gui.xpathchooser.model.XSDAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XSDElement
extends AbstractXSDValueHolder {
    public static final String[] EMPTY_STRING = new String[0];
    private static final long serialVersionUID = -6618584152825821109L;
    private List<XSDElement> elements = new ArrayList<XSDElement>();
    private List<XSDAttribute> attributes = new ArrayList<XSDAttribute>();
    private String idAttribute = null;
    private String idValue = null;
    private Map<String, Set<String>> idValues = new Hashtable<String, Set<String>>();

    public XSDElement(XSDElement parent, String name) {
        super(parent, name);
    }

    public List<XSDElement> getElements() {
        return this.elements;
    }

    public void setElements(List<XSDElement> theElements) {
        this.elements = theElements;
    }

    public List<XSDAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<XSDAttribute> theAttributes) {
        this.attributes = theAttributes;
    }

    @Override
    public String getPath() {
        if (this.getParent() == null) {
            return "/" + this.name;
        }
        return String.valueOf(this.getParent().getPath()) + "/" + this.name;
    }

    public String getCurrentAttributeName() {
        return this.idAttribute;
    }

    public String getCurrentAttributeValue() {
        return this.idValue;
    }

    public void setCurrentAttributeName(String value) {
        this.idAttribute = value.intern();
    }

    public void setCurrentAttributeValue(String value) {
        this.idValue = value.intern();
    }

    public String[] getAttributeNames() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.idValues.keySet());
        if (this.idAttribute != null) {
            names.add(this.idAttribute);
        }
        return names.toArray(EMPTY_STRING);
    }

    public String[] getAttributeValues() {
        if (this.idValues.containsKey(this.idAttribute)) {
            HashSet values = new HashSet();
            values.addAll(this.idValues.get(this.idAttribute));
            Object[] returnValues = values.toArray(EMPTY_STRING);
            Arrays.sort(returnValues);
            return returnValues;
        }
        return new String[]{this.idValue};
    }

    public void setAttributeName(String name) {
        if (name == null || name.equals("")) {
            this.setCurrentAttributeName("");
            return;
        }
        if (!this.idValues.containsKey(name)) {
            this.idValues.put(name, new LinkedHashSet());
        }
        this.setCurrentAttributeName(name);
        if (this.idValue != null && !this.idValue.equals("")) {
            this.idValues.get(this.idAttribute).add(this.idValue);
        }
    }

    public void setAttributeValue(String value) {
        if (value == null || value.equals("")) {
            this.setCurrentAttributeValue("");
            return;
        }
        if (!this.idValues.containsKey(this.idAttribute)) {
            this.idValues.put(this.idAttribute, new LinkedHashSet());
        }
        this.setCurrentAttributeValue(value);
        this.idValues.get(this.idAttribute).add(this.idValue);
    }

    public void setAttributeValues(String name, Set<String> values) {
        if (!this.idValues.containsKey(name)) {
            this.idValues.put(name, new HashSet());
        }
        this.idValues.get(name).addAll(values);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof XSDElement)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        XSDElement e = (XSDElement)o;
        return this.getPath().equals(e.getPath());
    }

    @Override
    public int hashCode() {
        return this.getPath().hashCode();
    }
}

