/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.wizards.toolintegration;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.gui.utils.common.configuration.VariableNameVerifyListener;
import de.rcenvironment.core.gui.wizards.toolintegration.Messages;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WizardEndpointEditDialog
extends Dialog {
    public static Map<String, DataType> guiNameToDataType = new HashMap<String, DataType>();
    private static final String NO_VALUE_STRING = "";
    private static final String INPUT_FOLDER_STANDARD_NAME = "Input folder";
    private static List<EndpointDefinition.InputDatumHandling> inputDatumHandlings = new ArrayList<EndpointDefinition.InputDatumHandling>();
    private static List<EndpointDefinition.InputExecutionContraint> inputExecutionConstraints;
    private Text nameText;
    private Combo dataTypeCombo;
    private Button[] inputDatumHandlingButtons = new Button[3];
    private Combo defaultInputDatumHandlingCombo;
    private Button[] inputExecutionConstraintButtons = new Button[3];
    private Combo defaultInputExecutionConstraintCombo;
    private Text filenameText;
    private final Map<String, String> config;
    private final String title;
    private final List<String> allEndpointNames;
    private final String oldName;
    private final String type;

    static {
        inputDatumHandlings.add(EndpointDefinition.InputDatumHandling.Constant);
        inputDatumHandlings.add(EndpointDefinition.InputDatumHandling.Single);
        inputDatumHandlings.add(EndpointDefinition.InputDatumHandling.Queue);
        inputExecutionConstraints = new ArrayList<EndpointDefinition.InputExecutionContraint>();
        inputExecutionConstraints.add(EndpointDefinition.InputExecutionContraint.Required);
        inputExecutionConstraints.add(EndpointDefinition.InputExecutionContraint.RequiredIfConnected);
        inputExecutionConstraints.add(EndpointDefinition.InputExecutionContraint.NotRequired);
    }

    public WizardEndpointEditDialog(Shell parentShell, String title, String type, List<String> allEndpointNames) {
        super(parentShell);
        this.config = new HashMap<String, String>();
        this.title = title;
        this.type = type;
        this.allEndpointNames = allEndpointNames;
        this.oldName = null;
    }

    public WizardEndpointEditDialog(Shell parentShell, String title, String type, Map<String, String> config, List<String> allEndpointNames) {
        super(parentShell);
        this.config = config;
        this.oldName = config.get("endpointName");
        this.title = title;
        this.type = type;
        this.allEndpointNames = allEndpointNames;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, true));
        GridData g = new GridData(1808);
        g.grabExcessHorizontalSpace = true;
        g.horizontalAlignment = 2;
        container.setLayoutData((Object)g);
        this.createEndpointSettings(container);
        this.updateInitValues();
        return container;
    }

    private void updateInitValues() {
        if (this.config.get("endpointDataType") != null) {
            this.dataTypeCombo.setText(DataType.valueOf((String)this.config.get("endpointDataType")).getDisplayName());
        }
        if (this.config.get("endpointName") != null) {
            this.nameText.setText(this.config.get("endpointName"));
        }
        if (this.type.equals("inputs")) {
            int n;
            int n2;
            String[] stringArray;
            if (this.config.containsKey("inputHandling")) {
                stringArray = StringUtils.splitAndUnescape((String)this.config.get("inputHandling"));
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    String handling = stringArray[n];
                    this.inputDatumHandlingButtons[inputDatumHandlings.indexOf(EndpointDefinition.InputDatumHandling.valueOf((String)handling))].setSelection(true);
                    ++n;
                }
            } else if (this.config.containsKey("endpointUsage")) {
                if (this.config.get("endpointUsage").equals("initial")) {
                    this.inputDatumHandlingButtons[inputDatumHandlings.indexOf(EndpointDefinition.InputDatumHandling.Constant)].setSelection(true);
                } else {
                    this.inputDatumHandlingButtons[inputDatumHandlings.indexOf(EndpointDefinition.InputDatumHandling.Single)].setSelection(true);
                }
            }
            this.fillInputHandlingComboForDefaultSelection(true);
            if (this.config.containsKey("inputExecutionConstraint")) {
                stringArray = StringUtils.splitAndUnescape((String)this.config.get("inputExecutionConstraint"));
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    String constraint = stringArray[n];
                    this.inputExecutionConstraintButtons[inputExecutionConstraints.indexOf(EndpointDefinition.InputExecutionContraint.valueOf((String)constraint))].setSelection(true);
                    ++n;
                }
            } else if (this.config.containsKey("endpointUsage")) {
                if (this.config.get("endpointUsage").equals("optional")) {
                    this.inputExecutionConstraintButtons[inputExecutionConstraints.indexOf(EndpointDefinition.InputExecutionContraint.NotRequired)].setSelection(true);
                } else {
                    this.inputExecutionConstraintButtons[inputExecutionConstraints.indexOf(EndpointDefinition.InputExecutionContraint.Required)].setSelection(true);
                }
            }
            this.fillInputExecutionConstraintsComboForDefaultSelection(true);
        }
        if (this.config.get("endpointFileName") != null && this.filenameText != null) {
            this.filenameText.setText(this.config.get("endpointFileName"));
        }
    }

    protected void createEndpointSettings(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        Composite propertyContainer = new Composite(container, 0);
        propertyContainer.setLayout((Layout)new GridLayout(2, true));
        Label nameLabel = new Label(propertyContainer, 0);
        nameLabel.setText(Messages.nameRequired);
        this.nameText = new Text(propertyContainer, 2048);
        GridData textGridData = new GridData(768);
        this.nameText.setLayoutData((Object)textGridData);
        this.nameText.addListener(25, (Listener)new VariableNameVerifyListener(true));
        LinkedList<DataType> supportedDataTypes = new LinkedList<DataType>();
        supportedDataTypes.add(DataType.ShortText);
        supportedDataTypes.add(DataType.Boolean);
        supportedDataTypes.add(DataType.Integer);
        supportedDataTypes.add(DataType.Float);
        supportedDataTypes.add(DataType.Vector);
        supportedDataTypes.add(DataType.Matrix);
        supportedDataTypes.add(DataType.FileReference);
        supportedDataTypes.add(DataType.DirectoryReference);
        new Label(propertyContainer, 0).setText(Messages.dataTypeColon);
        this.dataTypeCombo = new Combo(propertyContainer, 8);
        DataType[] dataTypeArray = DataType.values();
        int n = dataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataType t = dataTypeArray[n2];
            if (supportedDataTypes.contains(t)) {
                this.dataTypeCombo.add(t.getDisplayName());
                guiNameToDataType.put(t.getDisplayName(), t);
            }
            ++n2;
        }
        this.dataTypeCombo.select(0);
        GridData dataTypeData = new GridData(768);
        this.dataTypeCombo.setLayoutData((Object)dataTypeData);
        if (this.type.equals("inputs")) {
            new Label(propertyContainer, 0).setText(Messages.inputHandlingColon);
            this.inputDatumHandlingButtons[0] = new Button(propertyContainer, 32);
            this.inputDatumHandlingButtons[0].setText(inputDatumHandlings.get(0).getDisplayName());
            new Label(propertyContainer, 0);
            this.inputDatumHandlingButtons[1] = new Button(propertyContainer, 32);
            this.inputDatumHandlingButtons[1].setText(inputDatumHandlings.get(1).getDisplayName());
            new Label(propertyContainer, 0);
            this.inputDatumHandlingButtons[2] = new Button(propertyContainer, 32);
            this.inputDatumHandlingButtons[2].setText(inputDatumHandlings.get(2).getDisplayName());
            new Label(propertyContainer, 0).setText(Messages.defaultInputHandlingColon);
            this.defaultInputDatumHandlingCombo = new Combo(propertyContainer, 8);
            dataTypeData = new GridData(768);
            this.defaultInputDatumHandlingCombo.setLayoutData((Object)dataTypeData);
            new Label(propertyContainer, 0).setText(Messages.inputExecutionConstraintColon);
            this.inputExecutionConstraintButtons[0] = new Button(propertyContainer, 32);
            this.inputExecutionConstraintButtons[0].setText(inputExecutionConstraints.get(0).getDisplayName());
            new Label(propertyContainer, 0);
            this.inputExecutionConstraintButtons[1] = new Button(propertyContainer, 32);
            this.inputExecutionConstraintButtons[1].setText(inputExecutionConstraints.get(1).getDisplayName());
            new Label(propertyContainer, 0);
            this.inputExecutionConstraintButtons[2] = new Button(propertyContainer, 32);
            this.inputExecutionConstraintButtons[2].setText(inputExecutionConstraints.get(2).getDisplayName());
            new Label(propertyContainer, 0).setText(Messages.defaultInputExecutionConstraintColon);
            this.defaultInputExecutionConstraintCombo = new Combo(propertyContainer, 8);
            dataTypeData = new GridData(768);
            this.defaultInputExecutionConstraintCombo.setLayoutData((Object)dataTypeData);
            this.filenameText = null;
        }
    }

    private int getIndexFromSelectionIndexForInputHandling(int selectionIndex) {
        int count = -1;
        int i = 0;
        while (i < this.inputDatumHandlingButtons.length) {
            if (this.inputDatumHandlingButtons[i].getSelection() && ++count == selectionIndex) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getIndexFromSelectionIndexForExecutionConstraint(int selectionIndex) {
        int count = -1;
        int i = 0;
        while (i < this.inputExecutionConstraintButtons.length) {
            if (this.inputExecutionConstraintButtons[i].getSelection() && ++count == selectionIndex) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void saveAllConfig() {
        this.config.put("endpointName", this.nameText.getText());
        if (this.type.equals("inputs")) {
            Button b;
            ArrayList<String> parts = new ArrayList<String>();
            int i = 0;
            Button[] buttonArray = this.inputDatumHandlingButtons;
            int n = this.inputDatumHandlingButtons.length;
            int n2 = 0;
            while (n2 < n) {
                b = buttonArray[n2];
                if (b.getSelection()) {
                    parts.add(inputDatumHandlings.get(i).name());
                }
                ++i;
                ++n2;
            }
            this.config.put("inputHandling", StringUtils.escapeAndConcat(parts));
            if (this.defaultInputDatumHandlingCombo.getSelectionIndex() >= 0) {
                this.config.put("defaultInputHandling", inputDatumHandlings.get(this.getIndexFromSelectionIndexForInputHandling(this.defaultInputDatumHandlingCombo.getSelectionIndex())).name());
            }
            parts = new ArrayList();
            i = 0;
            buttonArray = this.inputExecutionConstraintButtons;
            n = this.inputExecutionConstraintButtons.length;
            n2 = 0;
            while (n2 < n) {
                b = buttonArray[n2];
                if (b.getSelection()) {
                    parts.add(inputExecutionConstraints.get(i).name());
                }
                ++i;
                ++n2;
            }
            this.config.put("inputExecutionConstraint", StringUtils.escapeAndConcat(parts));
            if (this.defaultInputExecutionConstraintCombo.getSelectionIndex() >= 0) {
                this.config.put("defaultInputExecutionConstraint", inputExecutionConstraints.get(this.getIndexFromSelectionIndexForExecutionConstraint(this.defaultInputExecutionConstraintCombo.getSelectionIndex())).name());
            }
        } else {
            this.config.put("inputHandling", "-");
            this.config.put("inputExecutionConstraint", "-");
        }
        this.config.put("endpointDataType", guiNameToDataType.get(this.dataTypeCombo.getText()).name());
        if (this.dataTypeCombo.getText().equals(DataType.FileReference.getDisplayName()) || this.dataTypeCombo.getText().equals(DataType.DirectoryReference.getDisplayName())) {
            if (this.filenameText != null) {
                this.config.put("endpointFileName", this.filenameText.getText());
            }
            if (this.type.equals("inputs")) {
                this.config.put("endpointFolder", INPUT_FOLDER_STANDARD_NAME);
            }
        } else {
            this.config.put("endpointFileName", NO_VALUE_STRING);
            this.config.put("endpointFolder", NO_VALUE_STRING);
        }
    }

    public void create() {
        super.create();
        this.getShell().setText(this.title);
        this.validateInput();
        this.installModifyListeners();
    }

    private void fillInputHandlingComboForDefaultSelection(boolean init) {
        String itemSelected = null;
        if (init && this.config.containsKey("defaultInputHandling")) {
            itemSelected = EndpointDefinition.InputDatumHandling.valueOf((String)this.config.get("defaultInputHandling")).getDisplayName();
        } else if (this.defaultInputDatumHandlingCombo.getItemCount() > 0) {
            itemSelected = this.defaultInputDatumHandlingCombo.getItem(this.defaultInputDatumHandlingCombo.getSelectionIndex());
        }
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        while (i < inputDatumHandlings.size()) {
            if (this.inputDatumHandlingButtons[i].getSelection()) {
                items.add(inputDatumHandlings.get(i).getDisplayName());
            }
            ++i;
        }
        this.defaultInputDatumHandlingCombo.setItems(items.toArray(new String[items.size()]));
        if (items.contains(itemSelected)) {
            this.defaultInputDatumHandlingCombo.select(items.indexOf(itemSelected));
        } else {
            this.defaultInputDatumHandlingCombo.select(0);
        }
    }

    private void fillInputExecutionConstraintsComboForDefaultSelection(boolean init) {
        String itemSelected = null;
        if (init && this.config.containsKey("defaultInputExecutionConstraint")) {
            itemSelected = EndpointDefinition.InputExecutionContraint.valueOf((String)this.config.get("defaultInputExecutionConstraint")).getDisplayName();
        } else if (this.defaultInputExecutionConstraintCombo.getItemCount() > 0) {
            itemSelected = this.defaultInputExecutionConstraintCombo.getItem(this.defaultInputExecutionConstraintCombo.getSelectionIndex());
        }
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        while (i < inputExecutionConstraints.size()) {
            if (this.inputExecutionConstraintButtons[i].getSelection()) {
                items.add(inputExecutionConstraints.get(i).getDisplayName());
            }
            ++i;
        }
        this.defaultInputExecutionConstraintCombo.setItems(items.toArray(new String[items.size()]));
        if (items.contains(itemSelected)) {
            this.defaultInputExecutionConstraintCombo.select(items.indexOf(itemSelected));
        } else {
            this.defaultInputExecutionConstraintCombo.select(0);
        }
    }

    private void installModifyListeners() {
        SelectionListener defaultSl = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                WizardEndpointEditDialog.this.saveAllConfig();
                WizardEndpointEditDialog.this.validateInput();
            }
        };
        this.dataTypeCombo.addSelectionListener(defaultSl);
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                WizardEndpointEditDialog.this.saveAllConfig();
                WizardEndpointEditDialog.this.validateInput();
            }
        };
        this.nameText.addModifyListener(ml);
        if (this.filenameText != null) {
            this.filenameText.addModifyListener(ml);
        }
        if (this.type.equals("inputs")) {
            SelectionListener buttonSl = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    WizardEndpointEditDialog.this.fillInputExecutionConstraintsComboForDefaultSelection(false);
                    WizardEndpointEditDialog.this.fillInputHandlingComboForDefaultSelection(false);
                    WizardEndpointEditDialog.this.saveAllConfig();
                    WizardEndpointEditDialog.this.validateInput();
                }
            };
            this.defaultInputDatumHandlingCombo.addSelectionListener(defaultSl);
            this.defaultInputExecutionConstraintCombo.addSelectionListener(defaultSl);
            if (this.type.equals("inputs")) {
                Button b;
                Button[] buttonArray = this.inputDatumHandlingButtons;
                int n = this.inputDatumHandlingButtons.length;
                int n2 = 0;
                while (n2 < n) {
                    b = buttonArray[n2];
                    b.addSelectionListener(buttonSl);
                    ++n2;
                }
                buttonArray = this.inputExecutionConstraintButtons;
                n = this.inputExecutionConstraintButtons.length;
                n2 = 0;
                while (n2 < n) {
                    b = buttonArray[n2];
                    b.addSelectionListener(buttonSl);
                    ++n2;
                }
            }
        }
    }

    protected void validateInput() {
        Button b;
        int n;
        int n2;
        Button[] buttonArray;
        boolean isValid = true;
        if (this.dataTypeCombo.getText().equals(DataType.FileReference.getDisplayName()) || this.dataTypeCombo.getText().equals(DataType.DirectoryReference.getDisplayName())) {
            if (this.filenameText != null) {
                this.filenameText.setEnabled(true);
            }
        } else if (this.filenameText != null) {
            this.filenameText.setEnabled(false);
        }
        if (this.nameText.getText() == null || this.nameText.getText().isEmpty()) {
            isValid = false;
        }
        if (this.allEndpointNames != null && this.allEndpointNames.contains(this.nameText.getText()) && (this.oldName == null || !this.oldName.equals(this.nameText.getText()))) {
            isValid = false;
        }
        if (this.type.equals("inputs") && isValid) {
            boolean inputHandlingSelected = false;
            buttonArray = this.inputDatumHandlingButtons;
            n2 = this.inputDatumHandlingButtons.length;
            n = 0;
            while (n < n2) {
                b = buttonArray[n];
                if (b.getSelection()) {
                    inputHandlingSelected = true;
                    break;
                }
                ++n;
            }
            isValid = inputHandlingSelected;
        }
        if (this.type.equals("inputs") && isValid) {
            boolean executionConstraintSelected = false;
            buttonArray = this.inputExecutionConstraintButtons;
            n2 = this.inputExecutionConstraintButtons.length;
            n = 0;
            while (n < n2) {
                b = buttonArray[n];
                if (b.getSelection()) {
                    executionConstraintSelected = true;
                    break;
                }
                ++n;
            }
            isValid = executionConstraintSelected;
        }
        this.getButton(0).setEnabled(isValid);
    }

    public Map<String, String> getConfig() {
        return this.config;
    }
}

