/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.utils.common.configuration;

import de.rcenvironment.core.gui.utils.common.configuration.AdapterManager;
import de.rcenvironment.core.gui.utils.common.configuration.IConfigurationSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ConfigurationViewerContentProvider
implements ITreeContentProvider {
    private final ElementFactory elementFactory = new ElementFactory();
    private Element root;
    private final Set<StructuredViewer> viewers = new HashSet<StructuredViewer>();

    public void addViewer(StructuredViewer viewer) {
        this.viewers.add(viewer);
    }

    public void removeViewer(StructuredViewer viewer) {
        this.viewers.remove(viewer);
    }

    public Object[] getElements(Object inputElement) {
        PropertyDescriptor descriptor = new PropertyDescriptor((Object)"<root>", "<root>");
        this.root = this.elementFactory.createElement(null, (IPropertyDescriptor)descriptor, inputElement);
        this.root.setOverrideValue(inputElement);
        return this.getChildren(this.root);
    }

    public Object getParent(Object element) {
        Element treeElement = (Element)element;
        return treeElement.getParent();
    }

    public boolean hasChildren(Object element) {
        Element treeElement = (Element)element;
        if (treeElement instanceof Leaf) {
            return false;
        }
        return ((Node)treeElement).hasChildren();
    }

    public Object[] getChildren(Object parentElement) {
        Element treeElement = (Element)parentElement;
        if (treeElement instanceof Leaf) {
            return new Object[0];
        }
        return ((Node)treeElement).getChildren();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private void fireElementChanged(Element element) {
        for (StructuredViewer viewer : this.viewers) {
            try {
                viewer.refresh((Object)element);
            }
            catch (RuntimeException runtimeException) {
            }
        }
    }

    public static interface ArraySource<T> {
        public T[] getValue();

        public void setValue(T[] var1);
    }

    abstract class Element {
        private final Node parent;
        private final IPropertyDescriptor descriptor;
        private Object overrideValue;

        private Element(Node parent, IPropertyDescriptor descriptor) {
            this.parent = parent;
            this.descriptor = descriptor;
        }

        public void setOverrideValue(Object overrideValue) {
            this.overrideValue = overrideValue;
        }

        protected void initialize() {
            if (this.parent == null) {
                return;
            }
            PropertyChangeListener listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Element element = Element.this;
                    ConfigurationViewerContentProvider.this.fireElementChanged(element);
                }
            };
            try {
                Object bean = this.parent.getValue();
                Method addMethod = bean.getClass().getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
                addMethod.invoke(bean, this.descriptor.getId().toString(), listener);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public Node getParent() {
            return this.parent;
        }

        public String getDisplayName() {
            return this.descriptor.getDisplayName();
        }

        public String getDisplayValue() {
            return this.descriptor.getLabelProvider().getText(this.getValue());
        }

        public String getDescription() {
            return this.descriptor.getDescription();
        }

        public IPropertyDescriptor getPropertyDescriptor() {
            return this.descriptor;
        }

        protected Object getValue() {
            if (this.overrideValue != null) {
                return this.overrideValue;
            }
            return this.parent.getValue(this.descriptor.getId());
        }

        protected void setValue(Object value) {
            if (this.overrideValue != null) {
                throw new UnsupportedOperationException();
            }
            this.parent.setValue(this.descriptor.getId(), value);
        }

        public CellEditor createPropertyEditor(Composite editorParent) {
            return this.descriptor.createPropertyEditor(editorParent);
        }
    }

    protected final class ElementFactory {
        private ElementFactory() {
        }

        private Element createElement(Node parent, IPropertyDescriptor descriptor, Object value) {
            IConfigurationSource source;
            Element result = descriptor.getClass() != PropertyDescriptor.class ? new Leaf(parent, descriptor) : ((source = (IConfigurationSource)AdapterManager.getInstance().getAdapter(value, IConfigurationSource.class)) == null ? new Leaf(parent, descriptor) : new Node(parent, descriptor, source));
            result.initialize();
            return result;
        }
    }

    final class Leaf
    extends Element {
        private Leaf(Node parent, IPropertyDescriptor descriptor) {
            super(parent, descriptor);
        }
    }

    final class Node
    extends Element {
        private final IConfigurationSource source;

        private Node(Node parent, IPropertyDescriptor descriptor, IConfigurationSource source) {
            super(parent, descriptor);
            this.source = source;
        }

        @Override
        public String getDisplayValue() {
            Object editableValue = this.source.getEditableValue();
            if (editableValue instanceof String) {
                return editableValue.toString();
            }
            return super.getDisplayValue();
        }

        private Object getValue(Object id) {
            return this.source.getPropertyValue(id);
        }

        private void setValue(Object id, Object value) {
            this.source.setPropertyValue(id, value);
        }

        public boolean hasChildren() {
            return true;
        }

        public Element[] getChildren() {
            IPropertyDescriptor[] descriptors;
            LinkedList<Element> children = new LinkedList<Element>();
            IPropertyDescriptor[] iPropertyDescriptorArray = descriptors = this.source.getConfigurationPropertyDescriptors();
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                Element child;
                final IPropertyDescriptor descriptor = iPropertyDescriptorArray[n2];
                Object value = this.source.getPropertyValue(descriptor.getId());
                if (value != null && value.getClass().getComponentType() != null) {
                    value = new ArraySource<Object>(){

                        @Override
                        public Object[] getValue() {
                            return (Object[])Node.this.source.getPropertyValue(descriptor.getId());
                        }

                        @Override
                        public void setValue(Object[] value) {
                            Node.this.source.setPropertyValue(descriptor.getId(), value);
                        }
                    };
                }
                if ((child = ConfigurationViewerContentProvider.this.elementFactory.createElement(this, descriptor, value)) != null) {
                    children.add(child);
                }
                ++n2;
            }
            Collections.sort(children, new Comparator<Element>(){

                @Override
                public int compare(Element o1, Element o2) {
                    return o1.getDisplayName().toLowerCase().compareTo(o2.getDisplayName().toLowerCase());
                }
            });
            return children.toArray(new Element[0]);
        }
    }
}

