/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.resources.internal;

import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageManagerImpl
extends ImageManager {
    private final Map<ImageSource, Image> sharedImages = new HashMap<ImageSource, Image>();
    private final Log log = LogFactory.getLog(this.getClass());

    public ImageManagerImpl() {
        this.log.debug((Object)"Image manager initialized");
    }

    @Override
    public Image getSharedImage(final ImageSource source) {
        final AtomicReference ref = new AtomicReference();
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = ImageManagerImpl.this.sharedImages;
                synchronized (map) {
                    Image image = (Image)ImageManagerImpl.this.sharedImages.get(source);
                    if (image == null) {
                        image = source.getImageDescriptor().createImage();
                        ImageManagerImpl.this.sharedImages.put(source, image);
                    }
                    ref.set(image);
                }
            }
        });
        Image image = (Image)ref.get();
        if (image == null) {
            throw new IllegalStateException("Image reference null at the end of getSharedImage()");
        }
        return image;
    }

    @Override
    public ImageDescriptor getImageDescriptor(ImageSource source) {
        return source.getImageDescriptor();
    }

    @Override
    public byte[] getImageBytes(ImageSource source) {
        this.log.debug((Object)("Providing raw image data for " + source));
        return source.getImageDescriptor().getImageData().data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Map<ImageSource, Image> map = this.sharedImages;
        synchronized (map) {
            this.log.debug((Object)("Disposing " + this.sharedImages.values().size() + " shared images"));
            for (Image image : this.sharedImages.values()) {
                image.dispose();
            }
            this.sharedImages.clear();
        }
        this.log.debug((Object)"Image manager disposed");
    }
}

