/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.configuration;

import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.utils.common.EditorsHelper;
import de.rcenvironment.core.start.gui.WorkspaceSettings;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import java.io.File;
import java.io.FileFilter;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;

public class ConfigurationInformationDialog
extends Dialog {
    private static final int MINIMUM_HEIGHT = 250;
    private static final int MINIMUM_WIDTH = 500;
    private final ConfigurationService configurationService;
    private SortedMap<String, File> exampleConfigFileNamesAndPaths;
    private String profileConfigPath = "";
    private String installationConfigPath = "";
    private String workspaceLocation = "";
    private boolean dontAskForWorkspaceLocationOnStartup = false;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Button loadButton;
    private List examplesList;
    private Button askWorkspaceLocationButton;

    public ConfigurationInformationDialog(Shell parentShell) {
        super(parentShell);
        this.configurationService = (ConfigurationService)ServiceRegistry.createAccessFor((Object)((Object)this)).getService(ConfigurationService.class);
        this.setShellStyle(34928);
        this.initConfigurationFileAndPathMapping();
        this.loadConfigurationDetails();
    }

    protected void configureShell(Shell shell) {
        shell.setText("Configuration Information");
        shell.setMinimumSize(500, 250);
        super.configureShell(shell);
    }

    private void loadConfigurationDetails() {
        this.profileConfigPath = this.configurationService.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_ROOT).getAbsolutePath();
        this.installationConfigPath = this.configurationService.getConfigurablePath(ConfigurationService.ConfigurablePathId.INSTALLATION_DATA_ROOT).getAbsolutePath();
        WorkspaceSettings workspaceSettings = WorkspaceSettings.getInstance();
        this.workspaceLocation = workspaceSettings.getLastLocation();
        this.dontAskForWorkspaceLocationOnStartup = workspaceSettings.getDontAskAgainSetting();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayoutData((Object)new GridData(4, 4, true, true));
        dialogArea.setLayout((Layout)new GridLayout());
        ScrolledComposite scrolled = new ScrolledComposite(dialogArea, 2816);
        scrolled.setLayoutData((Object)new GridData(4, 4, true, true));
        scrolled.setLayout((Layout)new GridLayout());
        scrolled.setExpandVertical(true);
        scrolled.setExpandHorizontal(true);
        Composite container = new Composite((Composite)scrolled, 0);
        scrolled.setContent((Control)container);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout());
        Group informationGroup = new Group(container, 0);
        informationGroup.setText("General");
        GridLayout informationGroupGridLayout = new GridLayout(1, true);
        informationGroup.setLayout((Layout)informationGroupGridLayout);
        GridData informationGroupGridData = new GridData();
        informationGroupGridData.grabExcessHorizontalSpace = true;
        informationGroupGridData.verticalAlignment = 1;
        informationGroupGridData.horizontalAlignment = 4;
        informationGroup.setLayoutData((Object)informationGroupGridData);
        CLabel informationLabel = new CLabel((Composite)informationGroup, 0);
        informationLabel.setText("You need to configure RCE to change the name of your instance, connect your instance to others, etc.\nAll configuration is done within a single file called \"configuration.json\" in your profile directory \n(see 'File System Locations' below). You can easily open and edit it with the \"Configuration > Open Configuration File\" \nmenu option, or with the corresponding tool bar button.");
        informationLabel.setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.INFORMATION_16));
        Group examplesGroup = new Group(container, 0);
        examplesGroup.setText("Example Configurations");
        GridLayout examplesGroupGridLayout = new GridLayout(1, true);
        examplesGroup.setLayout((Layout)examplesGroupGridLayout);
        GridData examplesGroupGridData = new GridData();
        examplesGroupGridData.grabExcessHorizontalSpace = true;
        examplesGroupGridData.verticalAlignment = 1;
        examplesGroupGridData.horizontalAlignment = 4;
        examplesGroup.setLayoutData((Object)examplesGroupGridData);
        CLabel exampleLabel = new CLabel((Composite)examplesGroup, 0);
        exampleLabel.setText("The following list shows configuration examples for typical configuration scenarios. You can open them, copy their \ncontent into your own configuration file, and adapt it to suit your needs. A special example file called \n\"Configuration Reference\" contains all existing parameters, which you can use for reference.\n ");
        this.examplesList = new List((Composite)examplesGroup, 2564);
        String[] examplesItems = this.exampleConfigFileNamesAndPaths.keySet().toArray(new String[this.exampleConfigFileNamesAndPaths.keySet().size()]);
        this.examplesList.setItems(examplesItems);
        this.examplesList.setLayoutData((Object)new GridData(4, 1, true, false));
        this.examplesList.addSelectionListener((SelectionListener)new ExampleListSelectionListener());
        this.examplesList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                ConfigurationInformationDialog.this.openSelectionInEditor();
                ConfigurationInformationDialog.this.closeConfigurationDialog();
            }
        });
        this.loadButton = new Button((Composite)examplesGroup, 8);
        this.loadButton.setText("Open in editor (read-only)");
        this.loadButton.setEnabled(false);
        this.loadButton.addSelectionListener((SelectionListener)new LoadButtonSelectionListener());
        Group locationsGroup = new Group(container, 0);
        locationsGroup.setText("File System Locations");
        GridLayout locationsGroupGridLayout = new GridLayout(2, false);
        locationsGroup.setLayout((Layout)locationsGroupGridLayout);
        GridData locationsGroupGridData = new GridData();
        locationsGroupGridData.grabExcessHorizontalSpace = true;
        locationsGroupGridData.verticalAlignment = 1;
        locationsGroupGridData.horizontalAlignment = 4;
        locationsGroup.setLayoutData((Object)locationsGroupGridData);
        Label installationLabel = new Label((Composite)locationsGroup, 0);
        installationLabel.setText("Installation:");
        Text installationConfigText = new Text((Composite)locationsGroup, 2056);
        installationConfigText.setText(this.installationConfigPath);
        installationConfigText.setLayoutData((Object)new GridData(4, 0, true, false));
        installationConfigText.setBackground(Display.getDefault().getSystemColor(19));
        Label profileLabel = new Label((Composite)locationsGroup, 0);
        profileLabel.setText("Profile:");
        Text profileConfigText = new Text((Composite)locationsGroup, 2056);
        profileConfigText.setText(this.profileConfigPath);
        profileConfigText.setLayoutData((Object)new GridData(4, 0, true, false));
        profileConfigText.setBackground(Display.getDefault().getSystemColor(19));
        Label workspaceLabel = new Label((Composite)locationsGroup, 0);
        workspaceLabel.setText("Workspace:");
        Text workspaceText = new Text((Composite)locationsGroup, 2056);
        workspaceText.setText(this.workspaceLocation);
        workspaceText.setLayoutData((Object)new GridData(4, 0, true, false));
        workspaceText.setBackground(Display.getDefault().getSystemColor(19));
        new Label((Composite)locationsGroup, 0);
        this.askWorkspaceLocationButton = new Button((Composite)locationsGroup, 32);
        this.askWorkspaceLocationButton.setText("Always use this workspace location (don't ask on startup)");
        this.askWorkspaceLocationButton.setSelection(this.dontAskForWorkspaceLocationOnStartup);
        this.askWorkspaceLocationButton.addSelectionListener((SelectionListener)new AskWorkspaceToggleButtonListener());
        GridData checkBoxData = new GridData();
        checkBoxData.horizontalIndent = 10;
        this.askWorkspaceLocationButton.setLayoutData((Object)checkBoxData);
        Group applyGroup = new Group(container, 0);
        applyGroup.setText("Apply Changes");
        GridLayout applyGroupGridLayout = new GridLayout(1, true);
        applyGroup.setLayout((Layout)applyGroupGridLayout);
        GridData applyGroupGridData = new GridData();
        applyGroupGridData.grabExcessHorizontalSpace = true;
        applyGroupGridData.verticalAlignment = 1;
        applyGroupGridData.horizontalAlignment = 4;
        applyGroup.setLayoutData((Object)applyGroupGridData);
        CLabel applyLabel = new CLabel((Composite)applyGroup, 0);
        applyLabel.setText("You need to restart RCE to apply any changes you made in the configuration file.\nNote that there is a \"Restart\" shortcut in the \"File\" menu for this.");
        applyLabel.setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.INFORMATION_16));
        container.setSize(container.computeSize(0, 0, true));
        scrolled.setMinSize(this.getInitialSize());
        scrolled.setVisible(true);
        return dialogArea;
    }

    private void initConfigurationFileAndPathMapping() {
        File[] files;
        this.exampleConfigFileNamesAndPaths = new TreeMap<String, File>(new Comparator<String>(){
            private static final String REMOTE_ACCESS = "Remote Access";
            private static final int MINUS_ONE = -1;

            @Override
            public int compare(String s1, String s2) {
                if (s1.startsWith(REMOTE_ACCESS) && !s2.startsWith(REMOTE_ACCESS)) {
                    return 1;
                }
                if (s2.startsWith(REMOTE_ACCESS) && !s1.startsWith(REMOTE_ACCESS)) {
                    return -1;
                }
                return s1.compareTo(s2);
            }
        });
        File examplesDir = this.configurationService.getConfigurablePath(ConfigurationService.ConfigurablePathId.CONFIGURATION_SAMPLES_LOCATION);
        if (!examplesDir.isDirectory()) {
            this.log.warn((Object)("Expected location for configuration example files does not exist: " + examplesDir.getAbsolutePath()));
            return;
        }
        File[] fileArray = files = examplesDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".sample");
            }
        });
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String name = file.getName();
            String shortName = WordUtils.capitalize((String)name.replaceFirst("^configuration\\.json\\.(.+)\\.sample$", "$1").replace("_", " "));
            this.exampleConfigFileNamesAndPaths.put(shortName, file);
            ++n2;
        }
    }

    private void closeConfigurationDialog() {
        this.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private void openSelectionInEditor() {
        int selectionIndex;
        if (this.examplesList.getSelectionCount() == 1 && (selectionIndex = this.examplesList.getSelectionIndex()) < this.examplesList.getItemCount()) {
            String selection = this.examplesList.getItem(selectionIndex);
            File configFile = (File)this.exampleConfigFileNamesAndPaths.get(selection);
            try {
                configFile.setReadOnly();
                EditorsHelper.openExternalFileInEditor((File)configFile, (Runnable[])new Runnable[0]);
            }
            catch (PartInitException e) {
                this.log.error((Object)"Failed to open profile configuration file in an editor.", (Throwable)e);
            }
        }
    }

    private final class AskWorkspaceToggleButtonListener
    implements SelectionListener {
        private AskWorkspaceToggleButtonListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            boolean newDontAskAgainValue = ConfigurationInformationDialog.this.askWorkspaceLocationButton.getSelection();
            WorkspaceSettings.getInstance().setDontAskAgainSetting(newDontAskAgainValue);
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetDefaultSelected(event);
        }
    }

    private final class ExampleListSelectionListener
    implements SelectionListener {
        private ExampleListSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            if (ConfigurationInformationDialog.this.examplesList.getSelectionCount() == 1) {
                ConfigurationInformationDialog.this.loadButton.setEnabled(true);
            }
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }
    }

    private final class LoadButtonSelectionListener
    implements SelectionListener {
        private LoadButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            ConfigurationInformationDialog.this.openSelectionInEditor();
            ConfigurationInformationDialog.this.closeConfigurationDialog();
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }
    }
}

