/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.LogFactory;

public final class SshAccountRole {
    private String roleName;
    private List<String> allowedCommandPatterns;
    private List<String> disallowedCommandPatterns;
    private String allowedCommandRegEx = null;
    private String disallowedCommandRegEx = null;
    private boolean allowedToOpenShell = true;
    private boolean allowedToUseUplink = false;

    public SshAccountRole(String roleName) {
        this.roleName = roleName;
        this.allowedCommandPatterns = new ArrayList<String>();
        this.disallowedCommandPatterns = new ArrayList<String>();
        switch (roleName) {
            case "remote access": 
            case "remote_access_user": {
                this.allowedCommandPatterns.add("ra .*");
                this.allowedCommandPatterns.add("sysmon.*");
                this.allowedToUseUplink = true;
                break;
            }
            case "remote_access_admin": {
                this.allowedCommandPatterns.add("ra.*");
                this.allowedCommandPatterns.add("sysmon.*");
                this.allowedCommandPatterns.add("components.*");
                break;
            }
            case "workflow_observer": {
                this.allowedCommandPatterns.add("components.*");
                this.allowedCommandPatterns.add("net info|net");
                this.allowedCommandPatterns.add("sysmon.*");
                this.allowedCommandPatterns.add("wf list");
                this.allowedCommandPatterns.add("wf details.*");
                this.allowedCommandPatterns.add("wf");
                break;
            }
            case "workflow_admin": {
                this.allowedCommandPatterns.add("components.*");
                this.allowedCommandPatterns.add("net info|net");
                this.allowedCommandPatterns.add("sysmon.*");
                this.allowedCommandPatterns.add("wf.*");
                break;
            }
            case "local_admin": {
                this.allowedCommandPatterns.add("cn.*");
                this.allowedCommandPatterns.add("components.*");
                this.allowedCommandPatterns.add("mail.*");
                this.allowedCommandPatterns.add("net.*");
                this.allowedCommandPatterns.add("restart");
                this.allowedCommandPatterns.add("shutdown");
                this.allowedCommandPatterns.add("stop");
                this.allowedCommandPatterns.add("stats");
                this.allowedCommandPatterns.add("tasks.*");
                this.allowedCommandPatterns.add("auth .*");
                break;
            }
            case "instance_management_admin": {
                this.allowedCommandPatterns.add("im.*");
                this.allowedCommandPatterns.add("auth .*");
                this.allowedCommandPatterns.add("net info|net");
                break;
            }
            case "instance_management_delegate_user": {
                this.allowedCommandPatterns.add("cn.*");
                this.allowedCommandPatterns.add("components.*");
                this.allowedCommandPatterns.add("net.*");
                this.allowedCommandPatterns.add("restart");
                this.allowedCommandPatterns.add("shutdown");
                this.allowedCommandPatterns.add("stop");
                this.allowedCommandPatterns.add("stats");
                this.allowedCommandPatterns.add("tasks.*");
                this.allowedCommandPatterns.add("wf.*");
                this.allowedCommandPatterns.add("ra-admin.*");
                this.allowedCommandPatterns.add("tc.*");
                this.allowedCommandPatterns.add("uplink.*");
                this.allowedCommandPatterns.add("force-crash.*");
                this.allowedCommandPatterns.add("auth .*");
                break;
            }
            case "developer": {
                this.allowedCommandPatterns.add(".*");
                break;
            }
            case "uplink_client": {
                this.allowedToOpenShell = false;
                this.allowedToUseUplink = true;
                break;
            }
            default: {
                this.roleName = "default";
                LogFactory.getLog(this.getClass()).warn((Object)("Tried to create a role with a name that is not allowed: " + roleName));
            }
            case "default": 
        }
        this.allowedCommandPatterns.add("dummy");
        if (!"developer".equals(roleName)) {
            this.disallowedCommandPatterns.add("wf open.*");
        }
    }

    public boolean isAllowedToUseUplink() {
        return this.allowedToUseUplink;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getAllowedCommandRegEx() {
        if (this.allowedCommandRegEx == null) {
            StringBuilder regExBuilder = new StringBuilder("help|exit|(version.*)");
            for (String pattern : this.allowedCommandPatterns) {
                regExBuilder.append(String.format("|(%s)", pattern.trim()));
            }
            this.allowedCommandRegEx = regExBuilder.toString();
        }
        return this.allowedCommandRegEx;
    }

    public String getDisallowedCommandRegEx() {
        if (this.disallowedCommandRegEx == null) {
            StringBuilder regExBuilder = new StringBuilder();
            for (String pattern : this.disallowedCommandPatterns) {
                regExBuilder.append(String.format("|(%s)", pattern.trim()));
            }
            this.disallowedCommandRegEx = regExBuilder.toString();
        }
        return this.disallowedCommandRegEx;
    }

    public boolean isAllowedToOpenShell() {
        return this.allowedToOpenShell;
    }

    public int hashCode() {
        return this.roleName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SshAccountRole) {
            SshAccountRole other = (SshAccountRole)obj;
            return this.roleName.equals(other.getRoleName());
        }
        return false;
    }
}

