/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.internal;

import de.rcenvironment.core.authorization.AuthorizationException;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.datamanagement.DataManagementService;
import de.rcenvironment.core.datamanagement.DataReferenceService;
import de.rcenvironment.core.datamanagement.FileDataService;
import de.rcenvironment.core.datamanagement.commons.DataReference;
import de.rcenvironment.core.datamanagement.commons.MetaDataSet;
import de.rcenvironment.core.utils.common.CrossPlatformFilenameUtils;
import de.rcenvironment.core.utils.common.FileCompressionFormat;
import de.rcenvironment.core.utils.common.FileCompressionService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataManagementServiceImpl
implements DataManagementService {
    private static final String STRING_FILENAME_NOT_VALID = "Filename/path '%s' contains characters that are not valid for all operating systems; it might lead to problems when accessing the file on another operating system";
    private static final String STRING_DIR_NAME_NOT_VALID = "Directory name/path '%s' contains characters that are not valid for all operating systems; it might lead to problems when accessing the directory on another operating system";
    private static final String ARCHIVE_TAR_GZ = "archive.tar.gz";
    private static final int BUFFER = 1024;
    private static final String REFERENCE_NOT_FOUND_MESSAGE = "No such data entry (id='%s').";
    private static final String TAR_GZ_PATH_SEPARATOR = "/";
    private static final Log LOGGER = LogFactory.getLog(DataManagementServiceImpl.class);
    private FileDataService fileDataService;
    private DataReferenceService dataReferenceService;

    @Override
    public String createReferenceFromLocalFile(File file, MetaDataSet additionalMetaData, NetworkDestination nodeId) throws IOException, AuthorizationException, InterruptedException, CommunicationException {
        if (!CrossPlatformFilenameUtils.isFilenameValid((String)file.getName())) {
            LOGGER.warn((Object)StringUtils.format((String)STRING_FILENAME_NOT_VALID, (Object[])new Object[]{file.getName()}));
        }
        return this.createReferenceFromStream(new FileInputStream(file), additionalMetaData, nodeId, false);
    }

    @Override
    public String createReferenceFromLocalFile(File file, MetaDataSet additionalMetaData, NetworkDestination nodeId, boolean alreadyCompressed) throws IOException, AuthorizationException, InterruptedException, CommunicationException {
        return this.createReferenceFromStream(new FileInputStream(file), additionalMetaData, nodeId, alreadyCompressed);
    }

    private String createReferenceFromStream(InputStream inputStream, MetaDataSet additionalMetaData, NetworkDestination nodeId, boolean alreadyCompressed) throws IOException, AuthorizationException, InterruptedException, CommunicationException {
        if (additionalMetaData == null) {
            additionalMetaData = new MetaDataSet();
        }
        try {
            DataReference dataRef = this.fileDataService.newReferenceFromStream(inputStream, additionalMetaData, nodeId, alreadyCompressed);
            String string = dataRef.getDataReferenceKey().toString();
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    @Override
    public String createReferenceFromLocalDirectory(File dir, MetaDataSet additionalMetaData, NetworkDestination nodeId) throws IOException, AuthorizationException, InterruptedException, CommunicationException {
        if (!CrossPlatformFilenameUtils.isFilenameValid((String)dir.getName())) {
            LOGGER.warn((Object)StringUtils.format((String)STRING_DIR_NAME_NOT_VALID, (Object[])new Object[]{dir.getName()}));
        }
        File archive = TempFileServiceAccess.getInstance().createTempFileWithFixedFilename(ARCHIVE_TAR_GZ);
        try {
            String string;
            block15: {
                if (!FileCompressionService.compressDirectoryToFile((File)dir, (File)archive, (FileCompressionFormat)FileCompressionFormat.TAR_GZ, (Boolean)true).booleanValue()) {
                    LOGGER.error((Object)"Was not able to create a reference from a local directory due to an issue with the compression.");
                    throw new IOException("Was not able to create a reference from a local directory due to an issue with the compression.");
                }
                Throwable throwable = null;
                Object var6_7 = null;
                FileInputStream fileInputStream = new FileInputStream(archive);
                try {
                    string = this.createReferenceFromStream(fileInputStream, additionalMetaData, nodeId, false);
                    if (fileInputStream == null) break block15;
                }
                catch (Throwable throwable2) {
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                fileInputStream.close();
            }
            return string;
        }
        finally {
            TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(archive);
        }
    }

    @Override
    public String createReferenceFromString(String object, MetaDataSet additionalMetaData, NetworkDestination nodeId) throws IOException, AuthorizationException, InterruptedException, CommunicationException {
        if (additionalMetaData == null) {
            additionalMetaData = new MetaDataSet();
        }
        InputStream inputStream = IOUtils.toInputStream((String)object);
        try {
            DataReference dataRef = this.fileDataService.newReferenceFromStream(inputStream, additionalMetaData, nodeId);
            String string = dataRef.getDataReferenceKey().toString();
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    @Override
    public void copyReferenceToLocalFile(String reference, File targetFile, NetworkDestination nodeId) throws IOException, CommunicationException {
        this.copyReferenceToLocalFile(reference, targetFile, nodeId, true);
    }

    @Override
    public void copyReferenceToLocalFile(String reference, File targetFile, NetworkDestination nodeId, boolean decompress) throws IOException, CommunicationException {
        DataReference dataRef = nodeId == null ? this.dataReferenceService.getReference(reference) : this.dataReferenceService.getReference(reference, nodeId);
        if (dataRef == null) {
            throw new FileNotFoundException(StringUtils.format((String)REFERENCE_NOT_FOUND_MESSAGE, (Object[])new Object[]{reference}));
        }
        InputStream dataMgmtStream = this.fileDataService.getStreamFromDataReference(dataRef);
        try {
            FileUtils.copyInputStreamToFile((InputStream)dataMgmtStream, (File)targetFile);
        }
        finally {
            IOUtils.closeQuietly((InputStream)dataMgmtStream);
        }
    }

    @Override
    @Deprecated
    public void copyReferenceToLocalFile(String reference, File targetFile, Collection<? extends NetworkDestination> platforms) throws IOException, AuthorizationException, CommunicationException {
        DataReference dataRef = platforms == null || platforms.size() == 0 ? this.dataReferenceService.getReference(reference) : this.dataReferenceService.getReference(reference, platforms);
        if (dataRef == null) {
            throw new FileNotFoundException(StringUtils.format((String)REFERENCE_NOT_FOUND_MESSAGE, (Object[])new Object[]{reference}));
        }
        InputStream dataMgmtStream = this.fileDataService.getStreamFromDataReference(dataRef);
        try {
            FileUtils.copyInputStreamToFile((InputStream)dataMgmtStream, (File)targetFile);
        }
        finally {
            IOUtils.closeQuietly((InputStream)dataMgmtStream);
        }
    }

    @Override
    public void copyReferenceToLocalDirectory(String reference, File targetDir, NetworkDestination node) throws IOException, CommunicationException {
        File archive = TempFileServiceAccess.getInstance().createTempFileWithFixedFilename(ARCHIVE_TAR_GZ);
        try {
            this.copyReferenceToLocalFile(reference, archive, node);
            if (!FileCompressionService.expandCompressedDirectoryFromFile((File)archive, (File)targetDir, (FileCompressionFormat)FileCompressionFormat.TAR_GZ).booleanValue()) {
                LOGGER.error((Object)"Was not able to copy reference to local directory due to an uncompression issue.");
                throw new CommunicationException("Was not able to copy reference to local directory due to an uncompression issue.");
            }
        }
        finally {
            TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(archive);
        }
    }

    @Override
    public String retrieveStringFromReference(String reference, NetworkDestination nodeId) throws IOException, AuthorizationException, CommunicationException {
        DataReference dataRef = nodeId == null ? this.dataReferenceService.getReference(reference) : this.dataReferenceService.getReference(reference, nodeId);
        if (dataRef == null) {
            throw new FileNotFoundException(StringUtils.format((String)REFERENCE_NOT_FOUND_MESSAGE, (Object[])new Object[]{reference}));
        }
        InputStream dataMgmtStream = this.fileDataService.getStreamFromDataReference(dataRef);
        try {
            String string = IOUtils.toString((InputStream)dataMgmtStream);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)dataMgmtStream);
        }
    }

    protected void bindFileDataService(FileDataService newValue) {
        this.fileDataService = newValue;
    }

    protected void bindDataReferenceService(DataReferenceService newValue) {
        this.dataReferenceService = newValue;
    }
}

