/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.testutils;

import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.execution.api.Component;
import de.rcenvironment.core.component.execution.api.ThreadHandler;
import de.rcenvironment.core.component.testutils.ComponentContextMock;

public class ComponentTestWrapper {
    private final Component component;
    private final ComponentContextMock context;
    private boolean started;

    public ComponentTestWrapper(Component component, ComponentContextMock context) {
        this.component = component;
        this.context = context;
        component.setComponentContext(context);
    }

    public synchronized void start() throws ComponentException {
        if (this.started) {
            throw new IllegalStateException("start() was called more than once");
        }
        this.started = true;
        if (this.component.treatStartAsComponentRun()) {
            this.context.incrementExecutionCount();
            this.context.resetOutputClosings();
        }
        this.component.start();
    }

    public synchronized void processInputs() throws ComponentException {
        if (!this.started) {
            throw new IllegalStateException("processInputs() called before start()");
        }
        if (this.context.getInputsWithDatum().isEmpty()) {
            throw new IllegalStateException("processInputs() was called without input");
        }
        this.context.incrementExecutionCount();
        this.context.resetOutputData();
        this.context.resetOutputClosings();
        this.context.resetOutputResets();
        this.component.processInputs();
        this.context.resetInputData();
    }

    public synchronized void reset() throws ComponentException {
        if (!this.started) {
            throw new IllegalStateException("reset() called before start()");
        }
        this.component.reset();
    }

    public synchronized void dispose() {
        if (!this.started) {
            throw new IllegalStateException("dispose() called before start()");
        }
        this.component.dispose();
    }

    public synchronized void tearDown(Component.FinalComponentState state) {
        if (!this.started) {
            throw new IllegalStateException("tearDown() called before start()");
        }
        this.component.tearDown(state);
    }

    public void onStartInterrupted(ThreadHandler executingThreadHandler) {
        this.component.onStartInterrupted(executingThreadHandler);
    }

    public synchronized void tearDownAndDispose(Component.FinalComponentState state) {
        this.tearDown(state);
        this.dispose();
    }
}

