/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.impl;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.api.ServiceCallContext;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.component.execution.api.ComponentExecutionContext;
import de.rcenvironment.core.component.execution.api.ComponentExecutionIdentifier;
import de.rcenvironment.core.component.execution.api.WorkflowGraph;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDatumRecipient;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDatumRecipientFactory;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComponentExecutionContextImpl
implements ComponentExecutionContext {
    private static final long serialVersionUID = -6480792333241604054L;
    private ComponentExecutionIdentifier executionIdentifier;
    private String instanceName;
    private LogicalNodeId controllerNode;
    private String workflowExecutionIdentifier;
    private String workflowInstanceName;
    private ComponentDescription componentDescription;
    private boolean isConnectedToEndpointDatumSenders;
    private Map<String, List<String>> serializedEndpointDatumRecipients = new HashMap<String, List<String>>();
    private File workingDirectory;
    private WorkflowGraph workflowGraph;
    private Long workflowInstanceDataManagementId;
    private Long instanceDataManagementId;
    private Map<String, Long> inputDataManagementIds;
    private Map<String, Long> outputDataManagementIds;
    private Map<String, List<EndpointDatumRecipient>> endpointDatumRecipients;
    private NetworkDestination workflowStorageNetworkDestination;
    private NetworkDestination workflowControllerNetworkDestination;
    private LogicalNodeId storageNodeId;

    @Override
    @Deprecated
    public String getExecutionIdentifier() {
        return this.executionIdentifier.toString();
    }

    @Override
    public ComponentExecutionIdentifier getExecutionIdentifierAsObject() {
        return this.executionIdentifier;
    }

    @Override
    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public LogicalNodeId getWorkflowNodeId() {
        return this.controllerNode;
    }

    @Override
    public String getWorkflowExecutionIdentifier() {
        return this.workflowExecutionIdentifier;
    }

    @Override
    public String getWorkflowInstanceName() {
        return this.workflowInstanceName;
    }

    @Override
    public LogicalNodeId getStorageNodeId() {
        return this.storageNodeId;
    }

    @Override
    public NetworkDestination getStorageNetworkDestination() {
        return this.workflowStorageNetworkDestination;
    }

    @Override
    public ComponentDescription getComponentDescription() {
        return this.componentDescription;
    }

    @Override
    public boolean isConnectedToEndpointDatumSenders() {
        return this.isConnectedToEndpointDatumSenders;
    }

    @Override
    public LogicalNodeId getNodeId() {
        return NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)this.componentDescription.getComponentInstallation().getNodeId());
    }

    @Override
    public synchronized Map<String, List<EndpointDatumRecipient>> getEndpointDatumRecipients() {
        if (this.endpointDatumRecipients == null) {
            throw new IllegalStateException("EndpointDatumRecipients have not been initialized");
        }
        return this.endpointDatumRecipients;
    }

    public synchronized List<EndpointDatumRecipient> deserializeEndpointDatumRecipients(CommunicationService communicationService) throws RemoteOperationException {
        this.endpointDatumRecipients = new HashMap<String, List<EndpointDatumRecipient>>();
        ArrayList<EndpointDatumRecipient> allCreatedRecipients = new ArrayList<EndpointDatumRecipient>();
        for (String output : this.serializedEndpointDatumRecipients.keySet()) {
            this.endpointDatumRecipients.put(output, new ArrayList());
            for (String sedr : this.serializedEndpointDatumRecipients.get(output)) {
                String[] parts = StringUtils.splitAndUnescape((String)sedr);
                String inputIdentifier = parts[0];
                String componentExecutionIdentifier = parts[1];
                String componentInstanceName = parts[2];
                LogicalNodeId targetNodeId = NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)parts[3]);
                EndpointDatumRecipient endpointDatumRecipient = EndpointDatumRecipientFactory.createEndpointDatumRecipient(inputIdentifier, componentExecutionIdentifier, componentInstanceName, targetNodeId);
                this.endpointDatumRecipients.get(output).add(endpointDatumRecipient);
                allCreatedRecipients.add(endpointDatumRecipient);
            }
        }
        return allCreatedRecipients;
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public WorkflowGraph getWorkflowGraph() {
        return this.workflowGraph;
    }

    @Override
    public Long getWorkflowInstanceDataManagementId() {
        return this.workflowInstanceDataManagementId;
    }

    @Override
    public Long getInstanceDataManagementId() {
        return this.instanceDataManagementId;
    }

    @Override
    public Map<String, Long> getInputDataManagementIds() {
        return this.inputDataManagementIds;
    }

    @Override
    public Map<String, Long> getOutputDataManagementIds() {
        return this.outputDataManagementIds;
    }

    @Deprecated
    public void setExecutionIdentifier(String executionIdentifier) {
        this.executionIdentifier = new ComponentExecutionIdentifier(executionIdentifier);
    }

    public void setExecutionIdentifier(ComponentExecutionIdentifier executionIdentifier) {
        this.executionIdentifier = executionIdentifier;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void setIsConnectedToEndpointDatumSenders(boolean isConnectedToEndpointDatumSenders) {
        this.isConnectedToEndpointDatumSenders = isConnectedToEndpointDatumSenders;
    }

    public void setWorkflowExecutionIdentifier(String wfExeId) {
        this.workflowExecutionIdentifier = wfExeId;
    }

    public void setWorkflowInstanceName(String wfInstanceName) {
        this.workflowInstanceName = wfInstanceName;
    }

    public void setWorkflowNodeId(LogicalNodeId wfNodeId) {
        this.controllerNode = wfNodeId;
    }

    public void setStorageNodeId(LogicalNodeId defaultStorageNode) {
        this.storageNodeId = defaultStorageNode;
    }

    public void setStorageNetworkDestination(NetworkDestination storageNetworkDestination) {
        this.workflowStorageNetworkDestination = storageNetworkDestination;
    }

    public void setComponentDescription(ComponentDescription componentDescription) {
        this.componentDescription = componentDescription;
    }

    public void setEndpointDatumRecipients(Map<String, List<EndpointDatumRecipient>> endpointDatumRecipients) {
        for (String output : endpointDatumRecipients.keySet()) {
            this.serializedEndpointDatumRecipients.put(output, new ArrayList());
            for (EndpointDatumRecipient edr : endpointDatumRecipients.get(output)) {
                this.serializedEndpointDatumRecipients.get(output).add(StringUtils.escapeAndConcat((String[])new String[]{edr.getInputName(), edr.getInputsComponentExecutionIdentifier(), edr.getInputsComponentInstanceName(), edr.getDestinationNodeId().getLogicalNodeIdString()}));
            }
        }
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setWorkflowGraph(WorkflowGraph workflowGraph) {
        this.workflowGraph = workflowGraph;
    }

    public void setWorkflowInstanceDataManagementId(Long workflowInstanceDataManagementId) {
        this.workflowInstanceDataManagementId = workflowInstanceDataManagementId;
    }

    public void setInstanceDataManagementId(Long instanceDataManagementId) {
        this.instanceDataManagementId = instanceDataManagementId;
    }

    public void setInputDataManagementIds(Map<String, Long> inputDataManagementIds) {
        this.inputDataManagementIds = inputDataManagementIds;
    }

    public void setOutputDataManagementIds(Map<String, Long> outputDataManagementIds) {
        this.outputDataManagementIds = outputDataManagementIds;
    }

    @Override
    public ServiceCallContext getServiceCallContext() {
        return null;
    }
}

