/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.api;

import de.rcenvironment.core.utils.common.StringUtils;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class StringIdentifier
implements Serializable {
    protected static final Log sharedLogger = LogFactory.getLog(StringIdentifier.class);
    private String identifier;

    protected StringIdentifier() {
        this.identifier = null;
    }

    public StringIdentifier(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("Provided string ids can not be null");
        }
        this.identifier = identifier;
    }

    public final boolean equals(Object other) {
        if (other == null) {
            this.logWarning("Comparing to a null object; returning false");
            return false;
        }
        if (other.getClass() != this.getClass()) {
            throw new IllegalArgumentException("Attempted to compare a " + this.getClass().getSimpleName() + " to an instance of " + other.getClass().getSimpleName());
        }
        String otherIdentifier = ((StringIdentifier)other).identifier;
        if (this.identifier == null) {
            this.logWarning("equals() called while containing a null string id");
            return otherIdentifier == null;
        }
        if (otherIdentifier == null) {
            this.logWarning("equals() called with a same-class parameter containing a null string id");
            return false;
        }
        return this.identifier.equals(otherIdentifier);
    }

    public final int hashCode() {
        if (this.identifier != null) {
            return this.identifier.hashCode();
        }
        this.logWarning("hashCode() called while containing a null string id");
        return this.getClass().hashCode();
    }

    public String toString() {
        return this.identifier;
    }

    private void logWarning(String text) {
        sharedLogger.warn((Object)StringUtils.format((String)"[%s: %s] %s", (Object[])new Object[]{this.getClass().getSimpleName(), this.identifier, text}));
    }
}

