/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.rpc.internal;

import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.security.MethodPermissionCheck;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public final class MethodCaller {
    private static final String ERROR_METHOD_CALL_FAILED = "Method call failed or refused: ";
    private static Map<String, Method> cache = new HashMap<String, Method>();

    private MethodCaller() {
    }

    public static Object callMethod(Object service, String methodName, List<? extends Serializable> parameters) throws RemoteOperationException, InvocationTargetException {
        return MethodCaller.callMethod(service, methodName, parameters, null);
    }

    public static Object callMethod(Object service, String methodName, List<? extends Serializable> parameters, MethodPermissionCheck permissionCheck) throws RemoteOperationException, InvocationTargetException {
        Class[] parameterTypes = null;
        Object[] parameterList = null;
        if (parameters != null) {
            parameterTypes = new Class[parameters.size()];
            parameterList = new Object[parameters.size()];
            int i = 0;
            while (i < parameters.size()) {
                parameterTypes[i] = parameters.get(i) == null ? Serializable.class : parameters.get(i).getClass();
                parameterList[i] = parameters.get(i);
                ++i;
            }
        } else {
            parameterTypes = new Class[]{};
            parameterList = new Class[]{};
        }
        String uid = MethodCaller.createUniqueIdentifier(service.getClass(), methodName, parameterTypes);
        Method method = null;
        if (cache.containsKey(uid)) {
            method = cache.get(uid);
        } else {
            method = MethodCaller.lookupMethod(service.getClass(), methodName, parameterTypes);
            if (method == null) {
                throw new RemoteOperationException(ERROR_METHOD_CALL_FAILED + uid + " - the method could not be not found");
            }
            cache.put(uid, method);
        }
        if (permissionCheck != null && !permissionCheck.checkPermission(method)) {
            LogFactory.getLog(MethodCaller.class).error((Object)("RPC permission check failed for method " + method + " of service " + service.getClass() + " - aborting request"));
            throw new RemoteOperationException(ERROR_METHOD_CALL_FAILED + uid + " - permission denied");
        }
        try {
            return method.invoke(service, parameterList);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RemoteOperationException(ERROR_METHOD_CALL_FAILED + uid + " - invalid arguments.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RemoteOperationException(ERROR_METHOD_CALL_FAILED + uid + " - it could not be not accessed.");
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Method lookupMethod(Class<?> clazz, String javaMethodName, Class<? extends Serializable>[] parameterTypes) {
        block5: {
            method = null;
            try {
                method = clazz.getMethod(javaMethodName, parameterTypes);
                break block5;
            }
            catch (NoSuchMethodException v0) {
                if (parameterTypes.length == 0) break block5;
                methods = new ArrayList<Method>();
                var8_5 = clazz.getMethods();
                var7_6 = var8_5.length;
                var6_7 = 0;
                ** while (var6_7 < var7_6)
            }
lbl-1000:
            // 1 sources

            {
                candidate = var8_5[var6_7];
                if (javaMethodName.equals(candidate.getName()) && MethodCaller.parameterTypesMatch(candidate.getParameterTypes(), parameterTypes)) {
                    methods.add(candidate);
                }
                ++var6_7;
                continue;
            }
lbl18:
            // 1 sources

            if (methods.size() > 0) {
                method = MethodCaller.mostSpecificMethod(methods);
            }
        }
        return method;
    }

    private static boolean parameterTypesMatch(Class<?>[] parameterTypesOne, Class<? extends Serializable>[] parameterTypesTwo) {
        if (parameterTypesOne.length == parameterTypesTwo.length) {
            int i = 0;
            while (i < parameterTypesOne.length) {
                if (!parameterTypesOne[i].isAssignableFrom(parameterTypesTwo[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static Method mostSpecificMethod(List<Method> methods) {
        ArrayList<Method> methodsToRemove = new ArrayList<Method>();
        int i = 0;
        while (i < methods.size()) {
            int j = 0;
            while (j < methods.size()) {
                if (i != j && MethodCaller.moreSpecific(methods.get(i), methods.get(j))) {
                    methodsToRemove.add(methods.get(j));
                }
                ++j;
            }
            ++i;
        }
        methods.removeAll(methodsToRemove);
        if (methods.size() == 1) {
            return methods.get(0);
        }
        return null;
    }

    private static boolean moreSpecific(Method methodOne, Method methodTwo) {
        Class<?>[] parameterTypesOne = methodOne.getParameterTypes();
        Class<?>[] parameterTypesTwo = methodTwo.getParameterTypes();
        int i = 0;
        while (i < parameterTypesOne.length) {
            if (!parameterTypesTwo[i].isAssignableFrom(parameterTypesOne[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String createUniqueIdentifier(Class<?> clazz, String javaMethodName, Class<? extends Serializable>[] parameterTypes) {
        String hash = "";
        hash = String.valueOf(hash) + clazz.getCanonicalName();
        hash = String.valueOf(hash) + "." + javaMethodName;
        hash = String.valueOf(hash) + "(";
        int i = 0;
        while (i < parameterTypes.length) {
            hash = String.valueOf(hash) + parameterTypes[i].getCanonicalName();
            if (i < parameterTypes.length - 1) {
                hash = String.valueOf(hash) + ", ";
            }
            ++i;
        }
        hash = String.valueOf(hash) + ")";
        return hash;
    }
}

