/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.rpc.internal;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.rpc.api.CallbackProxyService;
import de.rcenvironment.core.communication.rpc.internal.CallbackProxy;
import de.rcenvironment.core.communication.rpc.internal.CleanJob;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;

public class CallbackProxyServiceImpl
implements CallbackProxyService {
    private Map<String, WeakReference<Object>> proxies = Collections.synchronizedMap(new HashMap());
    private Map<String, InstanceNodeSessionId> homePlatforms = Collections.synchronizedMap(new HashMap());
    private Map<String, Long> ttls = Collections.synchronizedMap(new HashMap());

    protected void activate(BundleContext context) {
        CleanJob.scheduleJob(CallbackProxyService.class, this.proxies, this.ttls, this.homePlatforms);
    }

    protected void deactivate(BundleContext context) {
        CleanJob.unscheduleJob(CallbackProxyService.class);
    }

    @Override
    public void addCallbackProxy(CallbackProxy callBackProxy) {
        String identifier = callBackProxy.getObjectIdentifier();
        this.proxies.put(identifier, new WeakReference<CallbackProxy>(callBackProxy));
        this.homePlatforms.put(identifier, callBackProxy.getHomePlatform());
        this.ttls.put(identifier, new Date(System.currentTimeMillis() + 600000L).getTime());
    }

    @Override
    public Object getCallbackProxy(String objectIdentifier) {
        WeakReference<Object> weakRef = this.proxies.get(objectIdentifier);
        if (weakRef != null) {
            return weakRef.get();
        }
        return null;
    }

    @Override
    @AllowRemoteAccess
    public void setTTL(String objectIdentifier, Long ttl) {
        this.ttls.put(objectIdentifier, ttl);
    }
}

