/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.routing.internal;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.Serializable;
import java.util.Date;

public final class TopologyLink
implements Comparable<TopologyLink>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5377050931490338202L;
    private final Date creationTime = new Date();
    private final InstanceNodeSessionId source;
    private final InstanceNodeSessionId destination;
    private int weight;
    private int reliability;
    private String connectionId;
    private final String linkIdentity;

    public TopologyLink(InstanceNodeSessionId source, InstanceNodeSessionId destination, String connectionId) {
        this.source = source;
        this.destination = destination;
        this.linkIdentity = String.valueOf(source.getInstanceNodeSessionIdString()) + destination.getInstanceNodeSessionIdString() + connectionId;
        this.connectionId = connectionId;
        this.reliability = 0;
        this.weight = 1;
    }

    public String toString() {
        return StringUtils.format((String)"%s --[ConId=%3$s]--> %s, (Hash=%s)", (Object[])new Object[]{this.getSource(), this.getDestination(), this.getConnectionId(), this.hashCode()});
    }

    public TopologyLink clone() {
        return new TopologyLink(this.getSource(), this.getDestination(), this.connectionId);
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public InstanceNodeSessionId getSource() {
        return this.source;
    }

    public InstanceNodeSessionId getDestination() {
        return this.destination;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getReliability() {
        return this.reliability;
    }

    public void incReliability() {
        ++this.reliability;
    }

    @Override
    public int compareTo(TopologyLink otherLink) {
        return this.linkIdentity.compareTo(otherLink.linkIdentity);
    }

    public int hashCode() {
        return this.linkIdentity.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TopologyLink) {
            return ((TopologyLink)obj).linkIdentity.equals(this.linkIdentity);
        }
        return false;
    }
}

