/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.command.spi;

import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;

public final class CommandContext {
    private final List<String> originalTokens;
    private final Deque<String> remainingTokens;
    private final TextOutputReceiver outputReceiver;
    private Object invokerInformation;
    private boolean developerCommandSetEnabled = false;

    public CommandContext(List<String> originalTokens, TextOutputReceiver outputReceiver, Object invokerInformation) {
        this.originalTokens = originalTokens;
        this.remainingTokens = new LinkedList<String>(originalTokens);
        this.outputReceiver = outputReceiver;
        this.invokerInformation = invokerInformation;
    }

    public void println(Object line) {
        this.outputReceiver.addOutput(line.toString());
    }

    public String peekNextToken() {
        if (this.remainingTokens.isEmpty()) {
            return null;
        }
        return this.remainingTokens.peekFirst();
    }

    public String consumeNextToken() {
        if (this.remainingTokens.isEmpty()) {
            return null;
        }
        return this.remainingTokens.removeFirst();
    }

    public boolean consumeNextTokenIfEquals(String expected) {
        if (expected.equals(this.remainingTokens.peek())) {
            this.consumeExpectedToken(expected);
            return true;
        }
        return false;
    }

    public List<String> consumeRemainingTokens() {
        ArrayList<String> result = new ArrayList<String>(this.remainingTokens);
        this.remainingTokens.clear();
        return result;
    }

    public List<String> getOriginalTokens() {
        return Collections.unmodifiableList(this.originalTokens);
    }

    public TextOutputReceiver getOutputReceiver() {
        return this.outputReceiver;
    }

    public void consumeExpectedToken(String expected) {
        String actual = this.consumeNextToken();
        if (!expected.equals(actual)) {
            throw new IllegalStateException("Unexpected token '" + actual + "' (expected: '" + expected + "')");
        }
    }

    public boolean hasRemainingTokens() {
        return !this.remainingTokens.isEmpty();
    }

    public boolean isDeveloperCommandSetEnabled() {
        return this.developerCommandSetEnabled;
    }

    public void setDeveloperCommandSetEnabled(boolean developerCommandSetEnabled) {
        this.developerCommandSetEnabled = developerCommandSetEnabled;
    }

    public Object getInvokerInformation() {
        return this.invokerInformation;
    }
}

