/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.outputwriter.execution.validator;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.outputwriter.common.OutputLocation;
import de.rcenvironment.components.outputwriter.common.OutputLocationList;
import de.rcenvironment.components.outputwriter.common.OutputWriterValidatorHelper;
import de.rcenvironment.components.outputwriter.execution.Messages;
import de.rcenvironment.components.outputwriter.execution.OutputWriterPathResolver;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.spi.AbstractComponentValidator;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.LogFactory;

public class OutputWriterComponentValidator
extends AbstractComponentValidator {
    protected final List<ComponentValidationMessage> messages = new LinkedList<ComponentValidationMessage>();

    public String getIdentifier() {
        return "de.rcenvironment.outputwriter";
    }

    protected List<ComponentValidationMessage> validateComponentSpecific(ComponentDescription componentDescription) {
        this.messages.clear();
        this.checkRootLocation(componentDescription);
        String outputLocString = this.getProperty(componentDescription, "outputLocations");
        ObjectMapper jsonMapper = JsonUtils.getDefaultObjectMapper();
        jsonMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        if (outputLocString == null) {
            outputLocString = "{}";
        }
        try {
            OutputLocationList outputList = (OutputLocationList)jsonMapper.readValue(outputLocString, OutputLocationList.class);
            ArrayList<String> inputNamesHavingOutput = new ArrayList<String>();
            for (OutputLocation out : outputList.getOutputLocations()) {
                inputNamesHavingOutput.addAll(out.getInputs());
                this.checkOutputHasInput(out);
                this.checkConnectionStatusOfInputs(componentDescription, out);
                this.checkForUnknownPlaceholder(out);
            }
            this.checkAllInputsHaveOutput(componentDescription, inputNamesHavingOutput);
        }
        catch (IOException e) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)("Could not validate OutputLocation configuration " + e.getMessage()));
        }
        return this.messages;
    }

    private void checkRootLocation(ComponentDescription componentDescription) {
        String chooseAtStart = this.getProperty(componentDescription, "SelectRootOnWorkflowStart");
        if (!Boolean.parseBoolean(chooseAtStart)) {
            String rootString = this.getProperty(componentDescription, "SelectedRoot");
            if (rootString.isEmpty()) {
                ComponentValidationMessage noDirectory = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "SelectedRoot", Messages.noRootChosen, Messages.bind((String)Messages.noRootChosen, (Object)""));
                this.messages.add(noDirectory);
            } else {
                OutputWriterPathResolver pathResolver = new OutputWriterPathResolver(t -> {});
                try {
                    rootString = pathResolver.adaptRootToAbsoluteRootIfProjectRelative(rootString);
                }
                catch (ComponentException componentException) {
                    ComponentValidationMessage noWorkspace = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "SelectedRoot", Messages.noWorkspace, Messages.bind((String)Messages.noWorkspace, (Object)""));
                    this.messages.add(noWorkspace);
                    return;
                }
                File rootFile = new File(rootString);
                if (!rootFile.isAbsolute()) {
                    ComponentValidationMessage noAbsolutePath = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "SelectedRoot", Messages.noAbsolutePath, Messages.bind((String)Messages.noAbsolutePath, (Object)"${dir:workspace}"));
                    this.messages.add(noAbsolutePath);
                } else if (!rootFile.isDirectory()) {
                    ComponentValidationMessage nonExistingDirectory = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, "SelectedRoot", Messages.nonExistingRootChosen, Messages.bind((String)Messages.nonExistingRootChosen, (Object)""));
                    this.messages.add(nonExistingDirectory);
                }
            }
        }
    }

    private void checkConnectionStatusOfInputs(ComponentDescription componentDescription, OutputLocation out) {
        boolean connectedInputs = false;
        boolean unconnectedInputs = false;
        for (String inputName : out.getInputs()) {
            for (EndpointDescription ed : this.getInputs(componentDescription)) {
                if (!ed.getName().equals(inputName)) continue;
                if (ed.isConnected()) {
                    connectedInputs = true;
                    continue;
                }
                unconnectedInputs = true;
            }
        }
        if (connectedInputs && unconnectedInputs) {
            ComponentValidationMessage connectedAndUnconnectedInputs = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, out.getFilename(), Messages.connectedAndUnconnectedInputs, Messages.bind((String)Messages.connectedAndUnconnectedInputs, (Object)out.getFilename()));
            this.messages.add(connectedAndUnconnectedInputs);
        }
    }

    private void checkForUnknownPlaceholder(OutputLocation out) {
        String header = out.getHeader();
        ArrayList<String> knownPlaceholderList = new ArrayList<String>();
        knownPlaceholderList.add("[Linebreak]");
        knownPlaceholderList.add("[Timestamp]");
        knownPlaceholderList.add("[Execution count]");
        StringBuilder headerWarningBuilder = new StringBuilder();
        List unknownPlaceholderList = OutputWriterValidatorHelper.getValidationWarnings((StringBuilder)headerWarningBuilder, (String)header, knownPlaceholderList);
        for (String placeholder : unknownPlaceholderList) {
            this.setMessages(placeholder, out.getFilename(), Messages.unmatchedHeaderPlaceholder);
        }
        String formatString = out.getFormatString();
        for (String input : out.getInputs()) {
            String inputPlaceholder = "[" + input + "]";
            if (knownPlaceholderList.contains(inputPlaceholder)) continue;
            knownPlaceholderList.add(inputPlaceholder);
        }
        StringBuilder formatWarningBuilder = new StringBuilder();
        unknownPlaceholderList = OutputWriterValidatorHelper.getValidationWarnings((StringBuilder)formatWarningBuilder, (String)formatString, knownPlaceholderList);
        for (String placeholder : unknownPlaceholderList) {
            this.setMessages(placeholder, out.getFilename(), Messages.unmatchedFormatPlaceholder);
        }
    }

    private void checkAllInputsHaveOutput(ComponentDescription componentDescription, List<String> inputNamesHavingOutput) {
        for (EndpointDescription ed : this.getInputs(componentDescription)) {
            if (ed.getDataType().equals((Object)DataType.FileReference) || ed.getDataType().equals((Object)DataType.DirectoryReference) || inputNamesHavingOutput.contains(ed.getName())) continue;
            ComponentValidationMessage inputWithoutOutput = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, ed.getName(), Messages.noOutputForInput, Messages.bind((String)Messages.noOutputForInput, (Object)ed.getName()));
            this.messages.add(inputWithoutOutput);
        }
    }

    private void checkOutputHasInput(OutputLocation out) {
        if (out.getInputs().isEmpty()) {
            ComponentValidationMessage outputWithoutInput = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, out.getFilename(), Messages.noInputForOutput, Messages.bind((String)Messages.noInputForOutput, (Object)out.getFilename()));
            this.messages.add(outputWithoutInput);
        }
    }

    private void setMessages(String placeholder, String filename, String message) {
        ComponentValidationMessage unmatchedPlaceholder = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, placeholder, message, Messages.bind((String)message, (Object)filename, (Object)placeholder));
        this.messages.add(unmatchedPlaceholder);
    }

    protected List<ComponentValidationMessage> validateOnWorkflowStartComponentSpecific(ComponentDescription componentDescription) {
        return null;
    }
}

