/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.excel.common.internal;

import de.rcenvironment.components.excel.common.ExcelAddress;
import de.rcenvironment.components.excel.common.ExcelException;
import de.rcenvironment.components.excel.common.ExcelService;
import de.rcenvironment.components.excel.common.ExcelUtils;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumFactory;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.BooleanTD;
import de.rcenvironment.core.datamodel.types.api.DateTimeTD;
import de.rcenvironment.core.datamodel.types.api.FloatTD;
import de.rcenvironment.core.datamodel.types.api.IntegerTD;
import de.rcenvironment.core.datamodel.types.api.ShortTextTD;
import de.rcenvironment.core.datamodel.types.api.SmallTableTD;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelServicePOI
implements ExcelService {
    protected static final Log LOGGER = LogFactory.getLog(ExcelServicePOI.class);
    protected static final int BLOCKING_ITERATIONMAX = 600;
    protected static final int BLOCKING_SLEEP = 50;
    private static final String EXCMSG_EXCEL_FILE_IS_NOT_FOUND_OR_CANNOT_BE_OPENED = "Excel file is not found or cannot be opened.";
    private static final String EXCMSG_EXCEL_FILE_HAS_AN_INVALID_FORMAT = "Excel file has an invalid format.";
    private static final String EXCMSG_EXCEL_FILE_NOT_FOUND = "Excel file not found.";
    private static final String EXCMSG_CANNOT_SAVE_FILE_WITH_RESULT_DATA = "Cannot save file with result data.";
    private static final String EXCMSG_EXCEL_FILE_CANNOT_CLOSED = "Excel file access cannot be closed.";
    private static TypedDatumFactory typedDatumFactory;

    public ExcelServicePOI() {
    }

    public ExcelServicePOI(TypedDatumFactory typedDatumFactory) {
        ExcelServicePOI.typedDatumFactory = typedDatumFactory;
    }

    protected void bindTypedDatumService(TypedDatumService newTypedDatumService) {
        typedDatumFactory = newTypedDatumService.getFactory();
    }

    protected void unbindTypedDatumService(TypedDatumService oldTypedDatumService) {
    }

    protected void initialTest(File xlFile) throws ExcelException {
        try {
            Throwable throwable = null;
            Object var3_7 = null;
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(xlFile));){
                boolean isXls;
                boolean isXlsx = FileMagic.valueOf((InputStream)bis) == FileMagic.OOXML;
                bis.reset();
                boolean bl = isXls = FileMagic.valueOf((InputStream)bis) == FileMagic.OLE2;
                if (!isXlsx && !isXls) {
                    throw new ExcelException("Given file seems to be no Excel file");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw new ExcelException(EXCMSG_EXCEL_FILE_NOT_FOUND, e);
        }
        catch (IllegalArgumentException e) {
            throw new ExcelException("Given file seems to be no Excel file", e);
        }
        catch (IOException e) {
            throw new ExcelException(EXCMSG_EXCEL_FILE_IS_NOT_FOUND_OR_CANNOT_BE_OPENED, e);
        }
    }

    @Override
    public void setValues(File xlFile, ExcelAddress addr, SmallTableTD values) throws ExcelException {
        this.setValues(xlFile, xlFile, addr, values);
    }

    @Override
    public void setValues(File xlFile, File newFile, ExcelAddress addr, SmallTableTD values) throws ExcelException {
        block35: {
            try {
                if (xlFile == null) break block35;
                FileInputStream inp = null;
                OutputStream fileOut = null;
                inp = new FileInputStream(xlFile);
                try {
                    Workbook wb = WorkbookFactory.create((InputStream)inp);
                    Sheet sheet = wb.getSheet(addr.getWorkSheetName());
                    int addressRowCorrection = addr.getBeginningRowNumber() - 1;
                    int addressColumnCorrection = addr.getBeginningColumnNumber() - 1;
                    int row = addressRowCorrection;
                    while (row < addressRowCorrection + addr.getNumberOfRows() && row <= addressRowCorrection + (values.getRowCount() - 1)) {
                        Row r = sheet.getRow(row);
                        if (r == null) {
                            r = sheet.createRow(row);
                        }
                        int col = addressColumnCorrection;
                        while (col < addressColumnCorrection + addr.getNumberOfColumns() && col <= addressColumnCorrection + (values.getColumnCount() - 1)) {
                            Cell cell = r.createCell(col);
                            TypedDatum data = values.getTypedDatumOfCell(row - addressRowCorrection, col - addressColumnCorrection);
                            if (data != null) {
                                switch (data.getDataType()) {
                                    case ShortText: {
                                        cell.setCellType(CellType.STRING);
                                        cell.setCellValue(((ShortTextTD)data).getShortTextValue());
                                        break;
                                    }
                                    case Float: {
                                        cell.setCellType(CellType.NUMERIC);
                                        cell.setCellValue(((FloatTD)data).getFloatValue());
                                        break;
                                    }
                                    case Integer: {
                                        cell.setCellType(CellType.NUMERIC);
                                        cell.setCellValue((double)((IntegerTD)data).getIntValue());
                                        break;
                                    }
                                    case Boolean: {
                                        cell.setCellType(CellType.BOOLEAN);
                                        cell.setCellValue(((BooleanTD)data).getBooleanValue());
                                        break;
                                    }
                                    case DateTime: {
                                        cell.setCellType(CellType.STRING);
                                        cell.setCellValue((double)((DateTimeTD)data).getDateTime().getTime());
                                        break;
                                    }
                                    case Empty: {
                                        cell.setCellType(CellType.BLANK);
                                        break;
                                    }
                                }
                            }
                            ++col;
                        }
                        ++row;
                    }
                    int i = 0;
                    while (i < 600) {
                        block36: {
                            try {
                                if (newFile == null) break block36;
                                fileOut = new FileOutputStream(newFile);
                                wb.write(fileOut);
                                break;
                            }
                            catch (FileNotFoundException e) {
                                LOGGER.debug((Object)("File not found. (Method: setValueOfCells). Iteration: " + i + ". Retrying."));
                                if (i == 599) {
                                    throw new ExcelException(EXCMSG_CANNOT_SAVE_FILE_WITH_RESULT_DATA, e);
                                }
                            }
                            catch (IOException e) {
                                throw new ExcelException(EXCMSG_CANNOT_SAVE_FILE_WITH_RESULT_DATA, e);
                            }
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            LOGGER.error((Object)e);
                        }
                        ++i;
                    }
                }
                finally {
                    if (inp != null) {
                        try {
                            ((InputStream)inp).close();
                        }
                        catch (IOException e) {
                            LOGGER.error((Object)"Failed to close output stream", (Throwable)e);
                        }
                    }
                    if (fileOut != null) {
                        try {
                            fileOut.flush();
                            ((FileOutputStream)fileOut).close();
                        }
                        catch (IOException e) {
                            LOGGER.error((Object)"Failed to flush or close output stream", (Throwable)e);
                        }
                    }
                    ExcelUtils.destroyGarbage();
                }
                this.recalculateFormulas(xlFile);
            }
            catch (FileNotFoundException e) {
                throw new ExcelException(EXCMSG_EXCEL_FILE_NOT_FOUND, e);
            }
            catch (IOException e) {
                throw new ExcelException(EXCMSG_EXCEL_FILE_IS_NOT_FOUND_OR_CANNOT_BE_OPENED, e);
            }
        }
    }

    @Override
    public SmallTableTD getValueOfCells(File xlFile, ExcelAddress addr) throws ExcelException {
        this.recalculateFormulas(xlFile);
        SmallTableTD retValues = null;
        if (xlFile != null) {
            FileInputStream inp = null;
            try {
                try {
                    inp = new FileInputStream(xlFile);
                    Workbook wb = WorkbookFactory.create((InputStream)inp);
                    Sheet sheet = wb.getSheet(addr.getWorkSheetName());
                    retValues = typedDatumFactory.createSmallTable(addr.getNumberOfRows(), addr.getNumberOfColumns());
                    int addressRowCorrection = addr.getBeginningRowNumber() - 1;
                    int addressColumnCorrection = addr.getBeginningColumnNumber() - 1;
                    int row = addressRowCorrection;
                    while (row < addressRowCorrection + addr.getNumberOfRows()) {
                        Row r = sheet.getRow(row);
                        if (r == null) {
                            r = sheet.createRow(row);
                        }
                        int col = addressColumnCorrection;
                        while (col < addressColumnCorrection + addr.getNumberOfColumns()) {
                            Object data;
                            Cell cell = r.getCell(col);
                            if (cell == null) {
                                data = typedDatumFactory.createEmpty();
                                retValues.setTypedDatumForCell((TypedDatum)data, row - addressRowCorrection, col - addressColumnCorrection);
                            } else {
                                block5 : switch (cell.getCellType()) {
                                    case STRING: {
                                        data = typedDatumFactory.createShortText(cell.getRichStringCellValue().getString());
                                        retValues.setTypedDatumForCell((TypedDatum)data, row - addressRowCorrection, col - addressColumnCorrection);
                                        break;
                                    }
                                    case NUMERIC: {
                                        long lRawNumber;
                                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                            data = typedDatumFactory.createDateTime(cell.getDateCellValue().getTime());
                                            retValues.setTypedDatumForCell((TypedDatum)data, row - addressRowCorrection, col - addressColumnCorrection);
                                            break;
                                        }
                                        double rawNumber = cell.getNumericCellValue();
                                        data = rawNumber - (double)(lRawNumber = (long)rawNumber) == 0.0 ? typedDatumFactory.createInteger(lRawNumber) : typedDatumFactory.createFloat(rawNumber);
                                        retValues.setTypedDatumForCell((TypedDatum)data, row - addressRowCorrection, col - addressColumnCorrection);
                                        break;
                                    }
                                    case BOOLEAN: {
                                        data = typedDatumFactory.createBoolean(cell.getBooleanCellValue());
                                        retValues.setTypedDatumForCell((TypedDatum)data, row - addressRowCorrection, col - addressColumnCorrection);
                                        break;
                                    }
                                    case FORMULA: {
                                        FormulaEvaluator evaluator = wb.getCreationHelper().createFormulaEvaluator();
                                        try {
                                            CellValue cellValue = evaluator.evaluate(cell);
                                            switch (cellValue.getCellType()) {
                                                case BOOLEAN: {
                                                    data = typedDatumFactory.createBoolean(cellValue.getBooleanValue());
                                                    retValues.setTypedDatumForCell((TypedDatum)data, row - addressRowCorrection, col - addressColumnCorrection);
                                                    break block5;
                                                }
                                                case NUMERIC: {
                                                    data = typedDatumFactory.createFloat(cellValue.getNumberValue());
                                                    retValues.setTypedDatumForCell((TypedDatum)data, row - addressRowCorrection, col - addressColumnCorrection);
                                                    break block5;
                                                }
                                                case STRING: {
                                                    data = typedDatumFactory.createShortText(cellValue.getStringValue());
                                                    retValues.setTypedDatumForCell((TypedDatum)data, row - addressRowCorrection, col - addressColumnCorrection);
                                                    break block5;
                                                }
                                            }
                                            data = typedDatumFactory.createEmpty();
                                            retValues.setTypedDatumForCell((TypedDatum)data, row - addressRowCorrection, col - addressColumnCorrection);
                                        }
                                        catch (NotImplementedException notImplementedException) {
                                            switch (cell.getCachedFormulaResultType()) {
                                                case BOOLEAN: {
                                                    data = typedDatumFactory.createBoolean(cell.getBooleanCellValue());
                                                    retValues.setTypedDatumForCell((TypedDatum)data, row - addressRowCorrection, col - addressColumnCorrection);
                                                    break block5;
                                                }
                                                case NUMERIC: {
                                                    long lRawNumber;
                                                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                                        data = typedDatumFactory.createDateTime(cell.getDateCellValue().getTime());
                                                        retValues.setTypedDatumForCell((TypedDatum)data, row - addressRowCorrection, col - addressColumnCorrection);
                                                        break block5;
                                                    }
                                                    double rawNumber = cell.getNumericCellValue();
                                                    data = rawNumber - (double)(lRawNumber = (long)rawNumber) == 0.0 ? typedDatumFactory.createInteger(lRawNumber) : typedDatumFactory.createFloat(rawNumber);
                                                    retValues.setTypedDatumForCell((TypedDatum)data, row - addressRowCorrection, col - addressColumnCorrection);
                                                    break block5;
                                                }
                                                case STRING: {
                                                    data = typedDatumFactory.createShortText(cell.getStringCellValue());
                                                    retValues.setTypedDatumForCell((TypedDatum)data, row - addressRowCorrection, col - addressColumnCorrection);
                                                    break block5;
                                                }
                                            }
                                            data = typedDatumFactory.createEmpty();
                                            retValues.setTypedDatumForCell((TypedDatum)data, row - addressRowCorrection, col - addressColumnCorrection);
                                        }
                                        break;
                                    }
                                    default: {
                                        data = typedDatumFactory.createEmpty();
                                        retValues.setTypedDatumForCell((TypedDatum)data, row - addressRowCorrection, col - addressColumnCorrection);
                                    }
                                }
                            }
                            ++col;
                        }
                        ++row;
                    }
                }
                catch (FileNotFoundException e) {
                    throw new ExcelException(EXCMSG_EXCEL_FILE_NOT_FOUND, e);
                }
                catch (IOException e) {
                    throw new ExcelException(EXCMSG_EXCEL_FILE_IS_NOT_FOUND_OR_CANNOT_BE_OPENED, e);
                }
            }
            finally {
                if (inp != null) {
                    try {
                        ((InputStream)inp).close();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"Failed to close input stream", (Throwable)e);
                    }
                }
                ExcelUtils.destroyGarbage();
            }
        }
        return retValues;
    }

    @Override
    public ExcelAddress[] getUserDefinedCellNames(File xlFile) throws ExcelException {
        ExcelAddress[] names;
        FileInputStream inp = null;
        try {
            try {
                inp = new FileInputStream(xlFile);
                Workbook wb = WorkbookFactory.create((InputStream)inp);
                int noNames = wb.getNumberOfNames();
                names = new ExcelAddress[noNames];
                int i = 0;
                while (i < noNames) {
                    names[i] = new ExcelAddress(xlFile, wb.getNameAt(i).getNameName());
                    ++i;
                }
            }
            catch (FileNotFoundException e) {
                throw new ExcelException(EXCMSG_EXCEL_FILE_NOT_FOUND, e);
            }
            catch (IOException e) {
                throw new ExcelException(EXCMSG_EXCEL_FILE_IS_NOT_FOUND_OR_CANNOT_BE_OPENED, e);
            }
            catch (IllegalArgumentException e) {
                throw new ExcelException(EXCMSG_EXCEL_FILE_IS_NOT_FOUND_OR_CANNOT_BE_OPENED, e);
            }
        }
        finally {
            if (inp != null) {
                try {
                    ((InputStream)inp).close();
                }
                catch (IOException e) {
                    throw new ExcelException(EXCMSG_EXCEL_FILE_CANNOT_CLOSED, e);
                }
            }
            ExcelUtils.destroyGarbage();
        }
        return names;
    }

    @Override
    public String[] getMacros(File xlFile) throws ExcelException {
        throw new ExcelException("Excel is using POI implementation only. Cannot receive macro names.");
    }

    @Override
    public void runMacro(File xlFile, String macroname) throws ExcelException {
        throw new ExcelException("Excel is using POI implementation only. Cannot execute macro.");
    }

    @Override
    public void recalculateFormulas(File xlFile) throws ExcelException {
        FileInputStream inp = null;
        try {
            try {
                inp = new FileInputStream(xlFile);
                Workbook wb = WorkbookFactory.create((InputStream)inp);
                FormulaEvaluator evaluator = wb.getCreationHelper().createFormulaEvaluator();
                int sheetNum = 0;
                while (sheetNum < wb.getNumberOfSheets()) {
                    Sheet sheet = wb.getSheetAt(sheetNum);
                    for (Row r : sheet) {
                        for (Cell c : r) {
                            if (c.getCellType() != CellType.FORMULA) continue;
                            evaluator.evaluateFormulaCell(c);
                        }
                    }
                    ++sheetNum;
                }
            }
            catch (NotImplementedException e) {
                throw new ExcelException("Tried to evaluate unknow formula", e);
            }
            catch (FileNotFoundException e) {
                throw new ExcelException(EXCMSG_EXCEL_FILE_NOT_FOUND, e);
            }
            catch (IOException e) {
                throw new ExcelException(EXCMSG_EXCEL_FILE_IS_NOT_FOUND_OR_CANNOT_BE_OPENED, e);
            }
        }
        finally {
            if (inp != null) {
                try {
                    ((InputStream)inp).close();
                }
                catch (IOException e) {
                    throw new ExcelException(EXCMSG_EXCEL_FILE_CANNOT_CLOSED, e);
                }
            }
            ExcelUtils.destroyGarbage();
        }
    }

    @Override
    public boolean isValidExcelFile(File xlFile) {
        if (xlFile == null) {
            return false;
        }
        try {
            this.initialTest(xlFile);
        }
        catch (ExcelException excelException) {
            return false;
        }
        return true;
    }
}

