/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.excel.gui.view;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class SelectionProviderIntermediate
implements IPostSelectionProvider {
    private ISelectionProvider delegate = null;
    private final ListenerList selectionListeners = new ListenerList();
    private final ListenerList postSelectionListeners = new ListenerList();
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelectionProvider() == SelectionProviderIntermediate.this.delegate) {
                SelectionProviderIntermediate.this.fireSelectionChanged(event.getSelection());
            }
        }
    };
    private ISelectionChangedListener postSelectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelectionProvider() == SelectionProviderIntermediate.this.delegate) {
                SelectionProviderIntermediate.this.firePostSelectionChanged(event.getSelection());
            }
        }
    };

    public void setSelectionProviderDelegate(ISelectionProvider newDelegate) {
        if (this.delegate == newDelegate) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.removeSelectionChangedListener(this.selectionListener);
            if (this.delegate instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)this.delegate).removePostSelectionChangedListener(this.postSelectionListener);
            }
        }
        this.delegate = newDelegate;
        if (newDelegate != null) {
            newDelegate.addSelectionChangedListener(this.selectionListener);
            if (newDelegate instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)newDelegate).addPostSelectionChangedListener(this.postSelectionListener);
            }
            this.fireSelectionChanged(newDelegate.getSelection());
            this.firePostSelectionChanged(newDelegate.getSelection());
        }
    }

    protected void fireSelectionChanged(ISelection selection) {
        this.fireSelectionChanged(this.selectionListeners, selection);
    }

    protected void firePostSelectionChanged(ISelection selection) {
        this.fireSelectionChanged(this.postSelectionListeners, selection);
    }

    private void fireSelectionChanged(ListenerList list, ISelection selection) {
        Object[] listeners;
        SelectionChangedEvent event = new SelectionChangedEvent(this.delegate, selection);
        Object[] objectArray = listeners = list.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener2 = objectArray[n2];
            ISelectionChangedListener listener = (ISelectionChangedListener)listener2;
            listener.selectionChanged(event);
            ++n2;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (this.delegate != null) {
            this.delegate.setSelection(selection);
        }
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.remove((Object)listener);
    }
}

