/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.internal.ActionSetActionBars;
import org.eclipse.ui.internal.PluginActionSet;
import org.eclipse.ui.internal.PluginActionSetBuilder;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.provisional.application.IActionBarConfigurer2;
import org.eclipse.ui.internal.registry.IActionSet;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;

public class ActionPresentation {
    private WorkbenchWindow window;
    private HashMap mapDescToRec = new HashMap(3);
    private HashMap invisibleBars = new HashMap(3);

    public ActionPresentation(WorkbenchWindow window) {
        this.window = window;
    }

    public void clearActionSets() {
        ArrayList oldList = new ArrayList();
        oldList.addAll(this.mapDescToRec.keySet());
        oldList.addAll(this.invisibleBars.keySet());
        for (IActionSetDescriptor desc : oldList) {
            this.removeActionSet(desc);
        }
    }

    public void removeActionSet(IActionSetDescriptor desc) {
        SetRec rec = (SetRec)this.mapDescToRec.remove(desc);
        if (rec == null) {
            rec = (SetRec)this.invisibleBars.remove(desc);
        }
        if (rec != null) {
            IActionSet set = rec.set;
            SubActionBars bars = rec.bars;
            if (bars != null) {
                bars.dispose();
            }
            if (set != null) {
                set.dispose();
            }
        }
    }

    public void setActionSets(IActionSetDescriptor[] newArray) {
        HashSet<IActionSetDescriptor> newList = new HashSet<IActionSetDescriptor>();
        IActionSetDescriptor[] iActionSetDescriptorArray = newArray;
        int n = newArray.length;
        int n2 = 0;
        while (n2 < n) {
            IActionSetDescriptor descriptor = iActionSetDescriptorArray[n2];
            newList.add(descriptor);
            ++n2;
        }
        ArrayList oldList = new ArrayList(this.mapDescToRec.keySet());
        for (IActionSetDescriptor desc : oldList) {
            SetRec setRec;
            if (newList.contains(desc) || (setRec = (SetRec)this.mapDescToRec.get(desc)) == null) continue;
            this.mapDescToRec.remove(desc);
            IActionSet set = setRec.set;
            SubActionBars bars = setRec.bars;
            if (bars == null) continue;
            SetRec invisibleRec = new SetRec(set, bars);
            this.invisibleBars.put(desc, invisibleRec);
            bars.deactivate();
        }
        ArrayList<IActionSet> sets = new ArrayList<IActionSet>();
        IActionSetDescriptor[] iActionSetDescriptorArray2 = newArray;
        int n3 = newArray.length;
        int n4 = 0;
        while (n4 < n3) {
            IActionSetDescriptor iActionSetDescriptor = iActionSetDescriptorArray2[n4];
            if (!this.mapDescToRec.containsKey(iActionSetDescriptor)) {
                try {
                    SetRec rec;
                    if (this.invisibleBars.containsKey(iActionSetDescriptor)) {
                        rec = (SetRec)this.invisibleBars.get(iActionSetDescriptor);
                        if (rec.bars != null) {
                            rec.bars.activate();
                        }
                        this.invisibleBars.remove(iActionSetDescriptor);
                    } else {
                        IActionSet set = iActionSetDescriptor.createActionSet();
                        ActionSetActionBars bars = new ActionSetActionBars(this.window.getActionBars(), this.window, (IActionBarConfigurer2)this.window.getWindowConfigurer().getActionBarConfigurer(), iActionSetDescriptor.getId());
                        rec = new SetRec(set, bars);
                        set.init(this.window, bars);
                        sets.add(set);
                        Object[] existingRegistrations = this.window.getExtensionTracker().getObjects(iActionSetDescriptor.getConfigurationElement().getDeclaringExtension());
                        if (existingRegistrations.length == 0 || !this.containsRegistration(existingRegistrations, iActionSetDescriptor)) {
                            this.window.getExtensionTracker().registerObject(iActionSetDescriptor.getConfigurationElement().getDeclaringExtension(), (Object)iActionSetDescriptor, 2);
                        }
                    }
                    this.mapDescToRec.put(iActionSetDescriptor, rec);
                }
                catch (CoreException e) {
                    WorkbenchPlugin.log("Unable to create ActionSet: " + iActionSetDescriptor.getId(), e);
                }
            }
            ++n4;
        }
        PluginActionSetBuilder.processActionSets(sets, this.window);
        for (PluginActionSet pluginActionSet : sets) {
            pluginActionSet.getBars().activate();
        }
    }

    private boolean containsRegistration(Object[] existingRegistrations, IActionSetDescriptor set) {
        Object[] objectArray = existingRegistrations;
        int n = existingRegistrations.length;
        int n2 = 0;
        while (n2 < n) {
            Object existingRegistration = objectArray[n2];
            if (existingRegistration == set) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IActionSet[] getActionSets() {
        Collection setRecCollection = this.mapDescToRec.values();
        IActionSet[] result = new IActionSet[setRecCollection.size()];
        int i = 0;
        Iterator iterator = setRecCollection.iterator();
        while (iterator.hasNext()) {
            result[i] = ((SetRec)iterator.next()).set;
            ++i;
        }
        return result;
    }

    private static class SetRec {
        public IActionSet set;
        public SubActionBars bars;

        public SetRec(IActionSet set, SubActionBars bars) {
            this.set = set;
            this.bars = bars;
        }
    }
}

