/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.impl;

import cucumber.api.java.en.Given;
import cucumber.api.java.en.Then;
import cucumber.api.java.en.When;
import de.rcenvironment.core.instancemanagement.internal.InstanceConfigurationException;
import de.rcenvironment.core.instancemanagement.internal.SSHAccountParameters;
import de.rcenvironment.core.instancemanagement.internal.UplinkConnectionParameters;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.extras.testscriptrunner.definitions.common.InstanceManagementStepDefinitionBase;
import de.rcenvironment.extras.testscriptrunner.definitions.common.ManagedInstance;
import de.rcenvironment.extras.testscriptrunner.definitions.common.TestScenarioExecutionContext;
import de.rcenvironment.extras.testscriptrunner.definitions.helper.RegularConnectionOptions;
import de.rcenvironment.extras.testscriptrunner.definitions.helper.RegularConnectionParameters;
import de.rcenvironment.extras.testscriptrunner.definitions.helper.SSHConnectionOptions;
import de.rcenvironment.extras.testscriptrunner.definitions.helper.UplinkConnectionOptions;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;

public class InstanceNetworkingStepDefinitions
extends InstanceManagementStepDefinitionBase {
    private static final ManagedInstance[] EMPTY_INSTANCE_ARRAY = new ManagedInstance[0];

    public InstanceNetworkingStepDefinitions(TestScenarioExecutionContext executionContext) {
        super(executionContext);
    }

    @Given(value="^configured network connection[s]? \"([^\"]*)\"$")
    public void givenConfiguredNetworkConnections(String connectionsSetup) throws Throwable {
        this.printToCommandConsole(StringUtils.format((String)"Configuring network connections (\"%s\")", (Object[])new Object[]{connectionsSetup}));
        Pattern p = Pattern.compile("\\s*(\\w+)-(?:\\[(reg|ssh|upl)\\]-)?>(\\w+)\\s*(?:\\[([\\w\\s]*)\\])?\\s*");
        String[] stringArray = connectionsSetup.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String connectionSetupPart = stringArray[n2];
            Matcher m = p.matcher(connectionSetupPart);
            if (!m.matches()) {
                Assert.fail((String)("Syntax error in connection setup part: " + connectionSetupPart));
            }
            ManagedInstance clientInstance = this.resolveInstance(m.group(1));
            String connectionType = m.group(2) == null ? "reg" : m.group(2);
            ManagedInstance serverInstance = this.resolveInstance(m.group(3));
            String options = m.group(4);
            switch (connectionType) {
                case "reg": {
                    this.setUpCompleteRegularConnection(clientInstance, serverInstance, options);
                    break;
                }
                case "ssh": {
                    this.setUpCompleteSSHConnection(clientInstance, serverInstance, options);
                    break;
                }
                case "upl": {
                    this.setUpCompleteUplinkConnection(clientInstance, serverInstance, options);
                    break;
                }
                default: {
                    Assert.fail((String)StringUtils.format((String)"Type %s is not supported.", (Object[])new Object[]{connectionType}));
                }
            }
            ++n2;
        }
    }

    @When(value="^configuring(?: instance)? \"([^\"]+)\" as a(?: (reg|ssh|upl))? server(?: given(?: the)? option[s]? \\[([^\\]]*)\\])?$")
    public void whenConfiguringInstanceAsServer(String serverInstanceId, String connectionType, String options) throws Throwable {
        if (connectionType == null) {
            connectionType = "reg";
        }
        ManagedInstance serverInstance = this.resolveInstance(serverInstanceId);
        int serverNumber = options == null ? 0 : Integer.parseInt(options.split("_")[1]);
        switch (connectionType) {
            case "reg": {
                this.configureServer(serverInstance, serverNumber);
                break;
            }
            case "ssh": 
            case "upl": {
                this.configureSSHServer(serverInstance, serverNumber);
                break;
            }
            default: {
                Assert.fail((String)StringUtils.format((String)"Type %s is not supported.", (Object[])new Object[]{connectionType}));
            }
        }
    }

    @When(value="^adding( disabled)? ssh account with user role \"([^\"]+)\", user name \"([^\"]+)\" and password \"([^\"]+)\" to(?: (?:instance|server))? \"([^\"]+)\"$")
    public void whenAddingSSHAccount(String disabledFlag, String userRole, String userName, String password, String serverInstanceId) throws Throwable {
        boolean enabled = disabledFlag == null;
        SSHAccountParameters accountParameters = SSHAccountParameters.builder().userRole(userRole).userName(userName).password(password).isEnabled(enabled).build();
        this.addSSHAccount(this.resolveInstance(serverInstanceId), accountParameters);
    }

    @When(value="^connecting(?: instance)? \"([^\"]+)\" to(?: (?:instance|server))? \"([^\"]+)\"(?: via(reg|ssh|upl))?(?: given(?: the)? option[s]? \\[([^\\]]*)\\])?$")
    public void whenConnectingInstances(String clientInstanceId, String serverInstanceId, String connectionType, String options) throws Throwable {
        if (connectionType == null) {
            connectionType = "reg";
        }
        ManagedInstance clientInstance = this.resolveInstance(clientInstanceId);
        ManagedInstance serverInstance = this.resolveInstance(serverInstanceId);
        switch (connectionType) {
            case "reg": {
                this.setupPartialRegularConnection(clientInstance, serverInstance, options);
                break;
            }
            case "ssh": {
                this.setUpPartialSSHConnection(clientInstance, serverInstance, options);
                break;
            }
            case "upl": {
                this.setUpPartialUplinkConnection(clientInstance, serverInstance, options);
                break;
            }
            default: {
                Assert.fail((String)StringUtils.format((String)"Type %s is not supported.", (Object[])new Object[]{connectionType}));
            }
        }
    }

    @Then(value="^all auto-start network connections should be ready within (\\d+) seconds$")
    public void thenAutoStartConnectionsReadyIn(int maxWaitTimeSeconds) throws Throwable {
        boolean success;
        ManagedInstance instance;
        int n;
        int n2;
        ManagedInstance[] managedInstanceArray;
        this.printToCommandConsole("Waiting for all auto-start network connections to complete");
        HashSet<ManagedInstance> pendingInstances = new HashSet<ManagedInstance>();
        for (ManagedInstance instance2 : this.executionContext.getEnabledInstances()) {
            if (instance2.accessConfiguredAutostartConnectionIds().isEmpty()) continue;
            pendingInstances.add(instance2);
        }
        long maximumTimestampForStandardAttempts = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(maxWaitTimeSeconds);
        while (!pendingInstances.isEmpty() && System.currentTimeMillis() <= maximumTimestampForStandardAttempts) {
            managedInstanceArray = this.detachedIterableCopy(pendingInstances);
            n2 = managedInstanceArray.length;
            n = 0;
            while (n < n2) {
                instance = managedInstanceArray[n];
                success = this.testIfConfiguredOutgoingConnectionsAreConnected(instance, false);
                if (success) {
                    pendingInstances.remove(instance);
                }
                ++n;
            }
            if (pendingInstances.isEmpty()) continue;
            Thread.sleep(500L);
        }
        if (!pendingInstances.isEmpty()) {
            managedInstanceArray = this.detachedIterableCopy(pendingInstances);
            n2 = managedInstanceArray.length;
            n = 0;
            while (n < n2) {
                instance = managedInstanceArray[n];
                success = this.testIfConfiguredOutgoingConnectionsAreConnected(instance, true);
                if (success) {
                    pendingInstances.remove(instance);
                }
                ++n;
            }
        }
        if (!pendingInstances.isEmpty()) {
            Assert.fail((String)("On " + pendingInstances.size() + " instance(s), the configured outgoing connections " + "were not established after waiting/retrying for " + maxWaitTimeSeconds + " second(s)"));
        }
    }

    @Then(value="^the visible network of \"([^\"]*)\" should (consist of|contain) \"([^\"]*)\"$")
    public void thenVisibleNetworkConsistOf(String instanceId, String testType, String listOfExpectedVisibleInstances) throws Throwable {
        String commandOutput = this.executeCommandOnInstance(this.resolveInstance(instanceId), "net info", false);
        List<String> expectedVisibleInstances = this.parseCommaSeparatedList(listOfExpectedVisibleInstances);
        switch (testType) {
            case "contain": {
                for (String expectedInstanceId : expectedVisibleInstances) {
                    if (commandOutput.contains(expectedInstanceId)) continue;
                    Assert.fail((String)("The visible network of instance " + instanceId + " does not contain the expected instance " + expectedInstanceId));
                }
                break;
            }
            case "consist of": {
                String[] stringArray = commandOutput.split("(\r\n|\r|\n)");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (!line.contains("Reachable network nodes")) {
                        if (line.contains("Message channels")) break;
                        if (!this.isExpectedVisibleInstance(line, expectedVisibleInstances)) {
                            Assert.fail((String)StringUtils.format((String)"Instance %s could see unexpected instances: \n %s", (Object[])new Object[]{instanceId, line}));
                        }
                    }
                    ++n2;
                }
                this.thenVisibleNetworkConsistOf(instanceId, "contain", listOfExpectedVisibleInstances);
                break;
            }
            default: {
                Assert.fail((String)StringUtils.format((String)"Test type %s is not supported.", (Object[])new Object[]{testType}));
            }
        }
        this.printToCommandConsole("Verified the visible network of instance \"" + instanceId + "\"");
    }

    private boolean isExpectedVisibleInstance(String line, List<String> expectedVisibleInstances) {
        for (String expectedInstanceId : expectedVisibleInstances) {
            if (!line.contains(expectedInstanceId)) continue;
            return true;
        }
        return false;
    }

    private Optional<String> extractValueFromOption(String option) {
        String[] keyValuePair = option.split("_");
        switch (keyValuePair.length) {
            case 1: {
                return Optional.empty();
            }
            case 2: {
                return Optional.of(keyValuePair[1]);
            }
        }
        Assert.fail((String)StringUtils.format((String)"Option %s contains multiple %s", (Object[])new Object[]{option, "_"}));
        return null;
    }

    private RegularConnectionOptions parseRegularConnectionOptions(String optionsString) {
        if (optionsString == null) {
            return RegularConnectionOptions.builder().build();
        }
        RegularConnectionOptions.Builder builder = RegularConnectionOptions.builder();
        String[] stringArray = optionsString.split("\\s");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            String key = this.extractKeyFromOption(option);
            Optional<String> value = this.extractValueFromOption(option);
            try {
                switch (key) {
                    case "autoStart": {
                        builder.autoStart(true);
                        break;
                    }
                    case "autoRetryInitialDelay": {
                        builder.autoRetryInitialDelay(Integer.parseInt(value.get()));
                        break;
                    }
                    case "autoRetryMaxDelay": {
                        builder.autoRetryMaxDelay(Integer.parseInt(value.get()));
                        break;
                    }
                    case "autoRetryDelayMultiplier": {
                        builder.autoRetryDelayMultiplier(Float.parseFloat(value.get()));
                        break;
                    }
                    case "connectionName": {
                        builder.connectionName(value.get());
                        break;
                    }
                    case "host": {
                        builder.host(value.get());
                        break;
                    }
                    case "port": {
                        builder.port(Integer.parseInt(value.get()));
                        break;
                    }
                    case "relay": {
                        builder.relay(true);
                        break;
                    }
                    case "serverNumber": {
                        builder.serverNumber(Integer.parseInt(value.get()));
                        break;
                    }
                    default: {
                        Assert.fail((String)StringUtils.format((String)"Option %s is not valid for a regular connection", (Object[])new Object[]{key}));
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                Assert.fail((String)StringUtils.format((String)"Value %s is of a wrong type to be applied to option %s", (Object[])new Object[]{value, key}));
            }
            ++n2;
        }
        return builder.build();
    }

    private SSHConnectionOptions parseSSHConnectionOptions(String optionsString) {
        if (optionsString == null) {
            return SSHConnectionOptions.builder().build();
        }
        SSHConnectionOptions.Builder builder = SSHConnectionOptions.builder();
        String[] stringArray = optionsString.split("\\s");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            String key = this.extractKeyFromOption(option);
            Optional<String> value = this.extractValueFromOption(option);
            try {
                switch (key) {
                    case "connectionName": {
                        builder.connectionName(value.get());
                        break;
                    }
                    case "displayName": {
                        builder.displayName(value.get());
                        break;
                    }
                    case "host": {
                        builder.host(value.get());
                        break;
                    }
                    case "port": {
                        builder.port(Integer.parseInt(value.get()));
                        break;
                    }
                    case "serverNumber": {
                        builder.serverNumber(Integer.parseInt(value.get()));
                        break;
                    }
                    case "userName": {
                        builder.userName(value.get());
                        break;
                    }
                    case "userRole": {
                        builder.userRole(value.get());
                        break;
                    }
                    default: {
                        Assert.fail((String)StringUtils.format((String)"Option %s is not valid for a SSH connection", (Object[])new Object[]{key}));
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                Assert.fail((String)StringUtils.format((String)"Value %s is of a wrong type to be applied to option %s", (Object[])new Object[]{value, key}));
            }
            ++n2;
        }
        return builder.build();
    }

    private UplinkConnectionOptions parseUplinkConnectionOptions(String optionsString) {
        if (optionsString == null) {
            return UplinkConnectionOptions.builder().build();
        }
        UplinkConnectionOptions.Builder builder = UplinkConnectionOptions.builder();
        String[] stringArray = optionsString.split("\\s");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            String key = this.extractKeyFromOption(option);
            Optional<String> value = this.extractValueFromOption(option);
            try {
                switch (key) {
                    case "autoRetry": {
                        builder.autoRetry(true);
                        break;
                    }
                    case "autoStart": {
                        builder.autoStart(true);
                        break;
                    }
                    case "clientId": {
                        builder.clientId(value.get());
                        break;
                    }
                    case "connectionName": {
                        builder.connectionName(value.get());
                        break;
                    }
                    case "isGateway": {
                        builder.gateway(true);
                        break;
                    }
                    case "host": {
                        builder.host(value.get());
                        break;
                    }
                    case "password": {
                        builder.password(value.get());
                        break;
                    }
                    case "port": {
                        builder.port(Integer.parseInt(value.get()));
                        break;
                    }
                    case "serverNumber": {
                        builder.serverNumber(Integer.parseInt(value.get()));
                        break;
                    }
                    case "userName": {
                        builder.userName(value.get());
                        break;
                    }
                    case "userRole": {
                        builder.userRole(value.get());
                        break;
                    }
                    default: {
                        Assert.fail((String)StringUtils.format((String)"Option %s is not valid for a uplink connection", (Object[])new Object[]{key}));
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                Assert.fail((String)StringUtils.format((String)"Value %s is of a wrong type to be applied to option %s", (Object[])new Object[]{value, key}));
            }
            ++n2;
        }
        return builder.build();
    }

    private void setUpCompleteRegularConnection(ManagedInstance clientInstance, ManagedInstance serverInstance, String options) throws Throwable {
        RegularConnectionOptions connectionOptions = this.parseRegularConnectionOptions(options);
        Integer serverPort = this.configureServer(serverInstance, connectionOptions.getServerNumber());
        if (connectionOptions.isRelay()) {
            this.configureRelay(serverInstance, true);
        }
        RegularConnectionParameters connectionParameters = RegularConnectionParameters.builder().connectionId(StringUtils.format((String)"%s_%s", (Object[])new Object[]{serverInstance.getId(), serverPort})).host("127.0.0.1").port(serverPort).autoStartFlag(connectionOptions.getAutoStartFlag()).autoRetryInitDelay(connectionOptions.getAutoRetryInitialDelay()).autoRetryMaxDelay(connectionOptions.getAutoRetryMaxDelay()).autoRetryDelayMultiplier(connectionOptions.getAutoRetryDelayMultiplier()).build();
        this.configureRegularConnection(clientInstance, connectionParameters);
    }

    private void setupPartialRegularConnection(ManagedInstance clientInstance, ManagedInstance serverInstance, String options) throws Throwable {
        RegularConnectionOptions connectionOptions = this.parseRegularConnectionOptions(options);
        RegularConnectionParameters connectionParameters = RegularConnectionParameters.builder().connectionId(connectionOptions.getConnectionName().orElse(StringUtils.format((String)"%s_%s", (Object[])new Object[]{serverInstance.getId(), connectionOptions.getPort()}))).host(connectionOptions.getHost()).port(connectionOptions.getPort().orElse(this.getServerPort(serverInstance, connectionOptions.getServerNumber(), "reg"))).autoStartFlag(connectionOptions.getAutoStartFlag()).autoRetryInitDelay(connectionOptions.getAutoRetryInitialDelay()).autoRetryMaxDelay(connectionOptions.getAutoRetryMaxDelay()).autoRetryDelayMultiplier(connectionOptions.getAutoRetryDelayMultiplier()).build();
        this.configureRegularConnection(clientInstance, connectionParameters);
    }

    private void setUpCompleteSSHConnection(ManagedInstance clientInstance, ManagedInstance serverInstance, String options) throws Throwable {
        SSHConnectionOptions connectionOptions = this.parseSSHConnectionOptions(options);
        Integer serverPort = this.configureSSHServer(serverInstance, connectionOptions.getServerNumber());
        SSHAccountParameters accountParametersSSH = SSHAccountParameters.builder().userRole(connectionOptions.getUserRole().orElse("ra_demo")).userName(connectionOptions.getUserName()).password(connectionOptions.getUserName()).isEnabled(true).build();
        this.addSSHAccount(serverInstance, accountParametersSSH);
        this.configureSSHConnection(clientInstance, StringUtils.format((String)"%s_%s", (Object[])new Object[]{serverInstance.getId(), connectionOptions.getPort()}), clientInstance.getId(), "127.0.0.1", serverPort, connectionOptions.getUserName());
    }

    private void setUpPartialSSHConnection(ManagedInstance clientInstance, ManagedInstance serverInstance, String options) throws Throwable {
        SSHConnectionOptions connectionOptions = this.parseSSHConnectionOptions(options);
        this.configureSSHConnection(clientInstance, connectionOptions.getConnectionName().orElse(StringUtils.format((String)"%s_%s", (Object[])new Object[]{serverInstance.getId(), connectionOptions.getUserName()})), connectionOptions.getDisplayName().orElse(StringUtils.format((String)"%s_%s", (Object[])new Object[]{serverInstance.getId(), connectionOptions.getUserName()})), connectionOptions.getHost(), connectionOptions.getPort().orElse(this.getServerPort(serverInstance, connectionOptions.getServerNumber(), "reg")), connectionOptions.getUserName());
    }

    private void setUpCompleteUplinkConnection(ManagedInstance clientInstance, ManagedInstance serverInstance, String options) throws Throwable {
        UplinkConnectionOptions connectionOptions = this.parseUplinkConnectionOptions(options);
        Integer serverPort = this.configureSSHServer(serverInstance, connectionOptions.getServerNumber());
        SSHAccountParameters accountParametersUpl = SSHAccountParameters.builder().userRole(connectionOptions.getUserRole().orElse("uplink_client")).userName(connectionOptions.getUserName()).password(connectionOptions.getUserName()).isEnabled(true).build();
        this.addSSHAccount(serverInstance, accountParametersUpl);
        UplinkConnectionParameters uplinkParameters = UplinkConnectionParameters.builder().connectionId(StringUtils.format((String)"%s_%s", (Object[])new Object[]{serverInstance.getId(), connectionOptions.getUserName()})).host("127.0.0.1").port(serverPort.intValue()).clientId(StringUtils.format((String)"%s_%s", (Object[])new Object[]{clientInstance.getId(), serverInstance.getId()})).gateway(connectionOptions.getGateway()).autoStart(connectionOptions.getAutoStart()).autoRetry(connectionOptions.getAutoRetry()).userName(connectionOptions.getUserName()).password(connectionOptions.getUserName()).build();
        this.configureUplinkConnection(clientInstance, uplinkParameters);
    }

    private void setUpPartialUplinkConnection(ManagedInstance clientInstance, ManagedInstance serverInstance, String options) throws Throwable {
        UplinkConnectionOptions connectionOptions = this.parseUplinkConnectionOptions(options);
        UplinkConnectionParameters uplinkParameters = UplinkConnectionParameters.builder().autoRetry(connectionOptions.getAutoRetry()).autoStart(connectionOptions.getAutoStart()).clientId(connectionOptions.getClientId()).connectionId(connectionOptions.getConnectionName().orElse(StringUtils.format((String)"%s_%s", (Object[])new Object[]{serverInstance.getId(), connectionOptions.getUserName()}))).gateway(connectionOptions.getGateway()).host(connectionOptions.getHost()).password(connectionOptions.getPassword()).port(connectionOptions.getPort().orElse(this.getServerPort(serverInstance, connectionOptions.getServerNumber(), "reg")).intValue()).userName(connectionOptions.getUserName()).build();
        this.configureUplinkConnection(clientInstance, uplinkParameters);
    }

    private void configureRegularConnection(ManagedInstance clientInstance, RegularConnectionParameters parameters) throws Throwable {
        INSTANCE_MANAGEMENT_SERVICE.applyInstanceConfigurationOperations(clientInstance.getId(), INSTANCE_MANAGEMENT_SERVICE.newConfigurationOperationSequence().addNetworkConnection(parameters.getConnectionId(), parameters.getHost(), parameters.getPort(), parameters.isAutoStart(), parameters.getAutoRetryInitDelay(), parameters.getAutoRetryMaxDelay(), parameters.getAutoRetryDelayMultiplier()), (TextOutputReceiver)this.getTextoutReceiverForIMOperations());
        if (parameters.isAutoStart()) {
            clientInstance.accessConfiguredAutostartConnectionIds().add(StringUtils.format((String)"%s:%d", (Object[])new Object[]{parameters.getHost(), parameters.getPort()}));
        }
    }

    private void configureRelay(ManagedInstance serverInstance, boolean isRelay) throws Throwable {
        INSTANCE_MANAGEMENT_SERVICE.applyInstanceConfigurationOperations(serverInstance.getId(), INSTANCE_MANAGEMENT_SERVICE.newConfigurationOperationSequence().setRelayFlag(isRelay), (TextOutputReceiver)this.getTextoutReceiverForIMOperations());
    }

    private void configureSSHConnection(ManagedInstance clientInstance, String connectionId, String displayName, String host, int port, String loginName) throws Throwable {
        INSTANCE_MANAGEMENT_SERVICE.applyInstanceConfigurationOperations(clientInstance.getId(), INSTANCE_MANAGEMENT_SERVICE.newConfigurationOperationSequence().addSshConnection(connectionId, displayName, host, port, loginName), (TextOutputReceiver)this.getTextoutReceiverForIMOperations());
    }

    private void configureUplinkConnection(ManagedInstance clientInstance, UplinkConnectionParameters uplinkParameters) throws Throwable {
        INSTANCE_MANAGEMENT_SERVICE.applyInstanceConfigurationOperations(clientInstance.getId(), INSTANCE_MANAGEMENT_SERVICE.newConfigurationOperationSequence().addUplinkConnection(uplinkParameters), (TextOutputReceiver)this.getTextoutReceiverForIMOperations());
    }

    private Integer configureServer(ManagedInstance serverInstance, int serverNumber) throws InstanceConfigurationException, IOException {
        Integer serverPort = this.getServerPort(serverInstance, serverNumber, "reg");
        INSTANCE_MANAGEMENT_SERVICE.applyInstanceConfigurationOperations(serverInstance.getId(), INSTANCE_MANAGEMENT_SERVICE.newConfigurationOperationSequence().addServerPort(StringUtils.format((String)"%s:%s", (Object[])new Object[]{"127.0.0.1", serverPort}), "127.0.0.1", serverPort.intValue()), (TextOutputReceiver)this.getTextoutReceiverForIMOperations());
        return serverPort;
    }

    private Integer configureSSHServer(ManagedInstance serverInstance, int serverNumber) throws Throwable {
        Integer serverPort = this.getServerPort(serverInstance, serverNumber, "ssh");
        INSTANCE_MANAGEMENT_SERVICE.applyInstanceConfigurationOperations(serverInstance.getId(), INSTANCE_MANAGEMENT_SERVICE.newConfigurationOperationSequence().enableSshServer("127.0.0.1", serverPort.intValue()), (TextOutputReceiver)this.getTextoutReceiverForIMOperations());
        return serverPort;
    }

    private void addSSHAccount(ManagedInstance serverInstance, SSHAccountParameters parameters) throws Throwable {
        INSTANCE_MANAGEMENT_SERVICE.applyInstanceConfigurationOperations(serverInstance.getId(), INSTANCE_MANAGEMENT_SERVICE.newConfigurationOperationSequence().addSshAccount(parameters), (TextOutputReceiver)this.getTextoutReceiverForIMOperations());
    }

    private Integer getServerPort(ManagedInstance instance, int serverNumber, String connectionType) {
        Integer serverPort;
        if (connectionType.equals("upl")) {
            connectionType = "ssh";
        }
        if ((serverPort = instance.getServerPort(connectionType, serverNumber)) == null) {
            serverPort = PORT_NUMBER_GENERATOR.incrementAndGet();
            while (!this.isPortAvailable(serverPort)) {
                serverPort = PORT_NUMBER_GENERATOR.incrementAndGet();
            }
            instance.setServerPort(connectionType, serverNumber, serverPort);
        }
        return serverPort;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isPortAvailable(int portNumber) {
        ServerSocket socket = null;
        socket = new ServerSocket(portNumber);
        socket.setReuseAddress(true);
        if (socket == null) return true;
        try {
            socket.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
        catch (IOException iOException) {
            try {
                if (socket == null) return false;
            }
            catch (Throwable throwable) {
                if (socket == null) throw throwable;
                try {
                    socket.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                socket.close();
                return false;
            }
            catch (IOException iOException3) {}
            return false;
        }
    }

    private boolean testIfConfiguredOutgoingConnectionsAreConnected(ManagedInstance instance, boolean isFinalAttempt) {
        List<String> connectionIds = instance.accessConfiguredAutostartConnectionIds();
        String commandOutput = this.executeCommandOnInstance(instance, "cn list", false);
        int matches = 0;
        for (String connectionId : connectionIds) {
            Matcher matcher = Pattern.compile("'" + connectionId + "'.*?- (\\w+)").matcher(commandOutput);
            if (!matcher.find()) {
                if (!isFinalAttempt) continue;
                Assert.fail((String)StringUtils.format((String)"Unexpected state: Attempted to verify the state of connection \"%s\" on \"%s\", but it did not appear in the output of \"cn list\" at all; full command output:\n%s", (Object[])new Object[]{connectionId, instance, commandOutput}));
            }
            String state = matcher.group(1);
            if (matcher.find()) {
                Assert.fail((String)StringUtils.format((String)"Unexpected state: Found more than one entry for connection \"%s\" on \"%s\" in the output of \"cn list\"; full command output:\n%s", (Object[])new Object[]{connectionId, instance, commandOutput}));
            }
            if ("CONNECTED".equals(state)) {
                ++matches;
                continue;
            }
            if (!isFinalAttempt) continue;
            this.printToCommandConsole(StringUtils.format((String)"Failed expectation: the connection \"%s\" on \"%s\" should be in state \"CONNECTED\", but is \"%s\"", (Object[])new Object[]{connectionId, instance, state}));
        }
        boolean success = matches == connectionIds.size();
        return success;
    }

    private ManagedInstance[] detachedIterableCopy(Collection<ManagedInstance> pendingInstances) {
        return pendingInstances.toArray(EMPTY_INSTANCE_ARRAY);
    }

    private String extractKeyFromOption(String option) {
        return option.split("_")[0];
    }
}

