/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.impl;

import cucumber.api.java.en.When;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.extras.testscriptrunner.definitions.common.InstanceManagementStepDefinitionBase;
import de.rcenvironment.extras.testscriptrunner.definitions.common.ManagedInstance;
import de.rcenvironment.extras.testscriptrunner.definitions.common.TestScenarioExecutionContext;
import java.awt.AWTException;
import java.awt.Robot;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;

public class InstanceCommandStepDefinitions
extends InstanceManagementStepDefinitionBase {
    public InstanceCommandStepDefinitions(TestScenarioExecutionContext executionContext) {
        super(executionContext);
    }

    @When(value="^executing(?: the)? command[s]? \"([^\"]*)\" on( all)?(?: instance[s])?(?: \"([^\"]*)\")?(?: (in the given order|concurrently|in a random order))?$")
    public void whenExecutingCommandOnInstances(String commandList, String allFlag, String instanceIds, String executionDesc) throws Throwable {
        this.performActionOnInstances(new ExecuteCommandOnInstanceAction(this.parseCommaSeparatedList(commandList), true), this.resolveInstanceList(allFlag != null, instanceIds), this.resolveExecutionMode(executionDesc, InstanceManagementStepDefinitionBase.InstanceActionExecutionType.RANDOM));
    }

    @When(value="^executing command order \"([^\"]*)\"(?: on(?: the)? top layer(?: UI)?)?$")
    public void whenClosingConfigureUIAfterStartUp(String operations) throws Throwable {
        try {
            Robot robot = new Robot();
            LinkedList<Integer> keys = new LinkedList<Integer>();
            List<String> commands = this.parseCommaSeparatedList(operations);
            Iterator<String> iterator = commands.iterator();
            while (iterator.hasNext()) {
                String command;
                switch (command = iterator.next()) {
                    case "up": {
                        keys.add(38);
                        break;
                    }
                    case "left": {
                        keys.add(37);
                        break;
                    }
                    case "right": {
                        keys.add(39);
                        break;
                    }
                    case "down": {
                        keys.add(40);
                        break;
                    }
                    case "enter": {
                        keys.add(10);
                        break;
                    }
                    default: {
                        Assert.fail((String)StringUtils.format((String)"Command %s is not a valid execution command.", (Object[])new Object[]{command}));
                    }
                }
            }
            this.performKeyboardActions(robot, keys);
        }
        catch (AWTException aWTException) {
            Assert.fail((String)"Error attempting to execute commands");
        }
    }

    private void performKeyboardActions(Robot robot, List<Integer> keys) {
        keys.forEach(key -> {
            robot.keyPress((int)key);
            robot.keyRelease((int)key);
        });
    }

    private class ExecuteCommandOnInstanceAction
    implements InstanceManagementStepDefinitionBase.InstanceAction {
        private List<String> commands;
        private boolean mainAction;

        ExecuteCommandOnInstanceAction(List<String> commands, boolean mainAction) {
            this.commands = commands;
            this.mainAction = mainAction;
        }

        @Override
        public void performActionOnInstance(ManagedInstance instance, long timeout) throws IOException {
            for (String command : this.commands) {
                String commandOutput = InstanceCommandStepDefinitions.this.executeCommandOnInstance(instance, command, this.mainAction);
                instance.setLastCommandOutput(commandOutput);
            }
            InstanceCommandStepDefinitions.this.executionContext.setLastInstanceWithSingleCommandExecution(instance);
        }
    }
}

