/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common;

import de.rcenvironment.core.utils.common.TempFileManager;
import de.rcenvironment.core.utils.common.TempFileService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.LogFactory;

public class TempFileServiceAccess {
    private static volatile TempFileService instance;
    private static final String UNIT_TEST_RELATIVE_GLOBAL_ROOT_DIR_PATH = "rce-unittest";
    private static TempFileManager currentMmanager;

    protected TempFileServiceAccess() {
    }

    public static TempFileService getInstance() {
        TempFileService instanceCopy = instance;
        if (instanceCopy != null) {
            return instanceCopy;
        }
        LogFactory.getLog(TempFileServiceAccess.class).debug((Object)"A TempFileService instance was requested before the global instance was ready, returning a proxy");
        return new ServiceProxy();
    }

    public static void setupLiveEnvironment(File globalTempDirectoryRoot, String instancePrefix) throws IOException {
        currentMmanager = new TempFileManager(globalTempDirectoryRoot, instancePrefix);
        TempFileServiceAccess.setInstance(currentMmanager.getServiceImplementation());
    }

    public static void setupUnitTestEnvironment() {
        if (instance == null) {
            try {
                if (currentMmanager == null) {
                    currentMmanager = new TempFileManager(TempFileServiceAccess.getDefaultTestRootDir(), null, true);
                }
                TempFileServiceAccess.setInstance(currentMmanager.getServiceImplementation());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to initialize unittest temp directory root", e);
            }
        }
    }

    protected static void setInstance(TempFileService newInstance) {
        if (newInstance == null) {
            throw new IllegalArgumentException("Setting the global instance back to 'null' is not allowed");
        }
        instance = newInstance;
    }

    protected static File getDefaultTestRootDir() {
        return new File(System.getProperty("java.io.tmpdir"), UNIT_TEST_RELATIVE_GLOBAL_ROOT_DIR_PATH);
    }

    protected static void discardCurrentSetup() {
        currentMmanager = null;
        instance = null;
    }

    private static final class ServiceProxy
    implements TempFileService {
        private ServiceProxy() {
        }

        @Override
        public File createManagedTempDir() throws IOException {
            return this.getNullSafeInstance().createManagedTempDir();
        }

        @Override
        public File createManagedTempDir(String infoText) throws IOException {
            return this.getNullSafeInstance().createManagedTempDir(infoText);
        }

        @Override
        public File createTempFileFromPattern(String filenamePattern) throws IOException {
            return this.getNullSafeInstance().createTempFileFromPattern(filenamePattern);
        }

        @Override
        public File createTempFileWithFixedFilename(String filename) throws IOException {
            return this.getNullSafeInstance().createTempFileWithFixedFilename(filename);
        }

        @Override
        public File writeInputStreamToTempFile(InputStream is) throws IOException {
            return this.getNullSafeInstance().writeInputStreamToTempFile(is);
        }

        @Override
        public void disposeManagedTempDirOrFile(File tempFileOrDir) throws IOException {
            this.getNullSafeInstance().disposeManagedTempDirOrFile(tempFileOrDir);
        }

        private TempFileService getNullSafeInstance() {
            TempFileService instanceCopy = instance;
            if (instanceCopy == null) {
                throw new IllegalStateException("A TempFileService method was called while no global instance was available");
            }
            return instanceCopy;
        }
    }
}

