/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AuditLog {
    protected static final int EXPECTED_TIMESTAMP_LENGTH = 23;
    private static AuditLog sharedInstance = new AuditLog(new FallbackLoggingBackend());
    private final AuditLogBackend backend;
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private final DateTimeFormatter timestampFormatter = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSS");

    protected AuditLog(AuditLogBackend backend) {
        this.backend = backend;
    }

    public static synchronized void initialize(AuditLogBackend backend) {
        if (sharedInstance != null && !(AuditLog.sharedInstance.backend instanceof FallbackLoggingBackend)) {
            throw new IllegalStateException("Already initialized with custom backend");
        }
        sharedInstance = new AuditLog(backend);
    }

    @Deprecated
    public static synchronized void disableForIntegrationTesting() {
        sharedInstance = new AuditLog(new NOPLogBackend());
    }

    public static LogEntry newEntry(String eventId) {
        return new LogEntry(eventId);
    }

    public static synchronized void append(LogEntry entry) {
        if (sharedInstance == null) {
            throw new IllegalStateException("Not initialized");
        }
        sharedInstance.appendInternal(entry.eventId, entry.data);
    }

    public static synchronized void append(String eventId, Map<String, String> data) {
        if (sharedInstance == null) {
            throw new IllegalStateException("Not initialized");
        }
        sharedInstance.appendInternal(eventId, data);
    }

    public static synchronized void append(String eventId, String key, String value) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(key, value);
        AuditLog.append(eventId, data);
    }

    public static synchronized void close() {
        if (sharedInstance == null) {
            AuditLog.getStandardLog().warn((Object)"Audit log requested to close without being initialized first; ignoring call");
            return;
        }
        try {
            AuditLog.sharedInstance.backend.close();
        }
        catch (IOException e) {
            AuditLog.getStandardLog().error((Object)("Error closing audit log backend: " + e.toString()));
        }
        sharedInstance = null;
    }

    protected void appendInternal(String eventId, Map<String, String> data) {
        String dataString;
        LocalDateTime time = LocalDateTime.now();
        String timestamp = this.formatTimestamp(time);
        if (data == null || data.isEmpty()) {
            dataString = "{}";
        } else {
            try {
                dataString = this.jsonMapper.writeValueAsString(data);
            }
            catch (JsonProcessingException e) {
                dataString = "##JSON Write error:" + e.toString() + "##" + data.toString();
            }
        }
        try {
            this.backend.append(timestamp, eventId, dataString);
        }
        catch (IOException e) {
            AuditLog.getStandardLog().error((Object)("Error writing to audit log: " + e.toString()));
        }
    }

    protected String formatTimestamp(LocalDateTime time) {
        String formatted = time.format(this.timestampFormatter);
        int len = formatted.length();
        if (len == 23) {
            return formatted;
        }
        throw new IllegalStateException(Integer.toString(len));
    }

    private static Log getStandardLog() {
        return LogFactory.getLog(AuditLog.class);
    }

    public static abstract class AuditLogBackend
    implements Closeable {
        public abstract void append(String var1, String var2, String var3) throws IOException;
    }

    private static final class FallbackLoggingBackend
    extends AuditLogBackend {
        private FallbackLoggingBackend() {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void append(String timestamp, String eventId, String data) throws IOException {
            LogFactory.getLog(AuditLog.class).warn((Object)StringUtils.format("Received an event while no log receiver is configured; this is normal during unit/integration testing. Data: %s, %s, %s", timestamp, eventId, data));
        }
    }

    public static final class LogEntry {
        private final String eventId;
        private final Map<String, String> data = new TreeMap<String, String>();

        public LogEntry(String eventId) {
            this.eventId = eventId;
        }

        public LogEntry set(String key, String value) {
            this.data.put(key, value);
            return this;
        }

        public LogEntry set(String key, int value) {
            this.set(key, Integer.toString(value));
            return this;
        }

        public LogEntry setAll(Map<String, String> dataMap) {
            this.data.putAll(dataMap);
            return this;
        }
    }

    private static final class NOPLogBackend
    extends AuditLogBackend {
        private NOPLogBackend() {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void append(String timestamp, String eventId, String data) throws IOException {
        }
    }
}

