/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.scripting.python;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.component.datamanagement.api.CommonComponentHistoryDataItem;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.execution.api.ComponentLog;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.execution.api.ConsoleRowUtils;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.BooleanTD;
import de.rcenvironment.core.datamodel.types.api.DirectoryReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FloatTD;
import de.rcenvironment.core.datamodel.types.api.IntegerTD;
import de.rcenvironment.core.datamodel.types.api.MatrixTD;
import de.rcenvironment.core.datamodel.types.api.ShortTextTD;
import de.rcenvironment.core.datamodel.types.api.SmallTableTD;
import de.rcenvironment.core.datamodel.types.api.VectorTD;
import de.rcenvironment.core.scripting.ScriptDataTypeHelper;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.legacy.FileSupport;
import de.rcenvironment.core.utils.common.textstream.TextStreamWatcher;
import de.rcenvironment.core.utils.executor.LocalApacheCommandLineExecutor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PythonScriptEngine
implements ScriptEngine {
    private static final String INPUT_FILE_FACTORY_PY = "input_file_factory.py";
    private static final String SIMPLEJSON = "simplejson.zip";
    private static final String RESOURCES = "/resources/";
    private static final String PYTHON_BRIDGE = "RCE_Channel.py";
    private static final String RUN_SCRIPT = "Run_python_script_in_rce.py";
    private static final Log LOGGER = LogFactory.getLog(PythonScriptEngine.class);
    private static final String ESCAPED_DOUBLE_QUOTE = "\"";
    private static final int EXIT_CODE_FAILURE = 1;
    private static final String ESCAPESLASH = "\\\\";
    private static final String SLASH = "/";
    private static ComponentDataManagementService componentDatamanagementService;
    private File tempDir;
    private ScriptContext context;
    private LocalApacheCommandLineExecutor executor;
    private final ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
    private Map<String, Serializable> output = new HashMap<String, Serializable>();
    private final List<File> tempFiles = new LinkedList<File>();
    private List<String> closeOutputChannelsList = new LinkedList<String>();
    private TextStreamWatcher stdoutWatcher;
    private TextStreamWatcher stderrWatcher;
    private Map<String, Object> stateOutput;
    private List<String> writtenFileOutput;
    private CountDownLatch initializationSignal;
    private boolean canceledBeforeInitialization = false;

    public synchronized void createNewExecutor(CommonComponentHistoryDataItem dataItem) {
        if (this.canceledBeforeInitialization) {
            LOGGER.error((Object)"Failed to create executor for python, since the SriptEngine was already canceled.");
            return;
        }
        try {
            this.executor = new LocalApacheCommandLineExecutor(null);
            this.initializationSignal = new CountDownLatch(1);
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"Failed to create executor for python.");
        }
    }

    @Override
    public Bindings createBindings() {
        return null;
    }

    @Override
    public Object eval(String script) throws ScriptException {
        try {
            this.tempDir = TempFileServiceAccess.getInstance().createManagedTempDir("python");
            this.tempFiles.add(this.tempDir);
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"Could not create managed temp directory, falling back to default");
            try {
                File tmp = File.createTempFile("prefix", "suffix");
                this.tempDir = tmp.getParentFile();
                tmp.delete();
            }
            catch (IOException iOException2) {
                LOGGER.error((Object)"Failed to fall back.");
                throw new ScriptException("Unable to create temp file and directory");
            }
        }
        this.writeInputForPython();
        try {
            this.createTemporaryPythonScript(script);
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"Failed to create temporary Python script.");
        }
        this.executor.setWorkDir(this.tempDir);
        String command = ESCAPED_DOUBLE_QUOTE + (String)this.context.getAttribute("pythonExecutionPath") + ESCAPED_DOUBLE_QUOTE + " -u " + this.tempDir.getAbsolutePath() + File.separator + RUN_SCRIPT;
        LOGGER.debug((Object)("PythonExecutor executes command: " + command));
        int exitCode = 0;
        try {
            this.executor.start(command);
            this.prepareOutputForRun();
            this.initializationSignal.countDown();
            try {
                exitCode = this.executor.waitForTermination();
                this.stdoutWatcher.waitForTermination();
                this.stderrWatcher.waitForTermination();
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)("ProgramBlocker: InterruptedException " + e.getMessage()));
                return 1;
            }
            catch (CancellationException cancellationException) {
                LOGGER.debug((Object)"Execution canceled while waiting for termination of TextStreamWatcher.");
                return 1;
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Something during Python execution failed. See exception for details", (Throwable)e);
        }
        this.readOutputFromPython();
        for (String item : this.writtenFileOutput) {
            String message = "The Input File Factory has written the following file: " + item;
            LOGGER.debug((Object)message);
        }
        return exitCode;
    }

    private void prepareOutputForRun() {
        this.stdoutWatcher = ConsoleRowUtils.logToWorkflowConsole((ComponentLog)((ComponentContext)this.context.getAttribute("compCtx")).getLog(), (InputStream)this.executor.getStdout(), (ConsoleRow.Type)ConsoleRow.Type.TOOL_OUT, null, (boolean)false);
        this.stderrWatcher = ConsoleRowUtils.logToWorkflowConsole((ComponentLog)((ComponentContext)this.context.getAttribute("compCtx")).getLog(), (InputStream)this.executor.getStderr(), (ConsoleRow.Type)ConsoleRow.Type.TOOL_ERROR, null, (boolean)false);
    }

    private void writeInputForPython() {
        ComponentContext compContext = (ComponentContext)this.context.getAttribute("compCtx");
        Map<String, Object> inputsToWrite = this.extractInputsToWrite(compContext);
        LinkedList<String> inputsNotConnected = new LinkedList<String>();
        for (String input : compContext.getInputsNotConnected()) {
            if (compContext.getInputMetaDataValue(input, "inputExecutionConstraint_4aae3eea") == null || !compContext.getInputMetaDataValue(input, "inputExecutionConstraint_4aae3eea").equals(EndpointDefinition.InputExecutionContraint.RequiredIfConnected.name()) && !compContext.getInputMetaDataValue(input, "inputExecutionConstraint_4aae3eea").equals(EndpointDefinition.InputExecutionContraint.NotRequired.name())) continue;
            inputsNotConnected.add(input);
        }
        for (String input : compContext.getInputs()) {
            if (compContext.getInputMetaDataValue(input, "inputExecutionConstraint_4aae3eea") == null || !compContext.getInputMetaDataValue(input, "inputExecutionConstraint_4aae3eea").equals(EndpointDefinition.InputExecutionContraint.NotRequired.name()) || compContext.getInputsWithDatum().contains(input)) continue;
            inputsNotConnected.add(input);
        }
        try {
            this.mapper.writeValue(new File(this.tempDir.getAbsolutePath(), "pythonInput.rced"), inputsToWrite);
            this.mapper.writeValue(new File(this.tempDir.getAbsolutePath(), "pythonInputReqIfConnected.rced"), inputsNotConnected);
            this.mapper.writeValue(new File(this.tempDir.getAbsolutePath(), "pythonStateVariables.rces"), this.context.getAttribute("stateMap"));
            this.mapper.writeValue(new File(this.tempDir.getAbsolutePath(), "pythonRunNumber.rcen"), this.context.getAttribute("runNumber"));
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage());
        }
        LinkedList<String> outputNames = new LinkedList<String>();
        for (String outputName : compContext.getOutputs()) {
            outputNames.add(outputName);
        }
        try {
            this.mapper.writeValue(new File(String.valueOf(this.tempDir.getAbsolutePath()) + File.separator + "outputs.rceo"), outputNames);
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage());
        }
    }

    private Map<String, Object> extractInputsToWrite(ComponentContext compContext) {
        HashMap<String, Object> inputsToWrite = new HashMap<String, Object>();
        block15: for (String inputName : compContext.getInputsWithDatum()) {
            switch (compContext.getInputDataType(inputName)) {
                case FileReference: {
                    FileReferenceTD fileReference = (FileReferenceTD)compContext.readInput(inputName);
                    File fileInputDir = new File(this.tempDir, inputName);
                    this.tempFiles.add(fileInputDir);
                    File file = new File(fileInputDir, fileReference.getFileName());
                    try {
                        componentDatamanagementService.copyFileReferenceTDToLocalFile(compContext, fileReference, file);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to load input file from the data management", e);
                    }
                    inputsToWrite.put(inputName, file.getAbsolutePath().replaceAll(ESCAPESLASH, SLASH));
                    break;
                }
                case DirectoryReference: {
                    DirectoryReferenceTD directoryReference = (DirectoryReferenceTD)compContext.readInput(inputName);
                    File dirInputDir = new File(this.tempDir, inputName);
                    this.tempFiles.add(dirInputDir);
                    File dir = new File(dirInputDir, directoryReference.getDirectoryName());
                    try {
                        componentDatamanagementService.copyDirectoryReferenceTDToLocalDirectory(compContext, (DirectoryReferenceTD)compContext.readInput(inputName), dirInputDir);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to load input directory from the data management", e);
                    }
                    inputsToWrite.put(inputName, dir.getAbsolutePath().replaceAll(ESCAPESLASH, SLASH));
                    break;
                }
                case Boolean: {
                    boolean bool = ((BooleanTD)compContext.readInput(inputName)).getBooleanValue();
                    if (bool) {
                        inputsToWrite.put(inputName, true);
                        break;
                    }
                    inputsToWrite.put(inputName, false);
                    break;
                }
                case ShortText: {
                    inputsToWrite.put(inputName, ((ShortTextTD)compContext.readInput(inputName)).getShortTextValue());
                    break;
                }
                case Integer: {
                    inputsToWrite.put(inputName, ((IntegerTD)compContext.readInput(inputName)).getIntValue());
                    break;
                }
                case Float: {
                    if (compContext.readInput(inputName) instanceof FloatTD) {
                        inputsToWrite.put(inputName, ((FloatTD)compContext.readInput(inputName)).getFloatValue());
                        break;
                    }
                    if (!(compContext.readInput(inputName) instanceof IntegerTD)) continue block15;
                    inputsToWrite.put(inputName, ((IntegerTD)compContext.readInput(inputName)).getIntValue());
                    break;
                }
                case Vector: {
                    VectorTD vector = (VectorTD)compContext.readInput(inputName);
                    Object[] resultVector = new Object[vector.getRowDimension()];
                    int j = 0;
                    while (j < vector.getRowDimension()) {
                        resultVector[j] = vector.getFloatTDOfElement(j).getFloatValue();
                        ++j;
                    }
                    inputsToWrite.put(inputName, resultVector);
                    break;
                }
                case Matrix: {
                    int j;
                    Object[] result;
                    MatrixTD matrix = (MatrixTD)compContext.readInput(inputName);
                    if (matrix.getRowDimension() > 1) {
                        result = new Object[matrix.getRowDimension()][matrix.getColumnDimension()];
                        int i = 0;
                        while (i < result.length) {
                            j = 0;
                            while (j < ((Object)result[0]).length) {
                                result[i][j] = ScriptDataTypeHelper.getObjectOfEntryForPythonOrJython((TypedDatum)matrix.getFloatTDOfElement(i, j));
                                ++j;
                            }
                            ++i;
                        }
                        inputsToWrite.put(inputName, result);
                        break;
                    }
                    result = new Object[matrix.getColumnDimension()];
                    int j2 = 0;
                    while (j2 < matrix.getColumnDimension()) {
                        result[j2] = ScriptDataTypeHelper.getObjectOfEntryForPythonOrJython((TypedDatum)matrix.getFloatTDOfElement(0, j2));
                        ++j2;
                    }
                    inputsToWrite.put(inputName, result);
                    break;
                }
                case SmallTable: {
                    SmallTableTD table = (SmallTableTD)compContext.readInput(inputName);
                    if (table.getRowCount() > 1) {
                        Object[][] result = new Object[table.getRowCount()][table.getColumnCount()];
                        int i = 0;
                        while (i < table.getRowCount()) {
                            int j = 0;
                            while (j < table.getColumnCount()) {
                                result[i][j] = ScriptDataTypeHelper.getObjectOfEntryForPythonOrJython(table.getTypedDatumOfCell(i, j));
                                ++j;
                            }
                            ++i;
                        }
                        inputsToWrite.put(inputName, result);
                        break;
                    }
                    Object[] result = new Object[table.getColumnCount()];
                    int j = 0;
                    while (j < table.getColumnCount()) {
                        result[j] = ScriptDataTypeHelper.getObjectOfEntryForPythonOrJython(table.getTypedDatumOfCell(0, j));
                        ++j;
                    }
                    inputsToWrite.put(inputName, result);
                    break;
                }
                default: {
                    inputsToWrite.put(inputName, "None");
                }
            }
        }
        return inputsToWrite;
    }

    private void readOutputFromPython() throws ScriptException {
        try {
            if (new File(String.valueOf(this.tempDir.getAbsolutePath()) + File.separator + "pythonOutput.rced").exists()) {
                this.output = (Map)this.mapper.readValue(new File(String.valueOf(this.tempDir.getAbsolutePath()) + File.separator + "pythonOutput.rced"), this.output.getClass());
            }
            if (new File(String.valueOf(this.tempDir.getAbsolutePath()) + File.separator + "pythonCloseOutputChannelsList.rced").exists()) {
                this.closeOutputChannelsList = (List)this.mapper.readValue(new File(String.valueOf(this.tempDir.getAbsolutePath()) + File.separator + "pythonCloseOutputChannelsList.rced"), this.closeOutputChannelsList.getClass());
            }
            this.stateOutput = new HashMap<String, Object>();
            if (new File(String.valueOf(this.tempDir.getAbsolutePath()) + File.separator + "pythonStateOutput.rces").exists()) {
                this.stateOutput = (Map)this.mapper.readValue(new File(String.valueOf(this.tempDir.getAbsolutePath()) + File.separator + "pythonStateOutput.rces"), this.stateOutput.getClass());
            }
            this.writtenFileOutput = new LinkedList<String>();
            if (new File(String.valueOf(this.tempDir.getAbsolutePath()) + File.separator + "pythonInputFileFactoryOutput.rced").exists()) {
                this.writtenFileOutput = (List)this.mapper.readValue(new File(String.valueOf(this.tempDir.getAbsolutePath()) + File.separator + "pythonInputFileFactoryOutput.rced"), this.writtenFileOutput.getClass());
            }
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    public Map<String, Object> getStateOutput() {
        return this.stateOutput;
    }

    private void createTemporaryPythonScript(String script) throws IOException {
        File temp = new File(this.tempDir, "userscript.py");
        FileWriter writer = new FileWriter(temp);
        script = StringUtils.replace((String)script, (String)"\r\n", (String)"\n");
        writer.write(script);
        writer.close();
        File wrapperMain = new File(this.tempDir, RUN_SCRIPT);
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream wrapperScriptInputMain = PythonScriptEngine.class.getResourceAsStream("/resources/Run_python_script_in_rce.py");){
            FileUtils.copyInputStreamToFile((InputStream)wrapperScriptInputMain, (File)wrapperMain);
            File wrapperBridge = new File(this.tempDir, PYTHON_BRIDGE);
            File inputFileFactory = new File(this.tempDir, INPUT_FILE_FACTORY_PY);
            Throwable throwable2 = null;
            Object var11_15 = null;
            try (InputStream wrapperScriptInputBridge = PythonScriptEngine.class.getResourceAsStream("/resources/RCE_Channel.py");){
                FileUtils.copyInputStreamToFile((InputStream)wrapperScriptInputBridge, (File)wrapperBridge);
                Throwable throwable3 = null;
                Object var14_21 = null;
                try (InputStream simpleJsonFiles = PythonScriptEngine.class.getResourceAsStream("/resources/simplejson.zip");){
                    FileSupport.unzip((InputStream)simpleJsonFiles, (File)this.tempDir);
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
            throwable2 = null;
            var11_15 = null;
            try (InputStream wrapperScriptInputFactory = PythonScriptEngine.class.getResourceAsStream("/resources/input_file_factory.py");){
                FileUtils.copyInputStreamToFile((InputStream)wrapperScriptInputFactory, (File)inputFileFactory);
                String path = "\nInputFileFactory.p = '" + this.tempDir.getPath().replaceAll(ESCAPESLASH, SLASH) + "/'";
                FileUtils.writeStringToFile((File)inputFileFactory, (String)path, (boolean)true);
            }
            catch (Throwable throwable6) {
                if (throwable2 == null) {
                    throwable2 = throwable6;
                } else if (throwable2 != throwable6) {
                    throwable2.addSuppressed(throwable6);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable7) {
            if (throwable == null) {
                throwable = throwable7;
            } else if (throwable != throwable7) {
                throwable.addSuppressed(throwable7);
            }
            throw throwable;
        }
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        String script = "";
        BufferedReader br = new BufferedReader(reader);
        try {
            String line = br.readLine();
            while (line != null) {
                script = String.valueOf(script) + line;
            }
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"Could not read script");
        }
        return this.eval(script);
    }

    @Override
    public Object eval(String script, ScriptContext contextIn) throws ScriptException {
        this.context = contextIn;
        return this.eval(script);
    }

    @Override
    public Object eval(Reader reader, ScriptContext contextIn) throws ScriptException {
        this.context = contextIn;
        return this.eval(reader);
    }

    @Override
    public Object eval(String script, Bindings n) throws ScriptException {
        return this.eval(script);
    }

    @Override
    public Object eval(Reader reader, Bindings n) throws ScriptException {
        return this.eval(reader);
    }

    @Override
    public Object get(String key) {
        return this.output.get(key);
    }

    public List<String> getCloseOutputChannelsList() {
        return this.closeOutputChannelsList;
    }

    @Override
    public Bindings getBindings(int scope) {
        return null;
    }

    @Override
    public ScriptContext getContext() {
        return this.context;
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return null;
    }

    @Override
    public void put(String key, Object value) {
        this.context.setAttribute(key, value, 0);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
    }

    @Override
    public void setContext(ScriptContext context) {
        this.context = context;
    }

    public LocalApacheCommandLineExecutor getExecutor() {
        return this.executor;
    }

    public void dispose() {
        try {
            if (this.tempDir != null) {
                TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(this.tempDir);
            }
            if (this.tempFiles != null) {
                for (File f : this.tempFiles) {
                    if (!f.exists()) continue;
                    FileUtils.forceDelete((File)f);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void bindComponentDataManagementService(ComponentDataManagementService compDataManagementService) {
        componentDatamanagementService = compDataManagementService;
    }

    public synchronized void cancel() {
        if (this.initializationSignal == null) {
            this.canceledBeforeInitialization = true;
            return;
        }
        try {
            this.initializationSignal.await();
        }
        catch (InterruptedException e) {
            LOGGER.debug((Object)"Interrupted while waiting for the initialization to finish.", (Throwable)e);
            LOGGER.debug((Object)"Cancelling the cancellation.");
            return;
        }
        this.stdoutWatcher.cancel();
        this.stderrWatcher.cancel();
        this.executor.cancel();
    }

    public synchronized void agentPrepareScriptExecution(String script, File directory) throws IOException {
        this.tempDir = directory;
        this.writeInputForPython();
    }

    public void agentReadOutputFromPython(File directory) throws ScriptException {
        this.tempDir = directory;
        this.readOutputFromPython();
    }
}

