/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.instancemanagement.internal;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class InstanceOperationsUtils {
    public static final String TIMEOUT_REACHED_MESSAGE = "Timeout reached while trying to acquire the lock, aborting startup of instance with id: %s.";
    public static final String UNEXPECTED_ERROR_WHEN_TRYING_TO_ACQUIRE_A_FILE_LOCK_ON = "Unexpected error when trying to acquire a file lock on ";
    public static final String IM_LOCK_FILE_ACCESS_PERMISSIONS = "rw";
    public static final String INSTALLATION_ID_FILE_NAME = "installation";
    private static final String IM_LOCK_FILE_NAME = "instancemanagement.lock";
    private static final String SHUTDOWN_FILE_NAME = "shutdown.dat";
    private static final String SLASH = "/";

    private InstanceOperationsUtils() {
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean lockIMLockFile(File profile, long timeout) throws IOException {
        lockfile = new File(String.valueOf(profile.getAbsolutePath()) + "/" + "instancemanagement.lock");
        lockfile.createNewFile();
        lock = null;
        if (!lockfile.isFile()) {
            throw new IOException("Lockfile isn't available.");
        }
        try {
            var5_4 = null;
            var6_6 = null;
            try {
                randomAccessFile = new RandomAccessFile(lockfile, "rw");
                try {
                    block13: {
                        lock = randomAccessFile.getChannel().tryLock();
                        if (lock != null) break block13;
                        timestamp = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
                        ** GOTO lbl32
                    }
                    return true;
                }
                catch (Throwable var5_5) {
                    throw var5_5;
                }
                finally {
                    if (randomAccessFile == null) return true;
                    randomAccessFile.close();
                }
            }
            catch (Throwable var6_7) {
                if (var5_4 == null) {
                    var5_4 = var6_7;
                    throw var5_4;
                }
                if (var5_4 == var6_7) throw var5_4;
                var5_4.addSuppressed(var6_7);
                throw var5_4;
lbl32:
                // 1 sources

                if (true) ** GOTO lbl39
            }
        }
        catch (InterruptedException v0) {
            throw new IOException("Unexpected error when trying to acquire a file lock on ");
        }
        do {
            if ((lock = randomAccessFile.getChannel().tryLock()) != null) {
                return true;
            }
            Thread.sleep(20L);
lbl39:
            // 2 sources

        } while (timestamp - TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) < -timeout);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isProfileLocked(File profileDir) throws IOException {
        if (!profileDir.isDirectory()) {
            throw new IOException("Profile directory " + profileDir.getAbsolutePath() + " can not be created or is not a directory");
        }
        File lockfile = new File(profileDir, "instance.lock");
        FileLock lock = null;
        if (!lockfile.isFile()) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(lockfile, IM_LOCK_FILE_ACCESS_PERMISSIONS);){
                lock = randomAccessFile.getChannel().tryLock();
                if (lock != null) {
                    lock.release();
                    return false;
                }
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IOException(UNEXPECTED_ERROR_WHEN_TRYING_TO_ACQUIRE_A_FILE_LOCK_ON + lockfile, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean detectShutdownFile(String path) throws IOException {
        WatchService watcher = FileSystems.getDefault().newWatchService();
        Path shutdownFile = Paths.get(String.valueOf(path) + SLASH + "internal" + SLASH + SHUTDOWN_FILE_NAME, new String[0]);
        Path shutdownFileDir = shutdownFile.getParent();
        File file = new File(shutdownFileDir.toString());
        shutdownFileDir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        while (!Thread.currentThread().isInterrupted()) {
            WatchKey watchKey;
            try {
                if (file.isDirectory()) {
                    File[] fileArray = file.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        if (f.getName().equals(SHUTDOWN_FILE_NAME)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                if (!(watchKey = watcher.take()).isValid()) {
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("Shutdown watcher task was interrupted.");
            }
            List<WatchEvent<?>> watchEvents = watchKey.pollEvents();
            for (WatchEvent<?> event : watchEvents) {
                Path createdFileRelativePath;
                Path createdFileAbsolutePath;
                if (!event.kind().equals(StandardWatchEventKinds.ENTRY_CREATE) || !(createdFileAbsolutePath = shutdownFileDir.resolve(createdFileRelativePath = (Path)event.context())).equals(shutdownFile)) continue;
                int i = 0;
                while (i < 2) {
                    if (Files.size(Paths.get(createdFileAbsolutePath.toUri())) != 0L) {
                        return true;
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException("Interrupted while waiting for shutdown file to appear");
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public static void deleteInstanceLockFromProfileFolder(File profileDir) {
        File[] fileArray = profileDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File fileInProfileDir = fileArray[n2];
            if (fileInProfileDir.isFile() && "instance.lock".equals(fileInProfileDir.getName())) {
                fileInProfileDir.delete();
                break;
            }
            ++n2;
        }
    }
}

