/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.communication.views.contributors;

import de.rcenvironment.core.communication.connection.api.ConnectionSetup;
import de.rcenvironment.core.communication.connection.api.ConnectionSetupService;
import de.rcenvironment.core.communication.connection.api.ConnectionSetupState;
import de.rcenvironment.core.communication.connection.api.DisconnectReason;
import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.gui.communication.views.contributors.AddNetworkConnectionDialog;
import de.rcenvironment.core.gui.communication.views.contributors.EditNetworkConnectionDialog;
import de.rcenvironment.core.gui.communication.views.contributors.NetworkViewContributorBase;
import de.rcenvironment.core.gui.communication.views.contributors.ShowConfigurationSnippetDialog;
import de.rcenvironment.core.gui.communication.views.internal.AnchorPoints;
import de.rcenvironment.core.gui.communication.views.model.NetworkGraphNodeWithContext;
import de.rcenvironment.core.gui.communication.views.model.SimpleNetworkViewNode;
import de.rcenvironment.core.gui.communication.views.spi.NetworkViewContributor;
import de.rcenvironment.core.gui.communication.views.spi.SelfRenderingNetworkViewNode;
import de.rcenvironment.core.gui.communication.views.spi.StandardUserNodeActionNode;
import de.rcenvironment.core.gui.communication.views.spi.StandardUserNodeActionType;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import java.net.URL;
import java.util.Arrays;
import java.util.WeakHashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.MessageBox;

public class ConnectionSetupsListContributor
extends NetworkViewContributorBase {
    private static final AnchorPoints PARENT_ANCHOR = AnchorPoints.MAIN_NETWORK_SECTION_PARENT_NODE;
    private static final int ROOT_PRIORITY = 20;
    private final Image connectedImage;
    private final Image disconnectedImage;
    private SelfRenderingNetworkViewNode rootNode;
    private final WeakHashMap<ConnectionSetup, ConnectionSetupNode> wrapperMap = new WeakHashMap();
    private ConnectionSetupService connectionSetupService;

    public ConnectionSetupsListContributor() {
        this.connectedImage = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/connect.png")).createImage();
        this.disconnectedImage = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/disconnect.png")).createImage();
        this.connectionSetupService = (ConnectionSetupService)ServiceRegistry.createAccessFor((Object)this).getService(ConnectionSetupService.class);
    }

    @Override
    public int getRootElementsPriority() {
        return 20;
    }

    @Override
    public Object[] getTopLevelElements(Object parentNode) {
        if (parentNode != PARENT_ANCHOR) {
            return null;
        }
        boolean hasConnections = this.currentModel.connectionSetups != null && !this.currentModel.connectionSetups.isEmpty();
        this.rootNode = new SimpleNetworkViewNode("Connections", this.disconnectedImage, this, hasConnections);
        return new Object[]{this.rootNode};
    }

    @Override
    public int getInstanceDataElementsPriority() {
        return 0;
    }

    @Override
    public Object[] getChildrenForNetworkInstanceNode(NetworkGraphNodeWithContext parentNode) {
        return EMPTY_ARRAY;
    }

    @Override
    public boolean hasChildren(Object parentNode) {
        throw this.newUnexpectedCallException();
    }

    @Override
    public Object[] getChildren(Object node) {
        if (node != this.rootNode) {
            throw this.newUnexpectedCallException();
        }
        if (this.currentModel.connectionSetups == null) {
            return EMPTY_ARRAY;
        }
        ConnectionSetup[] setups = this.currentModel.connectionSetups.toArray(new ConnectionSetup[this.currentModel.connectionSetups.size()]);
        Arrays.sort(setups, (o1, o2) -> o1.getDisplayName().compareTo(o2.getDisplayName()));
        Object[] nodes = new ConnectionSetupNode[setups.length];
        int pos = 0;
        ConnectionSetup[] connectionSetupArray = setups;
        int n = setups.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectionSetup setup = connectionSetupArray[n2];
            ConnectionSetupNode wrapper = new ConnectionSetupNode(setup);
            this.wrapperMap.put(setup, wrapper);
            nodes[pos++] = wrapper;
            ++n2;
        }
        return nodes;
    }

    @Override
    public Object getParent(Object node) {
        if (node == this.rootNode) {
            return PARENT_ANCHOR;
        }
        return this.rootNode;
    }

    @Override
    public String getText(Object node) {
        throw this.newUnexpectedCallException();
    }

    @Override
    public Image getImage(Object node) {
        throw this.newUnexpectedCallException();
    }

    @Override
    public void dispose() {
        this.connectedImage.dispose();
        this.disconnectedImage.dispose();
    }

    public void showAddConnectionDialog() {
        AddNetworkConnectionDialog dialog = new AddNetworkConnectionDialog(this.treeViewer.getTree().getShell());
        if (dialog.open() == 0) {
            String connectionName = dialog.getConnectionName();
            boolean connectImmediately = dialog.getConnectImmediately();
            NetworkContactPoint ncp = dialog.getParsedNetworkContactPoint();
            if (this.connectionSetupService.connectionAlreadyExists(ncp)) {
                this.display.asyncExec(() -> {
                    MessageBox errorDialog = new MessageBox(this.treeViewer.getTree().getShell(), 33);
                    errorDialog.setMessage(StringUtils.format((String)"Connection with host %s and port %d already exists.", (Object[])new Object[]{ncp.getHost(), ncp.getPort()}));
                    errorDialog.open();
                });
                return;
            }
            if (ncp != null) {
                if (connectionName.isEmpty()) {
                    connectionName = String.valueOf(ncp.getHost()) + ":" + ncp.getPort();
                }
                ConnectionSetup cs = this.connectionSetupService.createConnectionSetup(ncp, connectionName, true);
                if (connectImmediately) {
                    cs.signalStartIntent();
                }
            }
        }
    }

    public Object getTreeNodeForSetup(ConnectionSetup setup) {
        return this.wrapperMap.get(setup);
    }

    public Object getFullRefreshRootElement() {
        return PARENT_ANCHOR;
    }

    public Object getRootElementToExpand() {
        return this.rootNode;
    }

    private final class ConnectionSetupNode
    implements SelfRenderingNetworkViewNode,
    StandardUserNodeActionNode {
        private final ConnectionSetup connectionSetup;

        ConnectionSetupNode(ConnectionSetup connectionSetup) {
            if (connectionSetup == null) {
                throw new NullPointerException();
            }
            this.connectionSetup = connectionSetup;
        }

        @Override
        public NetworkViewContributor getContributor() {
            return ConnectionSetupsListContributor.this;
        }

        @Override
        public String getText() {
            String subState = "";
            ConnectionSetupState connectionState = this.connectionSetup.getState();
            DisconnectReason disconnectReason = this.connectionSetup.getDisconnectReason();
            if ((connectionState == ConnectionSetupState.DISCONNECTED || connectionState == ConnectionSetupState.DISCONNECTING) && disconnectReason != null) {
                subState = ": " + disconnectReason.getDisplayText();
            }
            return StringUtils.format((String)"%s (%s%s)", (Object[])new Object[]{this.connectionSetup.getDisplayName(), connectionState.getDisplayText(), subState});
        }

        @Override
        public Image getImage() {
            if (this.connectionSetup.getState() == ConnectionSetupState.CONNECTED) {
                return ConnectionSetupsListContributor.this.connectedImage;
            }
            return ConnectionSetupsListContributor.this.disconnectedImage;
        }

        @Override
        public boolean getHasChildren() {
            return false;
        }

        @Override
        public boolean isActionApplicable(StandardUserNodeActionType actionType) {
            ConnectionSetupState state = this.connectionSetup.getState();
            switch (actionType) {
                case START: {
                    return state.isReasonableToAllowStart();
                }
                case STOP: {
                    return state.isReasonableToAllowStop();
                }
                case EDIT: 
                case DELETE: {
                    return state == ConnectionSetupState.DISCONNECTED;
                }
                case SHOW_CONFIGURATION_SNIPPET: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void performAction(StandardUserNodeActionType actionType) {
            switch (actionType) {
                case START: {
                    this.connectionSetup.signalStartIntent();
                    break;
                }
                case STOP: {
                    this.connectionSetup.signalStopIntent();
                    break;
                }
                case EDIT: {
                    this.performEdit();
                    break;
                }
                case DELETE: {
                    this.performDelete();
                    break;
                }
                case SHOW_CONFIGURATION_SNIPPET: {
                    this.performShowConfigurationSnippet();
                    break;
                }
            }
        }

        private void performEdit() {
            String connectionName = this.connectionSetup.getDisplayName();
            String networkContactString = this.connectionSetup.getNetworkContactPointString();
            EditNetworkConnectionDialog dialog = new EditNetworkConnectionDialog(ConnectionSetupsListContributor.this.treeViewer.getTree().getShell(), connectionName, networkContactString);
            if (dialog.open() == 0) {
                String newConnectionName = dialog.getConnectionName();
                boolean newConnectImmediately = dialog.getConnectImmediately();
                NetworkContactPoint ncp = dialog.getParsedNetworkContactPoint();
                ConnectionSetupsListContributor.this.connectionSetupService.disposeConnectionSetup(this.connectionSetup);
                if (ncp != null) {
                    ConnectionSetup newNetworkConnection = ConnectionSetupsListContributor.this.connectionSetupService.createConnectionSetup(ncp, newConnectionName, true);
                    if (newNetworkConnection != null) {
                        if (newConnectImmediately) {
                            newNetworkConnection.signalStartIntent();
                        }
                    } else {
                        ConnectionSetupsListContributor.this.display.asyncExec(() -> {
                            MessageBox errorDialog = new MessageBox(ConnectionSetupsListContributor.this.treeViewer.getTree().getShell(), 33);
                            errorDialog.setMessage(StringUtils.format((String)"SSH connection with host '%s' and port '%d' already exists.", (Object[])new Object[]{ncp.getHost(), ncp.getPort()}));
                            errorDialog.open();
                        });
                    }
                }
            }
        }

        private void performDelete() {
            String connectionName = this.connectionSetup.getDisplayName();
            String networkContactString = this.connectionSetup.getNetworkContactPointString();
            MessageBox dialog = new MessageBox(ConnectionSetupsListContributor.this.treeViewer.getTree().getShell(), 292);
            dialog.setText("Delete Connection");
            dialog.setMessage("Do you really want to delete connection \"" + connectionName + "\" to contact point \"" + networkContactString + "\" ?");
            if (dialog.open() == 32) {
                ConnectionSetupsListContributor.this.connectionSetupService.disposeConnectionSetup(this.connectionSetup);
            }
        }

        private void performShowConfigurationSnippet() {
            ConnectionSetupsListContributor.this.display.asyncExec(() -> {
                String message = this.createConnectionSetupMessage();
                ShowConfigurationSnippetDialog showConfigurationSnippetDialog = new ShowConfigurationSnippetDialog(ConnectionSetupsListContributor.this.treeViewer.getTree().getShell(), message);
                showConfigurationSnippetDialog.open();
            });
        }

        private String createConnectionSetupMessage() {
            String connectionName = this.connectionSetup.getDisplayName();
            String host = this.connectionSetup.getContactPointHost();
            int port = this.connectionSetup.getContactPointPort();
            boolean connectOnStartup = this.connectionSetup.getConnectOnStartup();
            int initialDelay = this.connectionSetup.getAutoRetryInitialDelayMsec() / 1000;
            int maximumDelay = this.connectionSetup.getAutoRetryMaximumDelayMsec() / 1000;
            float delayMultiplier = this.connectionSetup.getAutoRetryDelayMultiplier();
            return StringUtils.format((String)"            \"%s\" : {\r\n                \"host\" : %s,\r\n                \"port\" : %s,\r\n                \"connectOnStartup\" : %s,\r\n                \"autoRetryInitialDelay\" : %s,\r\n                \"autoRetryMaximumDelay\" : %s,\r\n                \"autoRetryDelayMultiplier\" : %s\r\n            }", (Object[])new Object[]{connectionName, host, port, connectOnStartup, initialDelay, maximumDelay, Float.valueOf(delayMultiplier)});
        }
    }
}

