/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.communication.views.contributors;

import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.communication.utils.NetworkContactPointUtils;
import de.rcenvironment.core.gui.communication.views.contributors.ConnectionSettings;
import de.rcenvironment.core.gui.communication.views.contributors.CustomPasteHandler;
import de.rcenvironment.core.gui.utils.incubator.PasteListeningText;
import de.rcenvironment.core.utils.common.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractNetworkConnectionDialog
extends Dialog
implements ModifyListener,
VerifyListener,
PasteListeningText.PasteListener {
    protected static final String ACTIVEMQ_PREFIX = "activemq-tcp:";
    protected static final String COM = ",";
    protected static final String DECIMAL = "[^0-9]";
    private static final String INVALID_IP = "0.0.0.0";
    private static final int DIALOG_WINDOW_OFFSET_Y = 100;
    private static final int DIALOG_WINDOW_OFFSET_X = 150;
    private static final String COLON = ":";
    private static final String NAME_LABEL = "Name:";
    private static final String HOST_LABEL = "Host:";
    private static final String PORT_LABEL = "Port:";
    private static final String AUTO_RETRY_INITIAL_DELAY_STR = "autoRetryInitialDelay";
    private static final String AUTO_RETRY_MAXI_DELAY_STR = "autoRetryMaximumDelay";
    private static final String AUTO_RETRY_DELAY_MULTIPL = "autoRetryDelayMultiplier";
    private static final String SETTINGS = "Settings:";
    private static final int CHECKBOX_LABEL_WIDTH = 300;
    private static Text portTextField;
    private static PasteListeningText hostTextField;
    protected String connectionName = "";
    protected String networkContactPointID = "";
    protected String hint = "";
    protected String host = "";
    protected String port = "";
    protected String settingsText = "";
    private boolean connectImmediately = true;
    private NetworkContactPoint parsedNetworkContactPoint;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Button useDefaultNameButton;
    private Button useDefaultSettings;
    private Text nameText;
    private Text settingsTextField;
    private Label nameLabel;
    private boolean isDefaultName = true;
    private Composite container;
    private ConnectionSettings settings;

    protected AbstractNetworkConnectionDialog(Shell parentShell) {
        super(parentShell);
    }

    public AbstractNetworkConnectionDialog(Shell parentShell, String connectionName, String connectionString) {
        super(parentShell);
        this.connectionName = connectionName;
        this.networkContactPointID = connectionString;
        this.host = this.networkContactPointID.substring(0, this.networkContactPointID.indexOf(COLON));
        this.port = this.networkContactPointID.substring(this.networkContactPointID.indexOf(COLON) + 1);
        this.settings = new ConnectionSettings();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (shell.getHorizontalBar() != null) {
            shell.getHorizontalBar().dispose();
        }
        shell.setLocation(shell.getParent().getLocation().x + shell.getParent().getSize().x / 2 - 150, shell.getParent().getLocation().y + shell.getParent().getSize().y / 2 - 100);
        shell.setText("Connection");
    }

    protected Control createDialogArea(Composite parent) {
        this.settings = new ConnectionSettings();
        this.container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        GridData containerGridData = new GridData(4, 4, false, false);
        this.container.setLayoutData((Object)containerGridData);
        this.container.setLayout((Layout)layout);
        GridData useDefaultCheckboxGridData = new GridData();
        useDefaultCheckboxGridData.widthHint = 300;
        useDefaultCheckboxGridData.horizontalSpan = 1;
        GridData connectImmediateCheckboxGridData = new GridData();
        connectImmediateCheckboxGridData.widthHint = 300;
        connectImmediateCheckboxGridData.horizontalSpan = 2;
        Label cpLabel = new Label(this.container, 0);
        cpLabel.setText(HOST_LABEL);
        hostTextField = new PasteListeningText(this.container, 2052);
        hostTextField.setLayoutData((Object)new GridData(256));
        if (!this.host.isEmpty()) {
            hostTextField.setText(this.host);
        }
        hostTextField.addPasteListener((PasteListeningText.PasteListener)this);
        hostTextField.addModifyListener((ModifyListener)this);
        Label cpLabelPort = new Label(this.container, 0);
        cpLabelPort.setText(PORT_LABEL);
        portTextField = new Text(this.container, 2052);
        portTextField.setLayoutData((Object)new GridData(256));
        if (!this.port.isEmpty()) {
            portTextField.setText(this.port);
        }
        portTextField.addVerifyListener((VerifyListener)this);
        portTextField.addModifyListener((ModifyListener)this);
        GridData separatorGridData = new GridData();
        separatorGridData.horizontalAlignment = 4;
        separatorGridData.grabExcessHorizontalSpace = true;
        separatorGridData.horizontalSpan = 2;
        this.nameLabel = new Label(this.container, 0);
        this.nameLabel.setText(NAME_LABEL);
        this.nameText = new Text(this.container, 2052);
        this.nameText.setLayoutData((Object)new GridData(256));
        this.nameText.setText(this.connectionName);
        this.nameText.setEnabled(!this.isDefaultName);
        Label placeholderLabel = new Label(this.container, 0);
        placeholderLabel.setText("");
        this.useDefaultNameButton = new Button(this.container, 32);
        this.useDefaultNameButton.setText("Use default name (host:port)");
        this.useDefaultNameButton.setLayoutData((Object)useDefaultCheckboxGridData);
        this.useDefaultNameButton.setSelection(this.isDefaultName);
        this.useDefaultNameButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractNetworkConnectionDialog.this.nameText.setEnabled(!AbstractNetworkConnectionDialog.this.useDefaultNameButton.getSelection());
                AbstractNetworkConnectionDialog.this.nameText.setText("");
                if (AbstractNetworkConnectionDialog.this.useDefaultNameButton.getSelection() && !hostTextField.getText().isEmpty() && !portTextField.getText().isEmpty()) {
                    AbstractNetworkConnectionDialog.this.nameText.setText(String.valueOf(hostTextField.getText()) + AbstractNetworkConnectionDialog.COLON + portTextField.getText());
                }
                AbstractNetworkConnectionDialog.this.updateOkButtonActivation();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        this.buildSettingsField();
        Label separator = new Label(this.container, 258);
        separator.setLayoutData((Object)separatorGridData);
        final Button immediateConnectButton = new Button(this.container, 32);
        immediateConnectButton.setSelection(true);
        immediateConnectButton.setText("Connect immediately");
        immediateConnectButton.setLayoutData((Object)connectImmediateCheckboxGridData);
        Label persistHint = new Label(this.container, 0);
        GridData hintGridData = new GridData();
        hintGridData.horizontalSpan = 2;
        persistHint.setText(this.hint);
        persistHint.setLayoutData((Object)hintGridData);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractNetworkConnectionDialog.this.connectionName = AbstractNetworkConnectionDialog.this.nameText.getText();
            }
        });
        this.connectImmediately = immediateConnectButton.getSelection();
        immediateConnectButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AbstractNetworkConnectionDialog.this.connectImmediately = immediateConnectButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        return this.container;
    }

    public void modifyText(ModifyEvent e) {
        this.host = hostTextField.getText();
        this.port = portTextField.getText();
        if (this.useDefaultNameButton.getSelection()) {
            if (!hostTextField.getText().isEmpty() && !portTextField.getText().isEmpty()) {
                this.nameText.setText(String.valueOf(hostTextField.getText()) + COLON + portTextField.getText());
            } else {
                this.nameText.setText("");
            }
        }
        this.updateOkButtonActivation();
    }

    public void paste(String text) {
        CustomPasteHandler.paste(text, (Text)hostTextField, portTextField);
    }

    public void verifyText(VerifyEvent e) {
        String currentText = ((Text)e.widget).getText();
        String portID = String.valueOf(currentText.substring(0, e.start)) + e.text + currentText.substring(e.end);
        e.doit = CustomPasteHandler.isValidPort(portID);
    }

    private void buildSettingsField() {
        Label cpSettingsLbl = new Label(this.container, 0);
        cpSettingsLbl.setText(SETTINGS);
        this.settingsTextField = new Text(this.container, 2052);
        this.settingsTextField.setLayoutData((Object)new GridData(256));
        this.settingsTextField.setEnabled(!this.settingsText.isEmpty());
        this.settingsTextField.setText(this.settingsText);
        if (this.settingsText.isEmpty()) {
            this.settingsTextField.setText(this.settings.createStringForsettings(5, 300, 1.5));
        }
        Label placeholderLabel = new Label(this.container, 0);
        placeholderLabel.setText("");
        GridData useDefaultData = new GridData();
        useDefaultData.horizontalSpan = 1;
        useDefaultData.grabExcessHorizontalSpace = false;
        this.useDefaultSettings = new Button(this.container, 32);
        this.useDefaultSettings.setSelection(this.settingsText.isEmpty());
        this.useDefaultSettings.setText("Use default settings");
        this.useDefaultSettings.setLayoutData((Object)useDefaultData);
        this.useDefaultSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private ConnectionSettings settings = new ConnectionSettings();

            public void widgetSelected(SelectionEvent e) {
                AbstractNetworkConnectionDialog.this.settingsTextField.setEnabled(!AbstractNetworkConnectionDialog.this.useDefaultSettings.getSelection());
                if (AbstractNetworkConnectionDialog.this.useDefaultSettings.getSelection()) {
                    AbstractNetworkConnectionDialog.this.settingsTextField.setText(this.settings.createStringForsettings(5, 300, 1.5));
                }
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(!this.networkContactPointID.isEmpty());
    }

    protected void okPressed() {
        boolean canParse = true;
        if (this.getNetworkContactPointID().contains(INVALID_IP)) {
            MessageDialog.openError((Shell)this.getParentShell(), (String)"Invalid host address", (String)"The IP address 0.0.0.0 configured for the network connection is invalid. For a local connection please use 127.0.0.1 or 'localhost' instead.");
            return;
        }
        try {
            this.catchSettingsFields();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String errorMessage = StringUtils.format((String)"The settings are not in a valid format.", (Object[])new Object[0]);
            this.log.debug((Object)errorMessage);
            MessageDialog.openError((Shell)this.getParentShell(), (String)"Invalid format", (String)errorMessage);
            return;
        }
        try {
            this.settings.setConnectOnStartup(this.connectImmediately);
            String hostAndPortString = StringUtils.format((String)"%s:%s", (Object[])new Object[]{this.host, this.port});
            String temp = String.valueOf(hostAndPortString) + "(" + this.settings.getSettingsString() + COM + "connectOnStartup=" + this.settings.isConnectOnStartup() + ")";
            String contactPoint = this.removeEmptySpaces(temp);
            if (!contactPoint.startsWith(ACTIVEMQ_PREFIX)) {
                contactPoint = ACTIVEMQ_PREFIX + contactPoint;
            }
            this.parsedNetworkContactPoint = NetworkContactPointUtils.parseStringRepresentation((String)contactPoint);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            canParse = false;
        }
        if (canParse) {
            super.okPressed();
        } else {
            String errorMessage = StringUtils.format((String)"'%s' is invalid for the host. It must be of format e.g. 192.168.0.15", (Object[])new Object[]{this.host});
            this.log.debug((Object)errorMessage);
            MessageDialog.openError((Shell)this.getParentShell(), (String)"Invalid format", (String)errorMessage);
        }
    }

    private void catchSettingsFields() {
        String temp;
        String text = this.settingsTextField.getText();
        if (text.isEmpty()) {
            return;
        }
        if (!(text.contains(AUTO_RETRY_INITIAL_DELAY_STR) && text.contains(AUTO_RETRY_MAXI_DELAY_STR) && text.contains(AUTO_RETRY_DELAY_MULTIPL))) {
            throw new IllegalArgumentException();
        }
        int indexFirstCom = 0;
        int indexSecondCom = 0;
        String numberOnly = this.settingsTextField.getText().replaceAll("[^0-9=,.]", "");
        if (this.settingsTextField.getText().contains(AUTO_RETRY_INITIAL_DELAY_STR) && !numberOnly.isEmpty() && numberOnly.contains(COM)) {
            indexFirstCom = numberOnly.indexOf(COM);
            temp = numberOnly.substring(0, indexFirstCom);
            String initDelay = temp.replaceAll(DECIMAL, "");
            this.settings.setAutoRetryInitialDelay(Integer.parseInt(initDelay));
        }
        if (this.settingsTextField.getText().contains(AUTO_RETRY_MAXI_DELAY_STR)) {
            indexSecondCom = numberOnly.indexOf(COM, numberOnly.indexOf(COM) + 1);
            temp = numberOnly.substring(indexFirstCom, indexSecondCom);
            String maxiDelay = temp.replaceAll(DECIMAL, "");
            this.settings.setAutoRetryMaximumDelay(Integer.parseInt(maxiDelay));
        }
        if (this.settingsTextField.getText().contains(AUTO_RETRY_DELAY_MULTIPL)) {
            temp = numberOnly.substring(indexSecondCom);
            String multiplier = temp.replaceAll("[^0-9.]", "");
            this.settings.setAutoRetryDelayMultiplier(Double.parseDouble(multiplier));
        }
    }

    private String removeEmptySpaces(String string) {
        String temp = string.replaceAll("\\s", "");
        return temp;
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        parent.getShell().pack();
        return buttonBar;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(67936);
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public NetworkContactPoint getParsedNetworkContactPoint() {
        return this.parsedNetworkContactPoint;
    }

    public String getNetworkContactPointID() {
        return this.networkContactPointID;
    }

    public boolean getConnectImmediately() {
        return this.connectImmediately;
    }

    protected void activateDefaultName() {
        this.isDefaultName = true;
    }

    protected void deactivateDefaultName() {
        this.isDefaultName = false;
    }

    private void updateOkButtonActivation() {
        this.getButton(0).setEnabled(!this.host.isEmpty() && !this.port.isEmpty());
    }
}

