/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.embedded.ssh.api.SshAccountConfigurationService;
import de.rcenvironment.toolkit.utils.common.IdGenerator;
import de.rcenvironment.toolkit.utils.common.IdGeneratorType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class KeyToolCommandPlugin
implements CommandPlugin {
    private static final String SUBCMD_SSH_PW = "ssh-pw";
    private static final String SUBCMD_UPLINK_PW = "uplink-pw";
    private static final String MAIN_CMD = "keytool";
    private static final int GENERATED_PASSWORD_LENGTH = 14;
    @Reference
    private SshAccountConfigurationService sshAccountService;

    public void execute(CommandContext context) throws CommandException {
        context.consumeExpectedToken(MAIN_CMD);
        String subCmd = context.consumeNextToken();
        List parameters = context.consumeRemainingTokens();
        if (!SUBCMD_SSH_PW.equals(subCmd) && !SUBCMD_UPLINK_PW.equals(subCmd)) {
            throw CommandException.syntaxError((String)"Missing operation argument (e.g. \"keytool ssh-pw\")", (CommandContext)context);
        }
        this.performGenerateSshOrUplinkPw(context, parameters);
    }

    private void performGenerateSshOrUplinkPw(CommandContext context, List<String> parameters) {
        String password = IdGenerator.createRandomBase64UrlString((int)28, (IdGeneratorType)IdGeneratorType.SECURE);
        password = password.replaceAll("[-_]", "").substring(0, 14);
        context.println((Object)"The generated password (keep this confidential):");
        context.println((Object)password);
        context.println((Object)"The password hash (send this to the server's administrator):");
        context.println((Object)this.sshAccountService.generatePasswordHash(password));
    }

    public Collection<CommandDescription> getCommandDescriptions() {
        ArrayList<CommandDescription> contributions = new ArrayList<CommandDescription>();
        contributions.add(new CommandDescription(MAIN_CMD, SUBCMD_SSH_PW, false, "generates a password for an SSH connection, and the corresponding server entry", new String[0]));
        contributions.add(new CommandDescription("keytool uplink-pw", null, false, "generates a password for an Uplink connection, and the corresponding server entry", new String[0]));
        return contributions;
    }
}

