/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import de.rcenvironment.core.utils.common.AuditLog;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IncomingSessionTracker<T> {
    private final Map<T, SessionStateHolder> stateHoldersBySession = new HashMap<T, SessionStateHolder>();
    private final String connectionTypeLogId;
    private final Log log = LogFactory.getLog(this.getClass());

    public IncomingSessionTracker(String connectionTypeLogId) {
        this.connectionTypeLogId = connectionTypeLogId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionHandle registerSessionStart(T session) {
        SessionStateHolder stateHolder = new SessionStateHolder();
        stateHolder.setConnectionType(this.connectionTypeLogId);
        stateHolder.setInternalSessionId(this.renderInternalIdOfSession(session));
        Map<T, SessionStateHolder> map = this.stateHoldersBySession;
        synchronized (map) {
            SessionStateHolder existing = this.stateHoldersBySession.get(session);
            if (existing != null) {
                throw new IllegalStateException("Requested duplicate registration of session object " + this.renderLogDescriptorOfSession(session));
            }
            this.stateHoldersBySession.put(session, stateHolder);
            return stateHolder;
        }
    }

    public SessionHandle forSession(T session) throws OperationFailureException {
        return this.getStateHolder(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSessionClosed(T session, boolean ignoreDuplicateCalls) {
        SessionStateHolder stateHolder;
        Map<T, SessionStateHolder> map = this.stateHoldersBySession;
        synchronized (map) {
            stateHolder = this.stateHoldersBySession.remove(session);
            if (stateHolder == null) {
                if (ignoreDuplicateCalls) {
                    return;
                }
                throw new IllegalStateException("Requested to close unregistered or already closed session " + this.renderLogDescriptorOfSession(session));
            }
        }
        stateHolder.registerEndOfSession(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int logLeftoverSessions() {
        Map<T, SessionStateHolder> map = this.stateHoldersBySession;
        synchronized (map) {
            for (Map.Entry<T, SessionStateHolder> e : this.stateHoldersBySession.entrySet()) {
                T session = e.getKey();
                SessionStateHolder stateHolder = e.getValue();
                this.log.error((Object)("Unfinished session state after cleanup should have occurred; writing best-effort entry to event log. Session object: " + this.renderLogDescriptorOfSession(session)));
                stateHolder.registerEndOfSession(false);
            }
            int leftoverCount = this.stateHoldersBySession.size();
            this.stateHoldersBySession.clear();
            return leftoverCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionStateHolder getStateHolder(T session) throws OperationFailureException {
        Map<T, SessionStateHolder> map = this.stateHoldersBySession;
        synchronized (map) {
            SessionStateHolder stateHolder = this.stateHoldersBySession.get(session);
            if (stateHolder == null) {
                throw new OperationFailureException("Unregistered session or session already closed: " + this.renderLogDescriptorOfSession(session));
            }
            return stateHolder;
        }
    }

    private String renderLogDescriptorOfSession(T session) {
        return StringUtils.format((String)"%s [%s]", (Object[])new Object[]{session.toString(), this.renderInternalIdOfSession(session)});
    }

    private String renderInternalIdOfSession(T session) {
        return Integer.toString(System.identityHashCode(session));
    }

    public static interface SessionHandle {
        public SessionHandle addLogData(Map<String, String> var1);

        public SessionHandle addLogData(String var1, String var2);

        public SessionHandle addLogData(String var1, int var2);

        public SessionHandle registerAuthenticationSuccess(String var1, String var2);

        public SessionHandle registerAuthenticationFailure(String var1, String var2, String var3);

        public SessionHandle registerDataStreamEOF();

        public int modifyCustomCounter(int var1);

        public int getAuthenticationFailureCount();
    }

    private static class SessionStateHolder
    implements SessionHandle {
        private static final Log sharedLog = LogFactory.getLog(SessionStateHolder.class);
        private static final String EVENT_LOG_KEY_CONNECTION_TYPE = "type";
        private static final String EVENT_LOG_KEY_INTERNAL_ID = "connection_id";
        private static final String EVENT_LOG_KEY_LOGIN_NAME = "login_name";
        private static final String EVENT_LOG_KEY_CLOSE_REASON = "close_reason";
        private static final String EVENT_LOG_KEY_LAST_PREFIX = "last_";
        private static final String EVENT_LOG_KEY_AUTH_METHOD = "auth_method";
        private static final String EVENT_LOG_KEY_NUM_AUTH_FAILURES = "auth_failure_count";
        private static final String EVENT_LOG_KEY_AUTH_FAILURE_REASON = "auth_failure_reason";
        private static final String EVENT_LOG_KEY_SESSION_DURATION_MSEC = "duration_msec";
        private final Instant startTime = Instant.now();
        private final Map<String, String> logData = new HashMap<String, String>();
        private boolean hadIncomingEOF;
        private int authenticationFailureCount;
        private String lastAuthLoginName;
        private String lastAuthMethod;
        private String lastAuthFailureReason;
        private boolean hadAuthenticationSuccess;
        private boolean wasRegularlyClosed;
        private String internalSessionId;
        private int customCounter;

        private SessionStateHolder() {
        }

        public synchronized void setInternalSessionId(String id) {
            this.internalSessionId = id;
            this.storeLogDataKeyValuePair(EVENT_LOG_KEY_INTERNAL_ID, id);
        }

        public synchronized void setConnectionType(String connectionTypeLogId) {
            this.storeLogDataKeyValuePair(EVENT_LOG_KEY_CONNECTION_TYPE, connectionTypeLogId);
        }

        public synchronized void registerEndOfSession(boolean regularClose) {
            sharedLog.debug((Object)("Closing session " + this.internalSessionId));
            this.wasRegularlyClosed = regularClose;
            this.writeFinalLogEntry();
        }

        @Override
        public synchronized SessionHandle addLogData(Map<String, String> data) {
            for (Map.Entry<String, String> e : data.entrySet()) {
                String key = e.getKey();
                String value = e.getValue();
                this.storeLogDataKeyValuePair(key, value);
            }
            return this;
        }

        @Override
        public synchronized SessionHandle addLogData(String key, String value) {
            this.storeLogDataKeyValuePair(key, value);
            return this;
        }

        @Override
        public synchronized SessionHandle addLogData(String key, int value) {
            this.storeLogDataKeyValuePair(key, Integer.toString(value));
            return this;
        }

        @Override
        public synchronized SessionHandle registerAuthenticationSuccess(String loginName, String method) {
            if (this.hadAuthenticationSuccess) {
                if (this.lastAuthLoginName.equals(loginName) && this.lastAuthMethod.equals(method)) {
                    sharedLog.debug((Object)("Ignoring duplicate successful authentication event with same parameters: user '" + loginName + "', method '" + method + "'"));
                    return this;
                }
                sharedLog.warn((Object)("Received duplicate successful authentication event with different parameters: user '" + loginName + "', method " + method + "; writing second event log entry for visibility"));
            }
            this.hadAuthenticationSuccess = true;
            this.lastAuthLoginName = loginName;
            this.lastAuthMethod = method;
            this.writeAuthenticationSuccessLogEntry();
            return this;
        }

        @Override
        public synchronized SessionHandle registerAuthenticationFailure(String loginName, String method, String failureReason) {
            if (this.hadAuthenticationSuccess) {
                throw new IllegalStateException("Attempted to register an authentication failure after authentication success for session id " + this.internalSessionId);
            }
            this.lastAuthLoginName = loginName;
            this.lastAuthMethod = method;
            this.lastAuthFailureReason = failureReason;
            ++this.authenticationFailureCount;
            this.writeAuthenticationFailureLogEntry();
            return this;
        }

        @Override
        public synchronized SessionHandle registerDataStreamEOF() {
            this.hadIncomingEOF = true;
            return this;
        }

        @Override
        public int modifyCustomCounter(int delta) {
            this.customCounter += delta;
            return this.customCounter;
        }

        @Override
        public synchronized int getAuthenticationFailureCount() {
            return this.authenticationFailureCount;
        }

        private void storeLogDataKeyValuePair(String key, String value) {
            String replaced = this.logData.put(key, value);
            if (replaced != null) {
                if (replaced.equals(value)) {
                    sharedLog.warn((Object)("Repeatedly attached the same log data for session " + this.internalSessionId + ", key: " + key + ", value: " + value));
                } else {
                    sharedLog.warn((Object)("Replacing log data for session " + this.internalSessionId + ", key: " + key + ", old value: " + replaced + ", new value: " + value));
                }
            }
        }

        private void writeAuthenticationSuccessLogEntry() {
            AuditLog.LogEntry logEntry = AuditLog.newEntry((String)"connection.incoming.accept");
            logEntry.setAll(this.logData);
            logEntry.set(EVENT_LOG_KEY_LOGIN_NAME, this.lastAuthLoginName);
            logEntry.set(EVENT_LOG_KEY_AUTH_METHOD, this.lastAuthMethod);
            if (this.authenticationFailureCount != 0) {
                logEntry.set(EVENT_LOG_KEY_NUM_AUTH_FAILURES, Integer.toString(this.authenticationFailureCount));
            }
            AuditLog.append((AuditLog.LogEntry)logEntry);
        }

        private void writeAuthenticationFailureLogEntry() {
            AuditLog.LogEntry logEntry = AuditLog.newEntry((String)"connection.incoming.authfail");
            logEntry.setAll(this.logData);
            logEntry.set(EVENT_LOG_KEY_NUM_AUTH_FAILURES, Integer.toString(this.authenticationFailureCount));
            logEntry.set(EVENT_LOG_KEY_LOGIN_NAME, this.lastAuthLoginName);
            logEntry.set(EVENT_LOG_KEY_AUTH_METHOD, this.lastAuthMethod);
            logEntry.set(EVENT_LOG_KEY_AUTH_FAILURE_REASON, this.lastAuthFailureReason);
            AuditLog.append((AuditLog.LogEntry)logEntry);
        }

        private void writeFinalLogEntry() {
            String closeReason;
            String mainEventType;
            boolean hadAuthenticationFailure;
            boolean bl = hadAuthenticationFailure = this.authenticationFailureCount != 0;
            if (!this.wasRegularlyClosed) {
                mainEventType = "connection.incoming.close";
                closeReason = "fallback";
            } else if (this.hadAuthenticationSuccess) {
                mainEventType = "connection.incoming.close";
                closeReason = this.hadIncomingEOF ? "end of stream" : "regular";
            } else if (hadAuthenticationFailure) {
                mainEventType = "connection.incoming.refuse";
                closeReason = "auth failure";
            } else {
                mainEventType = "connection.incoming.refuse";
                closeReason = "auth timeout";
            }
            AuditLog.LogEntry logEntry = AuditLog.newEntry((String)mainEventType);
            logEntry.setAll(this.logData);
            if (this.hadAuthenticationSuccess) {
                logEntry.set(EVENT_LOG_KEY_LOGIN_NAME, this.lastAuthLoginName);
                logEntry.set(EVENT_LOG_KEY_AUTH_METHOD, this.lastAuthMethod);
                if (hadAuthenticationFailure) {
                    logEntry.set(EVENT_LOG_KEY_NUM_AUTH_FAILURES, Integer.toString(this.authenticationFailureCount));
                }
            } else if (hadAuthenticationFailure) {
                logEntry.set(EVENT_LOG_KEY_NUM_AUTH_FAILURES, Integer.toString(this.authenticationFailureCount));
                logEntry.set("last_login_name", this.lastAuthLoginName);
                logEntry.set("last_auth_method", this.lastAuthMethod);
                logEntry.set("last_auth_failure_reason", this.lastAuthFailureReason);
            }
            logEntry.set(EVENT_LOG_KEY_CLOSE_REASON, closeReason);
            String durationString = Long.toString(Duration.between(this.startTime, Instant.now()).toMillis());
            logEntry.set(EVENT_LOG_KEY_SESSION_DURATION_MSEC, durationString);
            AuditLog.append((AuditLog.LogEntry)logEntry);
        }
    }
}

