/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.backend.metadata.derby.internal;

import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.configuration.bootstrap.RuntimeDetection;
import de.rcenvironment.core.datamanagement.FileDataService;
import de.rcenvironment.core.datamanagement.backend.MetaDataBackendService;
import de.rcenvironment.core.datamanagement.backend.metadata.derby.internal.DerbyDatabaseSetup;
import de.rcenvironment.core.datamanagement.backend.metadata.derby.internal.DerbyMetaDataBackendConfiguration;
import de.rcenvironment.core.datamanagement.backend.metadata.derby.internal.DerbyMetaDataBackendOperationsImpl;
import de.rcenvironment.core.datamanagement.backend.metadata.derby.internal.PooledConnection;
import de.rcenvironment.core.datamanagement.backend.metadata.derby.internal.PooledConnectionInvocationHandler;
import de.rcenvironment.core.datamanagement.commons.BinaryReference;
import de.rcenvironment.core.datamanagement.commons.ComponentInstance;
import de.rcenvironment.core.datamanagement.commons.ComponentRun;
import de.rcenvironment.core.datamanagement.commons.ComponentRunInterval;
import de.rcenvironment.core.datamanagement.commons.DataReference;
import de.rcenvironment.core.datamanagement.commons.EndpointData;
import de.rcenvironment.core.datamanagement.commons.EndpointInstance;
import de.rcenvironment.core.datamanagement.commons.TimelineInterval;
import de.rcenvironment.core.datamanagement.commons.WorkflowRun;
import de.rcenvironment.core.datamanagement.commons.WorkflowRunDescription;
import de.rcenvironment.core.datamanagement.commons.WorkflowRunTimline;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.datamodel.api.FinalComponentRunState;
import de.rcenvironment.core.datamodel.api.FinalComponentState;
import de.rcenvironment.core.datamodel.api.FinalWorkflowState;
import de.rcenvironment.core.datamodel.api.TimelineIntervalType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.toolkitbridge.transitional.StatsCounter;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedExecutionQueue;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransientException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.sql.ConnectionPoolDataSource;
import org.apache.commons.dbcp.datasources.SharedPoolDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource;
import org.osgi.framework.BundleContext;

public class DerbyMetaDataBackendServiceImpl
implements MetaDataBackendService {
    private static final String FALSE = "FALSE";
    private static final int NOT_MARKED_TO_BE_DELETED = 0;
    private static final int WORKFLOW_RUN_TO_BE_DELETED = 1;
    private static final int FILES_TO_BE_DELETED = 2;
    private static final String TRUE = "true";
    private static final int TIME_TO_WAIT_FOR_RETRY = 5000;
    private static final String INITIALIZATION_TIMEOUT_ERROR_MESSAGE = "Initialization timeout reached for meta data database.";
    private static final int INITIALIZATION_TIMEOUT = 30;
    private static final int SHUTDOWN_TIMEOUT = 5;
    private static final int MAX_RETRIES = 5;
    private static final Log LOGGER = LogFactory.getLog(DerbyMetaDataBackendServiceImpl.class);
    private static final String METADATA_DB_NAME = "metadata";
    private final CountDownLatch initializationLatch = new CountDownLatch(1);
    private final DerbyMetaDataBackendOperationsImpl metaDataBackendOperations = new DerbyMetaDataBackendOperationsImpl();
    private SharedPoolDataSource connectionPool;
    private EmbeddedConnectionPoolDataSource connectionPoolDatasource;
    private DerbyMetaDataBackendConfiguration configuration;
    private ConfigurationService configService;
    private volatile FileDataService dataService;
    private final ThreadLocal<PooledConnection> connections = new ThreadLocal();
    private final AsyncOrderedExecutionQueue executionQueue = ConcurrencyUtils.getFactory().createAsyncOrderedExecutionQueue(AsyncCallbackExceptionPolicy.LOG_AND_PROCEED);
    private TypedDatumSerializer typedDatumSerializer;
    private boolean startedSuccessfully = false;
    private String errorMessage = null;

    protected void activate(BundleContext context) throws IOException {
        if (RuntimeDetection.isImplicitServiceActivationDenied()) {
            return;
        }
        File storageRootDir = this.configService.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_DATA_MANAGEMENT);
        File metaDataDirectory = new File(storageRootDir, METADATA_DB_NAME);
        System.setProperty("derby.stream.error.file", new File(storageRootDir, "derby.log").getAbsolutePath());
        System.setProperty("derby.locks.waitTimeout", "30");
        System.setProperty("derby.locks.deadlockTimeout", "20");
        System.setProperty("derby.system.bootAll", TRUE);
        System.setProperty("derby.storage.pageCacheSize", "20000");
        System.setProperty("derby.storage.rowLocking", TRUE);
        System.setProperty("derby.locks.escalationThreshold", "500000");
        System.setProperty("derby.language.logQueryPlan", FALSE);
        System.setProperty("derby.locks.monitor", FALSE);
        System.setProperty("derby.locks.deadlockTrace", FALSE);
        this.configuration = new DerbyMetaDataBackendConfiguration();
        if (this.configuration.getDatabaseURL().equals("")) {
            this.configuration.setDatabaseUrl(metaDataDirectory.getAbsolutePath());
            LOGGER.debug((Object)("Initializing Derby meta data backend in " + metaDataDirectory));
        } else {
            LOGGER.warn((Object)"Unexpected state: Database URL already defined");
        }
        ConcurrencyUtils.getAsyncTaskService().execute("Database initialization", this::initialize);
    }

    protected void deactivate() {
        if (RuntimeDetection.isImplicitServiceActivationDenied()) {
            return;
        }
        try {
            if (!this.initializationLatch.await(30L, TimeUnit.SECONDS)) {
                LOGGER.error((Object)INITIALIZATION_TIMEOUT_ERROR_MESSAGE);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(INITIALIZATION_TIMEOUT_ERROR_MESSAGE, e);
        }
        this.shutDown();
    }

    protected void bindConfigurationService(ConfigurationService newConfigurationService) {
        this.configService = newConfigurationService;
    }

    protected void bindTypedDatumService(TypedDatumService newService) {
        this.typedDatumSerializer = newService.getSerializer();
    }

    protected void bindDataService(FileDataService newService) {
        this.dataService = newService;
    }

    protected Connection getConnection() {
        PooledConnection result = this.connections.get();
        try {
            if (result != null && result.isClosed()) {
                result = null;
            }
        }
        catch (SQLException sQLException) {
            result = null;
        }
        if (result == null) {
            try {
                Connection connection = this.connectionPool.getConnection();
                PooledConnectionInvocationHandler handler = new PooledConnectionInvocationHandler(connection);
                PooledConnection pooledConnection = (PooledConnection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{PooledConnection.class}, (InvocationHandler)handler);
                this.connections.set(pooledConnection);
                result = pooledConnection;
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to retrieve connection from connection pool:", e);
            }
            catch (NullPointerException nullPointerException) {
                LOGGER.warn((Object)"Unable to get database connection. Connection pool already shut down.");
            }
        }
        if (result != null) {
            result.increment();
        }
        return result;
    }

    public Long addWorkflowRun(final String workflowTitle, final String workflowControllerNodeId, final String workflowDataManagementNodeId, final Long starttime) {
        SafeExecution<Long> execution = new SafeExecution<Long>(this){

            @Override
            protected Long protectedCall(Connection connection, boolean isRetry) throws SQLException {
                Long wfRunId = metaDataBackendOperations.addWorkflowRun(workflowTitle, workflowControllerNodeId, workflowDataManagementNodeId, connection, isRetry);
                metaDataBackendOperations.addTimelineInterval(wfRunId, TimelineIntervalType.WORKFLOW_RUN, starttime, null, connection, isRetry);
                return wfRunId;
            }
        };
        return (Long)execution.call();
    }

    public void addWorkflowFileToWorkflowRun(final Long workflowRunId, final String wfFileReference) {
        SafeExecution<Void> execution = new SafeExecution<Void>(this){

            @Override
            protected Void protectedCall(Connection connection, boolean isRetry) throws SQLException {
                metaDataBackendOperations.addWorkflowFileToWorkflowRun(workflowRunId, wfFileReference, connection, isRetry);
                return null;
            }
        };
        execution.call();
    }

    private void addProperties(final String propertiesTableName, final Long relatedId, final Map<String, String> properties) {
        SafeExecution<Void> execution = new SafeExecution<Void>(this){

            @Override
            protected Void protectedCall(Connection connection, boolean isRetry) throws SQLException {
                metaDataBackendOperations.addProperties(propertiesTableName, relatedId, properties, connection, isRetry);
                return null;
            }
        };
        execution.call();
    }

    public Map<String, Long> addComponentInstances(final Long workflowRunId, final Collection<ComponentInstance> componentInstances) {
        SafeExecution<Map<String, Long>> execution = new SafeExecution<Map<String, Long>>(this){

            @Override
            protected Map<String, Long> protectedCall(Connection connection, boolean isRetry) throws SQLException {
                return metaDataBackendOperations.addComponentInstances(workflowRunId, componentInstances, connection, isRetry);
            }
        };
        return (Map)execution.call();
    }

    @AllowRemoteAccess
    public Long addComponentRun(final Long componentInstanceDbId, final String nodeId, final Integer count, final Long starttime) {
        SafeExecution<Long> execution = new SafeExecution<Long>(this){

            @Override
            protected Long protectedCall(Connection connection, boolean isRetry) throws SQLException {
                Long cRunId = metaDataBackendOperations.addComponentRun(componentInstanceDbId, nodeId, count, starttime, connection, isRetry);
                Long wfRunId = metaDataBackendOperations.getWorkflowRunIdByComponentInstanceId(componentInstanceDbId, connection, isRetry);
                metaDataBackendOperations.addTimelineInterval(wfRunId, TimelineIntervalType.COMPONENT_RUN, starttime, cRunId, connection, isRetry);
                return cRunId;
            }
        };
        return (Long)execution.call();
    }

    @AllowRemoteAccess
    public void setOrUpdateHistoryDataItem(final Long componentRunId, final String historyDataItem) {
        SafeExecution<Void> execution = new SafeExecution<Void>(this){

            @Override
            protected Void protectedCall(Connection connection, boolean isRetry) throws SQLException {
                metaDataBackendOperations.setOrUpdateHistoryDataItem(componentRunId, historyDataItem, connection, isRetry);
                return null;
            }
        };
        execution.call();
    }

    public void setOrUpdateTimelineDataItem(final Long workflowRunId, final String timelinDataItem) {
        SafeExecution<Void> execution = new SafeExecution<Void>(this){

            @Override
            protected Void protectedCall(Connection connection, boolean isRetry) throws SQLException {
                metaDataBackendOperations.setOrUpdateTimelineDataItem(workflowRunId, timelinDataItem, connection, isRetry);
                return null;
            }
        };
        execution.call();
    }

    public void setWorkflowRunFinished(final Long workflowRunId, final Long endtime, final FinalWorkflowState finalState) {
        SafeExecution<Void> execution = new SafeExecution<Void>(this){

            @Override
            protected Void protectedCall(Connection connection, boolean isRetry) throws SQLException {
                metaDataBackendOperations.setWorkflowRunEndtime(workflowRunId, endtime, connection, isRetry);
                metaDataBackendOperations.setWorkflowRunFinalState(workflowRunId, finalState, connection, isRetry);
                return null;
            }
        };
        execution.call();
    }

    @AllowRemoteAccess
    public void setComponentRunFinished(final Long componentRunId, final Long endtime, final FinalComponentRunState finalState) {
        SafeExecution<Void> execution = new SafeExecution<Void>(this){

            @Override
            protected Void protectedCall(Connection connection, boolean isRetry) throws SQLException {
                metaDataBackendOperations.setComponentRunFinished(componentRunId, endtime, finalState, connection, isRetry);
                return null;
            }
        };
        execution.call();
    }

    @AllowRemoteAccess
    public void setComponentInstanceFinalState(final Long componentInstanceId, final FinalComponentState finalState) {
        SafeExecution<Void> execution = new SafeExecution<Void>(this){

            @Override
            protected Void protectedCall(Connection connection, boolean isRetry) throws SQLException {
                metaDataBackendOperations.setComponentInstanceFinalState(componentInstanceId, finalState, connection, isRetry);
                return null;
            }
        };
        execution.call();
    }

    @AllowRemoteAccess
    public Set<WorkflowRunDescription> getWorkflowRunDescriptions() {
        SafeExecution<Set<WorkflowRunDescription>> execution = new SafeExecution<Set<WorkflowRunDescription>>(this){

            @Override
            protected Set<WorkflowRunDescription> protectedCall(Connection connection, boolean isRetry) throws SQLException {
                connection.setReadOnly(true);
                return metaDataBackendOperations.getWorkflowRunDescriptions(connection, isRetry);
            }
        };
        return (Set)execution.call();
    }

    @AllowRemoteAccess
    public WorkflowRun getWorkflowRun(final Long workflowRunId) {
        SafeExecution<WorkflowRun> execution = new SafeExecution<WorkflowRun>(this){

            @Override
            protected WorkflowRun protectedCall(Connection connection, boolean isRetry) throws SQLException {
                connection.setReadOnly(true);
                return metaDataBackendOperations.getWorkflowRun(workflowRunId, connection, isRetry);
            }
        };
        return (WorkflowRun)execution.call();
    }

    public Collection<ComponentRun> getComponentRuns(final Long componentInstanceId) {
        SafeExecution<Collection<ComponentRun>> execution = new SafeExecution<Collection<ComponentRun>>(this){

            @Override
            protected Collection<ComponentRun> protectedCall(Connection connection, boolean isRetry) throws SQLException {
                connection.setReadOnly(true);
                return metaDataBackendOperations.getComponentRuns(componentInstanceId, connection, isRetry);
            }
        };
        return (Collection)execution.call();
    }

    public Map<String, Long> addEndpointInstances(final Long componentInstanceId, final Collection<EndpointInstance> endpointInstances) {
        SafeExecution<Map<String, Long>> execution = new SafeExecution<Map<String, Long>>(this){

            @Override
            protected Map<String, Long> protectedCall(Connection connection, boolean isRetry) throws SQLException {
                return metaDataBackendOperations.addEndpointInstances(componentInstanceId, endpointInstances, connection, isRetry);
            }
        };
        return (Map)execution.call();
    }

    @AllowRemoteAccess
    public void addInputDatum(final Long componentRunId, final Long typedDatumId, final Long endpointInstanceId, final Integer count) {
        SafeExecution<Void> execution = new SafeExecution<Void>(this){

            @Override
            protected Void protectedCall(Connection connection, boolean isRetry) throws SQLException {
                metaDataBackendOperations.addEndpointDatum(componentRunId, typedDatumId, endpointInstanceId, count, connection, isRetry);
                return null;
            }
        };
        execution.call();
    }

    @AllowRemoteAccess
    public Long addOutputDatum(final Long componentRunId, final Long endpointInstanceId, final String datum, final Integer count) {
        SafeExecution<Long> execution = new SafeExecution<Long>(this){

            @Override
            protected Long protectedCall(Connection connection, boolean isRetry) throws SQLException {
                TypedDatum td = typedDatumSerializer.deserialize(datum);
                Long typedDatumId = metaDataBackendOperations.addTypedDatum(td.getDataType().getShortName(), datum, connection, isRetry);
                return metaDataBackendOperations.addEndpointDatum(componentRunId, typedDatumId, endpointInstanceId, count, connection, isRetry);
            }
        };
        return (Long)execution.call();
    }

    public Long addTimelineInterval(final Long workflowRunId, final TimelineIntervalType intervalType, final long starttime, final Long relatedComponentId) {
        if (intervalType.equals((Object)TimelineIntervalType.WORKFLOW_RUN) || intervalType.equals((Object)TimelineIntervalType.COMPONENT_RUN)) {
            throw new IllegalArgumentException("Called using internal TimelineIntervalType:" + intervalType.name());
        }
        SafeExecution<Long> execution = new SafeExecution<Long>(this){

            @Override
            protected Long protectedCall(Connection connection, boolean isRetry) throws SQLException {
                return metaDataBackendOperations.addTimelineInterval(workflowRunId, intervalType, starttime, relatedComponentId, connection, isRetry);
            }
        };
        return (Long)execution.call();
    }

    public void setTimelineIntervalFinished(final Long timelineIntervalId, final long endtime) {
        SafeExecution<Void> execution = new SafeExecution<Void>(this){

            @Override
            protected Void protectedCall(Connection connection, boolean isRetry) throws SQLException {
                metaDataBackendOperations.setTimelineIntervalFinished(timelineIntervalId, endtime, connection, isRetry);
                return null;
            }
        };
        execution.call();
    }

    @AllowRemoteAccess
    public WorkflowRunTimline getWorkflowTimeline(final Long workflowRunId) {
        SafeExecution<WorkflowRunTimline> execution = new SafeExecution<WorkflowRunTimline>(this){

            @Override
            protected WorkflowRunTimline protectedCall(Connection connection, boolean isRetry) throws SQLException {
                connection.setReadOnly(true);
                String workflowRunName = metaDataBackendOperations.getWorkflowRunName(workflowRunId, connection, isRetry);
                TimelineInterval workflowRunInterval = metaDataBackendOperations.getWorkflowInterval(workflowRunId, connection, isRetry);
                List<ComponentRunInterval> componentRunIntervals = metaDataBackendOperations.getComponentRunIntervals(workflowRunId, connection, isRetry);
                return new WorkflowRunTimline(workflowRunName, workflowRunInterval, componentRunIntervals);
            }
        };
        return (WorkflowRunTimline)execution.call();
    }

    private Map<String, String> getProperties(final String tableName, final Long relatedId) {
        SafeExecution<Map<String, String>> execution = new SafeExecution<Map<String, String>>(this){

            @Override
            protected Map<String, String> protectedCall(Connection connection, boolean isRetry) throws SQLException {
                connection.setReadOnly(true);
                return metaDataBackendOperations.getProperties(tableName, relatedId, connection, isRetry);
            }
        };
        return (Map)execution.call();
    }

    @AllowRemoteAccess
    public Boolean deleteWorkflowRunFiles(final Long workflowRunId) {
        SafeExecution<Boolean> execution = new SafeExecution<Boolean>(this){

            @Override
            protected Boolean protectedCall(Connection connection, boolean isRetry) throws SQLException {
                if (metaDataBackendOperations.isWorkflowFinished(workflowRunId, connection, isRetry)) {
                    metaDataBackendOperations.markDeletion(workflowRunId, 2, connection, isRetry);
                    LOGGER.debug((Object)StringUtils.format((String)"Marked workflow run id %d to delete files.", (Object[])new Object[]{workflowRunId}));
                    return true;
                }
                LOGGER.debug((Object)("Workflow files deletion requested, but workflow " + workflowRunId + " is either not finished yet or has already been deleted."));
                return false;
            }
        };
        Boolean markedDeletion = (Boolean)execution.call();
        if (markedDeletion.booleanValue()) {
            this.executionQueue.enqueue(new Runnable(){

                @Override
                public void run() {
                    DerbyMetaDataBackendServiceImpl.this.deleteWorkflowRunFilesInternal(workflowRunId);
                }
            });
        }
        return markedDeletion;
    }

    @AllowRemoteAccess
    public Boolean deleteWorkflowRun(final Long workflowRunId) {
        SafeExecution<Boolean> execution = new SafeExecution<Boolean>(this){

            @Override
            protected Boolean protectedCall(Connection connection, boolean isRetry) throws SQLException {
                if (metaDataBackendOperations.isWorkflowFinished(workflowRunId, connection, isRetry)) {
                    metaDataBackendOperations.markDeletion(workflowRunId, 1, connection, isRetry);
                    LOGGER.debug((Object)StringUtils.format((String)"Marked workflow run id %d to be deleted.", (Object[])new Object[]{workflowRunId}));
                    return true;
                }
                LOGGER.debug((Object)("Workflow run deletion requested, but workflow " + workflowRunId + " is either not finished yet or has already been deleted."));
                return false;
            }
        };
        Boolean markedDeletion = (Boolean)execution.call();
        if (markedDeletion.booleanValue()) {
            this.executionQueue.enqueue(new Runnable(){

                @Override
                public void run() {
                    DerbyMetaDataBackendServiceImpl.this.deleteWorkflowRunInternal(workflowRunId);
                }
            });
        }
        return markedDeletion;
    }

    private void deleteWorkflowRunInternal(final Long workflowRunId) {
        SafeExecution<Boolean> execution2;
        SafeExecution<Map<Long, Set<String>>> execution = new SafeExecution<Map<Long, Set<String>>>(this){

            @Override
            protected Map<Long, Set<String>> protectedCall(Connection connection, boolean isRetry) throws SQLException {
                connection.setReadOnly(true);
                LOGGER.debug((Object)StringUtils.format((String)"Starting to delete workflow run id %d.", (Object[])new Object[]{workflowRunId}));
                Map<Long, Set<String>> keys = metaDataBackendOperations.getDataReferenceBinaryKeys(workflowRunId, connection, isRetry);
                return keys;
            }
        };
        final Map dataKeys = (Map)execution.call();
        if (dataKeys != null) {
            try {
                this.deleteFiles(dataKeys.values());
            }
            catch (RemoteOperationException e) {
                throw new RuntimeException("Failed to delete files. ", e);
            }
        }
        if (((Boolean)(execution2 = new SafeExecution<Boolean>(this){

            @Override
            protected Boolean protectedCall(Connection connection, boolean isRetry) throws SQLException {
                Boolean deleted = metaDataBackendOperations.deleteDataReferences(dataKeys, connection, isRetry);
                LOGGER.debug((Object)StringUtils.format((String)"Deleted data references of workflow run id %d.", (Object[])new Object[]{workflowRunId}));
                return deleted;
            }
        }).call()).booleanValue()) {
            SafeExecution<Void> execution3 = new SafeExecution<Void>(this){

                @Override
                protected Void protectedCall(Connection connection, boolean isRetry) throws SQLException {
                    metaDataBackendOperations.deleteTypedDatums(workflowRunId, connection, isRetry);
                    metaDataBackendOperations.deleteWorkflowRunContent(workflowRunId, connection, isRetry);
                    LOGGER.debug((Object)StringUtils.format((String)"Finished deletion of workflow run id %d.", (Object[])new Object[]{workflowRunId}));
                    return null;
                }
            };
            execution3.call();
        } else {
            LOGGER.warn((Object)StringUtils.format((String)"Could not delete workflow run id %d.", (Object[])new Object[]{workflowRunId}));
        }
    }

    private void deleteWorkflowRunFilesInternal(final Long workflowRunId) {
        SafeExecution<Boolean> execution2;
        SafeExecution<Map<Long, Set<String>>> execution = new SafeExecution<Map<Long, Set<String>>>(this){

            @Override
            protected Map<Long, Set<String>> protectedCall(Connection connection, boolean isRetry) throws SQLException {
                connection.setReadOnly(true);
                LOGGER.debug((Object)StringUtils.format((String)"Starting to delete files of workflow run id %d.", (Object[])new Object[]{workflowRunId}));
                Map<Long, Set<String>> keys = metaDataBackendOperations.getDataReferenceBinaryKeys(workflowRunId, connection, isRetry);
                return keys;
            }
        };
        final Map dataKeys = (Map)execution.call();
        if (dataKeys != null) {
            try {
                this.deleteFiles(dataKeys.values());
            }
            catch (RemoteOperationException e) {
                throw new RuntimeException("Failed to delete files. ", e);
            }
        }
        if (((Boolean)(execution2 = new SafeExecution<Boolean>(this){

            @Override
            protected Boolean protectedCall(Connection connection, boolean isRetry) throws SQLException {
                return metaDataBackendOperations.deleteDataReferences(dataKeys, connection, isRetry);
            }
        }).call()).booleanValue()) {
            SafeExecution<Void> execution3 = new SafeExecution<Void>(this){

                @Override
                protected Void protectedCall(Connection connection, boolean isRetry) throws SQLException {
                    metaDataBackendOperations.markDataReferencesDeleted(workflowRunId, connection, isRetry);
                    metaDataBackendOperations.markDeletion(workflowRunId, 0, connection, isRetry);
                    LOGGER.debug((Object)StringUtils.format((String)"Finished file deletion of workflow run id %d.", (Object[])new Object[]{workflowRunId}));
                    return null;
                }
            };
            execution3.call();
        }
    }

    private void deleteFiles(Collection<Set<String>> binaryKeys) throws RemoteOperationException {
        for (Set<String> keySet : binaryKeys) {
            for (String key : keySet) {
                this.dataService.deleteReference(key);
            }
        }
    }

    public Long addDataReferenceToComponentRun(final Long componentRunId, final DataReference dataReference) {
        SafeExecution<Long> execution = new SafeExecution<Long>(this){

            @Override
            protected Long protectedCall(Connection connection, boolean isRetry) throws SQLException {
                Long dataReferenceId = metaDataBackendOperations.addDataReference(dataReference, connection, isRetry);
                metaDataBackendOperations.addDataReferenceComponentRunRelation(dataReferenceId, componentRunId, connection, isRetry);
                return dataReferenceId;
            }
        };
        return (Long)execution.call();
    }

    public Long addDataReferenceToComponentInstance(final Long componentInstanceId, final DataReference dataReference) {
        SafeExecution<Long> execution = new SafeExecution<Long>(this){

            @Override
            protected Long protectedCall(Connection connection, boolean isRetry) throws SQLException {
                Long dataReferenceId = metaDataBackendOperations.addDataReference(dataReference, connection, isRetry);
                metaDataBackendOperations.addDataReferenceComponentInstanceRelation(dataReferenceId, componentInstanceId, connection, isRetry);
                return dataReferenceId;
            }
        };
        return (Long)execution.call();
    }

    public Long addDataReferenceToWorkflowRun(final Long workflowRunId, final DataReference dataReference) {
        SafeExecution<Long> execution = new SafeExecution<Long>(this){

            @Override
            protected Long protectedCall(Connection connection, boolean isRetry) throws SQLException {
                Long dataReferenceId = metaDataBackendOperations.addDataReference(dataReference, connection, isRetry);
                metaDataBackendOperations.addDataReferenceWorkflowRunRelation(dataReferenceId, workflowRunId, connection, isRetry);
                return dataReferenceId;
            }
        };
        return (Long)execution.call();
    }

    public void addBinaryReference(final Long dataReferenceId, final BinaryReference binaryReference) {
        SafeExecution<Void> execution = new SafeExecution<Void>(this){

            @Override
            protected Void protectedCall(Connection connection, boolean isRetry) throws SQLException {
                HashSet<Long> brIds = new HashSet<Long>();
                brIds.add(metaDataBackendOperations.addBinaryReference(binaryReference, connection, isRetry));
                metaDataBackendOperations.addDataBinaryReferenceRelations(dataReferenceId, brIds, connection, isRetry);
                return null;
            }
        };
        execution.call();
    }

    @AllowRemoteAccess
    public DataReference getDataReference(final String dataReferenceKey) {
        SafeExecution<DataReference> execution = new SafeExecution<DataReference>(this){

            @Override
            protected DataReference protectedCall(Connection connection, boolean isRetry) throws SQLException {
                connection.setReadOnly(true);
                return metaDataBackendOperations.getDataReference(dataReferenceKey, connection, isRetry);
            }
        };
        return (DataReference)execution.call();
    }

    private Collection<EndpointData> getEndpointData(Long componentRunId, EndpointType endpointType) {
        return null;
    }

    public void addWorkflowRunProperties(Long workflowRunId, Map<String, String> properties) {
        this.addProperties("WORKFLOW_RUN_PROPERTIES", workflowRunId, properties);
    }

    public void addComponentInstanceProperties(Long componentInstanceId, Map<String, String> properties) {
        this.addProperties("COMPONENT_INSTANCE_PROPERTIES", componentInstanceId, properties);
    }

    public void addEndpointInstanceProperties(Long endpointInstanceId, Map<String, String> properties) {
        this.addProperties("ENDPOINT_INSTANCE_PROPERTIES", endpointInstanceId, properties);
    }

    public void addComponentRunProperties(Long componentRunId, Map<String, String> properties) {
        this.addProperties("COMPONENT_RUN_PROPERTIES", componentRunId, properties);
    }

    public Collection<EndpointData> getInputData(Long componentRunId) {
        return this.getEndpointData(componentRunId, EndpointType.INPUT);
    }

    public Collection<EndpointData> getOutputData(Long componentRunId) {
        return this.getEndpointData(componentRunId, EndpointType.OUTPUT);
    }

    public Map<String, String> getWorkflowRunProperties(Long workflowRunId) {
        return this.getProperties("WORKFLOW_RUN_PROPERTIES", workflowRunId);
    }

    public Map<String, String> getComponentRunProperties(Long componentRunId) {
        return this.getProperties("COMPONENT_RUN_PROPERTIES", componentRunId);
    }

    public void addTimelineInterval(Long workflowRunId, TimelineIntervalType intervalType, long starttime) {
        this.addTimelineInterval(workflowRunId, intervalType, starttime, null);
    }

    private void cleanUpDeletion(Connection connection, boolean isRetry) throws SQLException {
        Map<Long, Integer> wfsToBeDeleted = this.metaDataBackendOperations.getWorkflowRunsToBeDeleted(connection, isRetry);
        if (wfsToBeDeleted != null) {
            for (final Long wfrunId : wfsToBeDeleted.keySet()) {
                switch (wfsToBeDeleted.get(wfrunId)) {
                    case 1: {
                        LOGGER.debug((Object)StringUtils.format((String)"Clean up deletion of workflow run id %d", (Object[])new Object[]{wfrunId}));
                        this.executionQueue.enqueue(new Runnable(){

                            @Override
                            public void run() {
                                DerbyMetaDataBackendServiceImpl.this.deleteWorkflowRunInternal(wfrunId);
                            }
                        });
                        break;
                    }
                    case 2: {
                        LOGGER.debug((Object)StringUtils.format((String)"Clean up file deletion of workflow run id %d", (Object[])new Object[]{wfrunId}));
                        this.executionQueue.enqueue(new Runnable(){

                            @Override
                            public void run() {
                                DerbyMetaDataBackendServiceImpl.this.deleteWorkflowRunFilesInternal(wfrunId);
                            }
                        });
                        break;
                    }
                }
            }
        }
    }

    private void initialize() {
        this.createConnectionPool();
        try {
            Connection connection = this.connectionPool.getConnection();
            connection.close();
        }
        catch (SQLException e) {
            this.errorMessage = "Failed to connect to the database. Most likely reasons: The database is used by another RCE instance or the database was not created successfully before then.";
            throw new IllegalStateException("Connecting to data management meta data db failed.", e);
        }
        this.initializeDatabase();
        this.initializationLatch.countDown();
    }

    private void initializeDatabase() {
        block16: {
            Connection connection = null;
            try {
                try {
                    connection = this.connectionPool.getConnection();
                    DerbyDatabaseSetup.setupDatabase(connection);
                    int affectedLines = this.metaDataBackendOperations.cleanUpWorkflowRunFinalStates(connection, false);
                    if (affectedLines > 0) {
                        LOGGER.debug((Object)StringUtils.format((String)"Cleaned up corrupted final states of %d workflows.", (Object[])new Object[]{affectedLines}));
                    }
                    this.cleanUpDeletion(connection, false);
                    connection.commit();
                    this.startedSuccessfully = true;
                }
                catch (RuntimeException | SQLException e) {
                    this.startedSuccessfully = false;
                    this.errorMessage = e.getMessage();
                    if (connection != null) {
                        try {
                            connection.rollback();
                        }
                        catch (SQLException sQLException) {
                        }
                    }
                    if (connection == null) break block16;
                    try {
                        connection.close();
                    }
                    catch (SQLException e2) {
                        LOGGER.error((Object)"Failed to close connection:", (Throwable)e2);
                    }
                }
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        LOGGER.error((Object)"Failed to close connection:", (Throwable)e);
                    }
                }
            }
        }
    }

    private void createConnectionPool() {
        this.connectionPoolDatasource = new EmbeddedConnectionPoolDataSource();
        this.connectionPoolDatasource.setDatabaseName(this.configuration.getDatabaseURL());
        this.connectionPoolDatasource.setCreateDatabase("create");
        this.connectionPool = new SharedPoolDataSource();
        this.connectionPool.setConnectionPoolDataSource((ConnectionPoolDataSource)this.connectionPoolDatasource);
        this.connectionPool.setDefaultAutoCommit(false);
        this.connectionPool.setDefaultTransactionIsolation(2);
        this.connectionPool.setMaxActive(-1);
        this.connectionPool.setDefaultReadOnly(false);
        LOGGER.debug((Object)("Start data management meta data db: " + this.configuration.getDatabaseURL()));
    }

    /*
     * Exception decompiling
     */
    private void shutDown() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 6[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void waitForRetry() {
        LOGGER.debug((Object)"Waiting 5 seconds to retry SQL statement execution");
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            LOGGER.warn((Object)"Waiting for retrying a failed SQL statement was interupted");
        }
    }

    public boolean isMetaDataBackendOk() {
        try {
            this.initializationLatch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return this.startedSuccessfully;
    }

    public String getMetaDataBackendStartErrorMessage() {
        return this.errorMessage;
    }

    protected abstract class SafeExecution<T>
    implements Callable<T> {
        protected SafeExecution() {
        }

        @Override
        public final T call() {
            T result = null;
            try {
                if (!DerbyMetaDataBackendServiceImpl.this.initializationLatch.await(30L, TimeUnit.SECONDS)) {
                    LOGGER.error((Object)DerbyMetaDataBackendServiceImpl.INITIALIZATION_TIMEOUT_ERROR_MESSAGE);
                    throw new RuntimeException(DerbyMetaDataBackendServiceImpl.INITIALIZATION_TIMEOUT_ERROR_MESSAGE);
                }
            }
            catch (InterruptedException interruptedException) {
                try {
                    if (!DerbyMetaDataBackendServiceImpl.this.initializationLatch.await(1L, TimeUnit.SECONDS)) {
                        LOGGER.error((Object)DerbyMetaDataBackendServiceImpl.INITIALIZATION_TIMEOUT_ERROR_MESSAGE);
                        throw new RuntimeException(DerbyMetaDataBackendServiceImpl.INITIALIZATION_TIMEOUT_ERROR_MESSAGE);
                    }
                }
                catch (InterruptedException interruptedException2) {
                    throw new RuntimeException(DerbyMetaDataBackendServiceImpl.INITIALIZATION_TIMEOUT_ERROR_MESSAGE);
                }
            }
            Connection connection = DerbyMetaDataBackendServiceImpl.this.getConnection();
            if (connection == null) {
                throw new RuntimeException("Failed to get database connection.");
            }
            try {
                connection.setAutoCommit(false);
                connection.setTransactionIsolation(2);
                int count = 0;
                while (true) {
                    long startTimeForAttempt = System.currentTimeMillis();
                    try {
                        result = this.protectedCall(connection, false);
                        StatsCounter.registerValue((String)"Metadata Backend: successful database call duration (msec)", (String)this.getClass().getName(), (long)(System.currentTimeMillis() - startTimeForAttempt));
                    }
                    catch (SQLTransientException e) {
                        if (count == 0) {
                            LOGGER.debug((Object)StringUtils.format((String)"Executing database statement failed (%s). Will retry.", (Object[])new Object[]{e.getMessage()}));
                        }
                        StatsCounter.registerValue((String)"Metadata Backend: duration of database calls on transient failure (in msec) - will wait and retry", (String)this.getClass().getName(), (long)(System.currentTimeMillis() - startTimeForAttempt));
                        DerbyMetaDataBackendServiceImpl.this.waitForRetry();
                        if (++count < 5) continue;
                        throw new RuntimeException(StringUtils.format((String)"Failed to commit database transaction after %d retries.", (Object[])new Object[]{5}));
                    }
                    break;
                }
                connection.commit();
                T t = result;
                return t;
            }
            catch (RuntimeException | SQLException e) {
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    LOGGER.error((Object)"Failed to rollback database transaction", (Throwable)e1);
                }
                throw new RuntimeException("Failed to safely execute:", e);
            }
            finally {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"Failed to close database connection", (Throwable)e);
                }
            }
        }

        protected abstract T protectedCall(Connection var1, boolean var2) throws SQLException;
    }
}

