/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.impl;

import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.model.impl.ComponentImageUtility;
import de.rcenvironment.core.component.spi.DistributedComponentKnowledgeListener;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import java.util.Collection;

public abstract class ComponentImageChangeListener
implements DistributedComponentKnowledgeListener {
    private String lastIconHash;
    private String componentId;

    public ComponentImageChangeListener(String componentId) {
        Collection<DistributedComponentEntry> installations = ((DistributedComponentKnowledgeService)ServiceRegistry.createAccessFor((Object)this).getService(DistributedComponentKnowledgeService.class)).getCurrentSnapshot().getAllInstallations();
        installations = ComponentImageUtility.getDistinctInstallations(installations);
        for (DistributedComponentEntry entry : installations) {
            if (!entry.getComponentInterface().getIdentifierAndVersion().equals(componentId)) continue;
            this.lastIconHash = entry.getComponentInterface().getIconHash();
        }
        this.componentId = componentId;
    }

    private boolean hasImageChanged(DistributedComponentKnowledge newKnowledge) {
        Collection<DistributedComponentEntry> installations = ComponentImageUtility.getDistinctInstallations(newKnowledge.getAllInstallations());
        for (DistributedComponentEntry entry : installations) {
            if (!entry.getComponentInterface().getIdentifierAndVersion().equals(this.componentId) || entry.getComponentInterface().getIconHash().equals(this.lastIconHash)) continue;
            this.lastIconHash = entry.getComponentInterface().getIconHash();
            return true;
        }
        return false;
    }

    protected static ComponentImageChangeListener create(String componentId, Runnable function) {
        return new DefaultImageListener(componentId, function);
    }

    @Override
    public void onDistributedComponentKnowledgeChanged(DistributedComponentKnowledge newState) {
        if (this.hasImageChanged(newState)) {
            this.onComponentImageChanged();
        }
    }

    public abstract void onComponentImageChanged();

    private static class DefaultImageListener
    extends ComponentImageChangeListener {
        private final Runnable toExecute;

        DefaultImageListener(String componentId, Runnable toExecute) {
            super(componentId);
            this.toExecute = toExecute;
        }

        @Override
        public void onComponentImageChanged() {
            this.toExecute.run();
        }
    }
}

