/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.endpoint.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataConstants;
import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataDefinition;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.LogFactory;

public class EndpointMetaDataDefinitionImpl
implements Serializable,
EndpointMetaDataDefinition {
    private static final long serialVersionUID = 1277591939597311465L;
    private static final int MINUS_ONE = -1;
    private static final String KEY_POSSIBLEVALUES = "possibleValues";
    private static final String KEY_GUINAMESOFPOSSIBLEVALUES = "guiNamesOfPossibleValues";
    private static final String KEY_VALIDATION = "validation";
    private static final String KEY_GUI_ACTIVATION_FILTER = "guiActivationFilter";
    private static final String DEFAULT_GROUP = "";
    private static final String KEY_ENDPOINT_DATATYPES = "endpointDataTypes";
    private static final String KEY_PERSISTENT = "persistent";
    private static final Object KEY_GUI_VISIBILITY_FILTER = "guiVisibilityFilter";
    private Map<String, Map<String, Object>> rawMetaData;
    private Map<String, Map<String, Object>> rawMetaDataExtension;
    private Map<String, Map<String, Object>> combinedRawMetaData;
    private Map<String, List<DataType>> endpointDataTypes = new HashMap<String, List<DataType>>();

    @Override
    @JsonIgnore
    public Set<String> getMetaDataKeys() {
        return Collections.unmodifiableSet(this.combinedRawMetaData.keySet());
    }

    @Override
    @JsonIgnore
    public String getGuiName(String key) {
        return (String)this.combinedRawMetaData.get(key).get("guiName");
    }

    @Override
    @JsonIgnore
    public String getGuiGroup(String key) {
        if (this.combinedRawMetaData.get(key).get("guiGroup") != null) {
            return (String)this.combinedRawMetaData.get(key).get("guiGroup");
        }
        return DEFAULT_GROUP;
    }

    @Override
    @JsonIgnore
    public int getGuiPosition(String key) {
        if (this.combinedRawMetaData.get(key).get("guiPosition") != null) {
            return Integer.valueOf((String)this.combinedRawMetaData.get(key).get("guiPosition"));
        }
        return -1;
    }

    @Override
    @JsonIgnore
    public Map<String, List<String>> getGuiActivationFilter(String key) {
        return (Map)this.combinedRawMetaData.get(key).get(KEY_GUI_ACTIVATION_FILTER);
    }

    @Override
    @JsonIgnore
    public Map<String, List<String>> getGuiVisibilityFilter(String key) {
        return (Map)this.combinedRawMetaData.get(key).get(KEY_GUI_VISIBILITY_FILTER);
    }

    @Override
    @JsonIgnore
    public List<String> getPossibleValues(String key) {
        return (List)this.combinedRawMetaData.get(key).get(KEY_POSSIBLEVALUES);
    }

    @Override
    @JsonIgnore
    public List<String> getGuiNamesOfPossibleValues(String key) {
        if (this.combinedRawMetaData.get(key).containsKey(KEY_GUINAMESOFPOSSIBLEVALUES)) {
            return (List)this.combinedRawMetaData.get(key).get(KEY_GUINAMESOFPOSSIBLEVALUES);
        }
        return this.getPossibleValues(key);
    }

    @Override
    @JsonIgnore
    public String getDefaultValue(String key) {
        if ((String)this.combinedRawMetaData.get(key).get("defaultValue") != null) {
            return (String)this.combinedRawMetaData.get(key).get("defaultValue");
        }
        return DEFAULT_GROUP;
    }

    @Override
    @JsonIgnore
    public String getDataType(String key) {
        if (this.combinedRawMetaData.get(key).get("dataType") != null) {
            return (String)this.combinedRawMetaData.get(key).get("dataType");
        }
        return "text";
    }

    @Override
    @JsonIgnore
    public boolean isDefinedForDataType(String key, DataType dataType) {
        if (!this.combinedRawMetaData.get(key).containsKey(KEY_ENDPOINT_DATATYPES)) {
            return true;
        }
        return this.endpointDataTypes.get(key).contains(dataType);
    }

    @Override
    @JsonIgnore
    public String getValidation(String key) {
        return (String)this.combinedRawMetaData.get(key).get(KEY_VALIDATION);
    }

    @Override
    @JsonIgnore
    public EndpointMetaDataConstants.Visibility getVisibility(String key) {
        if (this.combinedRawMetaData.get(key).get("visibility") != null) {
            return EndpointMetaDataConstants.Visibility.valueOf((String)this.combinedRawMetaData.get(key).get("visibility"));
        }
        return EndpointMetaDataConstants.Visibility.userConfigurable;
    }

    @Override
    @JsonIgnore
    public Map<String, List<String>> getActivationFilter(String key) {
        return (Map)this.combinedRawMetaData.get(key).get("activationFilter");
    }

    public void setRawMetaData(Map<String, Map<String, Object>> metaData) {
        this.rawMetaData = metaData;
        this.combinedRawMetaData = new HashMap<String, Map<String, Object>>(this.rawMetaData);
        for (String key : metaData.keySet()) {
            if (!metaData.get(key).containsKey(KEY_ENDPOINT_DATATYPES)) continue;
            ArrayList<DataType> dataTypes = new ArrayList<DataType>();
            for (String type : (List)metaData.get(key).get(KEY_ENDPOINT_DATATYPES)) {
                dataTypes.add(DataType.valueOf((String)type));
            }
            this.endpointDataTypes.put(key, dataTypes);
        }
    }

    public void setRawMetaDataExtensions(Map<String, Map<String, Object>> metaDataExtension) {
        this.rawMetaDataExtension = metaDataExtension;
        for (String key : metaDataExtension.keySet()) {
            if (!this.rawMetaData.containsKey(key)) {
                this.combinedRawMetaData.put(key, metaDataExtension.get(key));
                continue;
            }
            LogFactory.getLog(this.getClass()).warn((Object)StringUtils.format((String)"Meta data key '%s' is already defined and will be ignored", (Object[])new Object[]{key}));
        }
    }

    public Map<String, Map<String, Object>> getRawMetaData() {
        return this.rawMetaData;
    }

    public Map<String, Map<String, Object>> getRawMetaDataExtension() {
        return this.rawMetaDataExtension;
    }

    @Override
    @JsonIgnore
    public boolean isPersistent(String key) {
        if (this.combinedRawMetaData.get(key) != null && this.combinedRawMetaData.get(key).containsKey(KEY_PERSISTENT)) {
            return Boolean.parseBoolean((String)this.combinedRawMetaData.get(key).get(KEY_PERSISTENT));
        }
        return false;
    }
}

