/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.internal;

import de.rcenvironment.core.component.execution.api.ComponentEventAnnouncement;
import de.rcenvironment.core.component.execution.api.ComponentEventAnnouncementDispatcher;
import de.rcenvironment.core.mail.InvalidMailException;
import de.rcenvironment.core.mail.Mail;
import de.rcenvironment.core.mail.MailDispatchResult;
import de.rcenvironment.core.mail.MailDispatchResultListener;
import de.rcenvironment.core.mail.MailService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.utils.text.TextLinesReceiver;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.LogFactory;

public class ComponentEventAnnouncementDispatcherImpl
implements ComponentEventAnnouncementDispatcher {
    private static final String SUBJECT_PATTERN = "[RCE] %s";
    private MailService mailService;

    @Override
    public boolean dispatchWorkflowEventAnnouncementViaMail(String[] recipients, final ComponentEventAnnouncement compEventAnnouncement, final TextLinesReceiver errorTextReceiver) {
        Mail mail;
        String subject = compEventAnnouncement.hasSubject() ? StringUtils.format((String)SUBJECT_PATTERN, (Object[])new Object[]{compEventAnnouncement.getSubject()}) : StringUtils.format((String)SUBJECT_PATTERN, (Object[])new Object[]{"no subject"});
        try {
            mail = Mail.createMail((String[])recipients, (String)subject, (String)compEventAnnouncement.getBody(), null);
        }
        catch (InvalidMailException e) {
            errorTextReceiver.addLine("Failed to send mail: " + e.getMessage());
            return false;
        }
        final AtomicBoolean success = new AtomicBoolean(false);
        Future mailSendFuture = this.mailService.sendMail(mail, new MailDispatchResultListener(){

            public void receiveResult(MailDispatchResult result, String message) {
                if (message == null) {
                    message = "";
                }
                switch (result) {
                    case SUCCESS: {
                        success.set(true);
                        break;
                    }
                    case FAILURE: {
                        errorTextReceiver.addLine(StringUtils.format((String)"Failed to deliver email to mail server: '%s'; %s", (Object[])new Object[]{compEventAnnouncement.getWorkflowEventType().getDisplayName(), message}));
                        break;
                    }
                    case FAILURE_RETRY: {
                        errorTextReceiver.addLine(StringUtils.format((String)"Failed to deliver email to mail server: '%s'; %s; retrying...", (Object[])new Object[]{compEventAnnouncement.getWorkflowEventType().getDisplayName(), message}));
                        break;
                    }
                    case FAILURE_MAIL_SERVICE_NOT_CONFIGURED: {
                        errorTextReceiver.addLine(StringUtils.format((String)"Failed to deliver email to mail server: '%s'; cause: mail server is not configured; %s", (Object[])new Object[]{compEventAnnouncement.getWorkflowEventType().getDisplayName(), message}));
                        break;
                    }
                    default: {
                        LogFactory.getLog(this.getClass()).error((Object)"Received unexpected result from the mail service.");
                    }
                }
            }
        });
        try {
            mailSendFuture.get();
        }
        catch (InterruptedException interruptedException) {
            mailSendFuture.cancel(true);
            LogFactory.getLog(this.getClass()).warn((Object)StringUtils.format((String)"Interrupted while waiting for mail to be delivered that announces the component event '%s'", (Object[])new Object[]{compEventAnnouncement.getWorkflowEventType()}));
        }
        catch (ExecutionException e) {
            LogFactory.getLog(this.getClass()).error((Object)StringUtils.format((String)"Error when delivering mail to mail server that announces the component event '%s'", (Object[])new Object[]{compEventAnnouncement.getWorkflowEventType()}), (Throwable)e);
        }
        return success.get();
    }

    protected void bindMailService(MailService service) {
        this.mailService = service;
    }
}

