/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.api;

import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.utils.common.CommonIdRules;
import de.rcenvironment.core.utils.common.CrossPlatformFilenameUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Optional;

public final class ComponentIdRules {
    protected static final int MINIMUM_ID_LENGTH = 2;
    protected static final String MINIMUM_ID_LENGTH_ERROR_MESSAGE = "It must consist of at least 2 characters";
    protected static final int MAXIMUM_ID_LENGTH = 100;
    protected static final String MAXIMUM_ID_LENGTH_ERROR_MESSAGE = "The maximum allowed length is %d characters";
    protected static final String ID_INVALID_AS_FILENAME_ERROR_MESSAGE = "It violates the rules for valid filenames of at least one operating system";
    private static final int MAXIMUM_VERSION_STRING_LENGTH = 32;

    private ComponentIdRules() {
    }

    public static Optional<String> validateComponentIdRules(String input) {
        Optional commonValidationError = CommonIdRules.validateCommonIdRules((String)input);
        if (commonValidationError.isPresent()) {
            return commonValidationError;
        }
        if (input.length() < 2) {
            return Optional.of(MINIMUM_ID_LENGTH_ERROR_MESSAGE);
        }
        if (input.length() > 100) {
            return Optional.of(StringUtils.format((String)MAXIMUM_ID_LENGTH_ERROR_MESSAGE, (Object[])new Object[]{100}));
        }
        if (!CrossPlatformFilenameUtils.isFilenameValid((String)input)) {
            return Optional.of(ID_INVALID_AS_FILENAME_ERROR_MESSAGE);
        }
        return Optional.empty();
    }

    public static Optional<String> validateComponentVersionRules(String input) {
        Optional commonValidationError = CommonIdRules.validateCommonVersionStringRules((String)input);
        if (commonValidationError.isPresent()) {
            return commonValidationError;
        }
        if (input.length() > 32) {
            return Optional.of(StringUtils.format((String)MAXIMUM_ID_LENGTH_ERROR_MESSAGE, (Object[])new Object[]{32}));
        }
        if (!CrossPlatformFilenameUtils.isFilenameValid((String)input)) {
            return Optional.of(ID_INVALID_AS_FILENAME_ERROR_MESSAGE);
        }
        return Optional.empty();
    }

    public static Optional<String> validateComponentGroupNameRules(String input) {
        if (input.length() < 2) {
            return Optional.of(MINIMUM_ID_LENGTH_ERROR_MESSAGE);
        }
        if (input.length() > 100) {
            return Optional.of(StringUtils.format((String)MAXIMUM_ID_LENGTH_ERROR_MESSAGE, (Object[])new Object[]{100}));
        }
        Optional commonValidationError = CommonIdRules.validateCommonIdRules((String)input);
        if (commonValidationError.isPresent()) {
            return commonValidationError;
        }
        return Optional.empty();
    }

    public static Optional<String> validateComponentInterfaceIds(ComponentInterface componentInterface) {
        Optional<String> validationError = ComponentIdRules.validateComponentIdRules(componentInterface.getIdentifier());
        if (validationError.isPresent()) {
            return Optional.of("Invalid component name/id: " + validationError.get());
        }
        validationError = ComponentIdRules.validateComponentVersionRules(componentInterface.getVersion());
        if (validationError.isPresent()) {
            return Optional.of("Invalid component version: " + validationError.get());
        }
        validationError = ComponentIdRules.validateComponentGroupNameRules(componentInterface.getGroupName());
        if (validationError.isPresent()) {
            return Optional.of("Invalid component group name: " + validationError.get());
        }
        return Optional.empty();
    }
}

