/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.rpc.internal;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.rpc.api.CallbackProxyService;
import de.rcenvironment.core.communication.rpc.api.CallbackService;
import de.rcenvironment.core.communication.rpc.internal.CallbackProxy;
import de.rcenvironment.core.communication.spi.CallbackObject;
import de.rcenvironment.core.toolkitbridge.transitional.StatsCounter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CallbackUtils {
    private static final Log LOGGER = LogFactory.getLog(CallbackUtils.class);

    private CallbackUtils() {
    }

    public static Object handleCallbackProxy(Object o, CallbackService cs, CallbackProxyService cps) {
        Object newObject = o;
        if (o instanceof CallbackProxy) {
            String objectIdentifier = ((CallbackProxy)o).getObjectIdentifier();
            Object object = cs.getCallbackObject(objectIdentifier);
            StatsCounter.countClass((String)"Callback proxy parameter", (Object)object);
            if (object != null) {
                newObject = object;
            } else {
                Object proxy = cps.getCallbackProxy(objectIdentifier);
                if (proxy != null) {
                    newObject = proxy;
                } else {
                    cps.addCallbackProxy((CallbackProxy)o);
                }
            }
        } else if (o instanceof Collection) {
            ArrayList<Object> newParam = new ArrayList<Object>();
            Iterator iterator = ((Collection)o).iterator();
            while (iterator.hasNext()) {
                newParam.add(newParam.size(), CallbackUtils.handleCallbackProxy(iterator.next(), cs, cps));
            }
            try {
                ((Collection)o).clear();
                ((Collection)o).addAll(newParam);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                LOGGER.debug((Object)("Handling callback objects failed for this collection because it is immutable: " + o.toString()));
            }
        }
        return newObject;
    }

    public static Object handleCallbackObject(Object o, InstanceNodeSessionId pi, CallbackService cs) {
        Object newObject = o;
        if (o instanceof CallbackObject) {
            String identifier = cs.getCallbackObjectIdentifier(o);
            if (identifier == null) {
                identifier = cs.addCallbackObject(o, pi);
            }
            newObject = cs.createCallbackProxy((CallbackObject)o, identifier, pi);
        } else if (o instanceof Collection) {
            ArrayList<Object> newParam = new ArrayList<Object>();
            Iterator iterator = ((Collection)o).iterator();
            while (iterator.hasNext()) {
                newParam.add(newParam.size(), CallbackUtils.handleCallbackObject(iterator.next(), pi, cs));
            }
            try {
                ((Collection)o).clear();
                ((Collection)o).addAll(newParam);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                LOGGER.debug((Object)("handling callback objects failed for this collection because it is immutable: " + o.toString()));
            }
        }
        return newObject;
    }
}

