/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.common.impl;

import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Optional;
import org.apache.commons.logging.LogFactory;

public final class NodeNameDataHolder {
    public static final String UNDECRYPED_NAME_PLACEHOLDER = "<no authorization>";
    private String resolvedName;
    private String encryptionGroupId;
    private String encryptedName;
    private boolean decryptionUnavailable;

    public NodeNameDataHolder() {
    }

    public NodeNameDataHolder(String resolvedName) {
        this();
        this.resolvedName = resolvedName;
    }

    public void setResolvedName(String resolvedName) {
        this.resolvedName = resolvedName;
    }

    public void setEncryptedNameData(String encryptedNameData) {
        String[] parts = StringUtils.splitAndUnescape((String)encryptedNameData);
        if (parts.length == 2) {
            this.encryptionGroupId = parts[0];
            this.encryptedName = parts[1];
        } else {
            LogFactory.getLog(this.getClass()).error((Object)("Ignoring invalid encrypted node name data: " + encryptedNameData));
            this.encryptionGroupId = null;
            this.encryptedName = null;
        }
    }

    public boolean isResolved() {
        return this.resolvedName != null;
    }

    public boolean isDecryptionUnavailable() {
        return this.decryptionUnavailable;
    }

    public boolean isEncrypted() {
        return this.encryptedName != null;
    }

    public String getResolvedName() {
        return this.resolvedName;
    }

    public Optional<String> getOptionalResolvedName() {
        return Optional.ofNullable(this.resolvedName);
    }

    public Optional<String> getOptionalEncryptionGroupId() {
        return Optional.ofNullable(this.encryptionGroupId);
    }

    public Optional<String> getOptionalEncryptedName() {
        return Optional.ofNullable(this.encryptedName);
    }

    public synchronized String toString() {
        if (this.isResolved()) {
            return this.resolvedName;
        }
        if (this.isEncrypted()) {
            return UNDECRYPED_NAME_PLACEHOLDER;
        }
        return "<unknown>";
    }
}

