/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.network.internal;

import de.rcenvironment.core.communication.uplink.common.internal.MessageType;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import java.util.Objects;

public class MessageBlock {
    private final MessageType type;
    private final byte[] data;

    public MessageBlock(int type, byte[] data) throws ProtocolException {
        if (type < 1 || type > 127) {
            throw new ProtocolException("Invalid message block type: " + type);
        }
        this.type = MessageType.resolve((byte)type);
        this.data = Objects.requireNonNull(data);
        if (data.length > 262144) {
            throw new ProtocolException(StringUtils.format((String)"The message data block of %d bytes exceeds the maximum of %d bytes", (Object[])new Object[]{data.length, 262144}));
        }
    }

    public MessageBlock(MessageType messageType) throws ProtocolException {
        this(messageType.getCode(), new byte[0]);
    }

    public MessageType getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getDataLength() {
        return this.data.length;
    }
}

