/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.command.internal;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.internal.CommandPlugins;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.command.spi.SingleCommandHandler;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.LogFactory;

public class CommandPluginDispatcher
implements SingleCommandHandler {
    private CommandPlugins pluginsByTopLevelCommand = new CommandPlugins();

    @Override
    public void execute(CommandContext context) throws CommandException {
        if (context.consumeNextTokenIfEquals("explain")) {
            context.println("Parsed command tokens: " + context.consumeRemainingTokens());
            return;
        }
        Optional<CommandPlugin> plugin = null;
        plugin = this.findBestFit(context);
        if (plugin.isPresent()) {
            try {
                plugin.get().execute(context);
            }
            catch (RuntimeException e) {
                LogFactory.getLog(this.getClass()).error((Object)"Uncaught exception in command handler", (Throwable)e);
                throw CommandException.executionError("Uncaught exception in command handler: " + e.toString(), context);
            }
        } else {
            throw CommandException.unknownCommand(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<CommandPlugin> findBestFit(CommandContext context) {
        Set<CommandPlugin> plugins;
        String topLevelCommand = context.peekNextToken();
        CommandPlugins commandPlugins = this.pluginsByTopLevelCommand;
        synchronized (commandPlugins) {
            if (topLevelCommand == null) {
                throw new IllegalArgumentException("Empty command");
            }
            plugins = this.pluginsByTopLevelCommand.getPluginsForTopLevelCommand(topLevelCommand);
        }
        Optional<CommandPlugin> plugin = Optional.empty();
        int maxNumberOfTokensMatched = 0;
        for (CommandPlugin pluginIterator : plugins) {
            for (CommandDescription desc : pluginIterator.getCommandDescriptions()) {
                int i = maxNumberOfTokensMatched + 1;
                while (i <= context.getOriginalTokens().size()) {
                    String attemptToMatch = String.join((CharSequence)" ", context.getOriginalTokens().subList(0, i));
                    if (desc.getStaticPart().equals(attemptToMatch)) {
                        maxNumberOfTokensMatched = i;
                        plugin = Optional.of(pluginIterator);
                    }
                    ++i;
                }
            }
        }
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPlugin(CommandPlugin plugin) {
        Set<String> topLevelCommands = this.determineTopLevelCommands(plugin);
        CommandPlugins commandPlugins = this.pluginsByTopLevelCommand;
        synchronized (commandPlugins) {
            for (String command : topLevelCommands) {
                this.pluginsByTopLevelCommand.put(command, plugin);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPlugin(CommandPlugin plugin) {
        CommandPlugins commandPlugins = this.pluginsByTopLevelCommand;
        synchronized (commandPlugins) {
            this.pluginsByTopLevelCommand.removePlugin(plugin);
        }
    }

    private Set<String> determineTopLevelCommands(CommandPlugin plugin) {
        HashSet<String> topLevelCommands = new HashSet<String>();
        for (CommandDescription cd : plugin.getCommandDescriptions()) {
            String[] tlcs;
            String[] staticPartSegments = cd.getStaticPart().split(" ");
            String[] stringArray = tlcs = staticPartSegments[0].split("/");
            int n = tlcs.length;
            int n2 = 0;
            while (n2 < n) {
                String tlc = stringArray[n2];
                topLevelCommands.add(tlc);
                ++n2;
            }
        }
        return topLevelCommands;
    }
}

