/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.figures;

import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.ButtonGroup;
import org.eclipse.draw2d.ButtonModel;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToggleButton;
import org.eclipse.draw2d.ToggleModel;
import org.eclipse.nebula.visualization.internal.xygraph.toolbar.AddAnnotationDialog;
import org.eclipse.nebula.visualization.internal.xygraph.toolbar.GrayableButton;
import org.eclipse.nebula.visualization.internal.xygraph.toolbar.RemoveAnnotationDialog;
import org.eclipse.nebula.visualization.internal.xygraph.toolbar.WrappableToolbarLayout;
import org.eclipse.nebula.visualization.internal.xygraph.toolbar.XYGraphConfigDialog;
import org.eclipse.nebula.visualization.internal.xygraph.undo.AddAnnotationCommand;
import org.eclipse.nebula.visualization.internal.xygraph.undo.IOperationsManagerListener;
import org.eclipse.nebula.visualization.internal.xygraph.undo.OperationsManager;
import org.eclipse.nebula.visualization.internal.xygraph.undo.RemoveAnnotationCommand;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.ZoomType;
import org.eclipse.nebula.visualization.xygraph.util.SingleSourceHelper;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class XYGraphToolbar
extends Figure {
    private static final int BUTTON_SIZE = 25;
    private final XYGraph xyGraph;
    private final ButtonGroup zoomGroup;

    public XYGraphToolbar(final XYGraph xyGraph, int flags) {
        this.xyGraph = xyGraph;
        this.setLayoutManager((LayoutManager)new WrappableToolbarLayout());
        Button configButton = new Button(XYGraphMediaFactory.getInstance().getImage("images/Configure.png"));
        configButton.setToolTip((IFigure)new Label("Configure Settings..."));
        this.addButton((Clickable)configButton);
        configButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                XYGraphConfigDialog dialog = new XYGraphConfigDialog(Display.getCurrent().getActiveShell(), xyGraph);
                dialog.open();
            }
        });
        Button addAnnotationButton = new Button(XYGraphMediaFactory.getInstance().getImage("images/Add_Annotation.png"));
        addAnnotationButton.setToolTip((IFigure)new Label("Add Annotation..."));
        this.addButton((Clickable)addAnnotationButton);
        addAnnotationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AddAnnotationDialog dialog = new AddAnnotationDialog(Display.getCurrent().getActiveShell(), xyGraph);
                if (dialog.open() == 0) {
                    xyGraph.addAnnotation(dialog.getAnnotation());
                    xyGraph.getOperationsManager().addCommand(new AddAnnotationCommand(xyGraph, dialog.getAnnotation()));
                }
            }
        });
        Button delAnnotationButton = new Button(XYGraphMediaFactory.getInstance().getImage("images/Del_Annotation.png"));
        delAnnotationButton.setToolTip((IFigure)new Label("Remove Annotation..."));
        this.addButton((Clickable)delAnnotationButton);
        delAnnotationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                RemoveAnnotationDialog dialog = new RemoveAnnotationDialog(Display.getCurrent().getActiveShell(), xyGraph);
                if (dialog.open() == 0 && dialog.getAnnotation() != null) {
                    xyGraph.removeAnnotation(dialog.getAnnotation());
                    xyGraph.getOperationsManager().addCommand(new RemoveAnnotationCommand(xyGraph, dialog.getAnnotation()));
                }
            }
        });
        this.addSeparator();
        if ((flags & 4) > 0) {
            Button staggerButton = new Button(XYGraphMediaFactory.getInstance().getImage("images/stagger.png"));
            staggerButton.setToolTip((IFigure)new Label("Stagger axes so they don't overlap"));
            this.addButton((Clickable)staggerButton);
            staggerButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    xyGraph.performStagger();
                }
            });
        } else {
            Button autoScaleButton = new Button(XYGraphMediaFactory.getInstance().getImage("images/AutoScale.png"));
            autoScaleButton.setToolTip((IFigure)new Label("Perform Auto Scale"));
            this.addButton((Clickable)autoScaleButton);
            autoScaleButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    xyGraph.performAutoScale();
                }
            });
        }
        this.zoomGroup = new ButtonGroup();
        this.createZoomButtons(flags);
        this.addSeparator();
        this.addUndoRedoButtons();
        this.addSeparator();
        if (!SWT.getPlatform().startsWith("rap")) {
            this.addSnapshotButton();
        }
    }

    private void addSnapshotButton() {
        Button snapShotButton = new Button(XYGraphMediaFactory.getInstance().getImage("images/camera.png"));
        snapShotButton.setToolTip((IFigure)new Label("Save Snapshot to PNG file"));
        this.addButton((Clickable)snapShotButton);
        snapShotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ImageLoader loader = new ImageLoader();
                Image image = XYGraphToolbar.this.xyGraph.getImage();
                loader.data = new ImageData[]{image.getImageData()};
                image.dispose();
                String path = SingleSourceHelper.getImageSavePath();
                if (path == null || path.length() <= 0) {
                    return;
                }
                if (!path.toLowerCase().endsWith(".png")) {
                    path = String.valueOf(path) + ".png";
                }
                loader.save(path, 5);
            }
        });
    }

    private void addUndoRedoButtons() {
        final GrayableButton undoButton = new GrayableButton(XYGraphMediaFactory.getInstance().getImage("images/Undo.png"), XYGraphMediaFactory.getInstance().getImage("images/Undo_Gray.png"));
        undoButton.setToolTip((IFigure)new Label("Undo"));
        undoButton.setEnabled(false);
        this.addButton((Clickable)undoButton);
        undoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                XYGraphToolbar.this.xyGraph.getOperationsManager().undo();
            }
        });
        this.xyGraph.getOperationsManager().addListener(new IOperationsManagerListener(){

            @Override
            public void operationsHistoryChanged(OperationsManager manager) {
                if (manager.getUndoCommandsSize() > 0) {
                    undoButton.setEnabled(true);
                    String cmd_name = manager.getUndoCommands()[manager.getUndoCommandsSize() - 1].toString();
                    undoButton.setToolTip((IFigure)new Label("Undo" + cmd_name));
                } else {
                    undoButton.setEnabled(false);
                    undoButton.setToolTip((IFigure)new Label("Undo"));
                }
            }
        });
        final GrayableButton redoButton = new GrayableButton(XYGraphMediaFactory.getInstance().getImage("images/Redo.png"), XYGraphMediaFactory.getInstance().getImage("images/Redo_Gray.png"));
        redoButton.setToolTip((IFigure)new Label("Redo"));
        redoButton.setEnabled(false);
        this.addButton((Clickable)redoButton);
        redoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                XYGraphToolbar.this.xyGraph.getOperationsManager().redo();
            }
        });
        this.xyGraph.getOperationsManager().addListener(new IOperationsManagerListener(){

            @Override
            public void operationsHistoryChanged(OperationsManager manager) {
                if (manager.getRedoCommandsSize() > 0) {
                    redoButton.setEnabled(true);
                    String cmd_name = manager.getRedoCommands()[manager.getRedoCommandsSize() - 1].toString();
                    redoButton.setToolTip((IFigure)new Label("Redo" + cmd_name));
                } else {
                    redoButton.setEnabled(false);
                    redoButton.setToolTip((IFigure)new Label("Redo"));
                }
            }
        });
    }

    private void createZoomButtons(int flags) {
        ZoomType[] zoomTypeArray = ZoomType.values();
        int n = zoomTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            final ZoomType zoomType = zoomTypeArray[n2];
            if (zoomType.useWithFlags(flags)) {
                ImageFigure imageFigure = new ImageFigure(zoomType.getIconImage());
                Label tip = new Label(zoomType.getDescription());
                final ToggleButton button = new ToggleButton((IFigure)imageFigure);
                button.setBackgroundColor(ColorConstants.button);
                button.setOpaque(true);
                ToggleModel model = new ToggleModel();
                model.addChangeListener(new ChangeListener(){

                    public void handleStateChanged(ChangeEvent event) {
                        if (event.getPropertyName().equals("selected") && button.isSelected()) {
                            XYGraphToolbar.this.xyGraph.setZoomType(zoomType);
                        }
                    }
                });
                button.setModel((ButtonModel)model);
                button.setToolTip((IFigure)tip);
                this.addButton((Clickable)button);
                this.zoomGroup.add((ButtonModel)model);
                if (zoomType == ZoomType.NONE) {
                    this.zoomGroup.setDefault((ButtonModel)model);
                }
            }
            ++n2;
        }
    }

    public void addButton(Clickable button) {
        button.setPreferredSize(25, 25);
        this.add((IFigure)button);
    }

    public void addSeparator() {
        ToolbarSeparator separator = new ToolbarSeparator();
        separator.setPreferredSize(12, 25);
        this.add((IFigure)separator);
    }

    private static class ToolbarSeparator
    extends Figure {
        private final Color GRAY_COLOR = XYGraphMediaFactory.getInstance().getColor(new RGB(130, 130, 130));

        private ToolbarSeparator() {
        }

        protected void paintClientArea(Graphics graphics) {
            super.paintClientArea(graphics);
            graphics.setForegroundColor(this.GRAY_COLOR);
            graphics.setLineWidth(1);
            graphics.drawLine(this.bounds.x + this.bounds.width / 2, this.bounds.y, this.bounds.x + this.bounds.width / 2, this.bounds.y + this.bounds.height);
        }
    }
}

