/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.modules.statistics.internal;

import de.rcenvironment.toolkit.modules.concurrency.utils.ThreadsafeAutoCreationMap;
import de.rcenvironment.toolkit.modules.introspection.api.StatusCollectionContributor;
import de.rcenvironment.toolkit.modules.introspection.api.StatusCollectionRegistry;
import de.rcenvironment.toolkit.modules.statistics.api.CounterCategory;
import de.rcenvironment.toolkit.modules.statistics.api.StatisticsFilterLevel;
import de.rcenvironment.toolkit.modules.statistics.api.StatisticsTrackerService;
import de.rcenvironment.toolkit.modules.statistics.api.ValueEventCategory;
import de.rcenvironment.toolkit.modules.statistics.setup.StatisticsModuleConfiguration;
import de.rcenvironment.toolkit.modules.statistics.utils.CompactStacktraceBuilder;
import de.rcenvironment.toolkit.utils.internal.StringUtils;
import de.rcenvironment.toolkit.utils.text.TextLinesReceiver;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatisticsTrackerServiceImpl
implements StatisticsTrackerService {
    private static final CounterCategory NO_OPERATION_COUNTER = new NoOperationCounterCategory();
    private static final ValueEventCategory NO_OPERATION_EVENT_TRACKER = new NoOperationValueEventCategory();
    private static ThreadsafeAutoCreationMap<String, CounterCategoryImpl> counterMap;
    private static ThreadsafeAutoCreationMap<String, ValueEventCategoryImpl> valueTrackerMap;
    private final Set<String> categoriesAlreadyLoggedAsDisabled = new HashSet<String>();
    private final StatisticsFilterLevel globalFilterLevel;
    private final Log log = LogFactory.getLog(this.getClass());

    public StatisticsTrackerServiceImpl(StatisticsModuleConfiguration moduleConfiguration, StatusCollectionRegistry statusCollectionRegistry) {
        final CompactStacktraceBuilder defaultCompactStacktraceBuilder = moduleConfiguration.getDefaultCompactStacktraceBuilder();
        this.globalFilterLevel = moduleConfiguration.getStatisticsFilterLevel();
        counterMap = new ThreadsafeAutoCreationMap<String, CounterCategoryImpl>(){

            @Override
            protected CounterCategoryImpl createNewEntry(String key) {
                return new CounterCategoryImpl(defaultCompactStacktraceBuilder);
            }
        };
        valueTrackerMap = new ThreadsafeAutoCreationMap<String, ValueEventCategoryImpl>(){

            @Override
            protected ValueEventCategoryImpl createNewEntry(String key) {
                return new ValueEventCategoryImpl();
            }
        };
        statusCollectionRegistry.addContributor(new StatusCollectionContributor(){

            @Override
            public String getStandardDescription() {
                return "Statistics";
            }

            @Override
            public void printDefaultStateInformation(TextLinesReceiver receiver) {
                receiver.addLines(StatisticsTrackerServiceImpl.this.getFullReportAsStandardTextRepresentation(""));
            }

            @Override
            public String getUnfinishedOperationsDescription() {
                return null;
            }

            @Override
            public void printUnfinishedOperationsInformation(TextLinesReceiver receiver) {
            }
        });
    }

    @Override
    public CounterCategory getCounterCategory(String name) {
        return this.getCounterCategory(name, StatisticsFilterLevel.RELEASE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CounterCategory getCounterCategory(String categoryName, StatisticsFilterLevel filterLevel) {
        if (filterLevel.compareTo(this.globalFilterLevel) <= 0) {
            return counterMap.get(categoryName);
        }
        Set<String> set = this.categoriesAlreadyLoggedAsDisabled;
        synchronized (set) {
            if (!this.categoriesAlreadyLoggedAsDisabled.contains(categoryName)) {
                this.log.debug((Object)StringUtils.format("Returning a disabled receiver for category '%s' as it was requested with level %s while the global level is %s", new Object[]{categoryName, filterLevel, this.globalFilterLevel}));
                this.categoriesAlreadyLoggedAsDisabled.add(categoryName);
            }
        }
        return NO_OPERATION_COUNTER;
    }

    @Override
    public ValueEventCategory getValueEventCategory(String name) {
        return this.getValueEventCategory(name, StatisticsFilterLevel.RELEASE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueEventCategory getValueEventCategory(String categoryName, StatisticsFilterLevel filterLevel) {
        if (filterLevel.compareTo(this.globalFilterLevel) <= 0) {
            return valueTrackerMap.get(categoryName);
        }
        Set<String> set = this.categoriesAlreadyLoggedAsDisabled;
        synchronized (set) {
            if (!this.categoriesAlreadyLoggedAsDisabled.contains(categoryName)) {
                this.log.debug((Object)StringUtils.format("Returning a disabled receiver for category '%s' as it was requested with level %s while the global level is %s", new Object[]{categoryName, filterLevel, this.globalFilterLevel}));
                this.categoriesAlreadyLoggedAsDisabled.add(categoryName);
            }
        }
        return NO_OPERATION_EVENT_TRACKER;
    }

    @Override
    public Map<String, Map<String, String>> getFullReport() {
        TreeMap<String, Map<String, String>> result = new TreeMap<String, Map<String, String>>();
        Map<String, CounterCategoryImpl> countersSnapshot = counterMap.getShallowCopy();
        for (Map.Entry<String, CounterCategoryImpl> category : countersSnapshot.entrySet()) {
            Map<String, AtomicLong> categoryCopy = category.getValue().counters.getShallowCopy();
            Map<String, String> renderedCategoryCounters = this.renderCategoryCounters(categoryCopy);
            if (renderedCategoryCounters.isEmpty()) continue;
            result.put(category.getKey(), renderedCategoryCounters);
        }
        Map<String, ValueEventCategoryImpl> valueTrackersSnapshot = valueTrackerMap.getShallowCopy();
        for (Map.Entry<String, ValueEventCategoryImpl> category : valueTrackersSnapshot.entrySet()) {
            Map<String, String> existingMap;
            Map<String, ValueTrackerEntry> valueTrackersCopy = category.getValue().valueTrackerEntries.getShallowCopy();
            Map<String, String> renderedValueTrackers = this.renderValueTrackers(valueTrackersCopy);
            if (renderedValueTrackers.isEmpty() || (existingMap = result.put(category.getKey(), renderedValueTrackers)) == null) continue;
            renderedValueTrackers.putAll(existingMap);
        }
        return result;
    }

    @Override
    public Map<String, String> getReportForCategory(String category) {
        return this.renderCategoryCounters(counterMap.get(category).counters.getShallowCopy());
    }

    @Override
    public List<String> getFullReportAsStandardTextRepresentation() {
        return this.getFullReportAsStandardTextRepresentation("");
    }

    @Override
    public List<String> getFullReportAsStandardTextRepresentation(String linePrefix) {
        ArrayList<String> output = new ArrayList<String>();
        Map<String, Map<String, String>> report = this.getFullReport();
        for (Map.Entry<String, Map<String, String>> category : report.entrySet()) {
            output.add(StringUtils.format("%s%s", linePrefix, category.getKey()));
            for (Map.Entry<String, String> entry : category.getValue().entrySet()) {
                output.add(StringUtils.format("%s  %s - %s", linePrefix, entry.getValue(), entry.getKey()));
            }
        }
        return output;
    }

    private Map<String, String> renderCategoryCounters(Map<String, AtomicLong> categoryCopy) {
        TreeMap<String, String> categoryResult = new TreeMap<String, String>();
        for (Map.Entry<String, AtomicLong> entry : categoryCopy.entrySet()) {
            String rendered = StringUtils.format("%,d", entry.getValue().get());
            categoryResult.put(entry.getKey(), rendered);
        }
        return categoryResult;
    }

    private Map<String, String> renderValueTrackers(Map<String, ValueTrackerEntry> categoryCopy) {
        TreeMap<String, String> categoryResult = new TreeMap<String, String>();
        for (Map.Entry<String, ValueTrackerEntry> entry : categoryCopy.entrySet()) {
            String rendered = entry.getValue().render();
            categoryResult.put(entry.getKey(), rendered);
        }
        return categoryResult;
    }

    public static final class CounterCategoryImpl
    implements CounterCategory {
        private final ThreadsafeAutoCreationMap<String, AtomicLong> counters = new ThreadsafeAutoCreationMap<String, AtomicLong>(){

            @Override
            protected AtomicLong createNewEntry(String key) {
                return new AtomicLong();
            }
        };
        private final CompactStacktraceBuilder defaultCompactStacktraceBuilder;

        public CounterCategoryImpl(CompactStacktraceBuilder defaultCompactStacktraceBuilder) {
            this.defaultCompactStacktraceBuilder = defaultCompactStacktraceBuilder;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void count(String key) {
            this.counters.get(key).incrementAndGet();
        }

        @Override
        public void count(String key, long delta) {
            this.counters.get(key).addAndGet(delta);
        }

        @Override
        public void countClass(Object object) {
            if (object != null) {
                this.count(object.getClass().getName());
            } else {
                this.count("<null>");
            }
        }

        @Override
        public void countStacktrace() {
            this.count(this.defaultCompactStacktraceBuilder.getSingleLineStacktrace(1));
        }
    }

    private static final class NoOperationCounterCategory
    implements CounterCategory {
        private NoOperationCounterCategory() {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void countClass(Object object) {
        }

        @Override
        public void count(String key, long delta) {
        }

        @Override
        public void count(String key) {
        }

        @Override
        public void countStacktrace() {
        }
    }

    private static final class NoOperationValueEventCategory
    implements ValueEventCategory {
        private NoOperationValueEventCategory() {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void registerEvent(String key, long value) {
        }
    }

    public static final class ValueEventCategoryImpl
    implements ValueEventCategory {
        private final ThreadsafeAutoCreationMap<String, ValueTrackerEntry> valueTrackerEntries = new ThreadsafeAutoCreationMap<String, ValueTrackerEntry>(){

            @Override
            protected ValueTrackerEntry createNewEntry(String key) {
                return new ValueTrackerEntry();
            }
        };

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void registerEvent(String key, long value) {
            this.valueTrackerEntries.get(key).register(value);
        }
    }

    private static final class ValueTrackerEntry {
        private long n;
        private long min = Long.MAX_VALUE;
        private long max = Long.MIN_VALUE;
        private double sum;

        private ValueTrackerEntry() {
        }

        public synchronized void register(long value) {
            this.min = Math.min(this.min, value);
            this.max = Math.max(this.max, value);
            this.sum += (double)value;
            ++this.n;
        }

        public String render() {
            if (this.n == 0L) {
                return "-";
            }
            return StringUtils.format("Total %,.2f, Average %,.2f, Min %,d, Max %,d, counted %,d times", this.sum, this.sum / (double)this.n, this.min, this.max, this.n);
        }
    }
}

