/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.modules.concurrency.internal;

import de.rcenvironment.toolkit.modules.concurrency.api.TaskType;
import de.rcenvironment.toolkit.modules.concurrency.api.ThreadPoolType;
import de.rcenvironment.toolkit.modules.concurrency.setup.ConcurrencyModuleConfiguration;
import de.rcenvironment.toolkit.utils.internal.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ThreadPoolAllocater {
    private static final int DEFAULT_COMMON_THREAD_POOL_SIZE = 512;
    private static final int SIXTY = 60;
    private static final int TWENTY = 20;
    private static final String DEFAULT_THREAD_NAME_PREFIX = "LongRunningThreadPool-";
    private static ThreadPoolAllocater instance;
    private final Map<TaskType, ThreadPoolType> threadPoolTypeByTaskType;
    private final Map<ThreadPoolType, ExecutorService> threadPoolByType;
    private AtomicInteger poolIndex = new AtomicInteger(0);
    private AtomicInteger threadIndex = new AtomicInteger(0);
    private AtomicBoolean areThreadPoolsActive = new AtomicBoolean(false);
    private ThreadGroup currentThreadGroup;
    private int logicalCores;
    private final ConcurrencyModuleConfiguration configuration;
    private final Log log = LogFactory.getLog(this.getClass());

    private ThreadPoolAllocater(ConcurrencyModuleConfiguration configuration) {
        this.configuration = configuration;
        this.threadPoolTypeByTaskType = new HashMap<TaskType, ThreadPoolType>();
        this.threadPoolByType = new HashMap<ThreadPoolType, ExecutorService>();
        this.logicalCores = Runtime.getRuntime().availableProcessors();
        if (this.logicalCores < 8) {
            this.logicalCores = 8;
        }
        this.configureTaskToThreadPoolMapping();
        this.initializeThreadPools();
    }

    public static ThreadPoolAllocater getInstance(ConcurrencyModuleConfiguration configuration) {
        if (instance == null) {
            instance = new ThreadPoolAllocater(configuration);
        }
        return instance;
    }

    private void configureTaskToThreadPoolMapping() {
        this.threadPoolTypeByTaskType.put(TaskType.UNDEFINED, ThreadPoolType.BLOCKING);
        this.threadPoolTypeByTaskType.put(TaskType.FAST_NON_BLOCKING, ThreadPoolType.FAST_NON_BLOCKING);
        this.threadPoolTypeByTaskType.put(TaskType.COMPUTATION, ThreadPoolType.LONG_RUNNING);
        this.threadPoolTypeByTaskType.put(TaskType.LOCAL_IO_OPERATION, ThreadPoolType.BLOCKING);
        this.threadPoolTypeByTaskType.put(TaskType.NETWORK_IO_OPERATION, ThreadPoolType.BLOCKING);
        this.threadPoolTypeByTaskType.put(TaskType.LONG_RUNNING, ThreadPoolType.LONG_RUNNING);
        this.threadPoolTypeByTaskType.put(TaskType.INITIALIZATION_NON_BLOCKING, ThreadPoolType.FAST_NON_BLOCKING);
        this.threadPoolTypeByTaskType.put(TaskType.INITIALIZATION_BLOCKING, ThreadPoolType.BLOCKING);
        this.threadPoolTypeByTaskType.put(TaskType.NETWORK_BLOCKING, ThreadPoolType.BLOCKING);
        this.threadPoolTypeByTaskType.put(TaskType.LOCAL_BLOCKING, ThreadPoolType.BLOCKING);
        this.threadPoolTypeByTaskType.put(TaskType.SCHEDULED, ThreadPoolType.SCHEDULED);
        this.threadPoolTypeByTaskType.put(TaskType.OTHER, ThreadPoolType.BLOCKING);
        this.isMappingFeasable(this.threadPoolTypeByTaskType);
    }

    private void configureAndCreateThreadPoolsAndMapping(int activeThreads, ThreadFactory threadFactory) {
        this.threadPoolByType.put(ThreadPoolType.FAST_NON_BLOCKING, this.createCachedThreadPool(threadFactory));
        this.threadPoolByType.put(ThreadPoolType.LONG_RUNNING, this.createFixedThreadPool(threadFactory));
        this.threadPoolByType.put(ThreadPoolType.BLOCKING, this.createDynamicThreadPool(threadFactory));
        this.threadPoolByType.put(ThreadPoolType.SCHEDULED, this.createScheduledThreadPool(threadFactory));
    }

    public synchronized void initializeThreadPools() {
        if (this.areThreadPoolsActive.get()) {
            this.log.debug((Object)"Abort initializing Thread Pools as they are still active");
            return;
        }
        String mainPrefix = DEFAULT_THREAD_NAME_PREFIX;
        if (this.configuration.getThreadPoolName() != null) {
            mainPrefix = String.valueOf(this.configuration.getThreadPoolName()) + "-";
        }
        final ThreadGroup threadGroup = new ThreadGroup(String.valueOf(mainPrefix) + "ThreadGroup");
        final String threadNamePrefix = String.valueOf(mainPrefix) + this.poolIndex.incrementAndGet() + "-";
        this.threadIndex.set(0);
        this.currentThreadGroup = threadGroup;
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(threadGroup, runnable, String.valueOf(threadNamePrefix) + ThreadPoolAllocater.this.threadIndex.incrementAndGet());
            }
        };
        this.configureAndCreateThreadPoolsAndMapping(this.logicalCores, threadFactory);
    }

    public synchronized int shutdown() {
        this.log.debug((Object)"Shutting down thread pools");
        ArrayList<ExecutorService> threadPools = new ArrayList<ExecutorService>(this.threadPoolByType.values());
        ArrayList<Runnable> queuedTasks = new ArrayList<Runnable>();
        for (ExecutorService executor : threadPools) {
            queuedTasks.addAll(executor.shutdownNow());
        }
        this.areThreadPoolsActive.set(false);
        return queuedTasks.size();
    }

    private ExecutorService createCachedThreadPool(ThreadFactory threadFactory) {
        return Executors.newCachedThreadPool(threadFactory);
    }

    private ExecutorService createFixedThreadPool(ThreadFactory threadFactory) {
        return Executors.newFixedThreadPool(this.logicalCores, threadFactory);
    }

    private ExecutorService createDynamicThreadPool(ThreadFactory threadFactory) {
        int maxThreads = 20 * this.logicalCores;
        LinkedTransferQueue<Runnable> queue = new LinkedTransferQueue<Runnable>(){
            private static final long serialVersionUID = -6450720761907180910L;

            @Override
            public boolean offer(Runnable r) {
                return this.tryTransfer(r);
            }
        };
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.logicalCores, maxThreads, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)queue, threadFactory);
        executor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    executor.getQueue().put(r);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        return executor;
    }

    private ExecutorService createScheduledThreadPool(ThreadFactory threadFactory) {
        return Executors.newScheduledThreadPool(this.logicalCores, threadFactory);
    }

    public ExecutorService getNullSafeThreadPoolExecutor(TaskType taskType) {
        ExecutorService snapshot = this.threadPoolByType.get((Object)this.threadPoolTypeByTaskType.get((Object)taskType));
        if (snapshot != null) {
            return snapshot;
        }
        throw new RejectedExecutionException();
    }

    public ScheduledExecutorService getNullSafeScheduledExecutorService(TaskType taskType) {
        ExecutorService executorService = this.getNullSafeThreadPoolExecutor(taskType);
        if (executorService instanceof ScheduledExecutorService) {
            return (ScheduledExecutorService)executorService;
        }
        throw new IllegalArgumentException(StringUtils.format("Given TaskType %s can not be executed by a scheduled thread pool", taskType.getName()));
    }

    public int getCurrentThreadCount() {
        return this.currentThreadGroup.activeCount();
    }

    private void isMappingFeasable(Map<TaskType, ThreadPoolType> mapping) {
        if (mapping.size() != TaskType.values().length) {
            throw new IllegalStateException("Not all task types have a corresponding thread pool");
        }
        for (Map.Entry<TaskType, ThreadPoolType> entry : mapping.entrySet()) {
            if (entry.getKey().isBlocking() != entry.getValue().handlesBlockingTasks()) {
                throw new IllegalStateException("");
            }
            if (entry.getKey().equals((Object)TaskType.SCHEDULED) || !entry.getValue().equals((Object)ThreadPoolType.SCHEDULED)) continue;
            throw new IllegalStateException("Non-scheduled tasks are mapped to the scheduling thread pool.");
        }
    }
}

