/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.modules.concurrency.internal;

import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskType;
import de.rcenvironment.toolkit.modules.concurrency.api.ThreadPoolManagementAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.threadcontext.ThreadContext;
import de.rcenvironment.toolkit.modules.concurrency.api.threadcontext.ThreadContextHolder;
import de.rcenvironment.toolkit.modules.concurrency.api.threadcontext.ThreadContextMemento;
import de.rcenvironment.toolkit.modules.concurrency.internal.ThreadPoolAllocater;
import de.rcenvironment.toolkit.modules.concurrency.setup.ConcurrencyModuleConfiguration;
import de.rcenvironment.toolkit.modules.introspection.api.StatusCollectionContributor;
import de.rcenvironment.toolkit.modules.introspection.api.StatusCollectionRegistry;
import de.rcenvironment.toolkit.utils.internal.StringUtils;
import de.rcenvironment.toolkit.utils.text.TextLinesReceiver;
import de.rcenvironment.toolkit.utils.text.impl.BufferingTextLinesReceiver;
import de.rcenvironment.toolkit.utils.text.impl.MultiLineOutputWrapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AsyncTaskServiceImpl
implements AsyncTaskService,
ThreadPoolManagementAccess {
    private static final float NANOS_TO_MSEC_RATIO = 1000000.0f;
    private static final String UNDEFINDED_CATEGORY = "Undefined";
    private Map<String, StatisticsEntry> statisticsEntriesByCategoryName;
    private final Log log = LogFactory.getLog(this.getClass());
    private final ConcurrencyModuleConfiguration configuration;
    private ThreadPoolAllocater threadPoolAllocater;

    public AsyncTaskServiceImpl(ConcurrencyModuleConfiguration configuration, StatusCollectionRegistry statusCollectionRegistry) {
        this.configuration = configuration;
        this.threadPoolAllocater = ThreadPoolAllocater.getInstance(this.configuration);
        this.initialize();
        statusCollectionRegistry.addContributor(new StatusCollectionContributor(){

            @Override
            public String getStandardDescription() {
                return "Asynchronous Tasks";
            }

            @Override
            public void printDefaultStateInformation(TextLinesReceiver receiver) {
                AsyncTaskServiceImpl.this.renderStatistics(false, true, receiver);
            }

            @Override
            public String getUnfinishedOperationsDescription() {
                return null;
            }

            @Override
            public void printUnfinishedOperationsInformation(TextLinesReceiver receiver) {
            }
        });
    }

    @Override
    @Deprecated
    public void execute(String categoryName, Runnable runnable) {
        this.execute(categoryName, null, runnable);
    }

    @Override
    @Deprecated
    public void execute(String categoryName, String taskId, Runnable runnable) {
        this.execute(TaskType.UNDEFINED, categoryName, taskId, runnable);
    }

    @Override
    @Deprecated
    public Future<?> submit(Runnable task) {
        return this.submit(task, null);
    }

    @Override
    @Deprecated
    public Future<?> submit(String categoryName, Runnable task) {
        return this.submit(TaskType.UNDEFINED, categoryName, task);
    }

    @Override
    @Deprecated
    public Future<?> submit(Runnable runnable, String taskId) {
        return this.submit(TaskType.UNDEFINED, null, taskId, runnable);
    }

    @Override
    @Deprecated
    public Future<?> submit(String categoryName, String taskId, Runnable runnable) {
        return this.submit(TaskType.UNDEFINED, categoryName, taskId, runnable);
    }

    @Override
    @Deprecated
    public <T> Future<T> submit(Callable<T> task) {
        return this.submit(task, null);
    }

    @Override
    @Deprecated
    public <T> Future<T> submit(String categoryName, Callable<T> task) {
        return this.submit(categoryName, null, task);
    }

    @Override
    @Deprecated
    public <T> Future<T> submit(Callable<T> task, String taskId) {
        return this.submit(TaskType.UNDEFINED, null, taskId, task);
    }

    @Override
    @Deprecated
    public <T> Future<T> submit(String categoryName, String taskId, Callable<T> task) {
        return this.submit(TaskType.UNDEFINED, categoryName, taskId, task);
    }

    @Override
    @Deprecated
    public ScheduledFuture<?> scheduleAfterDelay(Runnable runnable, long delayMsec) {
        return this.scheduleAfterDelay(TaskType.SCHEDULED, null, runnable, delayMsec);
    }

    @Override
    @Deprecated
    public ScheduledFuture<?> scheduleAfterDelay(String categoryName, Runnable runnable, long delayMsec) {
        return this.scheduleAfterDelay(TaskType.SCHEDULED, categoryName, runnable, delayMsec);
    }

    @Override
    @Deprecated
    public <T> ScheduledFuture<T> scheduleAfterDelay(String categoryName, Callable<T> callable, long delayMsec) {
        return this.scheduleAfterDelay(TaskType.SCHEDULED, categoryName, callable, delayMsec);
    }

    @Override
    @Deprecated
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long repetitionDelayMsec) {
        return this.scheduleAtFixedRate(TaskType.SCHEDULED, null, runnable, repetitionDelayMsec);
    }

    @Override
    @Deprecated
    public ScheduledFuture<?> scheduleAtFixedRate(String categoryName, Runnable runnable, long repetitionDelayMsec) {
        return this.scheduleAtFixedRate(TaskType.SCHEDULED, categoryName, runnable, repetitionDelayMsec);
    }

    @Override
    @Deprecated
    public ScheduledFuture<?> scheduleAtFixedInterval(String categoryName, Runnable runnable, long repetitionDelayMsec) {
        return this.scheduleAtFixedInterval(TaskType.SCHEDULED, categoryName, runnable, repetitionDelayMsec);
    }

    @Override
    @Deprecated
    public ScheduledFuture<?> scheduleAtFixedRateAfterDelay(Runnable runnable, long initialDelayMsec, long repetitionDelayMsec) {
        return this.scheduleAtFixedRateAfterDelay(TaskType.SCHEDULED, null, runnable, initialDelayMsec, repetitionDelayMsec);
    }

    @Override
    @Deprecated
    public ScheduledFuture<?> scheduleAtFixedRateAfterDelay(String categoryName, Runnable runnable, long initialDelayMsec, long repetitionDelayMsec) {
        return this.scheduleAtFixedRateAfterDelay(TaskType.SCHEDULED, categoryName, runnable, initialDelayMsec, repetitionDelayMsec);
    }

    @Override
    @Deprecated
    public ScheduledFuture<?> scheduleAtFixedIntervalAfterInitialDelay(String categoryName, Runnable runnable, long initialDelayMsec, long repetitionDelayMsec) {
        return this.scheduleAtFixedIntervalAfterInitialDelay(TaskType.SCHEDULED, categoryName, runnable, initialDelayMsec, repetitionDelayMsec);
    }

    @Override
    public int shutdown() {
        return this.threadPoolAllocater.shutdown();
    }

    @Override
    public int reset() {
        int unfinishedCount = this.shutdown();
        this.initialize();
        return unfinishedCount;
    }

    @Override
    public int getCurrentThreadCount() {
        return this.threadPoolAllocater.getCurrentThreadCount();
    }

    @Override
    public String getFormattedStatistics(boolean addTaskIds) {
        return this.getFormattedStatistics(addTaskIds, true);
    }

    @Override
    public String getFormattedStatistics(boolean addTaskIds, boolean includeInactive) {
        BufferingTextLinesReceiver lineBuffer = new BufferingTextLinesReceiver();
        this.renderStatistics(addTaskIds, includeInactive, lineBuffer);
        return new MultiLineOutputWrapper(lineBuffer.getCollectedLines()).asMultilineString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderStatistics(boolean addTaskIds, boolean includeInactive, TextLinesReceiver receiver) {
        StringBuilder lineBuffer = new StringBuilder(512);
        TreeMap<String, StatisticsEntry> sortedMap = new TreeMap<String, StatisticsEntry>();
        Map<String, StatisticsEntry> map = this.statisticsEntriesByCategoryName;
        synchronized (map) {
            for (StatisticsEntry statisticsEntry : this.statisticsEntriesByCategoryName.values()) {
                if (statisticsEntry.activeTasks == 0 && !includeInactive) continue;
                sortedMap.put(statisticsEntry.getCategoryName(), statisticsEntry);
            }
        }
        for (Map.Entry entry : sortedMap.entrySet()) {
            StatisticsEntry statsEntry;
            String taskName = (String)entry.getKey();
            StatisticsEntry statisticsEntry = statsEntry = (StatisticsEntry)entry.getValue();
            synchronized (statisticsEntry) {
                receiver.addLine(taskName);
                lineBuffer.setLength(0);
                lineBuffer.append("    ");
                statsEntry.printFormatted(lineBuffer);
                receiver.addLine(lineBuffer.toString());
                if (addTaskIds) {
                    if (statsEntry.activeTaskIds != null && !statsEntry.activeTaskIds.isEmpty()) {
                        receiver.addLine("        Named tasks:");
                        lineBuffer.setLength(0);
                        for (Map.Entry entry2 : statsEntry.activeTaskIds.entrySet()) {
                            receiver.addLine(StringUtils.format("          %s [%s]", entry2.getKey(), ((Thread)entry2.getValue()).getName()));
                        }
                    }
                    if (statsEntry.anonymousTaskThreads != null && !statsEntry.anonymousTaskThreads.isEmpty()) {
                        receiver.addLine("        Anonymous task threads:");
                        for (Thread thread : statsEntry.anonymousTaskThreads) {
                            receiver.addLine(StringUtils.format("          [%s]", thread.getName()));
                        }
                    }
                }
            }
        }
    }

    private void logExecutionRejectedAfterShutdown(String category) {
        this.log.debug((Object)("Ignoring request to execute task of category '" + category + "' as the thread pool has been shut down (java.util.concurrent.RejectedExecutionException)"));
    }

    private void initialize() {
        this.threadPoolAllocater.initializeThreadPools();
        this.statisticsEntriesByCategoryName = Collections.synchronizedMap(new HashMap());
        if (this.configuration.getPeriodicTaskLoggingIntervalMsec() > 0) {
            this.scheduleAtFixedRate(new Runnable(){

                @Override
                @TaskDescription(value="Thread pool debug logging")
                public void run() {
                    AsyncTaskServiceImpl.this.log.debug((Object)("Current combined thread pool size: " + AsyncTaskServiceImpl.this.getCurrentThreadCount() + "; Asynchronous tasks:\n" + AsyncTaskServiceImpl.this.getFormattedStatistics(false, true)));
                }
            }, this.configuration.getPeriodicTaskLoggingIntervalMsec());
        }
    }

    private StatisticsEntry getStatisticsEntry(String categoryName) {
        if (categoryName == null) {
            categoryName = UNDEFINDED_CATEGORY;
        }
        return this.statisticsEntriesByCategoryName.computeIfAbsent(categoryName, arg_0 -> StatisticsEntry.new(this, arg_0));
    }

    @Override
    public void execute(TaskType taskType, String categoryName, Runnable task) {
        this.execute(taskType, categoryName, null, task);
    }

    @Override
    public void execute(TaskType taskType, String categoryName, String taskId, Runnable task) {
        try {
            this.threadPoolAllocater.getNullSafeThreadPoolExecutor(taskType).execute(new WrappedRunnable(task, this.getStatisticsEntry(categoryName), taskId));
        }
        catch (RejectedExecutionException e) {
            this.logExecutionRejectedAfterShutdown(categoryName);
            throw e;
        }
    }

    @Override
    public Future<?> submit(TaskType taskType, String categoryName, Runnable task) {
        return this.submit(taskType, categoryName, null, task);
    }

    @Override
    public Future<?> submit(TaskType taskType, String categoryName, String taskId, Runnable task) {
        try {
            return this.threadPoolAllocater.getNullSafeThreadPoolExecutor(taskType).submit(new WrappedRunnable(task, this.getStatisticsEntry(categoryName), taskId));
        }
        catch (RejectedExecutionException e) {
            this.logExecutionRejectedAfterShutdown(categoryName);
            throw e;
        }
    }

    @Override
    public <T> Future<T> submit(TaskType taskType, String categoryName, Callable<T> task) {
        return this.submit(taskType, categoryName, null, task);
    }

    @Override
    public <T> Future<T> submit(TaskType taskType, String categoryName, String taskId, Callable<T> task) {
        try {
            return this.threadPoolAllocater.getNullSafeThreadPoolExecutor(taskType).submit(new WrappedCallable<T>(task, this.getStatisticsEntry(categoryName), taskId));
        }
        catch (RejectedExecutionException e) {
            this.logExecutionRejectedAfterShutdown(categoryName);
            throw e;
        }
    }

    @Override
    public ScheduledFuture<?> scheduleAfterDelay(TaskType taskType, String categoryName, Runnable task, long delayMsec) {
        try {
            return this.threadPoolAllocater.getNullSafeScheduledExecutorService(taskType).schedule(new WrappedRunnable(task, this.getStatisticsEntry(categoryName), null), delayMsec, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            this.logExecutionRejectedAfterShutdown(categoryName);
            throw e;
        }
    }

    @Override
    public <T> ScheduledFuture<T> scheduleAfterDelay(TaskType taskType, String categoryName, Callable<T> callable, long delayMsec) {
        try {
            return this.threadPoolAllocater.getNullSafeScheduledExecutorService(taskType).schedule(new WrappedCallable<T>(callable, this.getStatisticsEntry(categoryName), null), delayMsec, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            this.logExecutionRejectedAfterShutdown(categoryName);
            throw e;
        }
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(TaskType taskType, String categoryName, Runnable runnable, long repetitionDelayMsec) {
        return this.scheduleAtFixedRateAfterDelay(taskType, categoryName, runnable, repetitionDelayMsec, repetitionDelayMsec);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedInterval(TaskType taskType, String categoryName, Runnable runnable, long repetitionDelayMsec) {
        return this.scheduleAtFixedIntervalAfterInitialDelay(taskType, categoryName, runnable, repetitionDelayMsec, repetitionDelayMsec);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRateAfterDelay(TaskType taskType, String categoryName, Runnable runnable, long initialDelayMsec, long repetitionDelayMsec) {
        try {
            return this.threadPoolAllocater.getNullSafeScheduledExecutorService(taskType).scheduleAtFixedRate(new WrappedRunnable(runnable, this.getStatisticsEntry(categoryName), null), initialDelayMsec, repetitionDelayMsec, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            this.logExecutionRejectedAfterShutdown(categoryName);
            throw e;
        }
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedIntervalAfterInitialDelay(TaskType taskType, String categoryName, Runnable runnable, long initialDelayMsec, long repetitionDelayMsec) {
        try {
            return this.threadPoolAllocater.getNullSafeScheduledExecutorService(taskType).scheduleWithFixedDelay(new WrappedRunnable(runnable, this.getStatisticsEntry(categoryName), null), initialDelayMsec, repetitionDelayMsec, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            this.logExecutionRejectedAfterShutdown(categoryName);
            throw e;
        }
    }

    private final class StatisticsEntry {
        private int activeTasks;
        private int maxParallel;
        private int completedTasks;
        private int exceptionCount;
        private long maxNormalCompletionTime;
        private long totalCompletionTime;
        private Map<String, Thread> activeTaskIds;
        private Set<Thread> anonymousTaskThreads;
        private final String categoryName;

        StatisticsEntry(String categoryName) {
            this.categoryName = categoryName;
        }

        public String getCategoryName() {
            return this.categoryName;
        }

        private synchronized void beforeExecution(String taskId) {
            ++this.activeTasks;
            if (this.activeTasks > this.maxParallel) {
                this.maxParallel = this.activeTasks;
            }
            if (taskId != null) {
                Thread replaced;
                if (this.activeTaskIds == null) {
                    this.activeTaskIds = new HashMap<String, Thread>();
                }
                if ((replaced = this.activeTaskIds.put(taskId, Thread.currentThread())) != null) {
                    AsyncTaskServiceImpl.this.log.warn((Object)StringUtils.format("Task id '%s' used more than once for task '%s' (existing: %s, new: %s)", taskId, this.categoryName, replaced.getName(), Thread.currentThread().getName()), (Throwable)new RuntimeException());
                }
            } else {
                if (this.anonymousTaskThreads == null) {
                    this.anonymousTaskThreads = new HashSet<Thread>();
                }
                if (!this.anonymousTaskThreads.add(Thread.currentThread())) {
                    AsyncTaskServiceImpl.this.log.error((Object)("Consistency error: Thread " + Thread.currentThread() + " is already in the set of active tasks"));
                }
            }
        }

        private synchronized void afterExecution(String taskId, long duration, boolean exception) {
            this.totalCompletionTime += duration;
            ++this.completedTasks;
            --this.activeTasks;
            if (taskId != null) {
                Thread removed;
                if (this.activeTaskIds == null) {
                    AsyncTaskServiceImpl.this.log.error((Object)"Consistency error: Non-null task id finished, but active set not initialized");
                    this.activeTaskIds = new HashMap<String, Thread>();
                }
                if ((removed = this.activeTaskIds.remove(taskId)) == null) {
                    AsyncTaskServiceImpl.this.log.warn((Object)StringUtils.format("No registered task id '%s' for task '%s'; was there an id collision before?", taskId, this.categoryName));
                }
            } else if (!this.anonymousTaskThreads.remove(Thread.currentThread())) {
                AsyncTaskServiceImpl.this.log.error((Object)("Consistency error: Thread " + Thread.currentThread() + " was not in the set of active tasks"));
            }
            if (exception) {
                ++this.exceptionCount;
            } else if (duration > this.maxNormalCompletionTime) {
                this.maxNormalCompletionTime = duration;
            }
        }

        private void printFormatted(StringBuilder sb) {
            int numCompleted = this.completedTasks;
            int numActive = this.activeTasks;
            sb.append("Active: ");
            sb.append(numActive);
            sb.append(", Completed: ");
            sb.append(numCompleted);
            sb.append(", MaxParallel: ");
            sb.append(this.maxParallel);
            if (numCompleted > 0) {
                long totalTimeNanos = this.totalCompletionTime;
                float avgTimeMsec = (float)totalTimeNanos / 1000000.0f / (float)numCompleted;
                sb.append(", AvgTime: ");
                sb.append(avgTimeMsec);
                sb.append(" msec, Total: ");
                sb.append((float)totalTimeNanos / 1000000.0f);
                sb.append(" msec, MaxTime: ");
                sb.append((float)this.maxNormalCompletionTime / 1000000.0f);
                sb.append(" msec");
            }
            if (this.exceptionCount > 0) {
                sb.append(", Exceptions: ");
                sb.append(this.exceptionCount);
            }
        }
    }

    private class WrappedCallable<T>
    implements Callable<T> {
        private final Callable<T> innerCallable;
        private final String taskId;
        private final ThreadContext contextObject;
        private final StatisticsEntry statisticsEntry;

        WrappedCallable(Callable<T> callable, StatisticsEntry statisticsEntry, String taskId) {
            this.innerCallable = callable;
            this.statisticsEntry = statisticsEntry;
            this.taskId = taskId;
            this.contextObject = ThreadContextHolder.getCurrentContext();
        }

        @Override
        public T call() throws Exception {
            T result;
            ThreadContextMemento previousThreadContext = ThreadContextHolder.setCurrentContext(this.contextObject);
            long startTime = System.nanoTime();
            this.statisticsEntry.beforeExecution(this.taskId);
            boolean exception = false;
            try {
                try {
                    result = this.innerCallable.call();
                }
                catch (RejectedExecutionException e) {
                    AsyncTaskServiceImpl.this.log.debug((Object)("Execution of Callable for task " + this.statisticsEntry.getCategoryName() + " was rejected, typically because the thread pool is shutting down; detail information: " + e.toString()));
                    exception = true;
                    throw e;
                }
                catch (RuntimeException e) {
                    AsyncTaskServiceImpl.this.log.warn((Object)("Unhandled exception in Callable for task " + this.statisticsEntry.getCategoryName()), (Throwable)e);
                    exception = true;
                    throw e;
                }
            }
            finally {
                long duration = System.nanoTime() - startTime;
                this.statisticsEntry.afterExecution(this.taskId, duration, exception);
                previousThreadContext.restore();
            }
            if (Thread.interrupted()) {
                AsyncTaskServiceImpl.this.log.debug((Object)StringUtils.format("Thread %s was interrupted after running task '%s', resetting flag", Thread.currentThread().getName(), this.statisticsEntry.getCategoryName()));
            }
            return result;
        }
    }

    private final class WrappedRunnable
    implements Runnable {
        private final Runnable innerRunnable;
        private final String taskId;
        private final ThreadContext contextObject;
        private final StatisticsEntry statisticsEntry;

        WrappedRunnable(Runnable runnable, StatisticsEntry statisticsEntry, String taskId) {
            this.innerRunnable = runnable;
            this.statisticsEntry = statisticsEntry;
            this.taskId = taskId;
            this.contextObject = ThreadContextHolder.getCurrentContext();
        }

        @Override
        public void run() {
            ThreadContextMemento previousThreadContext = ThreadContextHolder.setCurrentContext(this.contextObject);
            long startTime = System.nanoTime();
            this.statisticsEntry.beforeExecution(this.taskId);
            boolean exception = false;
            try {
                try {
                    this.innerRunnable.run();
                }
                catch (RejectedExecutionException e) {
                    AsyncTaskServiceImpl.this.log.debug((Object)("Execution of Runnable for task " + this.statisticsEntry.getCategoryName() + " was rejected, typically because the thread pool is shutting down; detail information: " + e.toString()));
                    exception = true;
                }
                catch (RuntimeException e) {
                    AsyncTaskServiceImpl.this.log.warn((Object)("Unhandled exception in Runnable for task " + this.statisticsEntry.getCategoryName()), (Throwable)e);
                    exception = true;
                }
            }
            finally {
                long duration = System.nanoTime() - startTime;
                this.statisticsEntry.afterExecution(this.taskId, duration, exception);
                previousThreadContext.restore();
            }
            if (Thread.interrupted()) {
                AsyncTaskServiceImpl.this.log.debug((Object)StringUtils.format("Thread %s was interrupted after running task '%s', resetting flag", Thread.currentThread().getName(), this.statisticsEntry.getCategoryName()));
            }
        }
    }
}

