/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.xml.merger.execution;

import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.component.xml.XmlComponentHistoryDataItem;
import de.rcenvironment.core.component.xml.api.EndpointXMLService;
import de.rcenvironment.core.datamodel.api.DataTypeException;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.xml.XMLException;
import de.rcenvironment.core.utils.common.xml.api.XMLMapperService;
import de.rcenvironment.core.utils.common.xml.api.XMLSupportService;
import de.rcenvironment.toolkit.utils.text.AbstractTextLinesReceiver;
import de.rcenvironment.toolkit.utils.text.TextLinesReceiver;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class XmlMergerComponent
extends DefaultComponent {
    private static final String FAILED_TO_DELETE_TEMP_FILE = "Failed to delete temp file: ";
    private static final Log LOG = LogFactory.getLog(XmlMergerComponent.class);
    private ComponentContext componentContext;
    private ComponentDataManagementService dataManagementService;
    private EndpointXMLService endpointXmlUtils;
    private XMLMapperService xmlMapper;
    private XmlComponentHistoryDataItem historyDataItem = null;
    private XMLSupportService xmlSupport;
    private File tempMainFile = null;
    private File tempIntegratingFile = null;
    private File resultFile = null;
    private File xsltFile = null;

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }

    public void start() throws ComponentException {
        this.dataManagementService = (ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class);
        this.xmlSupport = (XMLSupportService)this.componentContext.getService(XMLSupportService.class);
        this.xmlMapper = (XMLMapperService)this.componentContext.getService(XMLMapperService.class);
        this.endpointXmlUtils = (EndpointXMLService)this.componentContext.getService(EndpointXMLService.class);
    }

    public void processInputs() throws ComponentException {
        FileReferenceTD fileReference;
        String mappingType;
        String mappingContent;
        this.initializeNewHistoryDataItem();
        TempFileService tempFileService = TempFileServiceAccess.getInstance();
        if (this.componentContext.getConfigurationValue("mappingFileDeployment").equals("loaded")) {
            mappingContent = this.componentContext.getConfigurationValue("xmlContent");
            mappingType = this.componentContext.getConfigurationValue("mappingType");
            if (mappingContent == null || mappingContent.isEmpty() || mappingType == null) {
                throw new ComponentException("No mapping file and/or no mapping type defined for XML Merger.");
            }
        } else {
            FileReferenceTD mappingFile = (FileReferenceTD)this.componentContext.readInput("Mapping file");
            try {
                File tempmappingFile = tempFileService.createTempFileFromPattern("XMLMappingFile*");
                this.dataManagementService.copyReferenceToLocalFile(mappingFile.getFileReference(), tempmappingFile, this.componentContext.getStorageNetworkDestination());
                mappingContent = FileUtils.readFileToString((File)tempmappingFile);
                mappingType = mappingFile.getFileName().endsWith("xml") ? "Classic" : "XSLT";
                if (mappingContent == null || mappingContent.isEmpty() || mappingType == null) {
                    throw new ComponentException("No mapping file and/or no mapping type defined for XML Merger.");
                }
            }
            catch (IOException iOException) {
                throw new ComponentException("Mapping file from input could not be read.");
            }
        }
        FileReferenceTD mainXML = (FileReferenceTD)this.componentContext.readInput("XML");
        FileReferenceTD xmlToIntegrate = (FileReferenceTD)this.componentContext.readInput("XML to integrate");
        this.tempMainFile = null;
        this.tempIntegratingFile = null;
        this.resultFile = null;
        this.xsltFile = null;
        try {
            this.tempMainFile = tempFileService.createTempFileFromPattern("XMLMerger-*.xml");
            this.tempIntegratingFile = tempFileService.createTempFileFromPattern("XMLMerger-to-integrate-*.xml");
            this.dataManagementService.copyReferenceToLocalFile(mainXML.getFileReference(), this.tempMainFile, this.componentContext.getStorageNetworkDestination());
            this.dataManagementService.copyReferenceToLocalFile(xmlToIntegrate.getFileReference(), this.tempIntegratingFile, this.componentContext.getStorageNetworkDestination());
        }
        catch (IOException e) {
            throw new ComponentException("Failed to write XML file into a temporary file (that is required for XML Merger)", (Throwable)e);
        }
        HashMap<String, TypedDatum> variableInputs = new HashMap<String, TypedDatum>();
        for (String inputName : this.componentContext.getInputsWithDatum()) {
            if (!this.componentContext.isDynamicInput(inputName) || inputName.equals("Mapping file")) continue;
            variableInputs.put(inputName, this.componentContext.readInput(inputName));
        }
        if (!variableInputs.isEmpty()) {
            try {
                this.endpointXmlUtils.updateXMLWithInputs(this.tempMainFile, variableInputs, this.componentContext);
            }
            catch (DataTypeException e) {
                throw new ComponentException("Failed to add dynamic input values to the XML file", (Throwable)e);
            }
            try {
                String xmlVariableIn = this.dataManagementService.createTaggedReferenceFromLocalFile(this.componentContext, this.tempMainFile, "xmlWithVariablees.xml");
                if (this.historyDataItem != null && !variableInputs.isEmpty()) {
                    this.historyDataItem.setXmlWithVariablesFileReference(xmlVariableIn);
                }
            }
            catch (IOException e) {
                String errorMessage = "Failed to store XML file with dynamic input values into the data management; it will not be available in the workflow data browser";
                String errorId = LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)LogFactory.getLog(XmlMergerComponent.class), (String)errorMessage, (Throwable)e);
                this.componentContext.getLog().componentError(errorMessage, (Throwable)e, errorId);
            }
        }
        if (mappingType.equals("XSLT")) {
            this.componentContext.getLog().componentInfo("XSL transformation is applied");
            try {
                this.xsltFile = tempFileService.createTempFileFromPattern("xsltMapping*.xsl");
                this.resultFile = tempFileService.createTempFileFromPattern("resultXML*.xml");
                String tempFilePath = this.tempIntegratingFile.getCanonicalPath().replaceAll("\\\\", "/");
                mappingContent = mappingContent.replaceAll("INTEGRATING_INPUT", tempFilePath);
                FileUtils.writeStringToFile((File)this.xsltFile, (String)mappingContent);
            }
            catch (IOException e) {
                throw new ComponentException("Failed to write XSLT mapping file into a temporary file (that is required for XML Merger)", (Throwable)e);
            }
            try {
                this.xmlMapper.transformXMLFileWithXSLT(this.tempMainFile, this.resultFile, this.xsltFile, (TextLinesReceiver)new XMLMergerTextLinesReceiver());
            }
            catch (XMLException e) {
                throw new ComponentException("XSL transformation failed", (Throwable)e);
            }
            this.componentContext.getLog().componentInfo("XSL transformation successful");
        } else if (mappingType.equals("Classic")) {
            this.componentContext.getLog().componentInfo("XML mapping is applied");
            this.resultFile = this.map(this.tempMainFile, this.tempIntegratingFile, mappingContent);
            if (this.tempMainFile == null || this.tempIntegratingFile == null || this.resultFile == null) {
                throw new ComponentException("Something does not perform correct in XML Merger component during classic mapping. All files are not filled properly.");
            }
            this.componentContext.getLog().componentInfo("XML mapping successful");
        }
        try {
            this.endpointXmlUtils.updateOutputsFromXML(this.resultFile, this.componentContext);
        }
        catch (DataTypeException e) {
            throw new ComponentException("Failed to extract dynamic output values from the merged XML file", (Throwable)e);
        }
        try {
            fileReference = this.dataManagementService.createFileReferenceTDFromLocalFile(this.componentContext, this.resultFile, String.valueOf(this.componentContext.getInstanceName()) + ".xml");
        }
        catch (IOException e) {
            throw new ComponentException("Failed to store merged XML file into the data management - if it is not stored in the data management, it can not be sent as output value", (Throwable)e);
        }
        this.componentContext.writeOutput("XML", (TypedDatum)fileReference);
        this.storeHistoryDataItem();
        this.deleteTempFiles();
    }

    public void completeStartOrProcessInputsAfterFailure() throws ComponentException {
        this.storeHistoryDataItem();
        this.deleteTempFiles();
    }

    private void deleteTempFiles() {
        TempFileService tempFileService = TempFileServiceAccess.getInstance();
        try {
            if (this.tempMainFile != null) {
                tempFileService.disposeManagedTempDirOrFile(this.tempMainFile);
            }
        }
        catch (IOException e) {
            LOG.error((Object)(FAILED_TO_DELETE_TEMP_FILE + this.tempMainFile.getAbsolutePath()), (Throwable)e);
        }
        try {
            if (this.tempIntegratingFile != null) {
                tempFileService.disposeManagedTempDirOrFile(this.tempIntegratingFile);
            }
        }
        catch (IOException e) {
            LOG.error((Object)(FAILED_TO_DELETE_TEMP_FILE + this.tempIntegratingFile.getAbsolutePath()), (Throwable)e);
        }
        try {
            if (this.resultFile != null) {
                tempFileService.disposeManagedTempDirOrFile(this.resultFile);
            }
        }
        catch (IOException e) {
            LOG.error((Object)(FAILED_TO_DELETE_TEMP_FILE + this.resultFile.getAbsolutePath()), (Throwable)e);
        }
        try {
            if (this.xsltFile != null) {
                tempFileService.disposeManagedTempDirOrFile(this.xsltFile);
            }
        }
        catch (IOException e) {
            LOG.error((Object)(FAILED_TO_DELETE_TEMP_FILE + this.xsltFile.getAbsolutePath()), (Throwable)e);
        }
    }

    private void initializeNewHistoryDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.historyDataItem = new XmlComponentHistoryDataItem("de.rcenvironment.xmlmerger");
        }
    }

    private void storeHistoryDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.componentContext.writeFinalHistoryDataItem((ComponentHistoryDataItem)this.historyDataItem);
        }
    }

    private File map(File main, File integrating, String mappingRules) throws ComponentException {
        if (main != null && integrating != null) {
            if (mappingRules == null || mappingRules.equals("null")) {
                throw new ComponentException("Failed to perform mapping as no mapping rules are given. Check the mapping file configured");
            }
            try {
                Document mappingDoc = this.xmlSupport.readXMLFromString(mappingRules);
                this.resultFile = TempFileServiceAccess.getInstance().createTempFileFromPattern("xml*.xml");
                FileUtils.copyFile((File)main, (File)this.resultFile);
                this.xmlMapper.transformXMLFileWithXMLMappingInformation(integrating, this.resultFile, mappingDoc);
                return this.resultFile;
            }
            catch (XMLException | IOException | XPathExpressionException e) {
                throw new ComponentException("Failed to perform XML mapping", e);
            }
        }
        return null;
    }

    private final class XMLMergerTextLinesReceiver
    extends AbstractTextLinesReceiver {
        private XMLMergerTextLinesReceiver() {
        }

        public void addLine(String line) {
            XmlMergerComponent.this.componentContext.getLog().componentInfo(line);
        }
    }
}

