/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.script.execution.validator;

import de.rcenvironment.components.script.common.DefaultScriptHelper;
import de.rcenvironment.components.script.execution.Messages;
import de.rcenvironment.components.script.execution.validator.ScriptComponentValidatorCache;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.spi.AbstractComponentValidator;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.TextStreamWatcher;
import de.rcenvironment.core.utils.common.textstream.receivers.CapturingTextOutReceiver;
import de.rcenvironment.core.utils.executor.LocalApacheCommandLineExecutor;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptComponentValidator
extends AbstractComponentValidator {
    private static final String PYTHON_VALIDATION_ERROR = "Validation of python path failed.";
    private static final Long PYTHON_TEST_TIMEOUT = 1L;
    private static final int MINUS_ONE = -1;
    private static final String COLON = ": ";
    private static final String DEFAULT_SCRIPT = DefaultScriptHelper.getDefaultScript();
    private static Log logger = LogFactory.getLog(ScriptComponentValidator.class);

    public String getIdentifier() {
        return "de.rcenvironment.script";
    }

    protected List<ComponentValidationMessage> validateComponentSpecific(ComponentDescription componentDescription) {
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        String script = this.getProperty(componentDescription, "script");
        if (script == null) {
            return messages;
        }
        if (script.trim().isEmpty()) {
            ComponentValidationMessage noScriptMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "script", Messages.noScript, String.valueOf(Messages.noScript) + " defined");
            messages.add(noScriptMessage);
        } else if (script.equals(DEFAULT_SCRIPT)) {
            ComponentValidationMessage defaultScriptMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, "script", Messages.defaultScriptMessage, Messages.defaultScriptMessage);
            messages.add(defaultScriptMessage);
        } else if (!this.checkScriptIndentationConsistency(script)) {
            ComponentValidationMessage inconsistentScriptMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, "script", Messages.scriptInconsistentIndentation, String.valueOf(Messages.scriptInconsistentIndentation) + COLON + "script");
            messages.add(inconsistentScriptMessage);
        }
        return messages;
    }

    private boolean checkScriptIndentationConsistency(String script) {
        String regexWs = "^ +([\\S].*)$";
        String regexWsOnly = "^( +)$";
        String regexTab = "^\\t+([\\S].*)$";
        String regexTabOnly = "^(\\t+)$";
        String eol = System.getProperty("line.separator");
        String[] scriptLines = script.split(eol);
        boolean ws = false;
        boolean tab = false;
        int i = 0;
        while (i < scriptLines.length) {
            if (!ws) {
                boolean bl = ws = scriptLines[i].matches(regexWs) || scriptLines[i].matches(regexWsOnly);
            }
            if (!tab) {
                boolean bl = tab = scriptLines[i].matches(regexTab) || scriptLines[i].matches(regexTabOnly);
            }
            if (scriptLines[i].matches("^(( +\\t+)|(\\t+ +)).*")) {
                return false;
            }
            ++i;
        }
        return !ws || !tab;
    }

    protected List<ComponentValidationMessage> validateOnWorkflowStartComponentSpecific(ComponentDescription componentDescription) {
        return null;
    }

    public List<ComponentValidationMessage> validateOnWorkflowStart(ComponentDescription componentDescription) {
        String pythonInstallation;
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        this.getProperty(componentDescription, "scriptLanguage");
        if (this.getProperty(componentDescription, "scriptLanguage").equals("Python") && !(pythonInstallation = this.getProperty(componentDescription, "pythonExecutionPath")).isEmpty()) {
            PythonValidationResult cachedResult = ScriptComponentValidatorCache.getCache().getValidationResult(pythonInstallation);
            if (!cachedResult.isPlaceholder()) {
                this.processPythonValidationResult(cachedResult, messages, pythonInstallation);
            } else {
                PythonVersionRegexValidator validator = new PythonVersionRegexValidator();
                PythonValidationResult result = this.executeAndValidate(pythonInstallation, validator);
                this.processPythonValidationResult(result, messages, pythonInstallation);
            }
        }
        return messages;
    }

    private PythonValidationResult executeAndValidate(final String pythonInstallation, final PythonVersionRegexValidator validator) {
        String command = "\"" + pythonInstallation + "\"" + " --version";
        try {
            block9: {
                LocalApacheCommandLineExecutor executor = this.createCommandLineExecutor(new File("/"));
                executor.start(command);
                TextStreamWatcher stdOutTextStreamWatcher = new TextStreamWatcher(executor.getStdout(), ConcurrencyUtils.getAsyncTaskService(), new TextOutputReceiver[]{new CapturingTextOutReceiver(){

                    public synchronized void addOutput(String line) {
                        super.addOutput(line);
                        validator.validatePythonVersion(line, pythonInstallation);
                    }
                }});
                TextStreamWatcher stdErrTextStreamWatcher = new TextStreamWatcher(executor.getStderr(), ConcurrencyUtils.getAsyncTaskService(), new TextOutputReceiver[]{new CapturingTextOutReceiver(){

                    public synchronized void addOutput(String line) {
                        super.addOutput(line);
                        validator.validatePythonVersion(line, pythonInstallation);
                    }
                }});
                stdOutTextStreamWatcher.start();
                stdErrTextStreamWatcher.start();
                AsyncTaskService asyncTaskService = ConcurrencyUtils.getAsyncTaskService();
                Future task = asyncTaskService.submit(TaskType.LOCAL_IO_OPERATION, "Waits for python validation to finish", () -> {
                    try {
                        executor.waitForTermination();
                        stdOutTextStreamWatcher.waitForTermination();
                        stdErrTextStreamWatcher.waitForTermination();
                    }
                    catch (IOException e1) {
                        logger.error((Object)PYTHON_VALIDATION_ERROR, (Throwable)e1);
                    }
                    catch (InterruptedException e2) {
                        logger.error((Object)PYTHON_VALIDATION_ERROR, (Throwable)e2);
                    }
                });
                try {
                    task.get(PYTHON_TEST_TIMEOUT, TimeUnit.SECONDS);
                }
                catch (TimeoutException timeoutException) {
                    executor.cancel();
                    executor.cancel();
                    break block9;
                }
                catch (ExecutionException e) {
                    try {
                        logger.error((Object)PYTHON_VALIDATION_ERROR, (Throwable)e);
                        break block9;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        executor.cancel();
                    }
                }
                executor.cancel();
            }
            PythonValidationResult result = validator.getValidationResult();
            ScriptComponentValidatorCache.getCache().addOrUpdateValidationResult(result);
            return result;
        }
        catch (IOException | InterruptedException e) {
            logger.error((Object)PYTHON_VALIDATION_ERROR, (Throwable)e);
            return PythonValidationResult.DEFAULT_NONE_PLACEHOLDER;
        }
    }

    private void processPythonValidationResult(PythonValidationResult validatorResult, List<ComponentValidationMessage> messages, String path) {
        if (!validatorResult.isPythonExecutionSuccessful() && validatorResult.getMajorPythonVersion() == -1) {
            ComponentValidationMessage message = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "pythonExecutionPath", Messages.pythonExecutionTestErrorRelative, StringUtils.format((String)Messages.pythonExecutionTestErrorRelative, (Object[])new Object[]{path}));
            messages.add(message);
        } else if (!validatorResult.isPythonExecutionSuccessful() && validatorResult.getMinorPythonVersion() < 6 && validatorResult.getMajorPythonVersion() >= 2) {
            ComponentValidationMessage message = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "pythonExecutionPath", Messages.pythonExecutionUnsupportedVersionRelative, Messages.pythonExecutionUnsupportedVersionRelative);
            messages.add(message);
        } else if (validatorResult.isPythonExecutionSuccessful()) {
            this.logPythonExecutionSuccessfulMessage(validatorResult);
        }
    }

    private void logPythonExecutionSuccessfulMessage(PythonValidationResult validatorResult) {
        LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)("Python Version Used: " + validatorResult.getMajorPythonVersion() + "." + validatorResult.getMinorPythonVersion() + "." + validatorResult.getMicroPythonVersion()));
    }

    protected PythonVersionRegexValidator createPythonVersionRegexValidator() {
        return new PythonVersionRegexValidator();
    }

    protected LocalApacheCommandLineExecutor createCommandLineExecutor(File workDirPath) throws IOException {
        return new LocalApacheCommandLineExecutor(workDirPath);
    }

    protected static final class PythonValidationResult {
        public static final PythonValidationResult DEFAULT_NONE_PLACEHOLDER = new PythonValidationResult("/none", -1, -1, -1, false);
        private final int majorPythonVersion;
        private final int minorPythonVersion;
        private final int microPythonVersion;
        private final boolean successfull;
        private final String pythonPath;

        public PythonValidationResult(String pythonPath, int majorVersion, int minorVersion, int microVersion, boolean successfull) {
            if (pythonPath == null) {
                throw new NullPointerException("The given Python path cannot be null");
            }
            if (pythonPath.isEmpty()) {
                throw new IllegalArgumentException("The given Python path cannot be empty.");
            }
            this.pythonPath = pythonPath;
            this.majorPythonVersion = majorVersion;
            this.minorPythonVersion = minorVersion;
            this.microPythonVersion = microVersion;
            this.successfull = successfull;
        }

        public boolean isPythonExecutionSuccessful() {
            if (this.isPlaceholder()) {
                return false;
            }
            return this.successfull;
        }

        public int getMajorPythonVersion() {
            return this.majorPythonVersion;
        }

        public int getMinorPythonVersion() {
            return this.minorPythonVersion;
        }

        public int getMicroPythonVersion() {
            return this.microPythonVersion;
        }

        public String getPythonPath() {
            return this.pythonPath;
        }

        public boolean isPlaceholder() {
            return this == DEFAULT_NONE_PLACEHOLDER;
        }
    }

    protected static final class PythonVersionRegexValidator {
        private static final Pattern MATCH_PATTERN = Pattern.compile("^Python\\s([0-9]+)\\.{0,}([0-9]+){0,}\\.{0,}([0-9]+){0,}");
        private static final int MINUS_ONE = -1;
        private PythonValidationResult currentResult = PythonValidationResult.DEFAULT_NONE_PLACEHOLDER;

        protected PythonVersionRegexValidator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validatePythonVersion(String line, String pythonPath) {
            PythonVersionRegexValidator pythonVersionRegexValidator;
            if (this.currentResult.isPythonExecutionSuccessful()) {
                return;
            }
            int majorPythonVersion = -1;
            int minorPythonVersion = -1;
            int microPythonVersion = -1;
            Matcher matcher = MATCH_PATTERN.matcher(line);
            if (matcher.find()) {
                String g1 = matcher.group(1);
                String g2 = matcher.group(2);
                String g3 = matcher.group(3);
                if (g1 != null) {
                    majorPythonVersion = Integer.parseInt(g1);
                }
                if (g2 != null) {
                    minorPythonVersion = Integer.parseInt(g2);
                }
                if (g3 != null) {
                    microPythonVersion = Integer.parseInt(g3);
                }
            }
            if (majorPythonVersion == 3 || majorPythonVersion == 2 && minorPythonVersion >= 6) {
                pythonVersionRegexValidator = this;
                synchronized (pythonVersionRegexValidator) {
                    this.currentResult = new PythonValidationResult(pythonPath, majorPythonVersion, minorPythonVersion, microPythonVersion, true);
                    return;
                }
            }
            pythonVersionRegexValidator = this;
            synchronized (pythonVersionRegexValidator) {
                this.currentResult = new PythonValidationResult(pythonPath, majorPythonVersion, minorPythonVersion, microPythonVersion, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PythonValidationResult getValidationResult() {
            PythonVersionRegexValidator pythonVersionRegexValidator = this;
            synchronized (pythonVersionRegexValidator) {
                return this.currentResult;
            }
        }
    }
}

