/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.script.common.pythonAgentInstanceManager.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.script.common.pythonAgentInstanceManager.PythonAgentInstanceManager;
import de.rcenvironment.components.script.common.pythonAgentInstanceManager.internal.ScriptJSONObject;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.execution.api.ComponentLog;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.execution.api.ConsoleRowUtils;
import de.rcenvironment.core.scripting.python.PythonScriptEngine;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.legacy.FileSupport;
import de.rcenvironment.core.utils.executor.LocalApacheCommandLineExecutor;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import javax.script.ScriptException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PythonAgent
implements Runnable {
    private static final String SIMPLEJSON = "simplejson.zip";
    private static final String RESOURCES = "/resources/";
    private static final String PYTHON_BRIDGE = "RCE_Channel.py";
    private static final String PYTHON_CLIENT = "RCE_PythonClient.py";
    private static final String INPUT_FILE_FACTORY_PY = "input_file_factory.py";
    private static final String ESCAPESLASH = "\\\\";
    private static final String SLASH = "/";
    private static final int HUGE_NUMBER = 999999;
    private static final Log LOGGER = LogFactory.getLog(PythonScriptEngine.class);
    private static final String STANDARD_ERROR_MESSAGE = "Error occured when receiving a message.";
    protected Scanner inputScanner;
    protected ComponentContext compCtx;
    private LocalApacheCommandLineExecutor executor;
    private Long authentificationNumber;
    private PrintWriter out;
    private File tempDir;
    private int number;
    private PythonAgentInstanceManager instanceManager;
    private String pythonInstallationPath;
    private ServerSocket serverSocket;
    private CountDownLatch initializationSignal;
    private CountDownLatch pythonStartSignal;
    private boolean pythonInstanceIsRunning;
    private boolean initializationWasSuccessful;
    private final Semaphore lock = new Semaphore(1);

    public PythonAgent(PythonAgentInstanceManager instanceManager, String pythonInstallationPath, int number, ServerSocket serverSocket, CountDownLatch initializationSignal, ComponentContext compCtx) throws ScriptException {
        this.instanceManager = instanceManager;
        this.number = number;
        this.serverSocket = serverSocket;
        this.pythonInstallationPath = pythonInstallationPath;
        this.initializationSignal = initializationSignal;
        this.compCtx = compCtx;
        this.createFiles();
    }

    @Override
    public void run() {
        boolean successfulInitialization = this.init();
        if (successfulInitialization) {
            try {
                this.initializationWasSuccessful = this.registerPythonInstance();
            }
            catch (IOException iOException) {
                this.initializationWasSuccessful = false;
            }
        }
        if (this.initializationWasSuccessful) {
            this.initializationSignal.countDown();
            this.writeNewLineToLog();
        } else {
            this.stopPythonInstance();
            this.initializationSignal.countDown();
        }
    }

    public boolean wasInitializationSuccessful() {
        return this.initializationWasSuccessful;
    }

    public boolean init() {
        Socket socket;
        this.pythonStartSignal = new CountDownLatch(1);
        this.startPythonInstance();
        try {
            this.pythonStartSignal.await();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        if (!this.pythonInstanceIsRunning) {
            return false;
        }
        try {
            socket = this.serverSocket.accept();
        }
        catch (IOException iOException) {
            this.stopPythonInstance();
            return false;
        }
        try {
            this.inputScanner = new Scanner(socket.getInputStream(), StandardCharsets.UTF_8.displayName());
            this.inputScanner.useDelimiter("\u0000");
            this.out = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.UTF_8), true);
        }
        catch (IOException iOException) {
            this.stopPythonInstance();
            return false;
        }
        return true;
    }

    private void stopPythonInstance() {
        this.executor.cancel();
    }

    private void startPythonInstance() {
        this.executor = this.instanceManager.createNewExecutor();
        this.executor.setWorkDir(this.tempDir);
        ConcurrencyUtils.getAsyncTaskService().execute(TaskType.LONG_RUNNING, "PythonInstance", () -> {
            this.authentificationNumber = (long)(Math.random() * 999999.0);
            String pythonScriptPath = String.valueOf(this.tempDir.getAbsolutePath()) + SLASH + PYTHON_CLIENT;
            String command = String.valueOf(this.pythonInstallationPath) + " -u " + pythonScriptPath + " " + Integer.toString(this.serverSocket.getLocalPort()) + " " + this.authentificationNumber.toString();
            try {
                this.executor.setWorkDir(new File(this.tempDir.getAbsolutePath()));
                this.executor.start(String.valueOf(this.pythonInstallationPath) + " -V");
                if (this.executor.waitForTermination() == 0) {
                    try {
                        this.executor.start(command);
                        this.pythonInstanceIsRunning = true;
                        this.pythonStartSignal.countDown();
                    }
                    catch (IOException iOException) {
                        this.pythonInstanceIsRunning = false;
                        this.pythonStartSignal.countDown();
                    }
                } else {
                    this.pythonInstanceIsRunning = false;
                    this.pythonStartSignal.countDown();
                }
            }
            catch (IOException | InterruptedException exception) {
                this.pythonInstanceIsRunning = false;
                this.pythonStartSignal.countDown();
            }
            ConsoleRowUtils.logToWorkflowConsole((ComponentLog)this.compCtx.getLog(), (InputStream)this.executor.getStdout(), (ConsoleRow.Type)ConsoleRow.Type.TOOL_OUT, null, (boolean)false);
            ConsoleRowUtils.logToWorkflowConsole((ComponentLog)this.compCtx.getLog(), (InputStream)this.executor.getStderr(), (ConsoleRow.Type)ConsoleRow.Type.TOOL_ERROR, null, (boolean)false);
        });
    }

    private boolean registerPythonInstance() throws IOException {
        this.sendMessage("Token request");
        String input = this.recvMessage();
        if (input == null) {
            return false;
        }
        if (!this.authentificationNumber.toString().equals(input)) {
            this.sendMessage("Token declined.");
            return false;
        }
        this.sendMessage("Token accepted.");
        return true;
    }

    public ScriptJSONObject scriptToJSON(String pythonCommand, String script) throws JsonMappingException, FileNotFoundException, IOException {
        ScriptJSONObject jsonObject = new ScriptJSONObject();
        jsonObject.setPythonComamnd(pythonCommand);
        jsonObject.setScript(script);
        return jsonObject;
    }

    public void executeScript(String script) throws IOException, ComponentException {
        this.compCtx.getLog().componentInfo("Execute Python Script:");
        this.sendMessage("executeUserscript");
        this.recvMessage();
        ScriptJSONObject jsonObject = this.scriptToJSON("execute", script);
        this.sendScript(jsonObject);
        String successfulExecution = this.recvMessage();
        if ("Error when executing the script. Waiting for next task.".equals(successfulExecution)) {
            this.throwGenericException();
        } else if ("Error when writing output to temporary folder.".equals(successfulExecution)) {
            this.throwGenericException();
        }
        this.writeNewLineToLog();
    }

    private void throwGenericException() throws ComponentException {
        throw new ComponentException("Failed to execute script.");
    }

    protected void writeNewLineToLog() {
        this.compCtx.getLog().componentInfo("");
    }

    private void sendScript(ScriptJSONObject scriptObject) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        this.sendMessage(objectMapper.writeValueAsString((Object)scriptObject));
        this.out.flush();
    }

    public void stopInstance() {
        int exitCode;
        try {
            this.sendMessage("stopInstance");
            this.recvMessage();
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"Error occured when closing the python instance.");
            this.stopPythonInstance();
        }
        try {
            exitCode = this.executor.waitForTermination();
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error((Object)("Error while waiting for termination of python instance: " + e.getMessage()));
            return;
        }
        if (exitCode != 0) {
            LOGGER.error((Object)("Python instance terminated with non-zero exit code: " + exitCode));
        }
    }

    public void stopInstanceRun() {
        try {
            this.sendMessage("stopInstanceRun");
            this.recvMessage();
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"Error occured when closing the python instance.");
            this.stopPythonInstance();
        }
    }

    protected void sendMessage(String message) {
        this.out.print(String.valueOf(message) + '\u0000');
        this.out.flush();
    }

    protected String recvMessage() throws IOException {
        String input = this.inputScanner.next();
        return input;
    }

    private void createFiles() throws ScriptException {
        try {
            this.tempDir = TempFileServiceAccess.getInstance().createManagedTempDir("pythonAgent");
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"Could not create managed temp directory, falling back to default");
            try {
                File tmp = File.createTempFile("prefix", "suffix");
                this.tempDir = tmp.getParentFile();
                tmp.delete();
            }
            catch (IOException iOException2) {
                LOGGER.error((Object)"Failed to fall back.");
                throw new ScriptException("Unable to create temp file and directory");
            }
        }
        try {
            File wrapperBridge = new File(this.tempDir, PYTHON_BRIDGE);
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream wrapperScriptInputBridge = PythonScriptEngine.class.getResourceAsStream("/resources/RCE_Channel.py");){
                FileUtils.copyInputStreamToFile((InputStream)wrapperScriptInputBridge, (File)wrapperBridge);
                Throwable throwable2 = null;
                Object var6_9 = null;
                try (InputStream simpleJsonFiles = PythonScriptEngine.class.getResourceAsStream("/resources/simplejson.zip");){
                    FileSupport.unzip((InputStream)simpleJsonFiles, (File)this.tempDir);
                    File pythonClient = new File(this.tempDir, PYTHON_CLIENT);
                    Throwable throwable3 = null;
                    Throwable throwable4 = null;
                    try (InputStream wrapperScriptInputClient = PythonScriptEngine.class.getResourceAsStream("/resources/RCE_PythonClient.py");){
                        FileUtils.copyInputStreamToFile((InputStream)wrapperScriptInputClient, (File)pythonClient);
                    }
                    catch (Throwable throwable5) {
                        if (throwable3 == null) {
                            throwable3 = throwable5;
                        } else if (throwable3 != throwable5) {
                            throwable3.addSuppressed(throwable5);
                        }
                        throw throwable3;
                    }
                    File inputFileFactory = new File(this.tempDir, INPUT_FILE_FACTORY_PY);
                    throwable4 = null;
                    Object var11_18 = null;
                    try (InputStream wrapperScriptInputFactory = PythonScriptEngine.class.getResourceAsStream("/resources/input_file_factory.py");){
                        FileUtils.copyInputStreamToFile((InputStream)wrapperScriptInputFactory, (File)inputFileFactory);
                        String path = "\nInputFileFactory.p = '" + this.tempDir.getPath().replaceAll(ESCAPESLASH, SLASH) + "/'";
                        FileUtils.writeStringToFile((File)inputFileFactory, (String)path, (boolean)true);
                    }
                    catch (Throwable throwable6) {
                        if (throwable4 == null) {
                            throwable4 = throwable6;
                        } else if (throwable4 != throwable6) {
                            throwable4.addSuppressed(throwable6);
                        }
                        throw throwable4;
                    }
                }
                catch (Throwable throwable7) {
                    if (throwable2 == null) {
                        throwable2 = throwable7;
                    } else if (throwable2 != throwable7) {
                        throwable2.addSuppressed(throwable7);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable8) {
                if (throwable == null) {
                    throwable = throwable8;
                } else if (throwable != throwable8) {
                    throwable.addSuppressed(throwable8);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"Failed to create temporary Python scripts.");
            throw new ScriptException("Unable to create temporary Python scripts");
        }
    }

    public File getDirectory() {
        return this.tempDir;
    }

    public InputStream getStdout() {
        return this.executor.getStdout();
    }

    public InputStream getStderr() {
        return this.executor.getStderr();
    }

    public String getInstallationPath() {
        return this.pythonInstallationPath;
    }

    public void acquireLock() throws InterruptedException {
        this.lock.acquire();
    }

    public void releaseLock() {
        this.lock.release();
    }
}

