/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.execution;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.optimizer.common.Dimension;
import de.rcenvironment.components.optimizer.common.Measure;
import de.rcenvironment.components.optimizer.common.MethodDescription;
import de.rcenvironment.components.optimizer.common.OptimizerComponentHistoryDataItem;
import de.rcenvironment.components.optimizer.common.OptimizerFileLoader;
import de.rcenvironment.components.optimizer.common.OptimizerPublisher;
import de.rcenvironment.components.optimizer.common.OptimizerResultService;
import de.rcenvironment.components.optimizer.common.OptimizerResultSet;
import de.rcenvironment.components.optimizer.common.ResultStructure;
import de.rcenvironment.components.optimizer.common.execution.OptimizerAlgorithmExecutor;
import de.rcenvironment.components.optimizer.execution.algorithms.registry.OptimizerAlgorithmExecutorFactoryRegistry;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.execution.api.Component;
import de.rcenvironment.core.component.model.api.LazyDisposal;
import de.rcenvironment.core.component.model.spi.AbstractNestedLoopComponent;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumFactory;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FloatTD;
import de.rcenvironment.core.datamodel.types.api.VectorTD;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@LazyDisposal
public class OptimizerComponent
extends AbstractNestedLoopComponent {
    private static final String INPUT_PREFIX_CONSTANT = "f81ec917-2221-4bcd-ac17-1c1cef6e08a5_input:";
    private static final String ITERATION = "Iteration";
    private static final double CONST_1E99 = 1.0E99;
    private static final String COMMA = ",";
    private static OptimizerResultService optimizerResultService;
    private static OptimizerAlgorithmExecutorFactoryRegistry optimizerAlgorithmExecutorFactoryRegistry;
    private static final Log LOGGER;
    private static TypedDatumFactory typedDatumFactory;
    public boolean programThreadInterrupted;
    private OptimizerPublisher resultPublisher;
    private Collection<String> output;
    private Collection<String> input;
    private Map<String, TypedDatum> outputValues;
    private OptimizerResultSet dataset = null;
    private String algorithm;
    private OptimizerAlgorithmExecutor optimizer;
    private final ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
    private Map<String, MethodDescription> methodConfigurations;
    private Map<String, Double> startValues;
    private Integer iterationCount = 0;
    private Map<String, Double> lowerBoundsStartValues;
    private Map<String, Double> upperBoundsStartValues;
    private boolean initFailed = false;
    private boolean optimizerStarted;
    private OptimizerComponentHistoryDataItem historyDataItem;
    private Map<String, TypedDatum> runtimeViewValues = new HashMap<String, TypedDatum>();
    private Map<Integer, Map<String, Double>> iterationData;
    private Map<Integer, Map<String, TypedDatum>> dataForwarded = new HashMap<Integer, Map<String, TypedDatum>>();
    private Map<String, Double> stepValues;

    static {
        LOGGER = LogFactory.getLog(OptimizerComponent.class);
    }

    private void prepareExternalProgram() throws ComponentException {
        HashMap<String, Map<String, Double>> boundMaps = new HashMap<String, Map<String, Double>>();
        boundMaps.put("lower", this.lowerBoundsStartValues);
        boundMaps.put("upper", this.upperBoundsStartValues);
        this.optimizer = optimizerAlgorithmExecutorFactoryRegistry.createAlgorithmProviderInstance(this.methodConfigurations.get(this.algorithm.split(COMMA)[0]).getOptimizerPackage(), this.methodConfigurations, this.outputValues, this.input, this.componentContext, boundMaps, this.stepValues);
        this.programThreadInterrupted = false;
        ConcurrencyUtils.getAsyncTaskService().execute(TaskType.COMPUTATION, "Optimizer Algorithm Executor", (Runnable)this.optimizer);
        if (this.optimizer.isInitFailed()) {
            throw new ComponentException("Failed to prepare optimizer", this.optimizer.getStartFailedException());
        }
    }

    private void manageNewInput(Map<String, Double> inputVariables, Map<String, Double> inputVariablesGradients, Map<String, Double> constraintVariables, Map<String, Double> constraintVariablesGradients) {
        Set inputValues = this.componentContext.getInputsWithDatum();
        Map<String, Double> iteration = this.iterationData.get(this.iterationCount);
        boolean gotRealInput = false;
        for (String e : this.input) {
            if (!inputValues.contains(e)) continue;
            gotRealInput = true;
            if (this.componentContext.getInputDataType(e) == DataType.Vector) {
                if (this.componentContext.readInput(e).getDataType() == DataType.NotAValue) {
                    int i = 0;
                    while (i < Integer.parseInt(this.componentContext.getOutputMetaDataValue(e.substring(e.lastIndexOf("\u2202") + 1), "vectorSize"))) {
                        this.convertValue(inputVariables, inputVariablesGradients, constraintVariables, String.valueOf(e) + "_" + i, this.componentContext.readInput(e), iteration);
                        ++i;
                    }
                    continue;
                }
                VectorTD vector = (VectorTD)this.componentContext.readInput(e);
                int i = 0;
                while (i < vector.getRowDimension()) {
                    this.convertValue(inputVariables, inputVariablesGradients, constraintVariables, String.valueOf(e) + "_" + i, (TypedDatum)vector.getFloatTDOfElement(i), iteration);
                    ++i;
                }
                continue;
            }
            this.convertValue(inputVariables, inputVariablesGradients, constraintVariables, e, this.componentContext.readInput(e), iteration);
        }
        if (gotRealInput) {
            this.createNewResultfile(iteration);
            this.fillRuntimeView(inputVariables, inputVariablesGradients, constraintVariables);
        }
    }

    private void createNewResultfile(Map<String, Double> iteration) {
        this.iterationData.put(this.iterationCount, iteration);
        if (!this.componentContext.getInputsWithDatum().isEmpty() && this.historyDataItem != null) {
            try {
                LinkedList outputs = new LinkedList(this.componentContext.getOutputs());
                Collections.sort(outputs);
                File resultFile = TempFileServiceAccess.getInstance().createTempFileFromPattern("OptimizerResultFile*.csv");
                this.writeResultToCSVFile(resultFile.getAbsolutePath());
                FileReferenceTD resultFileReference = ((ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class)).createFileReferenceTDFromLocalFile(this.componentContext, resultFile, "Result.csv");
                this.historyDataItem.setResultFileReference(resultFileReference.getFileReference());
                TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(resultFile);
            }
            catch (IOException e) {
                String errorMessage = "Failed to store result file into the data management; it is not available in the workflow data browser";
                String errorId = LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)LOGGER, (String)errorMessage, (Throwable)e);
                this.componentLog.componentError(errorMessage, (Throwable)e, errorId);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeResultToCSVFile(String path) throws IOException {
        if (path == null || this.iterationData.isEmpty()) return;
        LinkedList<String> orderedOutputs = new LinkedList<String>(this.output);
        LinkedList<String> orderedInputs = new LinkedList<String>(this.input);
        LinkedList<String> insert = new LinkedList<String>();
        LinkedList<String> remove = new LinkedList<String>();
        for (String outputName : orderedOutputs) {
            if (this.componentContext.getOutputDataType(outputName) != DataType.Vector) continue;
            remove.add(outputName);
            int i = 0;
            while (i < Integer.parseInt(this.componentContext.getOutputMetaDataValue(outputName, "vectorSize"))) {
                insert.add(String.valueOf(outputName) + "_" + i);
                ++i;
            }
        }
        for (String toRemove : remove) {
            orderedOutputs.remove(toRemove);
        }
        for (String toInsert : insert) {
            orderedOutputs.add(toInsert);
        }
        insert = new LinkedList();
        remove = new LinkedList();
        for (String inputName : orderedInputs) {
            if (this.componentContext.getInputDataType(inputName) != DataType.Vector) continue;
            int vectorSize = 0;
            if (inputName.contains("\u2202")) {
                String outputName = inputName.substring(inputName.lastIndexOf("\u2202") + 1);
                vectorSize = Integer.parseInt(this.componentContext.getOutputMetaDataValue(outputName, "vectorSize"));
            } else {
                vectorSize = Integer.parseInt(this.componentContext.getInputMetaDataValue(inputName, "vectorSize"));
            }
            remove.add(inputName);
            int i = 0;
            while (i < vectorSize) {
                insert.add(String.valueOf(inputName) + "_" + i);
                ++i;
            }
        }
        for (String toRemove : remove) {
            orderedInputs.remove(toRemove);
        }
        for (String toInsert : insert) {
            orderedInputs.add(toInsert);
        }
        Collections.sort(orderedOutputs);
        Collections.sort(orderedInputs);
        Throwable throwable = null;
        Iterator iterator = null;
        try {
            FileWriter fw = new FileWriter(new File(path));
            try {
                try (CSVPrinter printer = CSVFormat.newFormat((char)';').withIgnoreSurroundingSpaces().withAllowMissingColumnNames().withRecordSeparator("\n").print((Appendable)fw);){
                    printer.print((Object)ITERATION);
                    for (String outputName : orderedOutputs) {
                        printer.print((Object)outputName);
                    }
                    for (String inputName : orderedInputs) {
                        printer.print((Object)inputName);
                    }
                    printer.println();
                    Integer i = 1;
                    while (i < this.iterationData.keySet().size() + 1) {
                        Map<String, Double> iteration = this.iterationData.get(i);
                        printer.print((Object)i);
                        for (String out : orderedOutputs) {
                            printer.print((Object)iteration.get(out));
                        }
                        for (String in : orderedInputs) {
                            printer.print((Object)iteration.get(INPUT_PREFIX_CONSTANT + in));
                        }
                        printer.println();
                        printer.flush();
                        i = i + 1;
                    }
                }
                if (fw == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fw == null) throw throwable;
                fw.close();
                throw throwable;
            }
            fw.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void fillRuntimeView(Map<String, Double> inputVariables, Map<String, Double> inputVariablesGradients, Map<String, Double> constraintVariables) {
        for (String key : inputVariables.keySet()) {
            if (inputVariables.get(key).isNaN()) {
                this.runtimeViewValues.put(key, (TypedDatum)typedDatumFactory.createFloat(1.0E99));
                continue;
            }
            this.runtimeViewValues.put(key, (TypedDatum)typedDatumFactory.createFloat(inputVariables.get(key).doubleValue()));
        }
        for (String key : inputVariablesGradients.keySet()) {
            if (inputVariablesGradients.get(key).isNaN()) {
                this.runtimeViewValues.put(key, (TypedDatum)typedDatumFactory.createFloat(1.0E99));
                continue;
            }
            this.runtimeViewValues.put(key, (TypedDatum)typedDatumFactory.createFloat(inputVariablesGradients.get(key).doubleValue()));
        }
        for (String key : constraintVariables.keySet()) {
            if (constraintVariables.get(key).isNaN()) {
                this.runtimeViewValues.put(key, (TypedDatum)typedDatumFactory.createFloat(1.0E99));
                continue;
            }
            this.runtimeViewValues.put(key, (TypedDatum)typedDatumFactory.createFloat(constraintVariables.get(key).doubleValue()));
        }
        this.runtimeViewValues.put(ITERATION, (TypedDatum)typedDatumFactory.createInteger((long)this.iterationCount.intValue()));
        this.dataset = new OptimizerResultSet(this.runtimeViewValues, this.componentContext.getExecutionIdentifier());
        this.resultPublisher.add(this.dataset);
        this.runtimeViewValues = new HashMap<String, TypedDatum>();
    }

    private void convertValue(Map<String, Double> inputVariables, Map<String, Double> inputVariablesGradients, Map<String, Double> constraintVariables, String variableName, TypedDatum value, Map<String, Double> iteration) {
        double inputField = value.getDataType() != DataType.NotAValue ? ((FloatTD)value).getFloatValue() : Double.NaN;
        if (variableName.contains("\u2202")) {
            inputVariablesGradients.put(variableName, inputField);
        } else {
            String identifier = variableName.contains("_") && this.componentContext.getDynamicInputIdentifier(variableName.substring(0, variableName.indexOf("_"))) != null ? this.componentContext.getDynamicInputIdentifier(variableName.substring(0, variableName.indexOf("_"))) : this.componentContext.getDynamicInputIdentifier(variableName);
            if (identifier.equals("Objective")) {
                inputVariables.put(variableName, inputField);
            } else {
                constraintVariables.put(variableName, inputField);
            }
        }
        iteration.put(INPUT_PREFIX_CONSTANT + variableName, inputField);
    }

    private void terminateExecutor() {
        if (this.optimizer != null) {
            this.optimizer.closeConnection();
            this.programThreadInterrupted = true;
            this.optimizer.stop();
            File workDir = this.optimizer.getWorkingDir();
            this.optimizer.dispose();
            this.optimizer = null;
            try {
                TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(workDir);
            }
            catch (IOException e) {
                LOGGER.error((Object)"Failed to delete temporary directory", (Throwable)e);
            }
        }
    }

    private ResultStructure createStructure() {
        ResultStructure structure = new ResultStructure();
        for (String e : this.output) {
            if (this.componentContext.getOutputDataType(e) == DataType.Vector) {
                int i = 0;
                while (i < Integer.parseInt(this.componentContext.getOutputMetaDataValue(e, "vectorSize"))) {
                    Dimension dimension = new Dimension(String.valueOf(e) + "_" + i, DataType.Float.getDisplayName(), Boolean.valueOf(true));
                    structure.addDimension(dimension);
                    ++i;
                }
                continue;
            }
            Dimension dimension = new Dimension(e, this.componentContext.getOutputDataType(e).getDisplayName(), Boolean.valueOf(true));
            structure.addDimension(dimension);
        }
        Dimension dimension = new Dimension(ITERATION, DataType.Integer.getDisplayName(), Boolean.valueOf(true));
        structure.addDimension(dimension);
        for (String e : this.input) {
            if (this.componentContext.getInputDataType(e) == DataType.Vector) {
                int vecSize = Integer.parseInt(this.componentContext.getOutputMetaDataValue(e.substring(e.lastIndexOf("\u2202") + 1), "vectorSize"));
                int i = 0;
                while (i < vecSize) {
                    Measure measure = new Measure(String.valueOf(e) + "_" + i, DataType.Float.getDisplayName());
                    structure.addMeasure(measure);
                    ++i;
                }
                continue;
            }
            Measure measure = new Measure(e, DataType.Float.getDisplayName());
            structure.addMeasure(measure);
        }
        return structure;
    }

    public boolean treatStartAsComponentRun() {
        boolean runInitial = true;
        for (String e : this.componentContext.getInputs()) {
            if (!e.endsWith(" - start value") && !e.endsWith(" - step value") && !e.endsWith("_start")) continue;
            runInitial = false;
        }
        return runInitial;
    }

    protected void startNestedComponentSpecific() throws ComponentException {
        String[] splittedAlgorithms;
        optimizerResultService = (OptimizerResultService)this.componentContext.getService(OptimizerResultService.class);
        optimizerAlgorithmExecutorFactoryRegistry = (OptimizerAlgorithmExecutorFactoryRegistry)this.componentContext.getService(OptimizerAlgorithmExecutorFactoryRegistry.class);
        typedDatumFactory = ((TypedDatumService)this.componentContext.getService(TypedDatumService.class)).getFactory();
        this.iterationData = new TreeMap<Integer, Map<String, Double>>();
        this.output = new HashSet<String>();
        this.output.addAll(this.componentContext.getOutputs());
        LinkedList<String> toRemove = new LinkedList<String>();
        for (String e : this.output) {
            if (e.endsWith("_optimal")) {
                toRemove.add(e);
            }
            if (e.endsWith("Done")) {
                toRemove.add(e);
            }
            if (e.endsWith(ITERATION)) {
                toRemove.add(e);
            }
            if (e.endsWith("Gradient request")) {
                toRemove.add(e);
            }
            if (!this.componentContext.isDynamicInput(e) || !this.componentContext.getDynamicInputIdentifier(e).equals("toForward")) continue;
            toRemove.add(e);
        }
        for (String e : toRemove) {
            this.output.remove(e);
        }
        this.input = new HashSet<String>();
        for (String inputName : this.componentContext.getInputs()) {
            if (!this.componentContext.getDynamicInputIdentifier(inputName).equals("Objective") && !this.componentContext.getDynamicInputIdentifier(inputName).equals("Constraint") && !this.componentContext.getDynamicInputIdentifier(inputName).equals("gradients")) continue;
            this.input.add(inputName);
        }
        this.algorithm = this.componentContext.getConfigurationValue("algorithm");
        String configurations = this.componentContext.getConfigurationValue("methodConfigurations");
        if (this.output.isEmpty() || this.input.isEmpty()) {
            throw new ComponentException("Design variables or target functions not configured");
        }
        try {
            if (configurations != null && !configurations.isEmpty()) {
                this.methodConfigurations = (Map)this.mapper.readValue(configurations, new HashMap().getClass());
                for (String key : this.methodConfigurations.keySet()) {
                    this.methodConfigurations.put(key, (MethodDescription)this.mapper.convertValue((Object)this.methodConfigurations.get(key), MethodDescription.class));
                }
            } else {
                this.methodConfigurations = OptimizerFileLoader.getAllMethodDescriptions((String)"/optimizer");
            }
        }
        catch (IOException e) {
            throw new ComponentException("Failed to load or parse method file", (Throwable)e);
        }
        String[] stringArray = splittedAlgorithms = this.algorithm.split(COMMA);
        int n = splittedAlgorithms.length;
        int n2 = 0;
        while (n2 < n) {
            String alg = stringArray[n2];
            if (!this.methodConfigurations.containsKey(alg)) {
                throw new ComponentException("Failed to load algorithm '" + alg + "'; not found");
            }
            ++n2;
        }
        this.resultPublisher = optimizerResultService.createPublisher(this.componentContext.getExecutionIdentifier(), this.componentContext.getInstanceName(), this.createStructure());
        this.optimizerStarted = false;
        boolean runInitial = this.treatStartAsComponentRun();
        if (runInitial) {
            super.processInputs();
        }
    }

    protected void processInputsNestedComponentSpecific() throws ComponentException {
        this.initializeNewHistoryDataItem();
        if (!this.optimizerStarted) {
            this.firstRun();
        } else {
            if (!this.initFailed) {
                this.storeDataForwarded();
                HashMap<String, Double> inputVariables = new HashMap<String, Double>();
                HashMap<String, Double> constraintVariables = new HashMap<String, Double>();
                HashMap<String, Double> inputVariablesGradients = new HashMap<String, Double>();
                HashMap<String, Double> constraintVariablesGradients = new HashMap<String, Double>();
                this.manageNewInput(inputVariables, inputVariablesGradients, constraintVariables, constraintVariablesGradients);
                if (this.optimizer != null && !this.optimizer.isStopped()) {
                    this.optimizer.runStep(inputVariables, inputVariablesGradients, constraintVariables, constraintVariablesGradients, this.outputValues);
                }
            } else {
                if (this.optimizer != null) {
                    this.terminateExecutor();
                }
                throw new ComponentException("Failed to initialize optimizer");
            }
            if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue() && this.optimizer != null) {
                this.optimizer.writeHistoryDataItem(this.historyDataItem);
                this.writeFinalHistoryDataItem();
            }
        }
        this.iterationCount = this.iterationCount + 1;
    }

    private void storeDataForwarded() {
        Integer iteration = this.iterationCount;
        for (String inputName : this.componentContext.getInputsWithDatum()) {
            if (!this.componentContext.isDynamicInput(inputName) || !this.componentContext.getDynamicInputIdentifier(inputName).equals("toForward")) continue;
            if (!this.dataForwarded.containsKey(iteration)) {
                this.dataForwarded.put(this.iterationCount, new HashMap());
            }
            this.dataForwarded.get(iteration).put(inputName, this.componentContext.readInput(inputName));
        }
    }

    private void firstRun() throws ComponentException {
        this.outputValues = new HashMap<String, TypedDatum>();
        this.startValues = new HashMap<String, Double>();
        this.stepValues = new HashMap<String, Double>();
        this.lowerBoundsStartValues = new HashMap<String, Double>();
        this.upperBoundsStartValues = new HashMap<String, Double>();
        for (String e : this.output) {
            String hasStartValue = this.componentContext.getOutputMetaDataValue(e, "hasStartValue");
            String hasStep = this.componentContext.getOutputMetaDataValue(e, "useStep");
            String hasUseUnifiedStep = this.componentContext.getOutputMetaDataValue(e, "useUnifiedStep");
            String hasBoundValues = this.componentContext.getOutputMetaDataValue(e, "hasSingleBounds");
            String startValue = this.componentContext.getOutputMetaDataValue(e, "startValue");
            if (startValue.equals("-")) {
                startValue = "";
            }
            this.getStartAndStepValues(e, hasStartValue, hasStep, hasUseUnifiedStep, startValue);
            if (hasBoundValues == null || !Boolean.parseBoolean(hasBoundValues)) continue;
            if (this.componentContext.getOutputDataType(e) == DataType.Vector) {
                int i = 0;
                while (i < Integer.parseInt(this.componentContext.getOutputMetaDataValue(e, "vectorSize"))) {
                    this.lowerBoundsStartValues.put(String.valueOf(e) + "_" + i, Double.parseDouble(this.componentContext.getOutputMetaDataValue(e, "lower")));
                    this.upperBoundsStartValues.put(String.valueOf(e) + "_" + i, Double.parseDouble(this.componentContext.getOutputMetaDataValue(e, "upper")));
                    ++i;
                }
                continue;
            }
            this.lowerBoundsStartValues.put(e, Double.parseDouble(this.componentContext.getOutputMetaDataValue(e, "lower")));
            this.upperBoundsStartValues.put(e, Double.parseDouble(this.componentContext.getOutputMetaDataValue(e, "upper")));
        }
        for (String e : this.input) {
            String hasBoundValues = this.componentContext.getInputMetaDataValue(e, "hasSingleBounds");
            if (hasBoundValues == null || !Boolean.parseBoolean(hasBoundValues)) continue;
            if (this.componentContext.getInputDataType(e) == DataType.Vector) {
                int i = 0;
                while (i < Integer.parseInt(this.componentContext.getInputMetaDataValue(e, "vectorSize"))) {
                    this.lowerBoundsStartValues.put(String.valueOf(e) + "_" + i, Double.parseDouble(this.componentContext.getInputMetaDataValue(e, "lower")));
                    this.upperBoundsStartValues.put(String.valueOf(e) + "_" + i, Double.parseDouble(this.componentContext.getInputMetaDataValue(e, "upper")));
                    ++i;
                }
                continue;
            }
            this.lowerBoundsStartValues.put(e, Double.parseDouble(this.componentContext.getInputMetaDataValue(e, "lower")));
            this.upperBoundsStartValues.put(e, Double.parseDouble(this.componentContext.getInputMetaDataValue(e, "upper")));
        }
        for (String e : this.componentContext.getInputsWithDatum()) {
            if (e.contains(" - lower bounds")) {
                if (this.componentContext.getInputDataType(e) == DataType.Vector) {
                    int i = 0;
                    while (i < ((VectorTD)this.componentContext.readInput(e)).getRowDimension()) {
                        this.lowerBoundsStartValues.put(String.valueOf(e.substring(0, e.indexOf(" - lower bounds"))) + "_" + i, ((VectorTD)this.componentContext.readInput(e)).getFloatTDOfElement(i).getFloatValue());
                        ++i;
                    }
                } else {
                    this.lowerBoundsStartValues.put(e.substring(0, e.indexOf(" - lower bounds")), ((FloatTD)this.componentContext.readInput(e)).getFloatValue());
                }
            }
            if (!e.contains(" - upper bounds")) continue;
            if (this.componentContext.getInputDataType(e) == DataType.Vector) {
                int i = 0;
                while (i < ((VectorTD)this.componentContext.readInput(e)).getRowDimension()) {
                    this.upperBoundsStartValues.put(String.valueOf(e.substring(0, e.indexOf(" - upper bounds"))) + "_" + i, ((VectorTD)this.componentContext.readInput(e)).getFloatTDOfElement(i).getFloatValue());
                    ++i;
                }
                continue;
            }
            this.upperBoundsStartValues.put(e.substring(0, e.indexOf(" - upper bounds")), ((FloatTD)this.componentContext.readInput(e)).getFloatValue());
        }
        for (String e : this.startValues.keySet()) {
            this.outputValues.put(e, (TypedDatum)typedDatumFactory.createFloat(this.startValues.get(e).doubleValue()));
        }
        this.prepareExternalProgram();
        if (this.optimizer != null && !this.optimizer.isInitFailed() && !this.optimizer.getStartFailed().get()) {
            try {
                if (this.optimizer.initializationLoop()) {
                    this.optimizer.readOutputFileFromExternalProgram(this.outputValues);
                    this.sendValuesNestedComponentSpecific();
                } else if (!this.optimizer.getStartFailed().get()) {
                    this.sendFinalValues();
                    this.componentContext.closeAllOutputs();
                } else {
                    throw new ComponentException("Could not start optimizer. Maybe binaries are missing or not compatible with system.", this.optimizer.getStartFailedException());
                }
                this.optimizerStarted = true;
            }
            catch (IOException e) {
                this.componentContext.getLog().componentError("Failed to initialize optimizer: " + e.getMessage());
                LOGGER.error((Object)"Failed to initialize optimizer", (Throwable)e);
                this.initFailed = true;
            }
        } else {
            throw new ComponentException("Failed to start optimizer");
        }
    }

    private void getStartAndStepValues(String e, String hasStartValue, String hasStep, String hasUseUnifiedStep, String startValue) {
        int i;
        if (hasStartValue != null && Boolean.parseBoolean(hasStartValue) && !startValue.isEmpty() || hasStartValue == null && !startValue.isEmpty()) {
            if (this.componentContext.getOutputDataType(e) == DataType.Vector) {
                int i2 = 0;
                while (i2 < Integer.parseInt(this.componentContext.getOutputMetaDataValue(e, "vectorSize"))) {
                    this.startValues.put(String.valueOf(e) + "_" + i2, Double.parseDouble(this.componentContext.getOutputMetaDataValue(e, "startValue")));
                    ++i2;
                }
            } else {
                this.startValues.put(e, Double.parseDouble(startValue));
            }
        } else if (!Boolean.parseBoolean(hasStartValue)) {
            if (this.componentContext.getOutputDataType(e) == DataType.Vector) {
                VectorTD startValueVector = (VectorTD)this.componentContext.readInput(String.valueOf(e) + " - start value");
                i = 0;
                while (i < Integer.parseInt(this.componentContext.getOutputMetaDataValue(e, "vectorSize"))) {
                    this.outputValues.put(String.valueOf(e) + "_" + i, (TypedDatum)startValueVector.getFloatTDOfElement(i));
                    ++i;
                }
            } else {
                this.outputValues.put(e, this.componentContext.readInput(String.valueOf(e) + " - start value"));
            }
        }
        if (Boolean.parseBoolean(hasStep) && Boolean.parseBoolean(hasUseUnifiedStep)) {
            if (this.componentContext.getOutputDataType(e) == DataType.Vector) {
                int i3 = 0;
                while (i3 < Integer.parseInt(this.componentContext.getOutputMetaDataValue(e, "vectorSize"))) {
                    this.stepValues.put(String.valueOf(e) + "_" + i3, Double.parseDouble(this.componentContext.getOutputMetaDataValue(e, "step")));
                    ++i3;
                }
            } else {
                this.stepValues.put(e, Double.parseDouble(this.componentContext.getOutputMetaDataValue(e, "step")));
            }
        } else if (Boolean.parseBoolean(hasStep) && !Boolean.parseBoolean(hasUseUnifiedStep)) {
            if (this.componentContext.getOutputDataType(e) == DataType.Vector) {
                VectorTD stepVector = (VectorTD)this.componentContext.readInput(String.valueOf(e) + " - step value");
                i = 0;
                while (i < Integer.parseInt(this.componentContext.getOutputMetaDataValue(e, "vectorSize"))) {
                    this.stepValues.put(String.valueOf(e) + "_" + i, stepVector.getFloatTDOfElement(i).getFloatValue());
                    ++i;
                }
            } else {
                this.stepValues.put(e, ((FloatTD)this.componentContext.readInput(String.valueOf(e) + " - step value")).getFloatValue());
            }
        }
    }

    protected void sendValuesNestedComponentSpecific() {
        if (this.optimizerStarted && this.optimizer != null && !this.optimizer.isStopped()) {
            HashMap<String, Double> iteration = new HashMap<String, Double>();
            for (String e : this.output) {
                if (this.outputValues.get(e) != null) {
                    this.writeOutput(e, this.outputValues.get(e));
                    if (this.componentContext.getOutputDataType(e) == DataType.Vector) {
                        int i = 0;
                        while (i < Integer.parseInt(this.componentContext.getOutputMetaDataValue(e, "vectorSize"))) {
                            this.runtimeViewValues.put(String.valueOf(e) + "_" + i, (TypedDatum)((VectorTD)this.outputValues.get(e)).getFloatTDOfElement(i));
                            iteration.put(String.valueOf(e) + "_" + i, ((VectorTD)this.outputValues.get(e)).getFloatTDOfElement(i).getFloatValue());
                            ++i;
                        }
                        continue;
                    }
                    this.runtimeViewValues.put(e, this.outputValues.get(e));
                    iteration.put(e, ((FloatTD)this.outputValues.get(e)).getFloatValue());
                    continue;
                }
                LOGGER.info((Object)StringUtils.format((String)"Could not send out output %s because the value was null", (Object[])new Object[]{e}));
            }
            this.writeOutput(ITERATION, (TypedDatum)typedDatumFactory.createInteger((long)this.iterationCount.intValue()));
            if (this.optimizer != null) {
                this.writeOutput("Gradient request", (TypedDatum)typedDatumFactory.createBoolean(this.optimizer.getDerivativedNeeded()));
            }
            this.iterationData.put(this.iterationCount, iteration);
        }
    }

    protected void resetNestedComponentSpecific() {
        this.programThreadInterrupted = false;
        this.outputValues.clear();
        this.runtimeViewValues.clear();
        this.startValues = new HashMap<String, Double>();
        this.lowerBoundsStartValues = new HashMap<String, Double>();
        this.upperBoundsStartValues = new HashMap<String, Double>();
        this.stepValues = new HashMap<String, Double>();
        this.iterationCount = 0;
        this.optimizerStarted = false;
    }

    protected void finishLoopNestedComponentSpecific() {
        this.writeFinalHistoryDataItem();
    }

    protected boolean isDoneNestedComponentSpecific() {
        return this.optimizerStarted && (this.programThreadInterrupted || this.optimizer == null || this.optimizer.isStopped());
    }

    protected void sendFinalValues() throws ComponentException {
        if (this.optimizer != null) {
            this.optimizer.setIterationData(this.iterationData);
            int optimalRunNumber = this.optimizer.getOptimalRunNumber();
            Map<String, Double> optimum = this.iterationData.get(optimalRunNumber);
            if (optimalRunNumber != Integer.MIN_VALUE && optimum != null) {
                for (String e : this.output) {
                    if (this.componentContext.getOutputDataType(e) == DataType.Vector) {
                        int vectorSize = Integer.parseInt(this.componentContext.getOutputMetaDataValue(e, "vectorSize"));
                        VectorTD optimumVector = typedDatumFactory.createVector(vectorSize);
                        int i = 0;
                        while (i < vectorSize) {
                            String vectorOutputName = String.valueOf(e) + "_" + i;
                            this.runtimeViewValues.put(vectorOutputName, (TypedDatum)typedDatumFactory.createFloat(optimum.get(vectorOutputName).doubleValue()));
                            optimumVector.setFloatTDForElement(typedDatumFactory.createFloat(optimum.get(vectorOutputName).doubleValue()), i);
                            ++i;
                        }
                        this.writeOutput(String.valueOf(e) + "_optimal", (TypedDatum)optimumVector);
                        continue;
                    }
                    this.writeOutput(String.valueOf(e) + "_optimal", (TypedDatum)typedDatumFactory.createFloat(optimum.get(e).doubleValue()));
                }
                this.sendFinalValuesForwarded(optimalRunNumber);
            } else {
                throw new ComponentException("Failed to read optimal design variables");
            }
        }
        this.terminateExecutor();
    }

    private void sendFinalValuesForwarded(Integer optimalRunNumber) {
        if (optimalRunNumber == null || optimalRunNumber == Integer.MIN_VALUE) {
            this.componentContext.getLog().componentError("Internal error: iteration of optimal design variable cannot be determined");
            return;
        }
        if (!this.dataForwarded.isEmpty()) {
            for (String inputName : this.dataForwarded.get(optimalRunNumber).keySet()) {
                this.writeOutput(String.valueOf(inputName) + "_optimal", this.dataForwarded.get(optimalRunNumber).get(inputName));
            }
        }
    }

    private void initializeNewHistoryDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.historyDataItem = new OptimizerComponentHistoryDataItem();
        }
    }

    private void writeFinalHistoryDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.componentContext.writeFinalHistoryDataItem((ComponentHistoryDataItem)this.historyDataItem);
        }
    }

    public void tearDown(Component.FinalComponentState state) {
        super.tearDown(state);
        this.terminateExecutor();
    }
}

