/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.cluster.execution;

import de.rcenvironment.components.cluster.common.ClusterComponentConstants;
import de.rcenvironment.components.cluster.execution.ClusterComponentConfiguration;
import de.rcenvironment.components.cluster.execution.internal.ClusterJobFinishListener;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.Component;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.execution.api.ComponentLog;
import de.rcenvironment.core.component.execution.api.ThreadHandler;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.DirectoryReferenceTD;
import de.rcenvironment.core.datamodel.types.api.IntegerTD;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.cluster.ClusterJobStateChangeListener;
import de.rcenvironment.core.utils.cluster.ClusterQueuingSystem;
import de.rcenvironment.core.utils.cluster.ClusterService;
import de.rcenvironment.core.utils.cluster.ClusterServiceManager;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.validation.ValidationFailureException;
import de.rcenvironment.core.utils.executor.CommandLineExecutor;
import de.rcenvironment.core.utils.ssh.jsch.SshSessionConfiguration;
import de.rcenvironment.core.utils.ssh.jsch.SshSessionConfigurationFactory;
import de.rcenvironment.core.utils.ssh.jsch.executor.context.JSchExecutorContext;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncExceptionListener;
import de.rcenvironment.toolkit.modules.concurrency.api.CallablesGroup;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClusterComponent
extends DefaultComponent {
    private static final String FAILED_TO_WAIT_FOR_JOB_TO_BECOME_COMPLETED = "Failed to wait for job to become completed";
    private static final String FAILED_TO_SUBMIT_JOB = "Failed to submit job: ";
    private static final String FAILED_FILE_NAME = "cluster_job_failed";
    private static final String SLASH = "/";
    private static final String OUTPUT_FOLDER_NAME = "output";
    private static final String AT = "@";
    private static final String PATH_PATTERN = "iteration-%d/cluster-job-%d";
    private static Log log = LogFactory.getLog(ClusterComponent.class);
    private final Object executorLock = new Object();
    private ComponentLog componentLog;
    private ComponentContext componentContext;
    private ComponentDataManagementService dataManagementService;
    private SshSessionConfiguration sshConfiguration;
    private JSchExecutorContext context;
    private CommandLineExecutor executor;
    private ClusterService clusterService;
    private ClusterQueuingSystem queuingSystem;
    private Map<String, String> pathsToQueuingSystemCommands;
    private List<String> jobIds = Collections.synchronizedList(new ArrayList());
    private AtomicReference<CountDownLatch> jobsCountDefinedLatch = new AtomicReference<Object>(null);
    private AtomicReference<CountDownLatch> jobsSubmittedLatch = new AtomicReference<Object>(null);
    private AtomicBoolean isCancelled = new AtomicBoolean(false);
    private Integer jobCount = null;
    private boolean considerSharedInputDir = true;
    private int iteration = 0;
    private Semaphore upDownloadSemaphore;
    private boolean isJobScriptProvidedWithinInputDir;
    private Map<String, Deque<TypedDatum>> inputValues = new HashMap<String, Deque<TypedDatum>>();

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
        this.componentLog = componentContext.getLog();
    }

    public void start() throws ComponentException {
        ClusterServiceManager clusterServiceManager = (ClusterServiceManager)this.componentContext.getService(ClusterServiceManager.class);
        this.dataManagementService = (ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class);
        ConfigurationService configurationService = (ConfigurationService)this.componentContext.getService(ConfigurationService.class);
        ClusterComponentConfiguration clusterConfiguration = new ClusterComponentConfiguration(configurationService.getConfigurationSegment("componentSettings/de.rcenvironment.cluster"));
        this.isJobScriptProvidedWithinInputDir = Boolean.valueOf(this.componentContext.getConfigurationValue("isScriptProvided"));
        String host = this.componentContext.getConfigurationValue("host");
        Integer port = Integer.valueOf(this.componentContext.getConfigurationValue("port"));
        String authUser = this.componentContext.getConfigurationValue("authUser");
        String authPhrase = this.componentContext.getConfigurationValue("authPhrase");
        String sandboRootWorkDir = this.componentContext.getConfigurationValue("sandboxRoot");
        this.queuingSystem = ClusterQueuingSystem.valueOf((String)this.componentContext.getConfigurationValue("queuingSystem"));
        this.pathsToQueuingSystemCommands = ClusterComponentConstants.extractPathsToQueuingSystemCommands((String)this.componentContext.getConfigurationValue("pathToQueuingSystemCommands"));
        this.sshConfiguration = SshSessionConfigurationFactory.createSshSessionConfigurationWithAuthPhrase((String)host, (int)port, (String)authUser, (String)authPhrase);
        this.clusterService = clusterServiceManager.retrieveSshBasedClusterService(this.queuingSystem, this.pathsToQueuingSystemCommands, this.sshConfiguration.getDestinationHost(), this.sshConfiguration.getPort(), this.sshConfiguration.getSshAuthUser(), this.sshConfiguration.getSshAuthPhrase());
        this.context = new JSchExecutorContext(this.sshConfiguration, sandboRootWorkDir);
        try {
            this.context.setUpSession();
            this.componentLog.componentInfo("Session established: " + authUser + AT + host + ":" + port);
        }
        catch (IOException e) {
            throw new ComponentException("Failed to establish connection to remote host", (Throwable)e);
        }
        catch (ValidationFailureException e) {
            throw new ComponentException("Failed to validate passed parameters", (Throwable)e);
        }
        try {
            this.executor = this.context.setUpSandboxedExecutor();
            this.componentLog.componentInfo("Remote sandbox created: " + this.executor.getWorkDirPath());
        }
        catch (IOException e) {
            throw new ComponentException("Failed to set up remote sandbox", (Throwable)e);
        }
        this.upDownloadSemaphore = new Semaphore(clusterConfiguration.getMaxChannels());
        if (!this.componentContext.getInputs().contains("Job count")) {
            this.jobCount = 1;
        }
        if (!this.componentContext.getInputs().contains("Shared job input")) {
            this.considerSharedInputDir = false;
        }
    }

    public void processInputs() throws ComponentException {
        this.jobsCountDefinedLatch.set(new CountDownLatch(1));
        for (String inputName : this.componentContext.getInputsWithDatum()) {
            if (!this.inputValues.containsKey(inputName)) {
                this.inputValues.put(inputName, new LinkedList());
            }
            this.inputValues.get(inputName).add(this.componentContext.readInput(inputName));
        }
        if (this.jobCount == null && this.inputValues.containsKey("Job count")) {
            this.jobCount = this.readAndEvaluateJobCount();
        }
        if (this.jobCount != null && this.inputValues.containsKey("Job inputs") && this.inputValues.get("Job inputs").size() >= this.jobCount && (!this.considerSharedInputDir || this.inputValues.containsKey("Shared job input") && this.inputValues.get("Shared job input").size() >= 1)) {
            this.jobsSubmittedLatch.set(new CountDownLatch(this.jobCount));
            this.jobsCountDefinedLatch.get().countDown();
            ArrayList<DirectoryReferenceTD> inputDirs = new ArrayList<DirectoryReferenceTD>();
            int i = 0;
            while (i < this.jobCount) {
                inputDirs.add((DirectoryReferenceTD)this.inputValues.get("Job inputs").poll());
                ++i;
            }
            DirectoryReferenceTD sharedInputDir = null;
            if (this.considerSharedInputDir) {
                sharedInputDir = (DirectoryReferenceTD)this.inputValues.get("Shared job input").poll();
            }
            this.uploadInputDirectories(inputDirs, sharedInputDir);
            if (!this.isJobScriptProvidedWithinInputDir) {
                this.uploadJobScript();
            }
            Queue<BlockingQueue<String>> queues = this.submitJobs();
            this.downloadDirectoriesAndSendToOutputsOnJobFinished(queues);
            this.jobCount = null;
            ++this.iteration;
        }
    }

    public void onProcessInputsInterrupted(ThreadHandler executingThreadHandler) {
        this.isCancelled.set(true);
        try {
            this.jobsCountDefinedLatch.get().await();
            this.jobsSubmittedLatch.get().await();
            String stdErr = this.clusterService.cancelClusterJobs(this.jobIds);
            if (!stdErr.isEmpty()) {
                this.componentLog.componentError(stdErr);
            }
        }
        catch (InterruptedException interruptedException) {
            this.componentLog.componentError("Interrupted while cancelling cluster job(s)");
        }
        catch (IOException e) {
            this.componentLog.componentError("Failed to cancel cluster job(s): " + e.getMessage());
        }
    }

    private Integer readAndEvaluateJobCount() throws ComponentException {
        Integer count = (int)((IntegerTD)this.inputValues.get("Job count").poll()).getIntValue();
        if (count <= 0) {
            throw new ComponentException(StringUtils.format((String)"Job count is invalid. It is %d, but must be greater than 0", (Object[])new Object[]{count}));
        }
        return count;
    }

    public void tearDown(Component.FinalComponentState state) {
        super.tearDown(state);
        this.deleteSandboxIfNeeded();
    }

    private void deleteSandboxIfNeeded() {
        Boolean deleteSandbox = Boolean.valueOf(this.componentContext.getConfigurationValue("deleteSandbox"));
        if (this.executor != null && deleteSandbox.booleanValue()) {
            String sandbox = this.executor.getWorkDirPath();
            try {
                this.executor.start("rm -r " + sandbox);
                this.context.tearDownSession();
                this.componentLog.componentInfo("Remote sandbox deleted: " + sandbox);
            }
            catch (IOException e) {
                String errorMessage = "Failed to delete remote sandbox '%s'";
                this.componentLog.componentInfo(String.valueOf(StringUtils.format((String)errorMessage, (Object[])new Object[]{sandbox})) + ": " + e.getMessage());
                log.error((Object)StringUtils.format((String)errorMessage, (Object[])new Object[]{sandbox}), (Throwable)e);
            }
        }
    }

    private void uploadJobScript() throws ComponentException {
        String message = "Failed to upload job script";
        try {
            File jobFile = TempFileServiceAccess.getInstance().createTempFileWithFixedFilename("run_cluster_job.sh");
            FileUtils.write((File)jobFile, (CharSequence)this.componentContext.getConfigurationValue("script").replaceAll("\r\n", "\n"));
            this.componentLog.componentInfo("Uploading job script: " + jobFile.getName());
            this.upDownloadSemaphore.acquire();
            this.executor.uploadFileToWorkdir(jobFile, ".");
            this.upDownloadSemaphore.release();
            TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(jobFile);
            this.componentLog.componentInfo("Job script uploaded: " + jobFile.getName());
        }
        catch (IOException | InterruptedException e) {
            throw new ComponentException(message, (Throwable)e);
        }
    }

    private void uploadInputDirectories(List<DirectoryReferenceTD> inputDirs, final DirectoryReferenceTD sharedInputDir) {
        this.componentLog.componentInfo("Uploading input directories...");
        int count = 0;
        CallablesGroup callablesGroup = ConcurrencyUtils.getFactory().createCallablesGroup(RuntimeException.class);
        for (final DirectoryReferenceTD inputDir : inputDirs) {
            final int countSnapshot = count++;
            callablesGroup.add((Callable)new Callable<RuntimeException>(){

                @Override
                @TaskDescription(value="Upload input directory for cluster job execution")
                public RuntimeException call() throws Exception {
                    try {
                        ClusterComponent.this.uploadInputDirectory(inputDir, "/cluster-job-" + countSnapshot, "input");
                        return null;
                    }
                    catch (RuntimeException e) {
                        return e;
                    }
                }
            });
        }
        if (sharedInputDir != null) {
            callablesGroup.add((Callable)new Callable<RuntimeException>(){

                @Override
                @TaskDescription(value="Upload shared input directory for cluster job execution")
                public RuntimeException call() throws Exception {
                    try {
                        ClusterComponent.this.componentLog.componentInfo("Uploading shared input directory...");
                        ClusterComponent.this.uploadInputDirectory(sharedInputDir, "", "cluster-job-shared-input");
                        ClusterComponent.this.componentLog.componentInfo("Shared input directory uploaded");
                        return null;
                    }
                    catch (RuntimeException e) {
                        return e;
                    }
                }
            });
        }
        List exceptions = callablesGroup.executeParallel(new AsyncExceptionListener(){

            public void onAsyncException(Exception e) {
                log.warn((Object)"Illegal state: Uncaught exception from Callable", (Throwable)e);
            }
        });
        for (RuntimeException e : exceptions) {
            if (e == null) continue;
            log.error((Object)"Exception caught when uploading directories", (Throwable)e);
        }
        for (RuntimeException e : exceptions) {
            if (e == null) continue;
            throw e;
        }
        this.componentLog.componentInfo("Input directories uploaded");
    }

    private void uploadInputDirectory(DirectoryReferenceTD jobDir, String directoryParent, String dirName) throws ComponentException {
        String message = "Failed to upload directory: ";
        try {
            File dir = TempFileServiceAccess.getInstance().createManagedTempDir();
            this.dataManagementService.copyDirectoryReferenceTDToLocalDirectory(this.componentContext, jobDir, dir);
            this.componentLog.componentInfo("Uploading directory: " + jobDir.getDirectoryName());
            File inputDir = new File(dir, dirName);
            File origDir = new File(dir, jobDir.getDirectoryName());
            if (!origDir.renameTo(inputDir)) {
                throw new IOException(StringUtils.format((String)"Failed to rename directory for an unknown reason: %s->%s", (Object[])new Object[]{origDir, inputDir}));
            }
            this.upDownloadSemaphore.acquire();
            this.executor.uploadDirectoryToWorkdir(inputDir, "iteration-" + this.iteration + directoryParent);
            this.upDownloadSemaphore.release();
            TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(dir);
            this.componentLog.componentInfo("Directory uploaded: " + jobDir.getDirectoryName());
        }
        catch (IOException | InterruptedException e) {
            throw new ComponentException(String.valueOf(message) + jobDir.getDirectoryName(), (Throwable)e);
        }
    }

    private Queue<BlockingQueue<String>> submitJobs() throws ComponentException {
        LinkedList<BlockingQueue<String>> blockingQueues = new LinkedList<BlockingQueue<String>>();
        int i = 0;
        while (i < this.jobCount) {
            blockingQueues.add(this.submitJob(i));
            ++i;
        }
        return blockingQueues;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BlockingQueue<String> submitJob(int job) throws ComponentException {
        String stdout;
        block30: {
            try {
                String mkDirOutputCommand = "mkdir " + this.getOutputFolderPath(job) + " ";
                this.executor.start(mkDirOutputCommand);
                this.executor.waitForTermination();
                String qsubCommand = this.buildQsubCommand(this.getJobFolderPath(job));
                this.executor.start(qsubCommand);
                this.componentLog.componentInfo(StringUtils.format((String)"Job submitted: %s from %s", (Object[])new Object[]{"run_cluster_job.sh", this.getJobFolderPath(job)}));
                Throwable throwable = null;
                Object var6_7 = null;
                try {
                    InputStream stdoutStream = this.executor.getStdout();
                    try {
                        block29: {
                            try (InputStream stderrStream = this.executor.getStderr();){
                                this.executor.waitForTermination();
                                Throwable throwable2 = null;
                                Object var10_14 = null;
                                try {
                                    BufferedInputStream bufferedStdoutStream = new BufferedInputStream(stdoutStream);
                                    try {
                                        try (BufferedInputStream bufferedStderrStream = new BufferedInputStream(stderrStream);){
                                            bufferedStdoutStream.mark(10000);
                                            bufferedStderrStream.mark(10000);
                                            String stderr = IOUtils.toString((InputStream)bufferedStderrStream);
                                            if (stderr != null && !stderr.isEmpty()) {
                                                throw new ComponentException(FAILED_TO_SUBMIT_JOB + stderr);
                                            }
                                            stdout = IOUtils.toString((InputStream)bufferedStdoutStream);
                                            bufferedStdoutStream.reset();
                                            bufferedStderrStream.reset();
                                            String[] stringArray = stdout.split(SystemUtils.LINE_SEPARATOR);
                                            int n = stringArray.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                String line = stringArray[n2];
                                                this.componentLog.toolStdout(line);
                                                ++n2;
                                            }
                                        }
                                        if (bufferedStdoutStream == null) break block29;
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable3;
                                        } else if (throwable2 != throwable3) {
                                            throwable2.addSuppressed(throwable3);
                                        }
                                        if (bufferedStdoutStream == null) throw throwable2;
                                        bufferedStdoutStream.close();
                                        throw throwable2;
                                    }
                                    bufferedStdoutStream.close();
                                }
                                catch (Throwable throwable4) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable4;
                                        throw throwable2;
                                    }
                                    if (throwable2 == throwable4) throw throwable2;
                                    throwable2.addSuppressed(throwable4);
                                    throw throwable2;
                                }
                            }
                        }
                        if (stdoutStream == null) break block30;
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        if (stdoutStream == null) throw throwable;
                        stdoutStream.close();
                        throw throwable;
                    }
                    stdoutStream.close();
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                        throw throwable;
                    }
                    if (throwable == throwable6) throw throwable;
                    throwable.addSuppressed(throwable6);
                    throw throwable;
                }
            }
            catch (IOException | InterruptedException e) {
                throw new ComponentException("Failed to submit job", (Throwable)e);
            }
        }
        String jobId = this.extractJobIdFromQsubStdout(stdout);
        this.jobIds.add(jobId);
        this.jobsSubmittedLatch.get().countDown();
        this.componentLog.componentInfo("Id of submitted job: " + jobId);
        SynchronousQueue<String> synchronousQueue = new SynchronousQueue<String>();
        this.clusterService.addClusterJobStateChangeListener(jobId, (ClusterJobStateChangeListener)new ClusterJobFinishListener(synchronousQueue));
        return synchronousQueue;
    }

    private String buildQsubCommand(String path) throws ComponentException {
        String jobScript = "run_cluster_job.sh";
        if (this.isJobScriptProvidedWithinInputDir) {
            jobScript = StringUtils.format((String)"input%s%s", (Object[])new Object[]{SLASH, jobScript});
        } else {
            int i = 0;
            while (i < path.split(SLASH).length) {
                jobScript = StringUtils.format((String)"..%s%s", (Object[])new Object[]{SLASH, jobScript});
                ++i;
            }
        }
        return this.buildQsubCommand(path, jobScript);
    }

    private String buildQsubCommand(String path, String jobScript) throws ComponentException {
        switch (this.queuingSystem) {
            case TORQUE: {
                return this.buildTorqueQsubCommand(path, jobScript);
            }
            case SGE: {
                return this.buildSgeQsubCommand(path, jobScript);
            }
        }
        throw new ComponentException("Queuing system not supported: " + this.queuingSystem.name());
    }

    private String buildQsubMainCommand() {
        String qsubCommand = "qsub";
        if (this.pathsToQueuingSystemCommands.get("qsub") != null) {
            qsubCommand = String.valueOf(this.pathsToQueuingSystemCommands.get("qsub")) + "qsub";
        }
        return qsubCommand;
    }

    private String buildTorqueQsubCommand(String path, String jobScript) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("cd " + path);
        strBuilder.append(" && ");
        strBuilder.append(this.buildQsubMainCommand());
        strBuilder.append(" -d $PWD");
        strBuilder.append(" ");
        strBuilder.append(jobScript);
        return strBuilder.toString();
    }

    private String buildSgeQsubCommand(String path, String scriptFileName) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("cd " + path);
        strBuilder.append(" && ");
        strBuilder.append(this.buildQsubMainCommand());
        strBuilder.append(" -wd $PWD");
        strBuilder.append(" ");
        strBuilder.append(scriptFileName);
        return strBuilder.toString();
    }

    private String extractJobIdFromQsubStdout(String stdout) throws ComponentException {
        switch (this.queuingSystem) {
            case TORQUE: {
                return this.extractJobIdFromTorqueQsubStdout(stdout);
            }
            case SGE: {
                return this.extractJobIdFromSgeQsubStdout(stdout);
            }
        }
        throw new ComponentException("Queuing system not supported: " + this.queuingSystem.name());
    }

    private String extractJobIdFromTorqueQsubStdout(String stdout) throws ComponentException {
        Matcher matcher = Pattern.compile("\\d+\\.\\S*").matcher(stdout);
        if (matcher.find()) {
            return matcher.group();
        }
        matcher = Pattern.compile("\\d+").matcher(stdout);
        if (matcher.find()) {
            return matcher.group();
        }
        throw new ComponentException(FAILED_TO_SUBMIT_JOB + stdout);
    }

    private String extractJobIdFromSgeQsubStdout(String stdout) throws ComponentException {
        Matcher matcher = Pattern.compile("\\d+").matcher(stdout);
        if (matcher.find()) {
            return matcher.group();
        }
        throw new ComponentException(FAILED_TO_SUBMIT_JOB + stdout);
    }

    private void downloadDirectoriesAndSendToOutputsOnJobFinished(Queue<BlockingQueue<String>> queues) throws ComponentException {
        CallablesGroup callablesGroup = ConcurrencyUtils.getFactory().createCallablesGroup(ComponentException.class);
        int i = 0;
        Iterator iterator = queues.iterator();
        while (iterator.hasNext()) {
            BlockingQueue queue;
            final BlockingQueue queueSnapshot = queue = (BlockingQueue)iterator.next();
            final int jobSnapshot = i++;
            callablesGroup.add((Callable)new Callable<ComponentException>(){

                @Override
                @TaskDescription(value="Wait for Job termination, check for failure, and download output directory afterwards")
                public ComponentException call() throws Exception {
                    try {
                        if (((String)queueSnapshot.take()).equals("cluster fetching failed")) {
                            return new ComponentException(ClusterComponent.FAILED_TO_WAIT_FOR_JOB_TO_BECOME_COMPLETED);
                        }
                    }
                    catch (InterruptedException e) {
                        return new ComponentException("Interrupted while waiting for job termination", (Throwable)e);
                    }
                    try {
                        if (!ClusterComponent.this.isCancelled.get()) {
                            ClusterComponent.this.checkIfClusterJobSucceeded(jobSnapshot);
                            ClusterComponent.this.downloadDirectoryAndSendToOutput(jobSnapshot);
                        }
                    }
                    catch (ComponentException e) {
                        return e;
                    }
                    return null;
                }
            });
        }
        List exceptions = callablesGroup.executeParallel(new AsyncExceptionListener(){

            public void onAsyncException(Exception e) {
                log.warn((Object)"Illegal state: Uncaught exception from Callable", (Throwable)e);
            }
        });
        for (ComponentException e : exceptions) {
            if (e == null) continue;
            log.error((Object)("Exception caught when downloading directories: " + e.getMessage()));
        }
        for (ComponentException e : exceptions) {
            if (e == null) continue;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkIfClusterJobSucceeded(int job) throws ComponentException {
        String message = StringUtils.format((String)"Failed to determine if cluster job %d succeeded - assumed that it does to avoid false negatives", (Object[])new Object[]{job});
        String path = this.getOutputFolderPath(job);
        String command = StringUtils.format((String)"ls %s", (Object[])new Object[]{path});
        try {
            Object object = this.executorLock;
            synchronized (object) {
                this.executor.start(command);
                Throwable throwable = null;
                Object var7_9 = null;
                try {
                    InputStream stdoutStream = this.executor.getStdout();
                    try {
                        block23: {
                            try (InputStream stderrStream = this.executor.getStderr();){
                                this.executor.waitForTermination();
                                if (!IOUtils.toString((InputStream)stderrStream).isEmpty()) {
                                    this.componentLog.componentError(StringUtils.format((String)"Failed to execute command '%s' on %s: %s", (Object[])new Object[]{command, this.sshConfiguration.getDestinationHost(), IOUtils.toString((InputStream)stderrStream)}));
                                    this.componentLog.componentError(message);
                                    break block23;
                                }
                                if (IOUtils.toString((InputStream)stdoutStream).contains(FAILED_FILE_NAME)) {
                                    String errorMessage = "N/A";
                                    File file = TempFileServiceAccess.getInstance().createTempFileWithFixedFilename("out-" + job);
                                    try {
                                        this.executor.downloadFileFromWorkdir(String.valueOf(path) + SLASH + FAILED_FILE_NAME, file);
                                        errorMessage = FileUtils.readFileToString((File)file);
                                        throw new ComponentException(StringUtils.format((String)"Cluster job %d failed with message: %s", (Object[])new Object[]{job, errorMessage}));
                                    }
                                    catch (IOException iOException) {
                                        this.componentLog.componentError(StringUtils.format((String)"Failed to download file '%s' - error message could not be extracted", (Object[])new Object[]{FAILED_FILE_NAME}));
                                    }
                                    throw new ComponentException(StringUtils.format((String)"Cluster job %d failed with message: %s", (Object[])new Object[]{job, errorMessage}));
                                }
                                this.componentLog.componentInfo(StringUtils.format((String)"Cluster job %d succeeded", (Object[])new Object[]{job}));
                            }
                        }
                        if (stdoutStream == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (stdoutStream == null) throw throwable;
                        stdoutStream.close();
                        throw throwable;
                    }
                    stdoutStream.close();
                    {
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                return;
            }
        }
        catch (IOException | InterruptedException e) {
            this.componentLog.componentError(String.valueOf(message) + ": " + e.getMessage());
            log.error((Object)message, (Throwable)e);
        }
    }

    private void downloadDirectoryAndSendToOutput(int job) throws ComponentException {
        String message = "Downloading output directory failed: ";
        String path = this.getOutputFolderPath(job);
        try {
            File dir = TempFileServiceAccess.getInstance().createManagedTempDir();
            this.componentLog.componentInfo("Downloading output directory: " + path);
            this.upDownloadSemaphore.acquire();
            this.executor.downloadDirectoryFromWorkdir(path, dir);
            this.upDownloadSemaphore.release();
            File outputDir = new File(dir, "output-" + job);
            File origDir = new File(dir, OUTPUT_FOLDER_NAME);
            if (!origDir.renameTo(outputDir)) {
                throw new IOException(StringUtils.format((String)"Failed to rename directory for an unknown reason: %s->%s", (Object[])new Object[]{origDir, outputDir}));
            }
            DirectoryReferenceTD dirRef = this.dataManagementService.createDirectoryReferenceTDFromLocalDirectory(this.componentContext, outputDir, outputDir.getName());
            this.componentContext.writeOutput("Job outputs", (TypedDatum)dirRef);
            this.componentLog.componentInfo("Output directory downloaded: " + path + ". Will be sent as: " + outputDir.getName());
            TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(dir);
        }
        catch (IOException | InterruptedException e) {
            throw new ComponentException(String.valueOf(message) + path, (Throwable)e);
        }
    }

    private String getJobFolderPath(int job) {
        return StringUtils.format((String)PATH_PATTERN, (Object[])new Object[]{this.iteration, job});
    }

    private String getOutputFolderPath(int job) {
        return String.valueOf(this.getJobFolderPath(job)) + SLASH + OUTPUT_FOLDER_NAME;
    }
}

